/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Comparator;
import org.h2.engine.Session;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SimpleResult
implements ResultInterface,
ResultTarget {
    private final ArrayList<Column> columns;
    private final ArrayList<Value[]> rows;
    private final String schemaName;
    private final String tableName;
    private int rowId;

    public SimpleResult() {
        this("", "");
    }

    public SimpleResult(String schemaName, String tableName) {
        this.columns = Utils.newSmallArrayList();
        this.rows = new ArrayList();
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.rowId = -1;
    }

    private SimpleResult(ArrayList<Column> columns, ArrayList<Value[]> rows, String schemaName, String tableName) {
        this.columns = columns;
        this.rows = rows;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.rowId = -1;
    }

    public void addColumn(String alias, String columnName, int columnType, long columnPrecision, int columnScale) {
        this.addColumn(alias, columnName, TypeInfo.getTypeInfo(columnType, columnPrecision, columnScale, null));
    }

    public void addColumn(String columnName, TypeInfo columnType) {
        this.addColumn(new Column(columnName, columnName, columnType));
    }

    public void addColumn(String alias, String columnName, TypeInfo columnType) {
        this.addColumn(new Column(alias, columnName, columnType));
    }

    void addColumn(Column column) {
        assert (this.rows.isEmpty());
        this.columns.add(column);
    }

    @Override
    public void addRow(Value ... values) {
        assert (values.length == this.columns.size());
        this.rows.add(values);
    }

    @Override
    public void reset() {
        this.rowId = -1;
    }

    @Override
    public Value[] currentRow() {
        return this.rows.get(this.rowId);
    }

    @Override
    public boolean next() {
        int count = this.rows.size();
        if (this.rowId < count) {
            return ++this.rowId < count;
        }
        return false;
    }

    @Override
    public long getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rows.size();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.columns.size();
    }

    @Override
    public long getRowCount() {
        return this.rows.size();
    }

    @Override
    public boolean hasNext() {
        return this.rowId < this.rows.size() - 1;
    }

    @Override
    public boolean needToClose() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public String getAlias(int i) {
        return this.columns.get((int)i).alias;
    }

    @Override
    public String getSchemaName(int i) {
        return this.schemaName;
    }

    @Override
    public String getTableName(int i) {
        return this.tableName;
    }

    @Override
    public String getColumnName(int i) {
        return this.columns.get((int)i).columnName;
    }

    @Override
    public TypeInfo getColumnType(int i) {
        return this.columns.get((int)i).columnType;
    }

    @Override
    public boolean isIdentity(int i) {
        return false;
    }

    @Override
    public int getNullable(int i) {
        return 2;
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public SimpleResult createShallowCopy(Session targetSession) {
        return new SimpleResult(this.columns, this.rows, this.schemaName, this.tableName);
    }

    @Override
    public void limitsWereApplied() {
    }

    public void sortRows(Comparator<? super Value[]> comparator) {
        this.rows.sort(comparator);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class Column {
        final String alias;
        final String columnName;
        final TypeInfo columnType;

        Column(String alias, String columnName, TypeInfo columnType) {
            if (alias == null || columnName == null) {
                throw new NullPointerException();
            }
            this.alias = alias;
            this.columnName = columnName;
            this.columnType = columnType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alias.hashCode();
            result = 31 * result + this.columnName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Column other = (Column)obj;
            return this.alias.equals(other.alias) && this.columnName.equals(other.columnName);
        }

        public String toString() {
            if (this.alias.equals(this.columnName)) {
                return this.columnName;
            }
            return this.columnName + " " + this.alias;
        }
    }
}

