/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SimpleRowValue
extends SearchRow {
    private int index;
    private final int virtualColumnCount;
    private Value data;

    public SimpleRowValue(int columnCount) {
        this.virtualColumnCount = columnCount;
    }

    public SimpleRowValue(int columnCount, int index) {
        this.virtualColumnCount = columnCount;
        this.index = index;
    }

    @Override
    public int getColumnCount() {
        return this.virtualColumnCount;
    }

    @Override
    public Value getValue(int idx) {
        if (idx == -1) {
            return ValueBigint.get(this.getKey());
        }
        return idx == this.index ? this.data : null;
    }

    @Override
    public void setValue(int idx, Value v) {
        if (idx == -1) {
            this.setKey(v.getLong());
        }
        this.index = idx;
        this.data = v;
    }

    @Override
    public String toString() {
        return "( /* " + this.key + " */ " + (this.data == null ? "null" : this.data.getTraceSQL()) + " )";
    }

    @Override
    public int getMemory() {
        return 40 + (this.data == null ? 0 : this.data.getMemory());
    }

    @Override
    public boolean isNull(int index) {
        return index != this.index || this.data == null || this.data == ValueNull.INSTANCE;
    }

    @Override
    public void copyFrom(SearchRow source) {
        this.setKey(source.getKey());
        this.setValue(this.index, source.getValue(this.index));
    }
}

