/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;

public class CachedPreparedStatements {
    private Connection conn;
    private Statement stat;
    private final ConcurrentHashMap<String, PreparedStatement> prepared = new ConcurrentHashMap();

    public static void main(String ... args) throws Exception {
        new CachedPreparedStatements().run();
    }

    private void run() throws Exception {
        Class.forName("org.h2.Driver");
        this.conn = DriverManager.getConnection("jdbc:h2:mem:", "sa", "");
        this.stat = this.conn.createStatement();
        this.stat.execute("create table test(id int primary key, name varchar)");
        PreparedStatement prep = this.prepare("insert into test values(?, ?)");
        prep.setInt(1, 1);
        prep.setString(2, "Hello");
        prep.execute();
        this.conn.close();
    }

    private PreparedStatement prepare(String sql) throws SQLException {
        PreparedStatement prep = this.prepared.get(sql);
        if (prep == null) {
            prep = this.conn.prepareStatement(sql);
            this.prepared.put(sql, prep);
        }
        return prep;
    }
}

