/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import org.h2.security.SHA256;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileUtils;
import org.h2.tools.CompressTool;
import org.h2.tools.RunScript;
import org.h2.tools.Script;

public class CreateScriptFile {
    public static void main(String ... args) throws Exception {
        String line;
        String file = "test.txt";
        String cipher = "AES";
        String filePassword = "password";
        String compressionAlgorithm = "DEFLATE";
        String url = "jdbc:h2:mem:test";
        String user = "sa";
        String dbPassword = "sa";
        PrintWriter w = CreateScriptFile.openScriptWriter(file, compressionAlgorithm, cipher, filePassword, "UTF-8");
        w.println("create table test(id int primary key);");
        w.println("insert into test select x from system_range(1, 10);");
        w.close();
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection(url, user, dbPassword);
        RunScript.main("-url", url, "-user", user, "-password", dbPassword, "-script", file, "-options", "compression", compressionAlgorithm, "cipher", cipher, "password", "'" + filePassword + "'");
        Script.main("-url", url, "-user", user, "-password", dbPassword, "-script", file, "-options", "compression", compressionAlgorithm, "cipher", cipher, "password", "'" + filePassword + "'");
        conn.close();
        LineNumberReader r = CreateScriptFile.openScriptReader(file, compressionAlgorithm, cipher, filePassword, "UTF-8");
        while ((line = r.readLine()) != null) {
            System.out.println(line);
        }
        r.close();
    }

    public static PrintWriter openScriptWriter(String fileName, String compressionAlgorithm, String cipher, String password, String charset) throws IOException {
        try {
            OutputStream out;
            if (cipher != null) {
                byte[] key = SHA256.getKeyPasswordHash("script", password.toCharArray());
                FileUtils.delete(fileName);
                FileStore store = FileStore.open(null, fileName, "rw", cipher, key);
                store.init();
                out = new FileStoreOutputStream(store, compressionAlgorithm);
                out = new BufferedOutputStream(out, 131072);
            } else {
                out = FileUtils.newOutputStream(fileName, false);
                out = new BufferedOutputStream(out, 4096);
                out = CompressTool.wrapOutputStream(out, compressionAlgorithm, "script.sql");
            }
            return new PrintWriter(new OutputStreamWriter(out, charset));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static LineNumberReader openScriptReader(String fileName, String compressionAlgorithm, String cipher, String password, String charset) throws IOException {
        try {
            InputStream in;
            if (cipher != null) {
                byte[] key = SHA256.getKeyPasswordHash("script", password.toCharArray());
                FileStore store = FileStore.open(null, fileName, "rw", cipher, key);
                store.init();
                in = new FileStoreInputStream(store, compressionAlgorithm != null, false);
                in = new BufferedInputStream(in, 131072);
            } else {
                in = FileUtils.newInputStream(fileName);
                in = new BufferedInputStream(in, 4096);
                if ((in = CompressTool.wrapInputStream(in, compressionAlgorithm, "script.sql")) == null) {
                    throw new IOException("Entry not found: script.sql in " + fileName);
                }
            }
            return new LineNumberReader(new InputStreamReader(in, charset));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

