/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.tools.DeleteDbFiles;

public class DirectInsert {
    public static void main(String ... args) throws Exception {
        Class.forName("org.h2.Driver");
        DeleteDbFiles.execute("~", "test", true);
        String url = "jdbc:h2:~/test";
        DirectInsert.initialInsert(url, 200000);
        int i = 0;
        while (i < 3) {
            DirectInsert.createAsSelect(url, true);
            DirectInsert.createAsSelect(url, false);
            ++i;
        }
    }

    private static void initialInsert(String url, int len) throws SQLException {
        Connection conn = DriverManager.getConnection(url + ";LOG=0");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Test' || SPACE(100))");
        long time = System.nanoTime();
        int i = 0;
        while (i < len) {
            long now = System.nanoTime();
            if (now > time + TimeUnit.SECONDS.toNanos(1L)) {
                time = now;
                System.out.println("Inserting " + 100L * (long)i / (long)len + "%");
            }
            prep.setInt(1, i);
            prep.execute();
            ++i;
        }
        conn.commit();
        prep.close();
        stat.close();
        conn.close();
    }

    private static void createAsSelect(String url, boolean optimize) throws SQLException {
        Connection conn = DriverManager.getConnection(url + ";OPTIMIZE_INSERT_FROM_SELECT=" + optimize);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST2");
        System.out.println("CREATE TABLE ... AS SELECT " + (optimize ? "(optimized)" : ""));
        long time = System.nanoTime();
        stat.execute("CREATE TABLE TEST2 AS SELECT * FROM TEST");
        System.out.printf("%.3f sec.\n", (double)(System.nanoTime() - time) / (double)TimeUnit.SECONDS.toNanos(1L));
        stat.execute("INSERT INTO TEST2 SELECT * FROM TEST2");
        stat.close();
        conn.close();
    }
}

