/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.SimpleResultSet;

public class Function {
    public static void main(String ... args) throws Exception {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:", "sa", "");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS IS_PRIME FOR 'org.h2.samples.Function.isPrime'");
        ResultSet rs = stat.executeQuery("SELECT IS_PRIME(X), X FROM SYSTEM_RANGE(1, 20) ORDER BY X");
        while (rs.next()) {
            boolean isPrime = rs.getBoolean(1);
            if (!isPrime) continue;
            int x = rs.getInt(2);
            System.out.println(x + " is prime");
        }
        stat.execute("CREATE TABLE TEST(ID INT) AS SELECT X FROM SYSTEM_RANGE(1, 100)");
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM TABLE(X INT=?, O INT=?) J INNER JOIN TEST T ON J.X=T.ID ORDER BY J.O");
        prep.setObject(1, new Integer[]{30, 20});
        prep.setObject(2, new Integer[]{1, 2});
        rs = prep.executeQuery();
        while (rs.next()) {
            System.out.println(rs.getInt(1));
        }
        prep.close();
        rs.close();
        stat.execute("CREATE ALIAS MATRIX FOR 'org.h2.samples.Function.getMatrix'");
        prep = conn.prepareStatement("SELECT * FROM MATRIX(?) ORDER BY X, Y");
        prep.setInt(1, 2);
        rs = prep.executeQuery();
        while (rs.next()) {
            System.out.println(rs.getInt(1) + "/" + rs.getInt(2));
        }
        prep.close();
        stat.execute("create alias make_point as $$ java.awt.Point newPoint(int x, int y) { return new java.awt.Point(x, y); } $$");
        stat.execute("create alias get_x as $$ int pointX(java.awt.geom.Point2D p) { return (int) p.getX(); } $$");
        rs = stat.executeQuery("call get_x(make_point(10, 20))");
        while (rs.next()) {
            System.out.println(rs.getString(1));
        }
        stat.close();
        conn.close();
    }

    public static boolean isPrime(int value) {
        return BigInteger.valueOf(value).isProbablePrime(100);
    }

    public static ResultSet query(Connection conn, String sql) throws SQLException {
        return conn.createStatement().executeQuery(sql);
    }

    public static ResultSet simpleResultSet() {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("ID", 4, 10, 0);
        rs.addColumn("NAME", 12, 255, 0);
        rs.addRow(0, "Hello");
        return rs;
    }

    public static ResultSet getMatrix(Connection conn, Integer size) throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("X", 4, 10, 0);
        rs.addColumn("Y", 4, 10, 0);
        String url = conn.getMetaData().getURL();
        if (url.equals("jdbc:columnlist:connection")) {
            return rs;
        }
        int s = size;
        int x = 0;
        while (x < s) {
            int y = 0;
            while (y < s) {
                rs.addRow(x, y);
                ++y;
            }
            ++x;
        }
        return rs;
    }
}

