/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.tools.RunScript;

public class InitDatabaseFromJar {
    public static void main(String ... args) throws Exception {
        InitDatabaseFromJar.createScript();
        new InitDatabaseFromJar().initDb();
    }

    private static void createScript() throws Exception {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:test");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES('Hello World')");
        stat.execute("SCRIPT TO 'script.sql'");
        stat.close();
        conn.close();
    }

    void initDb() throws Exception {
        Class.forName("org.h2.Driver");
        InputStream in = this.getClass().getResourceAsStream("script.sql");
        if (in == null) {
            System.out.println("Please add the file script.sql to the classpath, package " + this.getClass().getPackage().getName());
        } else {
            Connection conn = DriverManager.getConnection("jdbc:h2:mem:test");
            RunScript.execute(conn, new InputStreamReader(in));
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
            rs.close();
            stat.close();
            conn.close();
        }
    }
}

