/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.Server;

public class MixedMode {
    public static void main(String ... args) throws Exception {
        Server server = Server.createTcpServer("-tcpPort", "9081");
        server.start();
        System.out.println("You can access the database remotely now, using the URL:");
        System.out.println("jdbc:h2:tcp://localhost:9081/~/test (user: sa, password: sa)");
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:~/test", "sa", "sa");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE TIMER IF EXISTS");
        stat.execute("CREATE TABLE TIMER(ID INT PRIMARY KEY, TIME VARCHAR)");
        System.out.println("Execute this a few times: SELECT TIME FROM TIMER");
        System.out.println("To stop this application (and the server), run: DROP TABLE TIMER");
        try {
            while (true) {
                stat.execute("MERGE INTO TIMER VALUES(1, LOCALTIME)");
                Thread.sleep(1000L);
            }
        }
        catch (SQLException e) {
            System.out.println("Error: " + e.toString());
            conn.close();
            server.stop();
            return;
        }
    }
}

