/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.h2.store.fs.FileUtils;
import org.h2.tools.Backup;
import org.h2.tools.DeleteDbFiles;

public class ReadOnlyDatabaseInZip {
    public static void main(String ... args) throws Exception {
        FileUtils.deleteRecursive("~/temp", false);
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:split:22:~/temp/test");
        System.out.println("adding test data...");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select x, space(1000) from system_range(1, 2000)");
        System.out.println("defrag to reduce random access...");
        stat.execute("shutdown defrag");
        conn.close();
        System.out.println("create the zip file...");
        Backup.execute("~/temp/test.zip", "~/temp", "", true);
        DeleteDbFiles.execute("split:~/temp", "test", true);
        System.out.println("open the database from the zip file...");
        conn = DriverManager.getConnection("jdbc:h2:split:zip:~/temp/test.zip!/test");
        conn.close();
    }
}

