/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLInjection {
    private Connection conn;
    private Statement stat;

    public static void main(String ... args) throws Exception {
        new SQLInjection().run("org.h2.Driver", "jdbc:h2:./test", "sa", "sa");
    }

    void run(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url, user, password);
        this.stat = this.conn.createStatement();
        try {
            this.stat.execute("DROP TABLE USERS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stat.execute("CREATE TABLE USERS(ID INT PRIMARY KEY, NAME VARCHAR(255), PASSWORD VARCHAR(255))");
        this.stat.execute("INSERT INTO USERS VALUES(1, 'admin', 'super')");
        this.stat.execute("INSERT INTO USERS VALUES(2, 'guest', '123456')");
        this.stat.execute("INSERT INTO USERS VALUES(3, 'test', 'abc')");
        this.loginByNameInsecure();
        if (url.startsWith("jdbc:h2:")) {
            this.loginStoredProcedureInsecure();
            this.limitRowAccess();
        }
        this.loginByNameSecure();
        if (url.startsWith("jdbc:h2:")) {
            this.stat.execute("SET ALLOW_LITERALS NONE");
            this.stat.execute("SET ALLOW_LITERALS NUMBERS");
            this.stat.execute("SET ALLOW_LITERALS ALL");
        }
        this.loginByIdInsecure();
        this.loginByIdSecure();
        try {
            this.stat.execute("DROP TABLE ITEMS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.stat.execute("CREATE TABLE ITEMS(ID INT PRIMARY KEY, NAME VARCHAR(255), ACTIVE INT)");
        this.stat.execute("INSERT INTO ITEMS VALUES(0, 'XBox', 0)");
        this.stat.execute("INSERT INTO ITEMS VALUES(1, 'XBox 360', 1)");
        this.stat.execute("INSERT INTO ITEMS VALUES(2, 'PlayStation 1', 0)");
        this.stat.execute("INSERT INTO ITEMS VALUES(3, 'PlayStation 2', 1)");
        this.stat.execute("INSERT INTO ITEMS VALUES(4, 'PlayStation 3', 1)");
        this.listActiveItems();
        if (url.startsWith("jdbc:h2:")) {
            this.stat.execute("DROP CONSTANT IF EXISTS TYPE_INACTIVE");
            this.stat.execute("DROP CONSTANT IF EXISTS TYPE_ACTIVE");
            this.stat.execute("CREATE CONSTANT TYPE_INACTIVE VALUE 0");
            this.stat.execute("CREATE CONSTANT TYPE_ACTIVE VALUE 1");
            this.listActiveItemsUsingConstants();
        }
        this.listItemsSortedInsecure();
        this.listItemsSortedSecure();
        if (url.startsWith("jdbc:h2:")) {
            this.listItemsSortedSecureParam();
            this.storePasswordHashWithSalt();
        }
        this.conn.close();
    }

    void loginByNameInsecure() throws Exception {
        System.out.println("Insecure Systems Inc. - login");
        String name = this.input("Name?");
        String password = this.input("Password?");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM USERS WHERE NAME='" + name + "' AND PASSWORD='" + password + "'");
        if (rs.next()) {
            System.out.println("Welcome!");
        } else {
            System.out.println("Access denied!");
        }
    }

    public static ResultSet getUser(Connection conn, String userName, String password) throws Exception {
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM USERS WHERE NAME=? AND PASSWORD=?");
        prep.setString(1, userName);
        prep.setString(2, password);
        return prep.executeQuery();
    }

    public static String changePassword(Connection conn, String userName, String password) throws Exception {
        PreparedStatement prep = conn.prepareStatement("UPDATE USERS SET PASSWORD=? WHERE NAME=?");
        prep.setString(1, password);
        prep.setString(2, userName);
        prep.executeUpdate();
        return password;
    }

    void loginStoredProcedureInsecure() throws Exception {
        System.out.println("Insecure Systems Inc. - login using a stored procedure");
        this.stat.execute("CREATE ALIAS IF NOT EXISTS GET_USER FOR 'org.h2.samples.SQLInjection.getUser'");
        this.stat.execute("CREATE ALIAS IF NOT EXISTS CHANGE_PASSWORD FOR 'org.h2.samples.SQLInjection.changePassword'");
        String name = this.input("Name?");
        String password = this.input("Password?");
        ResultSet rs = this.stat.executeQuery("CALL GET_USER('" + name + "', '" + password + "')");
        if (rs.next()) {
            System.out.println("Welcome!");
        } else {
            System.out.println("Access denied!");
        }
    }

    void loginByNameSecure() throws Exception {
        System.out.println("Secure Systems Inc. - login using placeholders");
        String name = this.input("Name?");
        String password = this.input("Password?");
        PreparedStatement prep = this.conn.prepareStatement("SELECT * FROM USERS WHERE NAME=? AND PASSWORD=?");
        prep.setString(1, name);
        prep.setString(2, password);
        ResultSet rs = prep.executeQuery();
        if (rs.next()) {
            System.out.println("Welcome!");
        } else {
            System.out.println("Access denied!");
        }
        rs.close();
        prep.close();
    }

    void limitRowAccess() throws Exception {
        System.out.println("Secure Systems Inc. - limit row access");
        this.stat.execute("DROP TABLE IF EXISTS SESSION_USER");
        this.stat.execute("CREATE TABLE SESSION_USER(ID INT, USER INT)");
        this.stat.execute("DROP VIEW IF EXISTS MY_USER");
        this.stat.execute("CREATE VIEW MY_USER AS SELECT U.* FROM SESSION_USER S, USERS U WHERE S.ID=SESSION_ID() AND S.USER=U.ID");
        this.stat.execute("INSERT INTO SESSION_USER VALUES(SESSION_ID(), 1)");
        ResultSet rs = this.stat.executeQuery("SELECT ID, NAME FROM MY_USER");
        while (rs.next()) {
            System.out.println(rs.getString(1) + ": " + rs.getString(2));
        }
    }

    void loginByIdInsecure() throws Exception {
        System.out.println("Half Secure Systems Inc. - login by id");
        String id = this.input("User ID?");
        String password = this.input("Password?");
        try {
            PreparedStatement prep = this.conn.prepareStatement("SELECT * FROM USERS WHERE ID=" + id + " AND PASSWORD=?");
            prep.setString(1, password);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                System.out.println("Welcome!");
            } else {
                System.out.println("Access denied!");
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    void loginByIdSecure() throws Exception {
        System.out.println("Secure Systems Inc. - login by id");
        String id = this.input("User ID?");
        String password = this.input("Password?");
        try {
            PreparedStatement prep = this.conn.prepareStatement("SELECT * FROM USERS WHERE ID=? AND PASSWORD=?");
            prep.setInt(1, Integer.parseInt(id));
            prep.setString(2, password);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                System.out.println("Welcome!");
            } else {
                System.out.println("Access denied!");
            }
            rs.close();
            prep.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void listActiveItems() throws Exception {
        System.out.println("Half Secure Systems Inc. - list active items");
        ResultSet rs = this.stat.executeQuery("SELECT NAME FROM ITEMS WHERE ACTIVE=1");
        while (rs.next()) {
            System.out.println("Name: " + rs.getString(1));
        }
    }

    void listActiveItemsUsingConstants() throws Exception {
        System.out.println("Secure Systems Inc. - list active items");
        ResultSet rs = this.stat.executeQuery("SELECT NAME FROM ITEMS WHERE ACTIVE=TYPE_ACTIVE");
        while (rs.next()) {
            System.out.println("Name: " + rs.getString(1));
        }
    }

    void listItemsSortedInsecure() throws Exception {
        System.out.println("Insecure Systems Inc. - list items");
        String order = this.input("order (id, name)?");
        try {
            ResultSet rs = this.stat.executeQuery("SELECT ID, NAME FROM ITEMS ORDER BY " + order);
            while (rs.next()) {
                System.out.println(rs.getString(1) + ": " + rs.getString(2));
            }
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    void listItemsSortedSecure() throws Exception {
        System.out.println("Secure Systems Inc. - list items");
        String order = this.input("order (id, name)?");
        if (!order.matches("[a-zA-Z0-9_]*")) {
            order = "id";
        }
        try {
            ResultSet rs = this.stat.executeQuery("SELECT ID, NAME FROM ITEMS ORDER BY " + order);
            while (rs.next()) {
                System.out.println(rs.getString(1) + ": " + rs.getString(2));
            }
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    void listItemsSortedSecureParam() throws Exception {
        System.out.println("Secure Systems Inc. - list items");
        String order = this.input("order (1, 2, -1, -2)?");
        PreparedStatement prep = this.conn.prepareStatement("SELECT ID, NAME FROM ITEMS ORDER BY ?");
        try {
            prep.setInt(1, Integer.parseInt(order));
            ResultSet rs = prep.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getString(1) + ": " + rs.getString(2));
            }
            rs.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        prep.close();
    }

    void storePasswordHashWithSalt() throws Exception {
        System.out.println("Very Secure Systems Inc. - login");
        this.stat.execute("DROP TABLE IF EXISTS USERS2");
        this.stat.execute("CREATE TABLE USERS2(ID INT PRIMARY KEY, NAME VARCHAR, SALT BINARY, HASH BINARY)");
        this.stat.execute("INSERT INTO USERS2 VALUES(1, 'admin', SECURE_RAND(16), NULL)");
        this.stat.execute("DROP CONSTANT IF EXISTS HASH_ITERATIONS");
        this.stat.execute("DROP CONSTANT IF EXISTS HASH_ALGORITHM");
        this.stat.execute("CREATE CONSTANT HASH_ITERATIONS VALUE 100");
        this.stat.execute("CREATE CONSTANT HASH_ALGORITHM VALUE 'SHA256'");
        this.stat.execute("UPDATE USERS2 SET HASH=HASH(HASH_ALGORITHM, STRINGTOUTF8('abc' || SALT), HASH_ITERATIONS) WHERE ID=1");
        String user = this.input("user?");
        String password = this.input("password?");
        this.stat.execute("SET ALLOW_LITERALS NONE");
        PreparedStatement prep = this.conn.prepareStatement("SELECT * FROM USERS2 WHERE NAME=? AND HASH=HASH(HASH_ALGORITHM, STRINGTOUTF8(? || SALT), HASH_ITERATIONS)");
        prep.setString(1, user);
        prep.setString(2, password);
        ResultSet rs = prep.executeQuery();
        while (rs.next()) {
            System.out.println("name: " + rs.getString("NAME"));
            System.out.println("salt: " + rs.getString("SALT"));
            System.out.println("hash: " + rs.getString("HASH"));
        }
        rs.close();
        prep.close();
        this.stat.execute("SET ALLOW_LITERALS ALL");
        this.stat.close();
    }

    String input(String prompt) throws Exception {
        System.out.print(prompt);
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }
}

