/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.lang.invoke.StringConcatFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.api.Trigger;

public class TriggerPassData
implements Trigger {
    private static final ConcurrentHashMap<String, TriggerPassData> TRIGGERS = new ConcurrentHashMap();
    private String triggerData;

    public static void main(String ... args) throws Exception {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:test", "sa", "");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("CREATE ALIAS TRIGGER_SET FOR '" + TriggerPassData.class.getName() + ".setTriggerData'");
        stat.execute("CREATE TRIGGER T1 BEFORE INSERT ON TEST FOR EACH ROW CALL \"" + TriggerPassData.class.getName() + "\"");
        stat.execute("CALL TRIGGER_SET('T1', 'Hello')");
        stat.execute("INSERT INTO TEST VALUES(1)");
        stat.execute("CALL TRIGGER_SET('T1', 'World')");
        stat.execute("INSERT INTO TEST VALUES(2)");
        stat.close();
        conn.close();
    }

    @Override
    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        TRIGGERS.put(TriggerPassData.getPrefix(conn) + triggerName, this);
    }

    @Override
    public void fire(Connection conn, Object[] old, Object[] row) {
        System.out.println(this.triggerData + ": " + String.valueOf(row[0]));
    }

    public static void setTriggerData(Connection conn, String trigger, String data) throws SQLException {
        TriggerPassData.TRIGGERS.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)TriggerPassData.getPrefix((Connection)conn), (String)trigger)).triggerData = data;
    }

    private static String getPrefix(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("call coalesce(database_path() || '_', '') || database() || '_'");
        rs.next();
        return rs.getString(1);
    }
}

