/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import org.h2.engine.SessionLocal;
import org.h2.expression.ValueExpression;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Constant
extends SchemaObject {
    private Value value;
    private ValueExpression expression;

    public Constant(Schema schema, int id, String name) {
        super(schema, id, name, 8);
    }

    @Override
    public String getCreateSQL() {
        StringBuilder builder = new StringBuilder("CREATE CONSTANT ");
        this.getSQL(builder, 0).append(" VALUE ");
        return this.value.getSQL(builder, 0).toString();
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    public void setValue(Value value) {
        this.value = value;
        this.expression = ValueExpression.get(value);
    }

    public ValueExpression getValue() {
        return this.expression;
    }
}

