/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.schema.MetaSchema;
import org.h2.table.InformationSchemaTable;
import org.h2.table.InformationSchemaTableLegacy;
import org.h2.table.Table;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class InformationSchema
extends MetaSchema {
    private volatile HashMap<String, Table> newTables;
    private volatile HashMap<String, Table> oldTables;

    public InformationSchema(Database database, User owner) {
        super(database, -1, database.sysIdentifier("INFORMATION_SCHEMA"), owner);
    }

    @Override
    protected Map<String, Table> getMap(SessionLocal session) {
        HashMap<String, Table> map;
        if (session == null) {
            return Collections.emptyMap();
        }
        boolean old = session.isOldInformationSchema();
        HashMap<String, Table> hashMap = map = old ? this.oldTables : this.newTables;
        if (map == null) {
            map = this.fillMap(old);
        }
        return map;
    }

    private synchronized HashMap<String, Table> fillMap(boolean old) {
        HashMap<String, Table> map;
        HashMap<String, Table> hashMap = map = old ? this.oldTables : this.newTables;
        if (map == null) {
            map = this.database.newStringMap(64);
            if (old) {
                int type = 0;
                while (type < 36) {
                    InformationSchemaTableLegacy table = new InformationSchemaTableLegacy(this, -1 - type, type);
                    map.put(table.getName(), table);
                    ++type;
                }
                this.oldTables = map;
            } else {
                int type = 0;
                while (type < 35) {
                    InformationSchemaTable table = new InformationSchemaTable(this, -1 - type, type);
                    map.put(table.getName(), table);
                    ++type;
                }
                this.newTables = map;
            }
        }
        return map;
    }
}

