/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.Bits;
import org.h2.util.MathUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SecureFileStore
extends FileStore {
    private byte[] key;
    private final BlockCipher cipher;
    private final BlockCipher cipherForInitVector;
    private byte[] buffer = new byte[4];
    private long pos;
    private final byte[] bufferForInitVector;
    private final int keyIterations;

    public SecureFileStore(DataHandler handler, String name, String mode, String cipher, byte[] key, int keyIterations) {
        super(handler, name, mode);
        this.key = key;
        this.cipher = CipherFactory.getBlockCipher(cipher);
        this.cipherForInitVector = CipherFactory.getBlockCipher(cipher);
        this.keyIterations = keyIterations;
        this.bufferForInitVector = new byte[16];
    }

    @Override
    protected byte[] generateSalt() {
        return MathUtils.secureRandomBytes(16);
    }

    @Override
    protected void initKey(byte[] salt) {
        this.key = SHA256.getHashWithSalt(this.key, salt);
        int i = 0;
        while (i < this.keyIterations) {
            this.key = SHA256.getHash(this.key, true);
            ++i;
        }
        this.cipher.setKey(this.key);
        this.key = SHA256.getHash(this.key, true);
        this.cipherForInitVector.setKey(this.key);
    }

    @Override
    protected void writeDirect(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.pos += (long)len;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.buffer.length < b.length) {
            this.buffer = new byte[len];
        }
        System.arraycopy(b, off, this.buffer, 0, len);
        this.xorInitVector(this.buffer, 0, len, this.pos);
        this.cipher.encrypt(this.buffer, 0, len);
        super.write(this.buffer, 0, len);
        this.pos += (long)len;
    }

    @Override
    public void readFullyDirect(byte[] b, int off, int len) {
        super.readFully(b, off, len);
        this.pos += (long)len;
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        super.readFully(b, off, len);
        int i = 0;
        while (i < len) {
            if (b[i] != 0) {
                this.cipher.decrypt(b, off, len);
                this.xorInitVector(b, off, len, this.pos);
                break;
            }
            ++i;
        }
        this.pos += (long)len;
    }

    @Override
    public void seek(long x) {
        this.pos = x;
        super.seek(x);
    }

    private void xorInitVector(byte[] b, int off, int len, long p) {
        byte[] iv = this.bufferForInitVector;
        while (len > 0) {
            int i = 0;
            while (i < 16) {
                Bits.LONG_VH_BE.set(iv, i, p + (long)i >>> 3);
                i += 8;
            }
            this.cipherForInitVector.encrypt(iv, 0, 16);
            i = 0;
            while (i < 16) {
                int n = off + i;
                b[n] = (byte)(b[n] ^ iv[i]);
                ++i;
            }
            p += 16L;
            off += 16;
            len -= 16;
        }
    }
}

