/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security.auth.impl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.h2.api.CredentialsValidator;
import org.h2.security.auth.AuthenticationInfo;
import org.h2.security.auth.ConfigProperties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JaasCredentialsValidator
implements CredentialsValidator {
    public static final String DEFAULT_APPNAME = "h2";
    private String appName;

    public JaasCredentialsValidator() {
        this(DEFAULT_APPNAME);
    }

    public JaasCredentialsValidator(String appName) {
        this.appName = appName;
    }

    @Override
    public void configure(ConfigProperties configProperties) {
        this.appName = configProperties.getStringValue("appName", this.appName);
    }

    @Override
    public boolean validateCredentials(AuthenticationInfo authenticationInfo) throws Exception {
        LoginContext loginContext = new LoginContext(this.appName, new AuthenticationInfoCallbackHandler(authenticationInfo));
        loginContext.login();
        authenticationInfo.setNestedIdentity(loginContext.getSubject());
        return true;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class AuthenticationInfoCallbackHandler
    implements CallbackHandler {
        AuthenticationInfo authenticationInfo;

        AuthenticationInfoCallbackHandler(AuthenticationInfo authenticationInfo) {
            this.authenticationInfo = authenticationInfo;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(this.authenticationInfo.getUserName());
                } else if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(this.authenticationInfo.getPassword().toCharArray());
                }
                ++i;
            }
        }
    }
}

