/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.h2.command.Command;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.jdbc.JdbcException;
import org.h2.jdbc.meta.DatabaseMetaServer;
import org.h2.message.DbException;
import org.h2.result.BatchResult;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.server.TcpServer;
import org.h2.store.LobStorageInterface;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.SmallMap;
import org.h2.util.TimeZoneProvider;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueLob;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TcpServerThread
implements Runnable {
    protected final Transfer transfer;
    private final TcpServer server;
    private SessionLocal session;
    private boolean stop;
    private Thread thread;
    private Command commit;
    private final SmallMap cache = new SmallMap(SysProperties.SERVER_CACHED_OBJECTS);
    private final SmallLRUCache<Long, CachedInputStream> lobs = SmallLRUCache.newInstance(Math.max(SysProperties.SERVER_CACHED_OBJECTS, SysProperties.SERVER_RESULT_SET_FETCH_SIZE * 5));
    private final int threadId;
    private int clientVersion;
    private String sessionId;
    private long lastRemoteSettingsId;

    TcpServerThread(Socket socket, TcpServer server, int id) {
        this.server = server;
        this.threadId = id;
        this.transfer = new Transfer(null, socket);
    }

    private void trace(String s) {
        this.server.trace(String.valueOf(this) + " " + s);
    }

    @Override
    public void run() {
        try {
            Socket socket;
            block29: {
                this.transfer.init();
                this.trace("Connect");
                socket = this.transfer.getSocket();
                if (socket != null) break block29;
                return;
            }
            try {
                try {
                    String baseDir;
                    if (!this.server.allow(this.transfer.getSocket())) {
                        throw DbException.get(90117);
                    }
                    int minClientVersion = this.transfer.readInt();
                    if (minClientVersion < 6) {
                        throw DbException.get(90047, Integer.toString(minClientVersion), "17");
                    }
                    int maxClientVersion = this.transfer.readInt();
                    if (maxClientVersion < 17) {
                        throw DbException.get(90047, Integer.toString(maxClientVersion), "17");
                    }
                    if (minClientVersion > 21) {
                        throw DbException.get(90047, Integer.toString(minClientVersion), "21");
                    }
                    this.clientVersion = maxClientVersion >= 21 ? 21 : maxClientVersion;
                    this.transfer.setVersion(this.clientVersion);
                    String db = this.transfer.readString();
                    String originalURL = this.transfer.readString();
                    if (db == null && originalURL == null) {
                        String targetSessionId = this.transfer.readString();
                        int command = this.transfer.readInt();
                        this.stop = true;
                        if (command == 13) {
                            int statementId = this.transfer.readInt();
                            this.server.cancelStatement(targetSessionId, statementId);
                        } else if (command == 14) {
                            db = this.server.checkKeyAndGetDatabaseName(targetSessionId);
                            if (!targetSessionId.equals(db)) {
                                this.transfer.writeInt(1);
                            } else {
                                this.transfer.writeInt(0);
                            }
                        }
                    }
                    if ((baseDir = this.server.getBaseDir()) == null) {
                        baseDir = SysProperties.getBaseDir();
                    }
                    db = this.server.checkKeyAndGetDatabaseName(db);
                    ConnectionInfo ci = new ConnectionInfo(db);
                    ci.setOriginalURL(originalURL);
                    ci.setUserName(this.transfer.readString());
                    ci.setUserPasswordHash(this.transfer.readBytes());
                    ci.setFilePasswordHash(this.transfer.readBytes());
                    int len = this.transfer.readInt();
                    int i = 0;
                    while (i < len) {
                        ci.setProperty(this.transfer.readString(), this.transfer.readString());
                        ++i;
                    }
                    if (baseDir != null) {
                        ci.setBaseDir(baseDir);
                    }
                    if (this.server.getIfExists()) {
                        ci.setProperty("FORBID_CREATION", "TRUE");
                    }
                    this.transfer.writeInt(1);
                    this.transfer.writeInt(this.clientVersion);
                    this.transfer.flush();
                    if (ci.getFilePasswordHash() != null) {
                        ci.setFileEncryptionKey(this.transfer.readBytes());
                    }
                    ci.setNetworkConnectionInfo(new NetworkConnectionInfo(NetUtils.ipToShortForm(new StringBuilder(this.server.getSSL() ? "ssl://" : "tcp://"), socket.getLocalAddress().getAddress(), true).append(':').append(socket.getLocalPort()).toString(), socket.getInetAddress().getAddress(), socket.getPort(), "" + 'P' + this.clientVersion));
                    if (this.clientVersion < 20) {
                        ci.setProperty("OLD_INFORMATION_SCHEMA", "TRUE");
                        ci.setProperty("NON_KEYWORDS", "VALUE");
                    }
                    this.session = Engine.createSession(ci);
                    this.transfer.setSession(this.session);
                    this.server.addConnection(this.threadId, originalURL, ci.getUserName());
                    this.trace("Connected");
                    this.lastRemoteSettingsId = this.session.getDatabase().getRemoteSettingsId();
                }
                catch (OutOfMemoryError e) {
                    this.server.traceError(e);
                    this.sendError(e, true);
                    this.stop = true;
                }
                catch (Throwable e) {
                    this.sendError(e, true);
                    this.stop = true;
                }
                while (!this.stop) {
                    try {
                        this.process();
                    }
                    catch (Throwable e) {
                        this.sendError(e, true);
                    }
                }
                this.trace("Disconnect");
            }
            catch (Throwable e) {
                this.server.traceError(e);
            }
        }
        finally {
            this.close();
        }
    }

    private void closeSession() {
        block9: {
            if (this.session != null) {
                RuntimeException closeError;
                block8: {
                    closeError = null;
                    try {
                        this.session.close();
                        this.server.removeConnection(this.threadId);
                    }
                    catch (RuntimeException e) {
                        closeError = e;
                        this.server.traceError(e);
                        this.session = null;
                        break block8;
                    }
                    catch (Exception e) {
                        try {
                            this.server.traceError(e);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.session = null;
                        }
                    }
                    this.session = null;
                }
                if (closeError == null) break block9;
                throw closeError;
            }
        }
    }

    void close() {
        try {
            try {
                this.stop = true;
                this.closeSession();
            }
            catch (Exception e) {
                this.server.traceError(e);
                this.transfer.close();
                this.trace("Close");
                this.server.remove(this);
            }
        }
        finally {
            this.transfer.close();
            this.trace("Close");
            this.server.remove(this);
        }
    }

    private void sendError(Throwable t, boolean withStatus) {
        try {
            if (withStatus) {
                this.transfer.writeInt(0);
            }
            this.sendSQLException(DbException.convert(t).getSQLException());
            this.transfer.flush();
        }
        catch (Exception e) {
            if (!this.transfer.isClosed()) {
                this.server.traceError(e);
            }
            this.stop = true;
        }
    }

    private void sendSQLException(SQLException e) throws IOException {
        String sql;
        String message;
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String trace = writer.toString();
        if (e instanceof JdbcException) {
            JdbcException j = (JdbcException)((Object)e);
            message = j.getOriginalMessage();
            sql = j.getSQL();
        } else {
            message = e.getMessage();
            sql = null;
        }
        this.transfer.writeString(e.getSQLState()).writeString(message).writeString(sql).writeInt(e.getErrorCode()).writeString(trace);
    }

    private void setParameters(Command command) throws IOException {
        int len = this.transfer.readInt();
        ArrayList<? extends ParameterInterface> params = command.getParameters();
        int i = 0;
        while (i < len) {
            Parameter p = (Parameter)params.get(i);
            p.setValue(this.transfer.readValue(null));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process() throws IOException {
        SessionLocal session = this.session;
        int operation = this.transfer.readInt();
        switch (operation) {
            case 0: 
            case 18: {
                int id = this.transfer.readInt();
                String sql = this.transfer.readString();
                int old = session.getModificationId();
                Command command = session.prepareLocal(sql);
                boolean readonly = command.isReadOnly();
                this.cache.addObject(id, command);
                boolean isQuery = command.isQuery();
                this.transfer.writeInt(this.getState(old)).writeBoolean(isQuery).writeBoolean(readonly);
                if (operation != 0) {
                    this.transfer.writeInt(command.getCommandType());
                }
                ArrayList<? extends ParameterInterface> params = command.getParameters();
                this.transfer.writeInt(params.size());
                if (operation != 0) {
                    for (ParameterInterface parameterInterface : params) {
                        ParameterRemote.writeMetaData(this.transfer, parameterInterface);
                    }
                }
                this.transfer.flush();
                break;
            }
            case 1: {
                this.stop = true;
                this.closeSession();
                this.transfer.writeInt(1).flush();
                this.close();
                break;
            }
            case 8: {
                if (this.commit == null) {
                    this.commit = session.prepareLocal("COMMIT");
                }
                int old = session.getModificationId();
                this.commit.executeUpdate(null);
                this.transfer.writeInt(this.getState(old)).flush();
                break;
            }
            case 10: {
                int id = this.transfer.readInt();
                int objectId = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                ResultInterface result = command.getMetaData();
                this.cache.addObject(objectId, result);
                int columnCount = result.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(columnCount).writeRowCount(0L);
                int i = 0;
                while (i < columnCount) {
                    ResultColumn.writeColumn(this.transfer, result, i);
                    ++i;
                }
                this.transfer.flush();
                break;
            }
            case 2: {
                ResultInterface resultInterface;
                int id = this.transfer.readInt();
                int objectId = this.transfer.readInt();
                long maxRows = this.transfer.readRowCount();
                int fetchSize = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                this.setParameters(command);
                int old = session.getModificationId();
                session.lock();
                try {
                    resultInterface = command.executeQuery(maxRows, false);
                }
                finally {
                    session.unlock();
                }
                this.cache.addObject(objectId, resultInterface);
                int columnCount = resultInterface.getVisibleColumnCount();
                int state = this.getState(old);
                this.transfer.writeInt(state).writeInt(columnCount);
                long rowCount = resultInterface.isLazy() ? -1L : resultInterface.getRowCount();
                this.transfer.writeRowCount(rowCount);
                int i = 0;
                while (i < columnCount) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, i);
                    ++i;
                }
                this.sendRows(resultInterface, rowCount >= 0L ? Math.min(rowCount, (long)fetchSize) : (long)fetchSize);
                this.transfer.flush();
                break;
            }
            case 3: {
                int status;
                ResultWithGeneratedKeys result;
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                this.setParameters(command);
                Object generatedKeysRequest = this.readGeneratedKeysRequest();
                int old = session.getModificationId();
                session.lock();
                try {
                    result = command.executeUpdate(generatedKeysRequest);
                }
                finally {
                    session.unlock();
                }
                if (session.isClosed()) {
                    status = 2;
                    this.stop = true;
                } else {
                    status = this.getState(old);
                }
                this.transfer.writeInt(status);
                this.transfer.writeRowCount(result.getUpdateCount());
                this.transfer.writeBoolean(session.getAutoCommit());
                if (generatedKeysRequest != Boolean.FALSE) {
                    this.sendGeneratedKeys(result.getGeneratedKeys());
                }
                this.transfer.flush();
                break;
            }
            case 4: {
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, true);
                if (command == null) break;
                command.close();
                this.cache.freeObject(id);
                break;
            }
            case 5: {
                int id = this.transfer.readInt();
                int count = this.transfer.readInt();
                ResultInterface result = (ResultInterface)this.cache.getObject(id, false);
                this.transfer.writeInt(1);
                this.sendRows(result, count);
                this.transfer.flush();
                break;
            }
            case 6: {
                int id = this.transfer.readInt();
                ResultInterface result = (ResultInterface)this.cache.getObject(id, false);
                result.reset();
                break;
            }
            case 7: {
                int id = this.transfer.readInt();
                ResultInterface result = (ResultInterface)this.cache.getObject(id, true);
                if (result == null) break;
                result.close();
                this.cache.freeObject(id);
                break;
            }
            case 9: {
                int oldId = this.transfer.readInt();
                int newId = this.transfer.readInt();
                Object obj = this.cache.getObject(oldId, false);
                this.cache.freeObject(oldId);
                this.cache.addObject(newId, obj);
                break;
            }
            case 12: {
                this.sessionId = this.transfer.readString();
                if (this.clientVersion >= 20) {
                    session.setTimeZone(TimeZoneProvider.ofId(this.transfer.readString()));
                }
                this.transfer.writeInt(1).writeBoolean(session.getAutoCommit()).flush();
                break;
            }
            case 15: {
                boolean autoCommit = this.transfer.readBoolean();
                session.setAutoCommit(autoCommit);
                this.transfer.writeInt(1).flush();
                break;
            }
            case 16: {
                this.transfer.writeInt(1).writeInt(session.hasPendingTransaction() ? 1 : 0).flush();
                break;
            }
            case 17: {
                long lobId = this.transfer.readLong();
                byte[] hmac = this.transfer.readBytes();
                long offset = this.transfer.readLong();
                int length = this.transfer.readInt();
                this.transfer.verifyLobMac(hmac, lobId);
                CachedInputStream in = (CachedInputStream)this.lobs.get(lobId);
                if (in == null || in.getPos() != offset) {
                    LobStorageInterface lobStorageInterface = session.getDataHandler().getLobStorage();
                    InputStream lobIn = lobStorageInterface.getInputStream(lobId, -1L);
                    in = new CachedInputStream(lobIn);
                    this.lobs.put(lobId, in);
                    lobIn.skip(offset);
                }
                length = Math.min(65536, length);
                byte[] byArray = new byte[length];
                length = IOUtils.readFully(in, byArray, length);
                this.transfer.writeInt(1);
                this.transfer.writeInt(length);
                this.transfer.writeBytes(byArray, 0, length);
                this.transfer.flush();
                break;
            }
            case 19: {
                ResultInterface result;
                int code = this.transfer.readInt();
                int length = this.transfer.readInt();
                Value[] args = new Value[length];
                int i = 0;
                while (i < length) {
                    args[i] = this.transfer.readValue(null);
                    ++i;
                }
                int old = session.getModificationId();
                session.lock();
                try {
                    result = DatabaseMetaServer.process(session, code, args);
                }
                finally {
                    session.unlock();
                }
                int columnCount = result.getVisibleColumnCount();
                int state = this.getState(old);
                this.transfer.writeInt(state).writeInt(columnCount);
                long l = result.getRowCount();
                this.transfer.writeRowCount(l);
                int i2 = 0;
                while (i2 < columnCount) {
                    ResultColumn.writeColumn(this.transfer, result, i2);
                    ++i2;
                }
                this.sendRows(result, l);
                this.transfer.flush();
                break;
            }
            case 20: {
                void var10_79;
                BatchResult result;
                int id = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(id, false);
                int size = this.transfer.readInt();
                ArrayList<Value[]> batchParameters = new ArrayList<Value[]>(size);
                int i = 0;
                while (i < size) {
                    int len = this.transfer.readInt();
                    Value[] parameters = new Value[len];
                    int n = 0;
                    while (n < len) {
                        parameters[n] = this.transfer.readValue(null);
                        ++n;
                    }
                    batchParameters.add(parameters);
                    ++i;
                }
                Object generatedKeysRequest = this.readGeneratedKeysRequest();
                int old = session.getModificationId();
                session.lock();
                try {
                    result = command.executeBatchUpdate(batchParameters, generatedKeysRequest);
                }
                finally {
                    session.unlock();
                }
                if (session.isClosed()) {
                    int n = 2;
                    this.stop = true;
                } else {
                    int n = this.getState(old);
                }
                this.transfer.writeInt((int)var10_79);
                long[] lArray = result.getUpdateCounts();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long updateCount = lArray[n2];
                    this.transfer.writeLong(updateCount);
                    ++n2;
                }
                if (generatedKeysRequest != Boolean.FALSE) {
                    this.sendGeneratedKeys(result.getGeneratedKeys());
                }
                List<SQLException> exceptions = result.getExceptions();
                this.transfer.writeInt(exceptions.size());
                for (SQLException exception : exceptions) {
                    this.sendSQLException(exception);
                }
                this.transfer.writeBoolean(session.getAutoCommit());
                this.transfer.flush();
                break;
            }
            default: {
                this.trace("Unknown operation: " + operation);
                this.close();
            }
        }
    }

    private Object readGeneratedKeysRequest() throws IOException {
        int mode = this.transfer.readInt();
        switch (mode) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                int len = this.transfer.readInt();
                int[] keys = new int[len];
                int i = 0;
                while (i < len) {
                    keys[i] = this.transfer.readInt();
                    ++i;
                }
                return keys;
            }
            case 3: {
                int len = this.transfer.readInt();
                String[] keys = new String[len];
                int i = 0;
                while (i < len) {
                    keys[i] = this.transfer.readString();
                    ++i;
                }
                return keys;
            }
        }
        throw DbException.get(90067, "Unsupported generated keys' mode " + mode);
    }

    private void sendGeneratedKeys(ResultInterface generatedKeys) throws IOException {
        int columnCount = generatedKeys.getVisibleColumnCount();
        this.transfer.writeInt(columnCount);
        long rowCount = generatedKeys.getRowCount();
        this.transfer.writeRowCount(rowCount);
        int i = 0;
        while (i < columnCount) {
            ResultColumn.writeColumn(this.transfer, generatedKeys, i);
            ++i;
        }
        this.sendRows(generatedKeys, rowCount);
        generatedKeys.close();
    }

    private int getState(int oldModificationId) {
        if (this.session == null) {
            return 2;
        }
        if (this.session.getModificationId() == oldModificationId) {
            long remoteSettingsId = this.session.getDatabase().getRemoteSettingsId();
            if (this.lastRemoteSettingsId == remoteSettingsId) {
                return 1;
            }
            this.lastRemoteSettingsId = remoteSettingsId;
        }
        return 3;
    }

    private void sendRows(ResultInterface result, long count) throws IOException {
        int columnCount = result.getVisibleColumnCount();
        boolean lazy = result.isLazy();
        Session oldSession = lazy ? this.session.setThreadLocalSession() : null;
        try {
            while (count-- > 0L) {
                boolean hasNext;
                try {
                    hasNext = result.next();
                }
                catch (Exception e) {
                    this.transfer.writeByte((byte)-1);
                    this.sendError(e, false);
                    break;
                }
                if (hasNext) {
                    this.transfer.writeByte((byte)1);
                    Value[] values = result.currentRow();
                    int i = 0;
                    while (i < columnCount) {
                        ValueLob v2;
                        Value v = values[i];
                        if (lazy && v instanceof ValueLob && (v2 = ((ValueLob)v).copyToResult()) != v) {
                            v = this.session.addTemporaryLob(v2);
                        }
                        this.transfer.writeValue(v);
                        ++i;
                    }
                    continue;
                }
                this.transfer.writeByte((byte)0);
                break;
            }
        }
        finally {
            if (lazy) {
                this.session.resetThreadLocalSession(oldSession);
            }
        }
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void cancelStatement(String targetSessionId, int statementId) {
        if (Objects.equals(targetSessionId, this.sessionId)) {
            Command cmd = (Command)this.cache.getObject(statementId, false);
            cmd.cancel();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class CachedInputStream
    extends FilterInputStream {
        private static final ByteArrayInputStream DUMMY = new ByteArrayInputStream(new byte[0]);
        private long pos;

        CachedInputStream(InputStream in) {
            super(in == null ? DUMMY : in);
            if (in == null) {
                this.pos = -1L;
            }
        }

        @Override
        public int read(byte[] buff, int off, int len) throws IOException {
            if ((len = super.read(buff, off, len)) > 0) {
                this.pos += (long)len;
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            int x = this.in.read();
            if (x >= 0) {
                ++this.pos;
            }
            return x;
        }

        @Override
        public long skip(long n) throws IOException {
            if ((n = super.skip(n)) > 0L) {
                this.pos += n;
            }
            return n;
        }

        public long getPos() {
            return this.pos;
        }
    }
}

