/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.tools.Server;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JakartaDbStarter
implements ServletContextListener {
    private Connection conn;
    private Server server;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Driver.load();
            ServletContext servletContext = servletContextEvent.getServletContext();
            String url = JakartaDbStarter.getParameter(servletContext, "db.url", "jdbc:h2:~/test");
            String user = JakartaDbStarter.getParameter(servletContext, "db.user", "sa");
            String password = JakartaDbStarter.getParameter(servletContext, "db.password", "sa");
            String serverParams = JakartaDbStarter.getParameter(servletContext, "db.tcpServer", null);
            if (serverParams != null) {
                String[] params = StringUtils.arraySplit(serverParams, ' ', true);
                this.server = Server.createTcpServer(params);
                this.server.start();
            }
            this.conn = DriverManager.getConnection(url, user, password);
            servletContext.setAttribute("connection", (Object)this.conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getParameter(ServletContext servletContext, String key, String defaultValue) {
        String value = servletContext.getInitParameter(key);
        return value == null ? defaultValue : value;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            Statement stat = this.conn.createStatement();
            stat.execute("SHUTDOWN");
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

