/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.bnf.Bnf;
import org.h2.bnf.context.DbColumn;
import org.h2.bnf.context.DbContents;
import org.h2.bnf.context.DbSchema;
import org.h2.bnf.context.DbTableOrView;
import org.h2.command.ParserBase;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcException;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.tools.Backup;
import org.h2.tools.ChangeFileEncryption;
import org.h2.tools.ConvertTraceFile;
import org.h2.tools.CreateCluster;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Recover;
import org.h2.tools.Restore;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.Profiler;
import org.h2.util.ScriptReader;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.value.DataType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WebApp {
    private static final Comparator<DbTableOrView> SYSTEM_SCHEMA_COMPARATOR = Comparator.comparing(DbTableOrView::getName, String.CASE_INSENSITIVE_ORDER);
    protected final WebServer server;
    protected WebSession session;
    protected Properties attributes;
    protected String mimeType;
    protected boolean cache;
    protected boolean stop;
    protected String headerLanguage;
    private Profiler profiler;

    WebApp(WebServer server) {
        this.server = server;
    }

    void setSession(WebSession session, Properties attributes) {
        this.session = session;
        this.attributes = attributes;
    }

    String processRequest(String file, NetworkConnectionInfo networkConnectionInfo) {
        block22: {
            block21: {
                int index = file.lastIndexOf(46);
                String suffix = index >= 0 ? file.substring(index + 1) : "";
                if ("ico".equals(suffix)) {
                    this.mimeType = "image/x-icon";
                    this.cache = true;
                } else if ("gif".equals(suffix)) {
                    this.mimeType = "image/gif";
                    this.cache = true;
                } else if ("css".equals(suffix)) {
                    this.cache = true;
                    this.mimeType = "text/css";
                } else if ("html".equals(suffix) || "do".equals(suffix) || "jsp".equals(suffix)) {
                    this.cache = false;
                    this.mimeType = "text/html";
                    if (this.session == null) {
                        this.session = this.server.createNewSession(NetUtils.ipToShortForm(null, networkConnectionInfo.getClientAddr(), false).toString());
                        if (!"notAllowed.jsp".equals(file)) {
                            file = "index.do";
                        }
                    }
                } else if ("js".equals(suffix)) {
                    this.cache = true;
                    this.mimeType = "text/javascript";
                } else {
                    this.cache = true;
                    this.mimeType = "application/octet-stream";
                }
                this.trace("mimeType=" + this.mimeType);
                this.trace(file);
                if (!file.endsWith(".do")) break block21;
                file = this.process(file, networkConnectionInfo);
                break block22;
            }
            if (!file.endsWith(".jsp")) break block22;
            switch (file) {
                case "tools.jsp": 
                case "admin.jsp": {
                    if (this.checkAdmin(file)) break;
                    file = this.process("adminLogin.do", networkConnectionInfo);
                }
            }
        }
        return file;
    }

    private static String getComboBox(String[] elements, String selected) {
        StringBuilder buff = new StringBuilder();
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            buff.append("<option value=\"").append(PageParser.escapeHtmlData(value)).append('\"');
            if (value.equals(selected)) {
                buff.append(" selected");
            }
            buff.append('>').append(PageParser.escapeHtml(value)).append("</option>");
            ++n2;
        }
        return buff.toString();
    }

    private static String getComboBox(String[][] elements, String selected) {
        StringBuilder buff = new StringBuilder();
        String[][] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String[] n3 = stringArray[n2];
            buff.append("<option value=\"").append(PageParser.escapeHtmlData(n3[0])).append('\"');
            if (n3[0].equals(selected)) {
                buff.append(" selected");
            }
            buff.append('>').append(PageParser.escapeHtml(n3[1])).append("</option>");
            ++n2;
        }
        return buff.toString();
    }

    private String process(String file, NetworkConnectionInfo networkConnectionInfo) {
        this.trace("process " + file);
        while (file.endsWith(".do")) {
            switch (file) {
                case "login.do": {
                    file = this.login(networkConnectionInfo);
                    break;
                }
                case "index.do": {
                    file = this.index();
                    break;
                }
                case "logout.do": {
                    file = this.logout();
                    break;
                }
                case "settingRemove.do": {
                    file = this.settingRemove();
                    break;
                }
                case "settingSave.do": {
                    file = this.settingSave();
                    break;
                }
                case "test.do": {
                    file = this.test(networkConnectionInfo);
                    break;
                }
                case "query.do": {
                    file = this.query();
                    break;
                }
                case "tables.do": {
                    file = this.tables();
                    break;
                }
                case "editResult.do": {
                    file = this.editResult();
                    break;
                }
                case "getHistory.do": {
                    file = this.getHistory();
                    break;
                }
                case "admin.do": {
                    file = this.checkAdmin(file) ? this.admin() : "adminLogin.do";
                    break;
                }
                case "adminSave.do": {
                    file = this.checkAdmin(file) ? this.adminSave() : "adminLogin.do";
                    break;
                }
                case "adminStartTranslate.do": {
                    file = this.checkAdmin(file) ? this.adminStartTranslate() : "adminLogin.do";
                    break;
                }
                case "adminShutdown.do": {
                    file = this.checkAdmin(file) ? this.adminShutdown() : "adminLogin.do";
                    break;
                }
                case "autoCompleteList.do": {
                    file = this.autoCompleteList();
                    break;
                }
                case "tools.do": {
                    file = this.checkAdmin(file) ? this.tools() : "adminLogin.do";
                    break;
                }
                case "adminLogin.do": {
                    file = this.adminLogin();
                    break;
                }
                default: {
                    file = "error.jsp";
                }
            }
        }
        this.trace("return " + file);
        return file;
    }

    private boolean checkAdmin(String file) {
        Boolean b = (Boolean)this.session.get("admin");
        if (b != null && b.booleanValue()) {
            return true;
        }
        String key = this.server.getKey();
        if (key != null && key.equals(this.session.get("key"))) {
            return true;
        }
        this.session.put("adminBack", file);
        return false;
    }

    private String adminLogin() {
        String password = this.attributes.getProperty("password");
        if (password == null || password.isEmpty() || !this.server.checkAdminPassword(password)) {
            return "adminLogin.jsp";
        }
        String back = (String)this.session.remove("adminBack");
        this.session.put("admin", true);
        return back != null ? back : "admin.do";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String autoCompleteList() {
        String query = (String)this.attributes.get("query");
        boolean lowercase = false;
        String tQuery = query.trim();
        if (!tQuery.isEmpty() && Character.isLowerCase(tQuery.charAt(0))) {
            lowercase = true;
        }
        try {
            Object result;
            block17: {
                char last;
                Bnf bnf;
                String lastSql;
                Object sql;
                block16: {
                    sql = query;
                    if (((String)sql).endsWith(";")) {
                        sql = (String)sql + " ";
                    }
                    ScriptReader reader = new ScriptReader(new StringReader((String)sql));
                    reader.setSkipRemarks(true);
                    lastSql = "";
                    while (true) {
                        String n;
                        if ((n = reader.readStatement()) == null) {
                            result = "";
                            if (reader.isInsideRemark()) {
                                break;
                            }
                            break block16;
                        }
                        lastSql = n;
                    }
                    result = reader.isBlockRemark() ? "1#(End Remark)# */\n" + (String)result : "1#(Newline)#\n" + (String)result;
                    break block17;
                }
                sql = lastSql;
                while (true) {
                    if (((String)sql).length() <= 0 || ((String)sql).charAt(0) > ' ') {
                        String tSql = ((String)sql).trim();
                        if (!tSql.isEmpty() && Character.isLowerCase(tSql.charAt(0))) {
                            lowercase = true;
                        }
                        if ((bnf = this.session.getBnf()) != null) break;
                        return "autoCompleteList.jsp";
                    }
                    sql = ((String)sql).substring(1);
                }
                HashMap<String, String> map = bnf.getNextTokenList((String)sql);
                String space = "";
                if (((String)sql).length() > 0 && !Character.isWhitespace(last = ((String)sql).charAt(((String)sql).length() - 1)) && last != '.' && last >= ' ' && last != '\'' && last != '\"') {
                    space = " ";
                }
                ArrayList<Object> list = new ArrayList<Object>(map.size());
                Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        Collections.sort(list);
                        if (query.endsWith("\n") || tQuery.endsWith(";")) {
                            list.add(0, "1#(Newline)#\n");
                        }
                        result = String.join((CharSequence)"|", list);
                        break;
                    }
                    Map.Entry<String, String> entry = iterator.next();
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    String type = String.valueOf(key.charAt(0));
                    if (Integer.parseInt(type) > 2) continue;
                    if (Character.isLetter((key = key.substring(2)).charAt(0)) && lowercase) {
                        key = StringUtils.toLowerEnglish(key);
                        value = StringUtils.toLowerEnglish((String)value);
                    }
                    if (key.equals(value) && !".".equals(value)) {
                        value = space + (String)value;
                    }
                    key = StringUtils.urlEncode(key);
                    key = key.replace('+', ' ');
                    value = StringUtils.urlEncode((String)value);
                    value = ((String)value).replace('+', ' ');
                    list.add(type + "#" + key + "#" + (String)value);
                }
            }
            this.session.put("autoCompleteList", result);
            return "autoCompleteList.jsp";
        }
        catch (Throwable e) {
            this.server.traceError(e);
        }
        return "autoCompleteList.jsp";
    }

    private String admin() {
        this.session.put("port", Integer.toString(this.server.getPort()));
        this.session.put("allowOthers", Boolean.toString(this.server.getAllowOthers()));
        this.session.put("webExternalNames", this.server.getExternalNames());
        this.session.put("ssl", String.valueOf(this.server.getSSL()));
        this.session.put("sessions", this.server.getSessions());
        return "admin.jsp";
    }

    private String adminSave() {
        try {
            SortedProperties prop = new SortedProperties();
            int port = Integer.decode((String)this.attributes.get("port"));
            prop.setProperty("webPort", Integer.toString(port));
            this.server.setPort(port);
            boolean allowOthers = Utils.parseBoolean((String)this.attributes.get("allowOthers"), false, false);
            prop.setProperty("webAllowOthers", String.valueOf(allowOthers));
            this.server.setAllowOthers(allowOthers);
            String externalNames = (String)this.attributes.get("webExternalNames");
            prop.setProperty("webExternalNames", externalNames);
            this.server.setExternalNames(externalNames);
            boolean ssl = Utils.parseBoolean((String)this.attributes.get("ssl"), false, false);
            prop.setProperty("webSSL", String.valueOf(ssl));
            this.server.setSSL(ssl);
            byte[] adminPassword = this.server.getAdminPassword();
            if (adminPassword != null) {
                prop.setProperty("webAdminPassword", StringUtils.convertBytesToHex(adminPassword));
            }
            this.server.saveProperties(prop);
        }
        catch (Exception e) {
            this.trace(e.toString());
        }
        return this.admin();
    }

    private String tools() {
        try {
            String toolName = (String)this.attributes.get("tool");
            this.session.put("tool", toolName);
            String args = (String)this.attributes.get("args");
            String[] argList = StringUtils.arraySplit(args, ',', false);
            Tool tool = null;
            if ("Backup".equals(toolName)) {
                tool = new Backup();
            } else if ("Restore".equals(toolName)) {
                tool = new Restore();
            } else if ("Recover".equals(toolName)) {
                tool = new Recover();
            } else if ("DeleteDbFiles".equals(toolName)) {
                tool = new DeleteDbFiles();
            } else if ("ChangeFileEncryption".equals(toolName)) {
                tool = new ChangeFileEncryption();
            } else if ("Script".equals(toolName)) {
                tool = new Script();
            } else if ("RunScript".equals(toolName)) {
                tool = new RunScript();
            } else if ("ConvertTraceFile".equals(toolName)) {
                tool = new ConvertTraceFile();
            } else if ("CreateCluster".equals(toolName)) {
                tool = new CreateCluster();
            } else {
                throw DbException.getInternalError(toolName);
            }
            ByteArrayOutputStream outBuff = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)outBuff, false, "UTF-8");
            tool.setOut(out);
            try {
                tool.runTool(argList);
                out.flush();
                String o = outBuff.toString(StandardCharsets.UTF_8);
                String result = PageParser.escapeHtml(o);
                this.session.put("toolResult", result);
            }
            catch (Exception e) {
                this.session.put("toolResult", this.getStackTrace(0, e, true));
            }
        }
        catch (Exception e) {
            this.server.traceError(e);
        }
        return "tools.jsp";
    }

    private String adminStartTranslate() {
        Map p;
        Map p2 = p = (Map)Map.class.cast(this.session.map.get("text"));
        String file = this.server.startTranslate(p2);
        this.session.put("translationFile", file);
        return "helpTranslate.jsp";
    }

    protected String adminShutdown() {
        this.server.shutdown();
        return "admin.jsp";
    }

    private String index() {
        String[][] languageArray = WebServer.LANGUAGES;
        String language = (String)this.attributes.get("language");
        Locale locale = this.session.locale;
        if (language != null) {
            if (locale == null || !StringUtils.toLowerEnglish(locale.getLanguage()).equals(language)) {
                locale = new Locale(language, "");
                this.server.readTranslations(this.session, locale.getLanguage());
                this.session.put("language", language);
                this.session.locale = locale;
            }
        } else {
            language = (String)this.session.get("language");
        }
        if (language == null) {
            language = this.headerLanguage;
        }
        this.session.put("languageCombo", WebApp.getComboBox(languageArray, language));
        String[] settingNames = this.server.getSettingNames();
        String setting = this.attributes.getProperty("setting");
        if (setting == null && settingNames.length > 0) {
            setting = settingNames[0];
        }
        String combobox = WebApp.getComboBox(settingNames, setting);
        this.session.put("settingsList", combobox);
        ConnectionInfo info = this.server.getSetting(setting);
        if (info == null) {
            info = new ConnectionInfo();
        }
        this.session.put("setting", PageParser.escapeHtmlData(setting));
        this.session.put("name", PageParser.escapeHtmlData(setting));
        this.session.put("driver", PageParser.escapeHtmlData(info.driver));
        this.session.put("url", PageParser.escapeHtmlData(info.url));
        this.session.put("user", PageParser.escapeHtmlData(info.user));
        return "index.jsp";
    }

    private String getHistory() {
        int id = Integer.parseInt(this.attributes.getProperty("id"));
        String sql = this.session.getCommand(id);
        this.session.put("query", PageParser.escapeHtmlData(sql));
        return "query.jsp";
    }

    private static int addColumns(boolean mainSchema, DbTableOrView table, StringBuilder builder, int treeIndex, boolean showColumnTypes, StringBuilder columnsBuilder) {
        DbColumn[] columns = table.getColumns();
        int i = 0;
        while (columns != null && i < columns.length) {
            DbColumn column = columns[i];
            if (columnsBuilder.length() > 0) {
                columnsBuilder.append(' ');
            }
            columnsBuilder.append(column.getName());
            String col = WebApp.escapeIdentifier(column.getName());
            String level = mainSchema ? ", 1, 1" : ", 2, 2";
            builder.append("setNode(").append(treeIndex).append(level).append(", 'column', '").append(PageParser.escapeJavaScript(column.getName())).append("', 'javascript:ins(\\'").append(col).append("\\')');\n");
            ++treeIndex;
            if (mainSchema && showColumnTypes) {
                builder.append("setNode(").append(treeIndex).append(", 2, 2, 'type', '").append(PageParser.escapeJavaScript(column.getDataType())).append("', null);\n");
                ++treeIndex;
            }
            ++i;
        }
        return treeIndex;
    }

    private static String escapeIdentifier(String name) {
        return StringUtils.urlEncode(PageParser.escapeJavaScript(name)).replace('+', ' ');
    }

    private static int addIndexes(boolean mainSchema, DatabaseMetaData meta, String table, String schema, StringBuilder buff, int treeIndex) throws SQLException {
        ResultSet rs;
        try {
            rs = meta.getIndexInfo(null, schema, table, false, true);
        }
        catch (SQLException e) {
            return treeIndex;
        }
        HashMap<String, IndexInfo> indexMap = new HashMap<String, IndexInfo>();
        while (rs.next()) {
            String name = rs.getString("INDEX_NAME");
            IndexInfo info = (IndexInfo)indexMap.get(name);
            if (info == null) {
                int t = rs.getInt("TYPE");
                Object type = t == 1 ? "" : (t == 2 ? " (${text.tree.hashed})" : (t == 3 ? "" : null));
                if (name == null || type == null) continue;
                info = new IndexInfo();
                info.name = name;
                info.type = type = (rs.getBoolean("NON_UNIQUE") ? "${text.tree.nonUnique}" : "${text.tree.unique}") + (String)type;
                info.columns = rs.getString("COLUMN_NAME");
                indexMap.put(name, info);
                continue;
            }
            info.columns = String.valueOf(info.columns) + ", " + rs.getString("COLUMN_NAME");
        }
        rs.close();
        if (indexMap.size() > 0) {
            String level = mainSchema ? ", 1, 1" : ", 2, 1";
            String levelIndex = mainSchema ? ", 2, 1" : ", 3, 1";
            String levelColumnType = mainSchema ? ", 3, 2" : ", 4, 2";
            buff.append("setNode(").append(treeIndex).append(level).append(", 'index_az', '${text.tree.indexes}', null);\n");
            ++treeIndex;
            for (IndexInfo info : indexMap.values()) {
                buff.append("setNode(").append(treeIndex).append(levelIndex).append(", 'index', '").append(PageParser.escapeJavaScript(info.name)).append("', null);\n");
                buff.append("setNode(").append(++treeIndex).append(levelColumnType).append(", 'type', '").append(info.type).append("', null);\n");
                buff.append("setNode(").append(++treeIndex).append(levelColumnType).append(", 'type', '").append(PageParser.escapeJavaScript(info.columns)).append("', null);\n");
                ++treeIndex;
            }
        }
        return treeIndex;
    }

    private int addTablesAndViews(DbSchema schema, boolean mainSchema, StringBuilder builder, int treeIndex) throws SQLException {
        if (schema == null) {
            return treeIndex;
        }
        Connection conn = this.session.getConnection();
        DatabaseMetaData meta = this.session.getMetaData();
        int level = mainSchema ? 0 : 1;
        boolean showColumns = mainSchema || !schema.isSystem;
        String indentation = ", " + level + ", " + (showColumns ? "1" : "2") + ", ";
        String indentNode = ", " + (level + 1) + ", 2, ";
        DbTableOrView[] tables = schema.getTables();
        if (tables == null) {
            return treeIndex;
        }
        DbContents contents = schema.getContents();
        boolean isOracle = contents.isOracle();
        boolean notManyTables = tables.length < SysProperties.CONSOLE_MAX_TABLES_LIST_INDEXES;
        Throwable throwable = null;
        Object var16_17 = null;
        try (PreparedStatement prep = showColumns ? WebApp.prepareViewDefinitionQuery(conn, contents) : null;){
            if (prep != null) {
                prep.setString(1, schema.name);
            }
            AtomicReference<PreparedStatement> prepRef = new AtomicReference<PreparedStatement>(prep);
            if (schema.isSystem) {
                Arrays.sort(tables, SYSTEM_SCHEMA_COMPARATOR);
                DbTableOrView[] dbTableOrViewArray = tables;
                int n = tables.length;
                int n2 = 0;
                while (n2 < n) {
                    DbTableOrView table = dbTableOrViewArray[n2];
                    treeIndex = WebApp.addTableOrView(schema, mainSchema, builder, treeIndex, meta, false, indentation, isOracle, notManyTables, table, table.isView(), prepRef, indentNode);
                    ++n2;
                }
            } else {
                DbTableOrView table;
                DbTableOrView[] dbTableOrViewArray = tables;
                int n = tables.length;
                int n3 = 0;
                while (n3 < n) {
                    table = dbTableOrViewArray[n3];
                    if (!table.isView()) {
                        treeIndex = WebApp.addTableOrView(schema, mainSchema, builder, treeIndex, meta, showColumns, indentation, isOracle, notManyTables, table, false, null, indentNode);
                    }
                    ++n3;
                }
                dbTableOrViewArray = tables;
                n = tables.length;
                n3 = 0;
                while (n3 < n) {
                    table = dbTableOrViewArray[n3];
                    if (table.isView()) {
                        treeIndex = WebApp.addTableOrView(schema, mainSchema, builder, treeIndex, meta, showColumns, indentation, isOracle, notManyTables, table, true, prepRef, indentNode);
                    }
                    ++n3;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return treeIndex;
    }

    private static PreparedStatement prepareViewDefinitionQuery(Connection conn, DbContents contents) {
        if (contents.mayHaveStandardViews()) {
            try {
                return conn.prepareStatement("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?");
            }
            catch (SQLException e) {
                contents.setMayHaveStandardViews(false);
            }
        }
        return null;
    }

    private static int addTableOrView(DbSchema schema, boolean mainSchema, StringBuilder builder, int treeIndex, DatabaseMetaData meta, boolean showColumns, String indentation, boolean isOracle, boolean notManyTables, DbTableOrView table, boolean isView, AtomicReference<PreparedStatement> prepRef, String indentNode) throws SQLException {
        int tableId = treeIndex;
        Object tab = table.getQuotedName();
        if (!mainSchema) {
            tab = schema.quotedName + "." + (String)tab;
        }
        tab = WebApp.escapeIdentifier((String)tab);
        builder.append("setNode(").append(treeIndex).append(indentation).append(" '").append(isView ? "view" : "table").append("', '").append(PageParser.escapeJavaScript(table.getName())).append("', 'javascript:ins(\\'").append((String)tab).append("\\',true)');\n");
        ++treeIndex;
        if (showColumns) {
            StringBuilder columnsBuilder = new StringBuilder();
            treeIndex = WebApp.addColumns(mainSchema, table, builder, treeIndex, notManyTables, columnsBuilder);
            if (isView) {
                PreparedStatement prep = prepRef.get();
                if (prep != null) {
                    prep.setString(2, table.getName());
                    try {
                        Throwable throwable = null;
                        Object var18_20 = null;
                        try (ResultSet rs = prep.executeQuery();){
                            String sql;
                            if (rs.next() && (sql = rs.getString(1)) != null) {
                                builder.append("setNode(").append(treeIndex).append(indentNode).append(" 'type', '").append(PageParser.escapeJavaScript(sql)).append("', null);\n");
                                ++treeIndex;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        prepRef.set(null);
                    }
                }
            } else if (!isOracle && notManyTables) {
                treeIndex = WebApp.addIndexes(mainSchema, meta, table.getName(), schema.name, builder, treeIndex);
            }
            builder.append("addTable('").append(PageParser.escapeJavaScript(table.getName())).append("', '").append(PageParser.escapeJavaScript(columnsBuilder.toString())).append("', ").append(tableId).append(");\n");
        }
        return treeIndex;
    }

    private String tables() {
        DbContents contents = this.session.getContents();
        boolean isH2 = false;
        try {
            Object schema;
            DbSchema[] schemas;
            String url = (String)this.session.get("url");
            Connection conn = this.session.getConnection();
            contents.readContents(url, conn);
            this.session.loadBnf();
            isH2 = contents.isH2();
            StringBuilder buff = new StringBuilder().append("setNode(0, 0, 0, 'database', '").append(PageParser.escapeJavaScript(url)).append("', null);\n");
            int treeIndex = 1;
            DbSchema defaultSchema = contents.getDefaultSchema();
            treeIndex = this.addTablesAndViews(defaultSchema, true, buff, treeIndex);
            DbSchema[] dbSchemaArray = schemas = contents.getSchemas();
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                schema = dbSchemaArray[n2];
                if (schema != defaultSchema && schema != null) {
                    buff.append("setNode(").append(treeIndex).append(", 0, 1, 'folder', '").append(PageParser.escapeJavaScript(((DbSchema)schema).name)).append("', null);\n");
                    ++treeIndex;
                    treeIndex = this.addTablesAndViews((DbSchema)schema, false, buff, treeIndex);
                }
                ++n2;
            }
            if (isH2) {
                schema = null;
                Object var10_14 = null;
                try (Statement stat = conn.createStatement();){
                    String name;
                    ResultSet rs;
                    try {
                        rs = stat.executeQuery("SELECT SEQUENCE_NAME, BASE_VALUE, INCREMENT FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    }
                    catch (SQLException e) {
                        rs = stat.executeQuery("SELECT SEQUENCE_NAME, CURRENT_VALUE, INCREMENT FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    }
                    int i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            buff.append("setNode(").append(treeIndex).append(", 0, 1, 'sequences', '${text.tree.sequences}', null);\n");
                            ++treeIndex;
                        }
                        name = rs.getString(1);
                        String currentBase = rs.getString(2);
                        String increment = rs.getString(3);
                        buff.append("setNode(").append(treeIndex).append(", 1, 1, 'sequence', '").append(PageParser.escapeJavaScript(name)).append("', null);\n");
                        buff.append("setNode(").append(++treeIndex).append(", 2, 2, 'type', '${text.tree.current}: ").append(PageParser.escapeJavaScript(currentBase)).append("', null);\n");
                        ++treeIndex;
                        if (!"1".equals(increment)) {
                            buff.append("setNode(").append(treeIndex).append(", 2, 2, 'type', '${text.tree.increment}: ").append(PageParser.escapeJavaScript(increment)).append("', null);\n");
                            ++treeIndex;
                        }
                        ++i;
                    }
                    rs.close();
                    try {
                        rs = stat.executeQuery("SELECT USER_NAME, IS_ADMIN FROM INFORMATION_SCHEMA.USERS ORDER BY USER_NAME");
                    }
                    catch (SQLException e) {
                        rs = stat.executeQuery("SELECT NAME, ADMIN FROM INFORMATION_SCHEMA.USERS ORDER BY NAME");
                    }
                    i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            buff.append("setNode(").append(treeIndex).append(", 0, 1, 'users', '${text.tree.users}', null);\n");
                            ++treeIndex;
                        }
                        name = rs.getString(1);
                        String admin = rs.getString(2);
                        buff.append("setNode(").append(treeIndex).append(", 1, 1, 'user', '").append(PageParser.escapeJavaScript(name)).append("', null);\n");
                        ++treeIndex;
                        if (admin.equalsIgnoreCase("TRUE")) {
                            buff.append("setNode(").append(treeIndex).append(", 2, 2, 'type', '${text.tree.admin}', null);\n");
                            ++treeIndex;
                        }
                        ++i;
                    }
                    rs.close();
                }
                catch (Throwable throwable) {
                    if (schema == null) {
                        schema = throwable;
                    } else if (schema != throwable) {
                        ((Throwable)schema).addSuppressed(throwable);
                    }
                    throw schema;
                }
            }
            DatabaseMetaData meta = this.session.getMetaData();
            String version = meta.getDatabaseProductName() + " " + meta.getDatabaseProductVersion();
            buff.append("setNode(").append(treeIndex).append(", 0, 0, 'info', '").append(PageParser.escapeJavaScript(version)).append("', null);\n").append("refreshQueryTables();");
            this.session.put("tree", buff.toString());
        }
        catch (Exception e) {
            this.session.put("tree", "");
            this.session.put("error", this.getStackTrace(0, e, isH2));
        }
        return "tables.jsp";
    }

    private String getStackTrace(int id, Throwable e, boolean isH2) {
        try {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String stackTrace = writer.toString();
            stackTrace = PageParser.escapeHtml(stackTrace);
            if (isH2) {
                stackTrace = WebApp.linkToSource(stackTrace);
            }
            stackTrace = StringUtils.replaceAll(stackTrace, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            String message = PageParser.escapeHtml(e.getMessage());
            Object error = "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('st" + id + "').style;x.display=x.display==''?'none':'';\">" + message + "</a>";
            if (e instanceof SQLException) {
                SQLException se = (SQLException)e;
                error = (String)error + " " + se.getSQLState() + "/" + se.getErrorCode();
                if (isH2) {
                    int code = se.getErrorCode();
                    error = (String)error + " <a href=\"https://h2database.com/javadoc/org/h2/api/ErrorCode.html#c" + code + "\">(${text.a.help})</a>";
                }
            }
            error = (String)error + "<span style=\"display: none;\" id=\"st" + id + "\"><br />" + stackTrace + "</span>";
            error = WebApp.formatAsError((String)error);
            return error;
        }
        catch (OutOfMemoryError e2) {
            this.server.traceError(e);
            return e.toString();
        }
    }

    private static String linkToSource(String s) {
        try {
            StringBuilder result = new StringBuilder(s.length());
            int idx = s.indexOf("<br />");
            result.append(s, 0, idx);
            while (true) {
                int start;
                if ((start = s.indexOf("org.h2.", idx)) < 0) {
                    result.append(s.substring(idx));
                    break;
                }
                result.append(s, idx, start);
                int end = s.indexOf(41, start);
                if (end < 0) {
                    result.append(s.substring(idx));
                    break;
                }
                String element = s.substring(start, end);
                int open = element.lastIndexOf(40);
                int dotMethod = element.lastIndexOf(46, open - 1);
                int dotClass = element.lastIndexOf(46, dotMethod - 1);
                String packageName = element.substring(0, dotClass);
                int colon = element.lastIndexOf(58);
                String file = element.substring(open + 1, colon);
                String lineNumber = element.substring(colon + 1, element.length());
                String fullFileName = packageName.replace('.', '/') + "/" + file;
                result.append("<a href=\"https://h2database.com/html/source.html?file=");
                result.append(fullFileName);
                result.append("&line=");
                result.append(lineNumber);
                result.append("&build=");
                result.append(229);
                result.append("\">");
                result.append(element);
                result.append("</a>");
                idx = end;
            }
            return result.toString();
        }
        catch (Throwable t) {
            return s;
        }
    }

    private static String formatAsError(String s) {
        return "<div class=\"error\">" + s + "</div>";
    }

    private String test(NetworkConnectionInfo networkConnectionInfo) {
        String driver = this.attributes.getProperty("driver", "");
        String url = this.attributes.getProperty("url", "");
        String user = this.attributes.getProperty("user", "");
        String password = this.attributes.getProperty("password", "");
        this.session.put("driver", driver);
        this.session.put("url", url);
        this.session.put("user", user);
        boolean isH2 = url.startsWith("jdbc:h2:");
        try {
            Connection conn;
            long start = System.currentTimeMillis();
            String profOpen = "";
            String profClose = "";
            Profiler prof = new Profiler();
            prof.startCollecting();
            try {
                conn = this.server.getConnection(driver, url, user, password, null, networkConnectionInfo);
            }
            finally {
                prof.stopCollecting();
                profOpen = prof.getTop(3);
            }
            prof = new Profiler();
            prof.startCollecting();
            try {
                JdbcUtils.closeSilently(conn);
            }
            finally {
                prof.stopCollecting();
                profClose = prof.getTop(3);
            }
            long time = System.currentTimeMillis() - start;
            Object success = time > 1000L ? "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('prof').style;x.display=x.display==''?'none':'';\">${text.login.testSuccessful}</a><span style=\"display: none;\" id=\"prof\"><br />" + PageParser.escapeHtml(profOpen) + "<br />" + PageParser.escapeHtml(profClose) + "</span>" : "<div class=\"success\">${text.login.testSuccessful}</div>";
            this.session.put("error", success);
            return "login.jsp";
        }
        catch (Exception e) {
            this.session.put("error", this.getLoginError(e, isH2));
            return "login.jsp";
        }
    }

    private String getLoginError(Exception e, boolean isH2) {
        if (e instanceof JdbcException && ((JdbcException)((Object)e)).getErrorCode() == 90086) {
            return "${text.login.driverNotFound}<br />" + this.getStackTrace(0, e, isH2);
        }
        return this.getStackTrace(0, e, isH2);
    }

    private String login(NetworkConnectionInfo networkConnectionInfo) {
        String driver = this.attributes.getProperty("driver", "");
        String url = this.attributes.getProperty("url", "");
        String user = this.attributes.getProperty("user", "");
        String password = this.attributes.getProperty("password", "");
        this.session.put("autoCommit", "checked");
        this.session.put("autoComplete", "1");
        this.session.put("maxrows", "1000");
        boolean isH2 = url.startsWith("jdbc:h2:");
        try {
            Connection conn = this.server.getConnection(driver, url, user, password, (String)this.session.get("key"), networkConnectionInfo);
            this.session.setConnection(conn);
            this.session.put("url", url);
            this.session.put("user", user);
            this.session.remove("error");
            this.settingSave();
            return "frame.jsp";
        }
        catch (Exception e) {
            this.session.put("error", this.getLoginError(e, isH2));
            return "login.jsp";
        }
    }

    private String logout() {
        try {
            Connection conn = this.session.getConnection();
            this.session.setConnection(null);
            this.session.remove("conn");
            this.session.remove("result");
            this.session.remove("tables");
            this.session.remove("user");
            this.session.remove("tool");
            if (conn != null) {
                if (this.session.getShutdownServerOnDisconnect()) {
                    this.server.shutdown();
                } else {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            this.trace(e.toString());
        }
        this.session.remove("admin");
        return "index.do";
    }

    private String query() {
        Connection conn;
        ArrayList<String> list;
        block5: {
            String s;
            String sql = this.attributes.getProperty("sql").trim();
            ScriptReader r = new ScriptReader(new StringReader(sql));
            list = new ArrayList<String>();
            while ((s = r.readStatement()) != null) {
                list.add(s);
            }
            conn = this.session.getConnection();
            if (!SysProperties.CONSOLE_STREAM || !this.server.getAllowChunked()) break block5;
            String page = new String(this.server.getFile("result.jsp"), StandardCharsets.UTF_8);
            int idx = page.indexOf("${result}");
            list.add(0, page.substring(0, idx));
            list.add(page.substring(idx + "${result}".length()));
            this.session.put("chunks", new Iterator<String>(){
                private int i;

                @Override
                public boolean hasNext() {
                    return this.i < list.size();
                }

                @Override
                public String next() {
                    String s = (String)list.get(this.i++);
                    if (this.i == 1 || this.i == list.size()) {
                        return s;
                    }
                    StringBuilder b = new StringBuilder();
                    WebApp.this.query(conn, s, this.i - 1, list.size() - 2, b);
                    return b.toString();
                }
            });
            return "result.jsp";
        }
        try {
            StringBuilder buff = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                String s = (String)list.get(i);
                this.query(conn, s, i, list.size(), buff);
                ++i;
            }
            String result = buff.toString();
            this.session.put("result", result);
        }
        catch (Throwable e) {
            this.session.put("result", this.getStackTrace(0, e, this.session.getContents().isH2()));
        }
        return "result.jsp";
    }

    void query(Connection conn, String s, int i, int size, StringBuilder buff) {
        if (!s.startsWith("@") || !s.endsWith(".")) {
            buff.append(PageParser.escapeHtml(s + ";")).append("<br />");
        }
        boolean forceEdit = s.startsWith("@edit");
        buff.append(this.getResult(conn, i + 1, s, size == 1, forceEdit)).append("<br />");
    }

    private String editResult() {
        ResultSet rs = this.session.result;
        int row = Integer.parseInt(this.attributes.getProperty("row"));
        int op = Integer.parseInt(this.attributes.getProperty("op"));
        Object result = "";
        String error = "";
        try {
            if (op == 1) {
                boolean insert;
                boolean bl = insert = row < 0;
                if (insert) {
                    rs.moveToInsertRow();
                } else {
                    rs.absolute(row);
                }
                int i = 0;
                while (i < rs.getMetaData().getColumnCount()) {
                    String x = this.attributes.getProperty("r" + row + "c" + (i + 1));
                    this.unescapeData(x, rs, i + 1);
                    ++i;
                }
                if (insert) {
                    rs.insertRow();
                } else {
                    rs.updateRow();
                }
            } else if (op == 2) {
                rs.absolute(row);
                rs.deleteRow();
            }
        }
        catch (Throwable e) {
            result = "<br />" + this.getStackTrace(0, e, this.session.getContents().isH2());
            error = WebApp.formatAsError(e.getMessage());
        }
        String sql = "@edit " + (String)this.session.get("resultSetSQL");
        Connection conn = this.session.getConnection();
        result = error + this.getResult(conn, -1, sql, true, true) + (String)result;
        this.session.put("result", result);
        return "result.jsp";
    }

    private int getMaxrows() {
        String r = (String)this.session.get("maxrows");
        return r == null ? 0 : Integer.parseInt(r);
    }

    private String getResult(Connection conn, int id, String sql, boolean allowEdit, boolean forceEdit) {
        try {
            ResultSet rs;
            sql = sql.trim();
            StringBuilder buff = new StringBuilder();
            String sqlUpper = StringUtils.toUpperEnglish(sql);
            if (sqlUpper.contains("CREATE") || sqlUpper.contains("DROP") || sqlUpper.contains("ALTER") || sqlUpper.contains("RUNSCRIPT")) {
                String sessionId = this.attributes.getProperty("jsessionid");
                buff.append("<script type=\"text/javascript\">parent['h2menu'].location='tables.do?jsessionid=").append(sessionId).append("';</script>");
            }
            DbContents contents = this.session.getContents();
            Statement stat = forceEdit || allowEdit && contents.isH2() ? conn.createStatement(1004, 1008) : conn.createStatement();
            long time = System.currentTimeMillis();
            boolean metadata = false;
            Object generatedKeys = null;
            boolean edit = false;
            boolean list = false;
            if (JdbcUtils.isBuiltIn(sql, "@autocommit_true")) {
                conn.setAutoCommit(true);
                return "${text.result.autoCommitOn}";
            }
            if (JdbcUtils.isBuiltIn(sql, "@autocommit_false")) {
                conn.setAutoCommit(false);
                return "${text.result.autoCommitOff}";
            }
            if (JdbcUtils.isBuiltIn(sql, "@cancel")) {
                stat = this.session.executingStatement;
                if (stat != null) {
                    stat.cancel();
                    buff.append("${text.result.statementWasCanceled}");
                } else {
                    buff.append("${text.result.noRunningStatement}");
                }
                String string = buff.toString();
                return string;
            }
            if (JdbcUtils.isBuiltIn(sql, "@edit")) {
                edit = true;
                sql = StringUtils.trimSubstring(sql, "@edit".length());
                this.session.put("resultSetSQL", sql);
            }
            if (JdbcUtils.isBuiltIn(sql, "@list")) {
                list = true;
                sql = StringUtils.trimSubstring(sql, "@list".length());
            }
            if (JdbcUtils.isBuiltIn(sql, "@meta")) {
                metadata = true;
                sql = StringUtils.trimSubstring(sql, "@meta".length());
            }
            if (JdbcUtils.isBuiltIn(sql, "@generated")) {
                generatedKeys = true;
                int offset = "@generated".length();
                int length = sql.length();
                while (offset < length) {
                    char c = sql.charAt(offset);
                    if (c == '(') {
                        ParserBase p = new ParserBase();
                        generatedKeys = p.parseColumnList(sql, offset);
                        offset = p.getLastParseIndex();
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                    ++offset;
                }
                sql = StringUtils.trimSubstring(sql, offset);
            } else {
                if (JdbcUtils.isBuiltIn(sql, "@history")) {
                    buff.append(this.getCommandHistoryString());
                    String string = buff.toString();
                    return string;
                }
                if (JdbcUtils.isBuiltIn(sql, "@loop")) {
                    sql = StringUtils.trimSubstring(sql, "@loop".length());
                    int idx = sql.indexOf(32);
                    int count = Integer.decode(sql.substring(0, idx));
                    sql = StringUtils.trimSubstring(sql, idx);
                    String string = this.executeLoop(conn, count, sql);
                    return string;
                }
                if (JdbcUtils.isBuiltIn(sql, "@maxrows")) {
                    int maxrows = (int)Double.parseDouble(StringUtils.trimSubstring(sql, "@maxrows".length()));
                    this.session.put("maxrows", Integer.toString(maxrows));
                    return "${text.result.maxrowsSet}";
                }
                if (JdbcUtils.isBuiltIn(sql, "@parameter_meta")) {
                    sql = StringUtils.trimSubstring(sql, "@parameter_meta".length());
                    PreparedStatement prep = conn.prepareStatement(sql);
                    buff.append(WebApp.getParameterResultSet(prep.getParameterMetaData()));
                    String string = buff.toString();
                    return string;
                }
                if (JdbcUtils.isBuiltIn(sql, "@password_hash")) {
                    sql = StringUtils.trimSubstring(sql, "@password_hash".length());
                    String[] p = JdbcUtils.split(sql);
                    String string = StringUtils.convertBytesToHex(SHA256.getKeyPasswordHash(p[0], p[1].toCharArray()));
                    return string;
                }
                if (JdbcUtils.isBuiltIn(sql, "@prof_start")) {
                    if (this.profiler != null) {
                        this.profiler.stopCollecting();
                    }
                    this.profiler = new Profiler();
                    this.profiler.startCollecting();
                    return "Ok";
                }
                if (JdbcUtils.isBuiltIn(sql, "@sleep")) {
                    String s = StringUtils.trimSubstring(sql, "@sleep".length());
                    int sleep = 1;
                    if (s.length() > 0) {
                        sleep = Integer.parseInt(s);
                    }
                    Thread.sleep(sleep * 1000);
                    return "Ok";
                }
                if (JdbcUtils.isBuiltIn(sql, "@transaction_isolation")) {
                    String s = StringUtils.trimSubstring(sql, "@transaction_isolation".length());
                    if (s.length() > 0) {
                        int level = Integer.parseInt(s);
                        conn.setTransactionIsolation(level);
                    }
                    buff.append("Transaction Isolation: ").append(conn.getTransactionIsolation()).append("<br />");
                    buff.append(1).append(": read_uncommitted<br />");
                    buff.append(2).append(": read_committed<br />");
                    buff.append(4).append(": repeatable_read<br />");
                    buff.append(6).append(": snapshot<br />");
                    buff.append(8).append(": serializable");
                }
            }
            if (sql.startsWith("@")) {
                rs = JdbcUtils.getMetaResultSet(conn, sql);
                if (rs == null && JdbcUtils.isBuiltIn(sql, "@prof_stop") && this.profiler != null) {
                    this.profiler.stopCollecting();
                    SimpleResultSet simple = new SimpleResultSet();
                    simple.addColumn("Top Stack Trace(s)", 12, 0, 0);
                    simple.addRow(this.profiler.getTop(3));
                    rs = simple;
                    this.profiler = null;
                }
                if (rs == null) {
                    buff.append("?: ").append(sql);
                    String string = buff.toString();
                    return string;
                }
            } else {
                int maxrows = this.getMaxrows();
                stat.setMaxRows(maxrows);
                this.session.executingStatement = stat;
                boolean isResultSet = generatedKeys == null ? stat.execute(sql) : (generatedKeys instanceof Boolean ? stat.execute(sql, (Boolean)generatedKeys != false ? 1 : 2) : (generatedKeys instanceof String[] ? stat.execute(sql, (String[])generatedKeys) : stat.execute(sql, (int[])generatedKeys)));
                this.session.addCommand(sql);
                if (generatedKeys != null) {
                    rs = null;
                    rs = stat.getGeneratedKeys();
                } else {
                    if (!isResultSet) {
                        long updateCount;
                        try {
                            updateCount = stat.getLargeUpdateCount();
                        }
                        catch (UnsupportedOperationException e) {
                            updateCount = stat.getUpdateCount();
                        }
                        buff.append("${text.result.updateCount}: ").append(updateCount);
                        time = System.currentTimeMillis() - time;
                        buff.append("<br />(").append(time).append(" ms)");
                        stat.close();
                        String string = buff.toString();
                        return string;
                    }
                    rs = stat.getResultSet();
                }
            }
            time = System.currentTimeMillis() - time;
            buff.append(this.getResultSet(sql, rs, metadata, list, edit, time, allowEdit));
            if (!edit) {
                stat.close();
            }
            String string = buff.toString();
            return string;
        }
        catch (Throwable e) {
            String string = this.getStackTrace(id, e, this.session.getContents().isH2());
            return string;
        }
        finally {
            this.session.executingStatement = null;
        }
    }

    private String executeLoop(Connection conn, int count, String sql) throws SQLException {
        int i;
        boolean prepared;
        ArrayList<Integer> params = new ArrayList<Integer>();
        int idx = 0;
        while (!this.stop) {
            if ((idx = ((String)sql).indexOf(63, idx)) < 0) break;
            if (JdbcUtils.isBuiltIn(((String)sql).substring(idx), "?/*rnd*/")) {
                params.add(1);
                sql = ((String)sql).substring(0, idx) + "?" + ((String)sql).substring(idx + "/*rnd*/".length() + 1);
            } else {
                params.add(0);
            }
            ++idx;
        }
        Random random = new Random(1L);
        long time = System.currentTimeMillis();
        if (JdbcUtils.isBuiltIn((String)sql, "@statement")) {
            sql = StringUtils.trimSubstring((String)sql, "@statement".length());
            prepared = false;
            Statement stat = conn.createStatement();
            i = 0;
            while (!this.stop && i < count) {
                Object s = sql;
                for (Integer type : params) {
                    idx = ((String)s).indexOf(63);
                    s = type == 1 ? ((String)s).substring(0, idx) + random.nextInt(count) + ((String)s).substring(idx + 1) : ((String)s).substring(0, idx) + i + ((String)s).substring(idx + 1);
                }
                if (stat.execute((String)s)) {
                    ResultSet rs = stat.getResultSet();
                    while (!this.stop && rs.next()) {
                    }
                    rs.close();
                }
                ++i;
            }
        } else {
            prepared = true;
            PreparedStatement prep = conn.prepareStatement((String)sql);
            i = 0;
            while (!this.stop && i < count) {
                int j = 0;
                while (j < params.size()) {
                    Integer type;
                    type = (Integer)params.get(j);
                    if (type == 1) {
                        prep.setInt(j + 1, random.nextInt(count));
                    } else {
                        prep.setInt(j + 1, i);
                    }
                    ++j;
                }
                if (this.session.getContents().isSQLite()) {
                    prep.executeUpdate();
                } else if (prep.execute()) {
                    ResultSet rs = prep.getResultSet();
                    while (!this.stop && rs.next()) {
                    }
                    rs.close();
                }
                ++i;
            }
        }
        time = System.currentTimeMillis() - time;
        StringBuilder builder = new StringBuilder().append(time).append(" ms: ").append(count).append(" * ").append(prepared ? "(Prepared) " : "(Statement) ").append('(');
        i = 0;
        int size = params.size();
        while (i < size) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((Integer)params.get(i) == 0 ? "i" : "rnd");
            ++i;
        }
        return builder.append(") ").append((String)sql).toString();
    }

    private String getCommandHistoryString() {
        StringBuilder buff = new StringBuilder();
        ArrayList<String> history = this.session.getCommandHistory();
        buff.append("<table cellspacing=0 cellpadding=0><tr><th></th><th>Command</th></tr>");
        int i = history.size() - 1;
        while (i >= 0) {
            String sql = history.get(i);
            buff.append("<tr><td><a href=\"getHistory.do?id=").append(i).append("&jsessionid=${sessionId}\" target=\"h2query\" >").append("<img width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" ").append("onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" ").append("title=\"${text.resultEdit.edit}\" border=\"1\"/></a>").append("</td><td>").append(PageParser.escapeHtml(sql)).append("</td></tr>");
            --i;
        }
        buff.append("</table>");
        return buff.toString();
    }

    private static String getParameterResultSet(ParameterMetaData meta) throws SQLException {
        StringBuilder buff = new StringBuilder();
        if (meta == null) {
            return "No parameter meta data";
        }
        buff.append("<table cellspacing=0 cellpadding=0>").append("<tr><th>className</th><th>mode</th><th>type</th>").append("<th>typeName</th><th>precision</th><th>scale</th></tr>");
        int i = 0;
        while (i < meta.getParameterCount()) {
            buff.append("</tr><td>").append(meta.getParameterClassName(i + 1)).append("</td><td>").append(meta.getParameterMode(i + 1)).append("</td><td>").append(meta.getParameterType(i + 1)).append("</td><td>").append(meta.getParameterTypeName(i + 1)).append("</td><td>").append(meta.getPrecision(i + 1)).append("</td><td>").append(meta.getScale(i + 1)).append("</td></tr>");
            ++i;
        }
        buff.append("</table>");
        return buff.toString();
    }

    private String getResultSet(String sql, ResultSet rs, boolean metadata, boolean list, boolean edit, long time, boolean allowEdit) throws SQLException {
        int i;
        int maxrows = this.getMaxrows();
        time = System.currentTimeMillis() - time;
        StringBuilder buff = new StringBuilder();
        if (edit) {
            buff.append("<form id=\"editing\" name=\"editing\" method=\"post\" action=\"editResult.do?jsessionid=${sessionId}\" id=\"mainForm\" target=\"h2result\"><input type=\"hidden\" name=\"op\" value=\"1\" /><input type=\"hidden\" name=\"row\" value=\"\" /><table class=\"resultSet\" cellspacing=\"0\" cellpadding=\"0\" id=\"editTable\">");
        } else {
            buff.append("<table class=\"resultSet\" cellspacing=\"0\" cellpadding=\"0\">");
        }
        if (metadata) {
            SimpleResultSet r = new SimpleResultSet();
            r.addColumn("#", 4, 0, 0);
            r.addColumn("label", 12, 0, 0);
            r.addColumn("catalog", 12, 0, 0);
            r.addColumn("schema", 12, 0, 0);
            r.addColumn("table", 12, 0, 0);
            r.addColumn("column", 12, 0, 0);
            r.addColumn("type", 4, 0, 0);
            r.addColumn("typeName", 12, 0, 0);
            r.addColumn("class", 12, 0, 0);
            r.addColumn("precision", 4, 0, 0);
            r.addColumn("scale", 4, 0, 0);
            r.addColumn("displaySize", 4, 0, 0);
            r.addColumn("autoIncrement", 16, 0, 0);
            r.addColumn("caseSensitive", 16, 0, 0);
            r.addColumn("currency", 16, 0, 0);
            r.addColumn("nullable", 4, 0, 0);
            r.addColumn("readOnly", 16, 0, 0);
            r.addColumn("searchable", 16, 0, 0);
            r.addColumn("signed", 16, 0, 0);
            r.addColumn("writable", 16, 0, 0);
            r.addColumn("definitelyWritable", 16, 0, 0);
            ResultSetMetaData m = rs.getMetaData();
            int i2 = 1;
            while (i2 <= m.getColumnCount()) {
                r.addRow(i2, m.getColumnLabel(i2), m.getCatalogName(i2), m.getSchemaName(i2), m.getTableName(i2), m.getColumnName(i2), m.getColumnType(i2), m.getColumnTypeName(i2), m.getColumnClassName(i2), m.getPrecision(i2), m.getScale(i2), m.getColumnDisplaySize(i2), m.isAutoIncrement(i2), m.isCaseSensitive(i2), m.isCurrency(i2), m.isNullable(i2), m.isReadOnly(i2), m.isSearchable(i2), m.isSigned(i2), m.isWritable(i2), m.isDefinitelyWritable(i2));
                ++i2;
            }
            rs = r;
        }
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        int rows = 0;
        if (list) {
            buff.append("<tr><th>Column</th><th>Data</th></tr><tr>");
            while (rs.next()) {
                if (maxrows <= 0 || rows < maxrows) {
                    buff.append("<tr><td>Row #</td><td>").append(++rows).append("</tr>");
                    i = 0;
                    while (i < columns) {
                        buff.append("<tr><td>").append(PageParser.escapeHtml(meta.getColumnLabel(i + 1))).append("</td><td>").append(WebApp.escapeData(rs, i + 1)).append("</td></tr>");
                        ++i;
                    }
                    continue;
                }
                break;
            }
        } else {
            buff.append("<tr>");
            if (edit) {
                buff.append("<th>${text.resultEdit.action}</th>");
            }
            i = 0;
            while (i < columns) {
                buff.append("<th>").append(PageParser.escapeHtml(meta.getColumnLabel(i + 1))).append("</th>");
                ++i;
            }
            buff.append("</tr>");
            while (rs.next()) {
                if (maxrows <= 0 || rows < maxrows) {
                    ++rows;
                    buff.append("<tr>");
                    if (edit) {
                        buff.append("<td>").append("<img onclick=\"javascript:editRow(").append(rs.getRow()).append(",'${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/>").append("<img onclick=\"javascript:deleteRow(").append(rs.getRow()).append(",'${sessionId}', '${text.resultEdit.delete}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_remove.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.delete}\" title=\"${text.resultEdit.delete}\" border=\"1\" /></a>").append("</td>");
                    }
                    i = 0;
                    while (i < columns) {
                        buff.append("<td>").append(WebApp.escapeData(rs, i + 1)).append("</td>");
                        ++i;
                    }
                    buff.append("</tr>");
                    continue;
                }
                break;
            }
        }
        boolean isUpdatable = false;
        try {
            if (!this.session.getContents().isDB2()) {
                isUpdatable = rs.getConcurrency() == 1008 && rs.getType() != 1003;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (edit) {
            ResultSet old = this.session.result;
            if (old != null) {
                old.close();
            }
            this.session.result = rs;
        } else {
            rs.close();
        }
        if (edit) {
            buff.append("<tr><td>").append("<img onclick=\"javascript:editRow(-1, '${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'").append(")\" width=16 height=16 src=\"ico_add.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.add}\" title=\"${text.resultEdit.add}\" border=\"1\"/>").append("</td>");
            int i3 = 0;
            while (i3 < columns) {
                buff.append("<td></td>");
                ++i3;
            }
            buff.append("</tr>");
        }
        buff.append("</table>");
        if (edit) {
            buff.append("</form>");
        }
        if (rows == 0) {
            buff.append("(${text.result.noRows}");
        } else if (rows == 1) {
            buff.append("(${text.result.1row}");
        } else {
            buff.append('(').append(rows).append(" ${text.result.rows}");
        }
        buff.append(", ");
        time = System.currentTimeMillis() - time;
        buff.append(time).append(" ms)");
        if (!edit && isUpdatable && allowEdit) {
            buff.append("<br /><br /><form name=\"editResult\" method=\"post\" action=\"query.do?jsessionid=${sessionId}\" target=\"h2result\"><input type=\"submit\" class=\"button\" value=\"${text.resultEdit.editResult}\" /><input type=\"hidden\" name=\"sql\" value=\"@edit ").append(PageParser.escapeHtmlData(sql)).append("\" /></form>");
        }
        return buff.toString();
    }

    private String settingSave() {
        ConnectionInfo info = new ConnectionInfo();
        info.name = this.attributes.getProperty("name", "");
        info.driver = this.attributes.getProperty("driver", "");
        info.url = this.attributes.getProperty("url", "");
        info.user = this.attributes.getProperty("user", "");
        this.server.updateSetting(info);
        this.attributes.put("setting", info.name);
        this.server.saveProperties(null);
        return "index.do";
    }

    private static String escapeData(ResultSet rs, int columnIndex) throws SQLException {
        if (DataType.isBinaryColumn(rs.getMetaData(), columnIndex)) {
            byte[] d = rs.getBytes(columnIndex);
            if (d == null) {
                return "<i>null</i>";
            }
            if (d.length > 50000) {
                return "<div style='display: none'>=+</div>" + StringUtils.convertBytesToHex(d, 3) + "... (" + d.length + " ${text.result.bytes})";
            }
            return StringUtils.convertBytesToHex(d);
        }
        String d = rs.getString(columnIndex);
        if (d == null) {
            return "<i>null</i>";
        }
        if (d.length() > 100000) {
            return "<div style='display: none'>=+</div>" + PageParser.escapeHtml(d.substring(0, 100)) + "... (" + d.length() + " ${text.result.characters})";
        }
        if (d.equals("null") || d.startsWith("= ") || d.startsWith("=+")) {
            return "<div style='display: none'>= </div>" + PageParser.escapeHtml(d);
        }
        if (d.equals("")) {
            return "";
        }
        return PageParser.escapeHtml(d);
    }

    private void unescapeData(String x, ResultSet rs, int columnIndex) throws SQLException {
        ResultSetMetaData meta;
        if (x.equals("null")) {
            rs.updateNull(columnIndex);
            return;
        }
        if (x.startsWith("=+")) {
            return;
        }
        if (x.equals("=*")) {
            int type = rs.getMetaData().getColumnType(columnIndex);
            switch (type) {
                case 92: {
                    rs.updateString(columnIndex, "12:00:00");
                    break;
                }
                case 91: 
                case 93: {
                    rs.updateString(columnIndex, "2001-01-01");
                    break;
                }
                default: {
                    rs.updateString(columnIndex, "1");
                }
            }
            return;
        }
        if (x.startsWith("= ")) {
            x = x.substring(2);
        }
        if (DataType.isBinaryColumn(meta = rs.getMetaData(), columnIndex)) {
            rs.updateBytes(columnIndex, StringUtils.convertHexToBytes(x));
            return;
        }
        int type = meta.getColumnType(columnIndex);
        if (this.session.getContents().isH2()) {
            rs.updateString(columnIndex, x);
            return;
        }
        switch (type) {
            case -5: {
                rs.updateLong(columnIndex, (long)Long.decode(x));
                break;
            }
            case 3: {
                rs.updateBigDecimal(columnIndex, new BigDecimal(x));
                break;
            }
            case 6: 
            case 8: {
                rs.updateDouble(columnIndex, Double.parseDouble(x));
                break;
            }
            case 7: {
                rs.updateFloat(columnIndex, Float.parseFloat(x));
                break;
            }
            case 4: {
                rs.updateInt(columnIndex, (int)Integer.decode(x));
                break;
            }
            case -6: {
                rs.updateShort(columnIndex, (short)Short.decode(x));
                break;
            }
            default: {
                rs.updateString(columnIndex, x);
            }
        }
    }

    private String settingRemove() {
        String setting = this.attributes.getProperty("name", "");
        this.server.removeSetting(setting);
        ArrayList<ConnectionInfo> settings = this.server.getSettings();
        if (!settings.isEmpty()) {
            this.attributes.put("setting", settings.get(0));
        }
        this.server.saveProperties(null);
        return "index.do";
    }

    String getMimeType() {
        return this.mimeType;
    }

    boolean getCache() {
        return this.cache;
    }

    WebSession getSession() {
        return this.session;
    }

    private void trace(String s) {
        this.server.trace(s);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class IndexInfo {
        String name;
        String type;
        String columns;

        IndexInfo() {
        }
    }
}

