/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.util.Utils21;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class WebThread
extends WebApp
implements Runnable {
    private static final byte[] RN = new byte[]{13, 10};
    private static final byte[] RNRN = new byte[]{13, 10, 13, 10};
    protected OutputStream output;
    protected final Socket socket;
    private final Thread thread;
    private InputStream input;
    private String host;
    private int dataLength;
    private String ifModifiedSince;

    WebThread(Socket socket, WebServer server) {
        super(server);
        this.socket = socket;
        this.thread = server.virtualThreads ? Utils21.newVirtualThread(this) : new Thread(this);
        this.thread.setName("H2 Console thread");
    }

    void start() {
        this.thread.start();
    }

    void join(int millis) throws InterruptedException {
        this.thread.join(millis);
    }

    void stopNow() {
        this.stop = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAllowedFile(String requestedFile) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        if (requestedFile.charAt(0) == '?') {
            return "index.do" + requestedFile;
        }
        return requestedFile;
    }

    @Override
    public void run() {
        try {
            this.input = new BufferedInputStream(this.socket.getInputStream());
            this.output = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.stop) {
                if (this.process()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DbException.traceThrowable(e);
        }
        IOUtils.closeSilently(this.output);
        IOUtils.closeSilently(this.input);
        try {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.server.remove(this);
            }
        }
        finally {
            this.server.remove(this);
        }
    }

    private boolean process() throws IOException {
        Object message;
        String head = this.readHeaderLine();
        boolean get = head.startsWith("GET ");
        if (!get && !head.startsWith("POST ") || !head.endsWith(" HTTP/1.1")) {
            this.writeSimple("HTTP/1.1 400 Bad Request", "Bad request");
            return false;
        }
        String file = StringUtils.trimSubstring(head, get ? 4 : 5, head.length() - 9);
        if (file.isEmpty() || file.charAt(0) != '/') {
            this.writeSimple("HTTP/1.1 400 Bad Request", "Bad request");
            return false;
        }
        this.attributes = new Properties();
        boolean keepAlive = this.parseHeader();
        if (!this.checkHost(this.host)) {
            return false;
        }
        file = file.substring(1);
        this.trace(head + ": " + file);
        file = this.getAllowedFile(file);
        int paramIndex = file.indexOf(63);
        this.session = null;
        String key = null;
        if (paramIndex >= 0) {
            String attrib = file.substring(paramIndex + 1);
            this.parseAttributes(attrib);
            String sessionId = this.attributes.getProperty("jsessionid");
            key = this.attributes.getProperty("key");
            file = file.substring(0, paramIndex);
            this.session = this.server.getSession(sessionId);
        }
        this.parseBodyAttributes();
        file = this.processRequest(file, new NetworkConnectionInfo(NetUtils.ipToShortForm(new StringBuilder(this.server.getSSL() ? "https://" : "http://"), this.socket.getLocalAddress().getAddress(), true).append(':').append(this.socket.getLocalPort()).toString(), this.socket.getInetAddress().getAddress(), this.socket.getPort(), null));
        if (file.length() == 0) {
            return true;
        }
        if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
            this.writeSimple("HTTP/1.1 304 Not Modified", (byte[])null);
            return keepAlive;
        }
        byte[] bytes = this.server.getFile(file);
        if (bytes == null) {
            this.writeSimple("HTTP/1.1 404 Not Found", "File not found: " + file);
            return keepAlive;
        }
        if (this.session != null && file.endsWith(".jsp")) {
            Iterator it;
            if (key != null) {
                this.session.put("key", key);
            }
            String page = new String(bytes, StandardCharsets.UTF_8);
            if (SysProperties.CONSOLE_STREAM && (it = (Iterator)this.session.map.remove("chunks")) != null) {
                message = "HTTP/1.1 200 OK\r\n";
                message = (String)message + "Content-Type: " + this.mimeType + "\r\n";
                message = (String)message + "Cache-Control: no-cache\r\n";
                message = (String)message + "Transfer-Encoding: chunked\r\n";
                message = (String)message + "\r\n";
                this.trace((String)message);
                this.output.write(((String)message).getBytes(StandardCharsets.ISO_8859_1));
                while (it.hasNext()) {
                    String s = (String)it.next();
                    bytes = (s = PageParser.parse(s, this.session.map)).getBytes(StandardCharsets.UTF_8);
                    if (bytes.length == 0) continue;
                    this.output.write(Integer.toHexString(bytes.length).getBytes(StandardCharsets.ISO_8859_1));
                    this.output.write(RN);
                    this.output.write(bytes);
                    this.output.write(RN);
                    this.output.flush();
                }
                this.output.write(48);
                this.output.write(RNRN);
                this.output.flush();
                return keepAlive;
            }
            page = PageParser.parse(page, this.session.map);
            bytes = page.getBytes(StandardCharsets.UTF_8);
        }
        message = "HTTP/1.1 200 OK\r\n";
        message = (String)message + "Content-Type: " + this.mimeType + "\r\n";
        if (!this.cache) {
            message = (String)message + "Cache-Control: no-cache\r\n";
        } else {
            message = (String)message + "Cache-Control: max-age=10\r\n";
            message = (String)message + "Last-Modified: " + this.server.getStartDateTime() + "\r\n";
        }
        message = (String)message + "Content-Length: " + bytes.length + "\r\n";
        message = (String)message + "\r\n";
        this.trace((String)message);
        this.output.write(((String)message).getBytes(StandardCharsets.ISO_8859_1));
        this.output.write(bytes);
        this.output.flush();
        return keepAlive;
    }

    private void writeSimple(String status, String text) throws IOException {
        this.writeSimple(status, text != null ? text.getBytes(StandardCharsets.UTF_8) : null);
    }

    private void writeSimple(String status, byte[] bytes) throws IOException {
        this.trace(status);
        this.output.write(status.getBytes(StandardCharsets.ISO_8859_1));
        if (bytes != null) {
            this.output.write(RN);
            String contentLength = "Content-Length: " + bytes.length;
            this.trace(contentLength);
            this.output.write(contentLength.getBytes(StandardCharsets.ISO_8859_1));
            this.output.write(RNRN);
            this.output.write(bytes);
        } else {
            this.output.write(RNRN);
        }
        this.output.flush();
    }

    private boolean checkHost(String host) throws IOException {
        if (host == null) {
            this.writeSimple("HTTP/1.1 400 Bad Request", "Bad request");
            return false;
        }
        int index = host.lastIndexOf(58);
        if (index >= 0) {
            host = host.substring(0, index);
        }
        if (host.isEmpty()) {
            return false;
        }
        if ((host = StringUtils.toLowerEnglish(host)).equals(this.server.getHost()) || host.equals("localhost") || host.equals("127.0.0.1") || host.equals("[::1]")) {
            return true;
        }
        String externalNames = this.server.getExternalNames();
        if (externalNames != null && !externalNames.isEmpty()) {
            String[] stringArray = externalNames.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (host.equals(s.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        this.writeSimple("HTTP/1.1 404 Not Found", "Host " + host + " not found");
        return false;
    }

    private String readHeaderLine() throws IOException {
        StringBuilder buff = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (c == 13) {
                if (this.input.read() != 10) continue;
                return buff.length() > 0 ? buff.toString() : null;
            }
            if (c == 10) {
                return buff.length() > 0 ? buff.toString() : null;
            }
            buff.append((char)c);
        }
    }

    private void parseBodyAttributes() throws IOException {
        if (this.dataLength > 0) {
            byte[] bytes = Utils.newBytes(this.dataLength);
            int pos = 0;
            while (pos < this.dataLength) {
                pos += this.input.read(bytes, pos, this.dataLength - pos);
            }
            String s = new String(bytes, StandardCharsets.UTF_8);
            this.parseAttributes(s);
        }
    }

    private void parseAttributes(String s) {
        this.trace("data=" + s);
        while (s != null) {
            String value;
            int idx = s.indexOf(61);
            if (idx < 0) break;
            String property = s.substring(0, idx);
            if ((idx = (s = s.substring(idx + 1)).indexOf(38)) >= 0) {
                value = s.substring(0, idx);
                s = s.substring(idx + 1);
            } else {
                value = s;
            }
            String attr = StringUtils.urlDecode(value);
            this.attributes.put(property, attr);
        }
        this.trace(this.attributes.toString());
    }

    private boolean parseHeader() throws IOException {
        String line;
        boolean keepAlive = false;
        this.trace("parseHeader");
        int len = 0;
        this.host = null;
        this.ifModifiedSince = null;
        boolean multipart = false;
        block0: while ((line = this.readHeaderLine()) != null) {
            this.trace(" " + line);
            String lower = StringUtils.toLowerEnglish(line);
            if (lower.startsWith("host")) {
                this.host = WebThread.getHeaderLineValue(line);
                continue;
            }
            if (lower.startsWith("if-modified-since")) {
                this.ifModifiedSince = WebThread.getHeaderLineValue(line);
                continue;
            }
            if (lower.startsWith("connection")) {
                String conn = WebThread.getHeaderLineValue(line);
                if (!"keep-alive".equals(conn)) continue;
                keepAlive = true;
                continue;
            }
            if (lower.startsWith("content-type")) {
                String type = WebThread.getHeaderLineValue(line);
                if (!type.startsWith("multipart/form-data")) continue;
                multipart = true;
                continue;
            }
            if (lower.startsWith("content-length")) {
                len = Integer.parseInt(WebThread.getHeaderLineValue(line));
                this.trace("len=" + len);
                continue;
            }
            if (lower.startsWith("user-agent")) {
                boolean isWebKit = lower.contains("webkit/");
                if (!isWebKit || this.session == null) continue;
                this.session.put("frame-border", "1");
                this.session.put("frameset-border", "2");
                continue;
            }
            if (lower.startsWith("accept-language")) {
                Locale locale;
                Locale locale2 = locale = this.session == null ? null : this.session.locale;
                if (locale != null) continue;
                String languages = WebThread.getHeaderLineValue(line);
                StringTokenizer tokenizer = new StringTokenizer(languages, ",;");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.startsWith("q=") || !this.server.supportsLanguage(token)) continue;
                    int dash = token.indexOf(45);
                    if (dash >= 0) {
                        String language = token.substring(0, dash);
                        String country = token.substring(dash + 1);
                        locale = new Locale(language, country);
                    } else {
                        locale = new Locale(token, "");
                    }
                    this.headerLanguage = locale.getLanguage();
                    if (this.session == null) continue block0;
                    this.session.locale = locale;
                    this.session.put("language", this.headerLanguage);
                    this.server.readTranslations(this.session, this.headerLanguage);
                    continue block0;
                }
                continue;
            }
            if (StringUtils.isWhitespaceOrEmpty(line)) break;
        }
        this.dataLength = 0;
        if (!multipart && len > 0) {
            this.dataLength = len;
        }
        return keepAlive;
    }

    private static String getHeaderLineValue(String line) {
        return StringUtils.trimSubstring(line, line.indexOf(58) + 1);
    }

    @Override
    protected String adminShutdown() {
        this.stopNow();
        return super.adminShutdown();
    }

    private boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(this.socket);
        }
        catch (UnknownHostException e) {
            this.server.traceError(e);
            return false;
        }
    }

    private void trace(String s) {
        this.server.trace(s);
    }
}

