/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DataReader
extends Reader {
    private final InputStream in;

    public DataReader(InputStream in) {
        this.in = in;
    }

    public byte readByte() throws IOException {
        int x = this.in.read();
        if (x < 0) {
            throw new FastEOFException();
        }
        return (byte)x;
    }

    public int readVarInt() throws IOException {
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int x = b & 0x7F;
        b = this.readByte();
        if (b >= 0) {
            return x | b << 7;
        }
        x |= (b & 0x7F) << 7;
        b = this.readByte();
        if (b >= 0) {
            return x | b << 14;
        }
        x |= (b & 0x7F) << 14;
        b = this.readByte();
        if (b >= 0) {
            return x | b << 21;
        }
        return x | (b & 0x7F) << 21 | this.readByte() << 28;
    }

    private char readChar() throws IOException {
        int x = this.readByte() & 0xFF;
        if (x < 128) {
            return (char)x;
        }
        if (x >= 224) {
            return (char)(((x & 0xF) << 12) + ((this.readByte() & 0x3F) << 6) + (this.readByte() & 0x3F));
        }
        return (char)(((x & 0x1F) << 6) + (this.readByte() & 0x3F));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] buff, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int i = 0;
        try {
            while (i < len) {
                buff[off + i] = this.readChar();
                ++i;
            }
            return len;
        }
        catch (EOFException e) {
            if (i == 0) {
                return -1;
            }
            return i;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class FastEOFException
    extends EOFException {
        private static final long serialVersionUID = 1L;

        FastEOFException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

