/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.h2.util.IOUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class RangeInputStream
extends FilterInputStream {
    private long limit;

    public RangeInputStream(InputStream in, long offset, long limit) throws IOException {
        super(in);
        this.limit = limit;
        IOUtils.skipFully(in, offset);
    }

    @Override
    public int read() throws IOException {
        if (this.limit <= 0L) {
            return -1;
        }
        int b = this.in.read();
        if (b >= 0) {
            --this.limit;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int cnt;
        if (this.limit <= 0L) {
            return -1;
        }
        if ((long)len > this.limit) {
            len = (int)this.limit;
        }
        if ((cnt = this.in.read(b, off, len)) > 0) {
            this.limit -= (long)cnt;
        }
        return cnt;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > this.limit) {
            n = (int)this.limit;
        }
        n = this.in.skip(n);
        this.limit -= n;
        return n;
    }

    @Override
    public int available() throws IOException {
        int cnt = this.in.available();
        if ((long)cnt > this.limit) {
            return (int)this.limit;
        }
        return cnt;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

