/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.h2.store.fs.FileBaseDefault;
import org.h2.store.fs.FileUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class FileAsync
extends FileBaseDefault {
    private final String name;
    private final AsynchronousFileChannel channel;

    /*
     * Loose catch block
     */
    private static <T> T complete(Future<T> future) throws IOException {
        boolean interrupted = false;
        while (true) {
            try {
                T result = future.get();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return result;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    FileAsync(String fileName, String mode) throws IOException {
        this.name = fileName;
        this.channel = AsynchronousFileChannel.open(Paths.get(fileName, new String[0]), FileUtils.modeToOptions(mode), null, FileUtils.NO_ATTRIBUTES);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return FileAsync.complete(this.channel.read(dst, position));
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        return FileAsync.complete(this.channel.write(src, position));
    }

    @Override
    protected void implTruncate(long newLength) throws IOException {
        this.channel.truncate(newLength);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.channel.tryLock(position, size, shared);
    }

    public String toString() {
        return "async:" + this.name;
    }
}

