/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.encrypt;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.h2.mvstore.DataUtils;
import org.h2.security.AES;
import org.h2.security.SHA256;
import org.h2.store.fs.FileBaseDefault;
import org.h2.store.fs.encrypt.XTS;
import org.h2.util.MathUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FileEncrypt
extends FileBaseDefault {
    public static final int BLOCK_SIZE = 4096;
    static final int BLOCK_SIZE_MASK = 4095;
    static final int HEADER_LENGTH = 4096;
    private static final byte[] HEADER = "H2encrypt\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final int SALT_POS = HEADER.length;
    private static final int SALT_LENGTH = 8;
    private static final int HASH_ITERATIONS = 10;
    private final FileChannel base;
    private volatile long size;
    private final String name;
    private volatile XTS xts;
    private byte[] encryptionKey;
    private FileEncrypt source;

    public FileEncrypt(String name, byte[] encryptionKey, FileChannel base) {
        this.name = name;
        this.base = base;
        this.encryptionKey = encryptionKey;
    }

    public FileEncrypt(String name, FileEncrypt source, FileChannel base) {
        this.name = name;
        this.base = base;
        this.source = source;
        try {
            source.init();
        }
        catch (IOException e) {
            throw DataUtils.newMVStoreException(3, "Can not open {0} using encryption of {1}", name, source.name);
        }
    }

    private XTS init() throws IOException {
        XTS xts = this.xts;
        if (xts == null) {
            xts = this.createXTS();
        }
        return xts;
    }

    private synchronized XTS createXTS() throws IOException {
        boolean existingFile;
        XTS xts = this.xts;
        if (xts != null) {
            return xts;
        }
        assert (this.size == 0L);
        long sz = this.base.size() - 4096L;
        boolean bl = existingFile = sz >= 0L;
        if (this.encryptionKey != null) {
            byte[] salt;
            if (existingFile) {
                salt = new byte[8];
                FileEncrypt.readFully(this.base, SALT_POS, ByteBuffer.wrap(salt));
            } else {
                byte[] header = Arrays.copyOf(HEADER, 4096);
                salt = MathUtils.secureRandomBytes(8);
                System.arraycopy(salt, 0, header, SALT_POS, salt.length);
                FileEncrypt.writeFully(this.base, 0L, ByteBuffer.wrap(header));
            }
            AES cipher = new AES();
            cipher.setKey(SHA256.getPBKDF2(this.encryptionKey, salt, 10, 16));
            this.encryptionKey = null;
            xts = new XTS(cipher);
        } else {
            if (!existingFile) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096);
                FileEncrypt.readFully(this.source.base, 0L, byteBuffer);
                byteBuffer.flip();
                FileEncrypt.writeFully(this.base, 0L, byteBuffer);
            }
            xts = this.source.xts;
            this.source = null;
        }
        if (existingFile) {
            if ((sz & 0xFFFL) != 0L) {
                sz -= 4096L;
            }
            this.size = sz;
        }
        this.xts = xts;
        return this.xts;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.base.close();
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        int len = dst.remaining();
        if (len == 0) {
            return 0;
        }
        XTS xts = this.init();
        len = (int)Math.min((long)len, this.size - position);
        if (position >= this.size) {
            return -1;
        }
        if (position < 0L) {
            throw new IllegalArgumentException("pos: " + position);
        }
        if ((position & 0xFFFL) != 0L || (len & 0xFFF) != 0) {
            long p = position / 4096L * 4096L;
            int offset = (int)(position - p);
            int l = (len + offset + 4096 - 1) / 4096 * 4096;
            ByteBuffer temp = ByteBuffer.allocate(l);
            this.readInternal(temp, p, l, xts);
            temp.flip().limit(offset + len).position(offset);
            dst.put(temp);
            return len;
        }
        this.readInternal(dst, position, len, xts);
        return len;
    }

    private void readInternal(ByteBuffer dst, long position, int len, XTS xts) throws IOException {
        int x = dst.position();
        FileEncrypt.readFully(this.base, position + 4096L, dst);
        long block = position / 4096L;
        while (len > 0) {
            xts.decrypt(block++, 4096, dst.array(), dst.arrayOffset() + x);
            x += 4096;
            len -= 4096;
        }
    }

    private static void readFully(FileChannel file, long pos, ByteBuffer dst) throws IOException {
        do {
            int len;
            if ((len = file.read(dst, pos)) < 0) {
                throw new EOFException();
            }
            pos += (long)len;
        } while (dst.remaining() > 0);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        XTS xts = this.init();
        int len = src.remaining();
        if ((position & 0xFFFL) != 0L || (len & 0xFFF) != 0) {
            long p = position / 4096L * 4096L;
            int offset = (int)(position - p);
            int l = (len + offset + 4096 - 1) / 4096 * 4096;
            ByteBuffer temp = ByteBuffer.allocate(l);
            int available = (int)(this.size - p + 4096L - 1L) / 4096 * 4096;
            int readLen = Math.min(l, available);
            if (readLen > 0) {
                this.readInternal(temp, p, readLen, xts);
                temp.rewind();
            }
            temp.limit(offset + len).position(offset);
            temp.put(src).limit(l).rewind();
            this.writeInternal(temp, p, l, xts);
            long p2 = position + (long)len;
            this.size = Math.max(this.size, p2);
            int plus = (int)(this.size & 0xFFFL);
            if (plus > 0) {
                temp = ByteBuffer.allocate(plus);
                FileEncrypt.writeFully(this.base, p + 4096L + (long)l, temp);
            }
            return len;
        }
        this.writeInternal(src, position, len, xts);
        long p2 = position + (long)len;
        this.size = Math.max(this.size, p2);
        return len;
    }

    private void writeInternal(ByteBuffer src, long position, int len, XTS xts) throws IOException {
        ByteBuffer crypt = ByteBuffer.allocate(len).put(src);
        crypt.flip();
        long block = position / 4096L;
        int x = 0;
        int l = len;
        while (l > 0) {
            xts.encrypt(block++, 4096, crypt.array(), crypt.arrayOffset() + x);
            x += 4096;
            l -= 4096;
        }
        FileEncrypt.writeFully(this.base, position + 4096L, crypt);
    }

    private static void writeFully(FileChannel file, long pos, ByteBuffer src) throws IOException {
        do {
            pos += (long)file.write(src, pos);
        } while (src.remaining() > 0);
    }

    @Override
    public long size() throws IOException {
        this.init();
        return this.size;
    }

    @Override
    protected void implTruncate(long newSize) throws IOException {
        this.init();
        if (newSize > this.size) {
            return;
        }
        if (newSize < 0L) {
            throw new IllegalArgumentException("newSize: " + newSize);
        }
        int offset = (int)(newSize & 0xFFFL);
        if (offset > 0) {
            this.base.truncate(newSize + 4096L + 4096L);
        } else {
            this.base.truncate(newSize + 4096L);
        }
        this.size = newSize;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.base.force(metaData);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.base.tryLock(position, size, shared);
    }

    public String toString() {
        return this.name;
    }
}

