/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.split;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.store.fs.FileBaseDefault;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.split.FilePathSplit;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class FileSplit
extends FileBaseDefault {
    private final FilePathSplit filePath;
    private final String mode;
    private final long maxLength;
    private FileChannel[] list;
    private volatile long length;

    FileSplit(FilePathSplit file, String mode, FileChannel[] list, long length, long maxLength) {
        this.filePath = file;
        this.mode = mode;
        this.list = list;
        this.length = length;
        this.maxLength = maxLength;
    }

    @Override
    public synchronized void implCloseChannel() throws IOException {
        FileChannel[] fileChannelArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            FileChannel c = fileChannelArray[n2];
            c.close();
            ++n2;
        }
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public synchronized int read(ByteBuffer dst, long position) throws IOException {
        int len = dst.remaining();
        if (len == 0) {
            return 0;
        }
        if ((len = (int)Math.min((long)len, this.length - position)) <= 0) {
            return -1;
        }
        long offset = position % this.maxLength;
        len = (int)Math.min((long)len, this.maxLength - offset);
        FileChannel channel = this.getFileChannel(position);
        return channel.read(dst, offset);
    }

    private FileChannel getFileChannel(long position) throws IOException {
        int id = (int)(position / this.maxLength);
        while (id >= this.list.length) {
            int i = this.list.length;
            FileChannel[] newList = new FileChannel[i + 1];
            System.arraycopy(this.list, 0, newList, 0, i);
            FilePath f = this.filePath.getBase(i);
            newList[i] = f.open(this.mode);
            this.list = newList;
        }
        return this.list[id];
    }

    @Override
    protected void implTruncate(long newLength) throws IOException {
        if (newLength >= this.length) {
            return;
        }
        int newFileCount = 1 + (int)(newLength / this.maxLength);
        if (newFileCount < this.list.length) {
            FileChannel[] newList = new FileChannel[newFileCount];
            int i = this.list.length - 1;
            while (i >= newFileCount) {
                this.list[i].truncate(0L);
                this.list[i].close();
                try {
                    this.filePath.getBase(i).delete();
                }
                catch (DbException e) {
                    throw DataUtils.convertToIOException(e);
                }
                --i;
            }
            System.arraycopy(this.list, 0, newList, 0, newList.length);
            this.list = newList;
        }
        long size = newLength - this.maxLength * (long)(newFileCount - 1);
        this.list[this.list.length - 1].truncate(size);
        this.length = newLength;
    }

    @Override
    public synchronized void force(boolean metaData) throws IOException {
        FileChannel[] fileChannelArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            FileChannel c = fileChannelArray[n2];
            c.force(metaData);
            ++n2;
        }
    }

    @Override
    public synchronized int write(ByteBuffer src, long position) throws IOException {
        if (position >= this.length && position > this.maxLength) {
            long oldFilePointer = position;
            long x = this.length - this.length % this.maxLength + this.maxLength;
            while (x < position) {
                if (x > this.length) {
                    this.position(x - 1L);
                    this.write(ByteBuffer.wrap(new byte[1]));
                }
                position = oldFilePointer;
                x += this.maxLength;
            }
        }
        long offset = position % this.maxLength;
        int len = src.remaining();
        FileChannel channel = this.getFileChannel(position);
        int l = (int)Math.min((long)len, this.maxLength - offset);
        if (l == len) {
            l = channel.write(src, offset);
        } else {
            int oldLimit = src.limit();
            src.limit(src.position() + l);
            l = channel.write(src, offset);
            src.limit(oldLimit);
        }
        this.length = Math.max(this.length, position + (long)l);
        return l;
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.list[0].tryLock(position, size, shared);
    }

    public String toString() {
        return this.filePath.toString();
    }
}

