/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.zip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.disk.FilePathDisk;
import org.h2.store.fs.zip.FileZip;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FilePathZip
extends FilePath {
    @Override
    public FilePathZip getPath(String path) {
        FilePathZip p = new FilePathZip();
        p.name = path;
        return p;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public boolean exists() {
        String entryName;
        block12: {
            try {
                entryName = this.getEntryName();
                if (!entryName.isEmpty()) break block12;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (ZipFile file = this.openZipFile();){
            boolean bl = file.getEntry(entryName) != null;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int idx = this.name.lastIndexOf(47);
        return idx < 0 ? null : this.getPath(this.name.substring(0, idx));
    }

    @Override
    public boolean isAbsolute() {
        String fileName = FilePathZip.translateFileName(this.name);
        return FilePath.get(fileName).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    @Override
    public boolean isDirectory() {
        return this.isRegularOrDirectory(true);
    }

    @Override
    public boolean isRegularFile() {
        return this.isRegularOrDirectory(false);
    }

    private boolean isRegularOrDirectory(boolean directory) {
        try {
            String entryName = this.getEntryName();
            if (entryName.isEmpty()) {
                return directory;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile file = this.openZipFile();){
                Enumeration<? extends ZipEntry> en = file.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    String n = entry.getName();
                    if (n.equals(entryName)) {
                        boolean bl = entry.isDirectory() == directory;
                        return bl;
                    }
                    if (!n.startsWith(entryName) || n.length() != entryName.length() + 1 || !n.equals(entryName + "/")) continue;
                    return directory;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    @Override
    public long size() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipFile file = this.openZipFile();){
                ZipEntry entry = file.getEntry(this.getEntryName());
                long l = entry == null ? 0L : entry.getSize();
                return l;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ArrayList<FilePath> newDirectoryStream() {
        Object path = this.name;
        ArrayList<FilePath> list = new ArrayList<FilePath>();
        try {
            if (((String)path).indexOf(33) < 0) {
                path = (String)path + "!";
            }
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile file = this.openZipFile();){
                String dirName = this.getEntryName();
                String prefix = ((String)path).substring(0, ((String)path).length() - dirName.length());
                Enumeration<? extends ZipEntry> en = file.entries();
                while (en.hasMoreElements()) {
                    int idx;
                    ZipEntry entry = en.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(dirName) || name.length() <= dirName.length() || (idx = name.indexOf(47, dirName.length())) >= 0 && idx < name.length() - 1) continue;
                    list.add(this.getPath(prefix + name));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return list;
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "listFiles " + (String)path);
        }
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        ZipFile file = this.openZipFile();
        ZipEntry entry = file.getEntry(this.getEntryName());
        if (entry == null) {
            file.close();
            throw new FileNotFoundException(this.name);
        }
        return new FileZip(file, entry);
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        throw new IOException("write");
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        throw DbException.getUnsupportedException("write");
    }

    private static String translateFileName(String fileName) {
        int idx;
        if (fileName.startsWith("zip:")) {
            fileName = fileName.substring("zip:".length());
        }
        if ((idx = fileName.indexOf(33)) >= 0) {
            fileName = fileName.substring(0, idx);
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    private String getEntryName() {
        int idx = this.name.indexOf(33);
        String fileName = idx <= 0 ? "" : this.name.substring(idx + 1);
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }

    private ZipFile openZipFile() throws IOException {
        String fileName = FilePathZip.translateFileName(this.name);
        return new ZipFile(fileName);
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        if (!inTempDir) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(suffix, true);
    }

    @Override
    public String getScheme() {
        return "zip";
    }
}

