/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.Arrays;
import java.util.Objects;
import org.h2.command.ParserBase;
import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.ColumnTemplate;
import org.h2.table.GeneratedColumnResolver;
import org.h2.table.Table;
import org.h2.util.HasSQL;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;
import org.h2.value.ValueUuid;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Column
implements HasSQL,
Typed,
ColumnTemplate {
    public static final String ROWID = "_ROWID_";
    public static final int NOT_NULLABLE = 0;
    public static final int NULLABLE = 1;
    public static final int NULLABLE_UNKNOWN = 2;
    private TypeInfo type;
    private Table table;
    private String name;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private Expression onUpdateExpression;
    private SequenceOptions identityOptions;
    private boolean defaultOnNull;
    private Sequence sequence;
    private boolean isGeneratedAlways;
    private GeneratedColumnResolver generatedTableFilter;
    private int selectivity;
    private String comment;
    private boolean primaryKey;
    private boolean visible = true;
    private boolean rowId;
    private Domain domain;

    public static StringBuilder writeColumns(StringBuilder builder, Column[] columns, int sqlFlags) {
        int i = 0;
        int l = columns.length;
        while (i < l) {
            if (i > 0) {
                builder.append(", ");
            }
            columns[i].getSQL(builder, sqlFlags);
            ++i;
        }
        return builder;
    }

    public static StringBuilder writeColumns(StringBuilder builder, Column[] columns, String separator, String suffix, int sqlFlags) {
        int i = 0;
        int l = columns.length;
        while (i < l) {
            if (i > 0) {
                builder.append(separator);
            }
            columns[i].getSQL(builder, sqlFlags).append(suffix);
            ++i;
        }
        return builder;
    }

    public Column(String name, TypeInfo type) {
        this.name = name;
        this.type = type;
    }

    public Column(String name, TypeInfo type, Table table, int columnId) {
        this.name = name;
        this.type = type;
        this.table = table;
        this.columnId = columnId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (this.table == null || other.table == null || this.name == null || other.name == null) {
            return false;
        }
        if (this.table != other.table) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        if (this.table == null || this.name == null) {
            return 0;
        }
        return this.table.getId() ^ this.name.hashCode();
    }

    public Column getClone() {
        Column newColumn = new Column(this.name, this.type);
        newColumn.copy(this);
        return newColumn;
    }

    public Value convert(CastDataProvider provider, Value v) {
        try {
            return v.convertTo(this.type, provider, this);
        }
        catch (DbException e) {
            if (e.getErrorCode() == 22018) {
                e = this.getDataConversionError(v, e);
            }
            throw e;
        }
    }

    public static ValueRow convert(CastDataProvider provider, Column[] columns, ValueRow valueRow) {
        Value[] copy = null;
        Value[] values = valueRow.getList();
        int i = values.length;
        while (--i >= 0) {
            Value v = values[i];
            Value nv = columns[i].convert(provider, v);
            if (v == nv) continue;
            if (copy == null) {
                copy = Arrays.copyOf(values, values.length);
            }
            copy[i] = nv;
        }
        if (copy == null) {
            return valueRow;
        }
        TypeInfo typeInfo = TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(columns));
        return ValueRow.get(typeInfo, copy);
    }

    public boolean isIdentity() {
        return this.sequence != null || this.identityOptions != null;
    }

    public boolean isGenerated() {
        return this.isGeneratedAlways && this.defaultExpression != null;
    }

    public boolean isGeneratedAlways() {
        return this.isGeneratedAlways;
    }

    public void setGeneratedExpression(Expression expression) {
        this.isGeneratedAlways = true;
        this.defaultExpression = expression;
    }

    public void setTable(Table table, int columnId) {
        this.table = table;
        this.columnId = columnId;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public void setDefaultExpression(SessionLocal session, Expression defaultExpression) {
        if (defaultExpression != null && (defaultExpression = defaultExpression.optimize(session)).isConstant()) {
            defaultExpression = ValueExpression.get(defaultExpression.getValue(session));
        }
        this.defaultExpression = defaultExpression;
        this.isGeneratedAlways = false;
    }

    @Override
    public void setOnUpdateExpression(SessionLocal session, Expression onUpdateExpression) {
        if (onUpdateExpression != null && (onUpdateExpression = onUpdateExpression.optimize(session)).isConstant()) {
            onUpdateExpression = ValueExpression.get(onUpdateExpression.getValue(session));
        }
        this.onUpdateExpression = onUpdateExpression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    @Override
    public String getSQL(int sqlFlags) {
        return this.rowId ? this.name : ParserBase.quoteIdentifier(this.name, sqlFlags);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.rowId ? builder.append(this.name) : ParserUtil.quoteIdentifier(builder, this.name, sqlFlags);
    }

    public StringBuilder getSQLWithTable(StringBuilder builder, int sqlFlags) {
        return this.getSQL(this.table.getSQL(builder, sqlFlags).append('.'), sqlFlags);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    public void setNullable(boolean b) {
        this.nullable = b;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isRowId() {
        return this.rowId;
    }

    public void setRowId(boolean rowId) {
        this.rowId = rowId;
    }

    /*
     * Unable to fully structure code
     */
    Value validateConvertUpdateSequence(SessionLocal session, Value value, Row row) {
        if (value != null) ** GOTO lbl6
        if (this.sequence != null) {
            value = session.getNextValueFor(this.sequence, null);
        } else {
            value = this.getDefaultOrGenerated(session, row);
lbl6:
            // 2 sources

            if (value == ValueNull.INSTANCE && !this.nullable) {
                throw DbException.get(23502, this.name);
            }
        }
        try {
            value = value.convertForAssignTo(this.type, session, this.name);
        }
        catch (DbException e) {
            if (e.getErrorCode() == 22018) {
                e = this.getDataConversionError(value, e);
            }
            throw e;
        }
        if (this.domain != null) {
            this.domain.checkConstraints(session, value);
        }
        if (this.sequence != null && session.getMode().updateSequenceOnManualIdentityInsertion) {
            this.updateSequenceIfRequired(session, value.getLong());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value getDefaultOrGenerated(SessionLocal session, Row row) {
        Value value;
        Expression localDefaultExpression = this.getEffectiveDefaultExpression();
        if (localDefaultExpression == null) {
            value = ValueNull.INSTANCE;
        } else {
            if (this.isGeneratedAlways) {
                Column column = this;
                synchronized (column) {
                    this.generatedTableFilter.set(row);
                    try {
                        value = localDefaultExpression.getValue(session);
                    }
                    finally {
                        this.generatedTableFilter.set(null);
                    }
                }
            }
            value = localDefaultExpression.getValue(session);
        }
        return value;
    }

    private DbException getDataConversionError(Value value, DbException cause) {
        StringBuilder builder = new StringBuilder().append(value.getTraceSQL()).append(" (");
        if (this.table != null) {
            builder.append(this.table.getName()).append(": ");
        }
        builder.append(this.getCreateSQL()).append(')');
        return DbException.get(22018, cause, builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSequenceIfRequired(SessionLocal session, long value) {
        Sequence sequence = this.sequence;
        synchronized (sequence) {
            if (this.sequence.getCycle() == Sequence.Cycle.EXHAUSTED) {
                return;
            }
            long current = this.sequence.getCurrentValue();
            long inc = this.sequence.getIncrement();
            if (inc > 0L) {
                if (value <= current) {
                    return;
                }
            } else if (value >= current) {
                return;
            }
            try {
                this.sequence.modify(value + inc, null, null, null, null, null, null);
            }
            catch (DbException ex) {
                if (ex.getErrorCode() == 90009) {
                    return;
                }
                throw ex;
            }
        }
        this.sequence.flush(session);
    }

    public void initializeSequence(SessionLocal session, Schema schema, int id, boolean temporary) {
        String sequenceName;
        if (this.identityOptions == null) {
            throw DbException.getInternalError();
        }
        while (schema.findSequence(sequenceName = "SYSTEM_SEQUENCE_" + StringUtils.toUpperEnglish(ValueUuid.getNewRandom().getString().replace('-', '_'))) != null) {
        }
        this.identityOptions.setDataType(this.type);
        Sequence seq = new Sequence(session, schema, id, sequenceName, this.identityOptions, true);
        seq.setTemporary(temporary);
        session.getDatabase().addSchemaObject(session, seq);
        this.setSequence(seq, this.isGeneratedAlways);
    }

    @Override
    public void prepareExpressions(SessionLocal session) {
        if (this.defaultExpression != null) {
            if (this.isGeneratedAlways) {
                this.generatedTableFilter = new GeneratedColumnResolver(this.table);
                this.defaultExpression.mapColumns(this.generatedTableFilter, 0, 0);
            }
            this.defaultExpression = this.defaultExpression.optimize(session);
        }
        if (this.onUpdateExpression != null) {
            this.onUpdateExpression = this.onUpdateExpression.optimize(session);
        }
        if (this.domain != null) {
            this.domain.prepareExpressions(session);
        }
    }

    public String getCreateSQLWithoutName() {
        return this.getCreateSQL(new StringBuilder(), false);
    }

    public String getCreateSQL() {
        return this.getCreateSQL(false);
    }

    public String getCreateSQL(boolean forMeta) {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            ParserUtil.quoteIdentifier(builder, this.name, 0).append(' ');
        }
        return this.getCreateSQL(builder, forMeta);
    }

    private String getCreateSQL(StringBuilder builder, boolean forMeta) {
        if (this.domain != null) {
            this.domain.getSQL(builder, 0);
        } else {
            this.type.getSQL(builder, 0);
        }
        if (!this.visible) {
            builder.append(" INVISIBLE ");
        }
        if (this.sequence != null) {
            builder.append(" GENERATED ").append(this.isGeneratedAlways ? "ALWAYS" : "BY DEFAULT").append(" AS IDENTITY");
            if (!forMeta) {
                this.sequence.getSequenceOptionsSQL(builder.append('(')).append(')');
            }
        } else if (this.defaultExpression != null) {
            if (this.isGeneratedAlways) {
                this.defaultExpression.getEnclosedSQL(builder.append(" GENERATED ALWAYS AS "), 0);
            } else {
                this.defaultExpression.getUnenclosedSQL(builder.append(" DEFAULT "), 0);
            }
        }
        if (this.onUpdateExpression != null) {
            this.onUpdateExpression.getUnenclosedSQL(builder.append(" ON UPDATE "), 0);
        }
        if (this.defaultOnNull) {
            builder.append(" DEFAULT ON NULL");
        }
        if (forMeta && this.sequence != null) {
            this.sequence.getSQL(builder.append(" SEQUENCE "), 0);
        }
        if (this.selectivity != 0) {
            builder.append(" SELECTIVITY ").append(this.selectivity);
        }
        if (this.comment != null) {
            StringUtils.quoteStringSQL(builder.append(" COMMENT "), this.comment);
        }
        if (!this.nullable) {
            builder.append(" NOT NULL");
        }
        return builder.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public Expression getEffectiveDefaultExpression() {
        if (this.sequence != null) {
            return null;
        }
        return this.defaultExpression != null ? this.defaultExpression : (this.domain != null ? this.domain.getEffectiveDefaultExpression() : null);
    }

    @Override
    public Expression getOnUpdateExpression() {
        return this.onUpdateExpression;
    }

    @Override
    public Expression getEffectiveOnUpdateExpression() {
        if (this.sequence != null || this.isGeneratedAlways) {
            return null;
        }
        return this.onUpdateExpression != null ? this.onUpdateExpression : (this.domain != null ? this.domain.getEffectiveOnUpdateExpression() : null);
    }

    public boolean hasIdentityOptions() {
        return this.identityOptions != null;
    }

    public void setIdentityOptions(SequenceOptions identityOptions, boolean generatedAlways) {
        this.identityOptions = identityOptions;
        this.isGeneratedAlways = generatedAlways;
        this.removeNonIdentityProperties();
    }

    private void removeNonIdentityProperties() {
        this.nullable = false;
        this.defaultExpression = null;
        this.onUpdateExpression = null;
    }

    public SequenceOptions getIdentityOptions() {
        return this.identityOptions;
    }

    public void setDefaultOnNull(boolean defaultOnNull) {
        this.defaultOnNull = defaultOnNull;
    }

    public boolean isDefaultOnNull() {
        return this.defaultOnNull;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    public void setSequence(Sequence sequence, boolean generatedAlways) {
        this.sequence = sequence;
        this.isGeneratedAlways = generatedAlways;
        this.identityOptions = null;
        if (sequence != null) {
            this.removeNonIdentityProperties();
            if (sequence.getDatabase().getMode().identityColumnsHaveDefaultOnNull) {
                this.defaultOnNull = true;
            }
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int selectivity) {
        this.selectivity = selectivity = selectivity < 0 ? 0 : (selectivity > 100 ? 100 : selectivity);
    }

    @Override
    public String getDefaultSQL() {
        return this.defaultExpression == null ? null : this.defaultExpression.getUnenclosedSQL(new StringBuilder(), 0).toString();
    }

    @Override
    public String getOnUpdateSQL() {
        return this.onUpdateExpression == null ? null : this.onUpdateExpression.getUnenclosedSQL(new StringBuilder(), 0).toString();
    }

    public void setComment(String comment) {
        this.comment = comment != null && !comment.isEmpty() ? comment : null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    boolean isEverything(ExpressionVisitor visitor) {
        Expression e;
        if (visitor.getType() == 7 && this.sequence != null) {
            visitor.getDependencies().add(this.sequence);
        }
        if ((e = this.getEffectiveDefaultExpression()) != null && !e.isEverything(visitor)) {
            return false;
        }
        e = this.getEffectiveOnUpdateExpression();
        return e == null || e.isEverything(visitor);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String toString() {
        return this.name;
    }

    public boolean isWideningConversion(Column newColumn) {
        long newPrecision;
        TypeInfo newType = newColumn.type;
        int valueType = this.type.getValueType();
        if (valueType != newType.getValueType()) {
            return false;
        }
        long precision = this.type.getPrecision();
        if (precision > (newPrecision = newType.getPrecision()) || precision < newPrecision && (valueType == 1 || valueType == 5)) {
            return false;
        }
        if (this.type.getScale() != newType.getScale()) {
            return false;
        }
        if (!Objects.equals(this.type.getExtTypeInfo(), newType.getExtTypeInfo())) {
            return false;
        }
        if (this.nullable && !newColumn.nullable) {
            return false;
        }
        if (this.primaryKey != newColumn.primaryKey) {
            return false;
        }
        if (this.identityOptions != null || newColumn.identityOptions != null) {
            return false;
        }
        if (this.domain != newColumn.domain) {
            return false;
        }
        if (this.defaultExpression != null || newColumn.defaultExpression != null) {
            return false;
        }
        if (this.isGeneratedAlways || newColumn.isGeneratedAlways) {
            return false;
        }
        return this.onUpdateExpression == null && newColumn.onUpdateExpression == null;
    }

    public void copy(Column source) {
        this.name = source.name;
        this.type = source.type;
        this.domain = source.domain;
        this.nullable = source.nullable;
        this.defaultExpression = source.defaultExpression;
        this.onUpdateExpression = source.onUpdateExpression;
        this.defaultOnNull = source.defaultOnNull;
        this.sequence = source.sequence;
        this.comment = source.comment;
        this.generatedTableFilter = source.generatedTableFilter;
        this.isGeneratedAlways = source.isGeneratedAlways;
        this.selectivity = source.selectivity;
        this.primaryKey = source.primaryKey;
        this.visible = source.visible;
    }
}

