/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.QueryScope;
import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.QueryExpressionIndex;
import org.h2.index.RegularQueryExpressionIndex;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.QueryExpressionTable;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DerivedTable
extends QueryExpressionTable {
    private final String querySQL;
    private final Query topQuery;
    private final ArrayList<Parameter> originalParameters;

    public DerivedTable(SessionLocal session, String name, Column[] columnTemplates, Query query, Query topQuery) {
        super(session.getDatabase().getMainSchema(), 0, name);
        this.setTemporary(true);
        this.topQuery = topQuery;
        query.prepareExpressions();
        try {
            this.querySQL = query.getPlanSQL(0);
            this.originalParameters = query.getParameters();
            this.tables = new ArrayList<Table>(query.getTables());
            this.setColumns(this.initColumns(session, columnTemplates, query, true));
            this.viewQuery = query;
        }
        catch (DbException e) {
            if (e.getErrorCode() == 90156) {
                throw e;
            }
            e.addSQL(this.getCreateSQL());
            throw e;
        }
    }

    @Override
    protected QueryExpressionIndex createIndex(SessionLocal session, int[] masks) {
        return new RegularQueryExpressionIndex(this, this.querySQL, this.originalParameters, session, masks);
    }

    @Override
    public boolean isQueryComparable() {
        if (!super.isQueryComparable()) {
            return false;
        }
        return this.topQuery == null || this.topQuery.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR);
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public Query getTopQuery() {
        return this.topQuery;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return StringUtils.indent(builder.append("(\n"), this.querySQL, 4, true).append(')');
    }

    @Override
    public QueryScope getQueryScope() {
        return this.viewQuery.getOuterQueryScope();
    }
}

