/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.HashMap;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class GeneratedColumnResolver
implements ColumnResolver {
    private final Table table;
    private Column[] columns;
    private HashMap<String, Column> columnMap;
    private Row current;

    GeneratedColumnResolver(Table table) {
        this.table = table;
    }

    void set(Row current) {
        this.current = current;
    }

    @Override
    public Column[] getColumns() {
        Column[] columns = this.columns;
        if (columns == null) {
            columns = this.createColumns();
            this.columns = columns;
        }
        return columns;
    }

    private Column[] createColumns() {
        int totalCount;
        Column[] allColumns = this.table.getColumns();
        int baseCount = totalCount = allColumns.length;
        int i = 0;
        while (i < totalCount) {
            if (allColumns[i].isGenerated()) {
                --baseCount;
            }
            ++i;
        }
        Column[] baseColumns = new Column[baseCount];
        int i2 = 0;
        int j = 0;
        while (i2 < totalCount) {
            Column c = allColumns[i2];
            if (!c.isGenerated()) {
                baseColumns[j++] = c;
            }
            ++i2;
        }
        return baseColumns;
    }

    @Override
    public Column findColumn(String name) {
        HashMap<String, Column> columnMap = this.columnMap;
        if (columnMap == null) {
            columnMap = this.table.getDatabase().newStringMap();
            Column[] columnArray = this.getColumns();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column c = columnArray[n2];
                columnMap.put(c.getName(), c);
                ++n2;
            }
            this.columnMap = columnMap;
        }
        return columnMap.get(name);
    }

    @Override
    public Value getValue(Column column) {
        int columnId = column.getColumnId();
        if (columnId == -1) {
            return ValueBigint.get(this.current.getKey());
        }
        return this.current.getValue(columnId);
    }

    @Override
    public Column getRowIdColumn() {
        return this.table.getRowIdColumn();
    }
}

