/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.h2.command.QueryScope;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Query;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.QueryExpressionIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.value.TypeInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class QueryExpressionTable
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    Query viewQuery;
    ArrayList<Table> tables;
    private long lastModificationCheck;
    private long maxDataModificationId;

    public static List<Column> createQueryColumnTemplateList(String[] cols, Query theQuery) {
        ArrayList<Column> columnTemplateList = new ArrayList<Column>();
        theQuery.prepare();
        SessionLocal session = theQuery.getSession();
        ArrayList<Expression> withExpressions = theQuery.getExpressions();
        int i = 0;
        while (i < withExpressions.size()) {
            Expression columnExp = withExpressions.get(i);
            String columnName = cols != null && cols.length > i ? cols[i] : columnExp.getColumnNameForView(session, i);
            columnTemplateList.add(new Column(columnName, columnExp.getType()));
            ++i;
        }
        return columnTemplateList;
    }

    QueryExpressionTable(Schema schema, int id, String name) {
        super(schema, id, name, false, true);
    }

    Column[] initColumns(SessionLocal session, Column[] columnTemplates, Query query, boolean isDerivedTable) {
        ArrayList<Expression> expressions = query.getExpressions();
        int count = query.getColumnCount();
        ArrayList<Column> list = new ArrayList<Column>(count);
        int i = 0;
        while (i < count) {
            Expression expr = expressions.get(i);
            String name = null;
            TypeInfo type = TypeInfo.TYPE_UNKNOWN;
            if (columnTemplates != null && columnTemplates.length > i) {
                name = columnTemplates[i].getName();
                type = columnTemplates[i].getType();
            }
            if (name == null) {
                String string = name = isDerivedTable ? expr.getAlias(session, i) : expr.getColumnNameForView(session, i);
            }
            if (type.getValueType() == -1) {
                type = expr.getType();
            }
            list.add(new Column(name, type, this, i));
            ++i;
        }
        return list.toArray(new Column[0]);
    }

    public final Query getQuery() {
        return this.viewQuery;
    }

    public abstract Query getTopQuery();

    @Override
    public final void close(SessionLocal session) {
    }

    @Override
    public final Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".addIndex");
    }

    @Override
    public final boolean isView() {
        return true;
    }

    @Override
    public final PlanItem getBestPlanItem(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        CacheKey cacheKey = new CacheKey(masks, this);
        Map<Object, QueryExpressionIndex> indexCache = session.getViewIndexCache(this.getTableType() == null);
        QueryExpressionIndex i = indexCache.get(cacheKey);
        if (i == null || i.isExpired()) {
            i = this.createIndex(session, masks);
            indexCache.put(cacheKey, i);
        }
        PlanItem item = new PlanItem();
        item.cost = i.getCost(session, masks, filters, filter, sortOrder, allColumnsSet);
        item.setIndex(i);
        return item;
    }

    abstract QueryExpressionIndex createIndex(SessionLocal var1, int[] var2);

    @Override
    public boolean isQueryComparable() {
        for (Table t : this.tables) {
            if (t.isQueryComparable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isInsertable() {
        return false;
    }

    @Override
    public final void removeRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".removeRow");
    }

    @Override
    public final void addRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".addRow");
    }

    @Override
    public final void checkSupportAlter() {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".checkSupportAlter");
    }

    @Override
    public final long truncate(SessionLocal session) {
        throw DbException.getUnsupportedException(this.getClass().getSimpleName() + ".truncate");
    }

    @Override
    public final long getRowCount(SessionLocal session) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public final boolean canGetRowCount(SessionLocal session) {
        return false;
    }

    @Override
    public final long getRowCountApproximation(SessionLocal session) {
        return 100L;
    }

    public final int getParameterOffset(ArrayList<Parameter> additionalParameters) {
        int result;
        Query topQuery = this.getTopQuery();
        int n = result = topQuery == null ? 0 : Parameter.getMaxIndex(topQuery.getParameters());
        if (additionalParameters != null) {
            result = Math.max(result, Parameter.getMaxIndex(additionalParameters));
        }
        return result;
    }

    @Override
    public final boolean canReference() {
        return false;
    }

    @Override
    public final ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        long dbMod = this.database.getModificationDataId();
        if (dbMod > this.lastModificationCheck && this.maxDataModificationId <= dbMod) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = dbMod;
        }
        return this.maxDataModificationId;
    }

    @Override
    public final Index getScanIndex(SessionLocal session) {
        return this.getBestPlanItem(session, null, null, -1, null, null).getIndex();
    }

    @Override
    public Index getScanIndex(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.getBestPlanItem(session, masks, filters, filter, sortOrder, allColumnsSet).getIndex();
    }

    @Override
    public boolean isDeterministic() {
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    @Override
    public final void addDependencies(HashSet<DbObject> dependencies) {
        super.addDependencies(dependencies);
        if (this.tables != null) {
            for (Table t : this.tables) {
                if (TableType.VIEW == t.getTableType()) continue;
                t.addDependencies(dependencies);
            }
        }
    }

    public abstract QueryScope getQueryScope();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class CacheKey {
        private final int[] masks;
        private final QueryExpressionTable queryExpressionTable;

        CacheKey(int[] masks, QueryExpressionTable queryExpressionTable) {
            this.masks = masks;
            this.queryExpressionTable = queryExpressionTable;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.masks);
            result = 31 * result + this.queryExpressionTable.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.queryExpressionTable != other.queryExpressionTable) {
                return false;
            }
            return Arrays.equals(this.masks, other.masks);
        }
    }
}

