/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Select;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.index.IndexCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.DualTable;
import org.h2.table.IndexHints;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.table.VirtualTable;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTinyint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    public static final Comparator<TableFilter> ORDER_IN_FROM_COMPARATOR = Comparator.comparing(TableFilter::getOrderInFrom);
    private static final TableFilterVisitor JOI_VISITOR = f -> {
        boolean bl = f.joinOuterIndirect = true;
    };
    protected boolean joinOuterIndirect;
    private SessionLocal session;
    private final Table table;
    private final Select select;
    private String alias;
    private Index index;
    private final IndexHints indexHints;
    private int[] masks;
    private int scanCount;
    private boolean evaluatable;
    private boolean used;
    private final IndexCursor cursor;
    private final ArrayList<IndexCondition> indexConditions = Utils.newSmallArrayList();
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean joinOuter;
    private TableFilter nestedJoin;
    private LinkedHashMap<Column, Column> commonJoinColumns;
    private TableFilter commonJoinColumnsFilter;
    private ArrayList<Column> commonJoinColumnsToExclude;
    private boolean foundOne;
    private Expression fullCondition;
    private final int hashCode;
    private final int orderInFrom;
    private LinkedHashMap<Column, String> derivedColumnMap;

    public TableFilter(SessionLocal session, Table table, String alias, boolean rightsChecked, Select select, int orderInFrom, IndexHints indexHints) {
        this.session = session;
        this.table = table;
        this.alias = alias;
        this.select = select;
        this.cursor = new IndexCursor();
        if (!rightsChecked) {
            session.getUser().checkTableRight(table, 1);
        }
        this.hashCode = session.nextObjectId();
        this.orderInFrom = orderInFrom;
        this.indexHints = indexHints;
    }

    public int getOrderInFrom() {
        return this.orderInFrom;
    }

    public IndexCursor getIndexCursor() {
        return this.cursor;
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(SessionLocal s) {
        this.table.lock(s, 0);
        if (this.join != null) {
            this.join.lock(s);
        }
    }

    public PlanItem getBestPlanItem(SessionLocal s, TableFilter[] filters, int filter, AllColumnsForPlan allColumnsSet) {
        PlanItem item1 = null;
        SortOrder sortOrder = null;
        if (this.select != null) {
            sortOrder = this.select.getSortOrder();
        }
        if (this.indexConditions.isEmpty()) {
            item1 = new PlanItem();
            item1.setIndex(this.table.getScanIndex(s, null, filters, filter, sortOrder, allColumnsSet));
            item1.cost = item1.getIndex().getCost(s, null, filters, filter, sortOrder, allColumnsSet);
        }
        int len = this.table.getColumns().length;
        int[] masks = new int[len];
        for (IndexCondition condition : this.indexConditions) {
            if (!condition.isEvaluatable()) continue;
            if (condition.isAlwaysFalse()) {
                masks = null;
                break;
            }
            if (condition.isCompoundColumns()) {
                Column[] columns = condition.getColumns();
                int i = 0;
                int n = columns.length;
                while (i < n) {
                    int id = columns[i].getColumnId();
                    if (id >= 0) {
                        int n2 = id;
                        masks[n2] = masks[n2] | condition.getMask(this.indexConditions);
                    }
                    ++i;
                }
                continue;
            }
            int id = condition.getColumn().getColumnId();
            if (id < 0) continue;
            int n = id;
            masks[n] = masks[n] | condition.getMask(this.indexConditions);
        }
        PlanItem item = this.table.getBestPlanItem(s, masks, filters, filter, sortOrder, allColumnsSet);
        item.setMasks(masks);
        item.cost -= item.cost * (double)this.indexConditions.size() / 100.0 / (double)(filter + 1);
        if (item1 != null && item1.cost < item.cost) {
            item = item1;
        }
        if (this.nestedJoin != null) {
            this.setEvaluatable(true);
            item.setNestedJoinPlan(this.nestedJoin.getBestPlanItem(s, filters, filter, allColumnsSet));
            item.cost += item.cost * item.getNestedJoinPlan().cost;
        }
        if (this.join != null) {
            this.setEvaluatable(true);
            while (filters[++filter] != this.join) {
            }
            item.setJoinPlan(this.join.getBestPlanItem(s, filters, filter, allColumnsSet));
            item.cost += item.cost * item.getJoinPlan().cost;
        }
        return item;
    }

    public void setPlanItem(PlanItem item) {
        if (item == null) {
            return;
        }
        this.setIndex(item.getIndex(), false);
        this.masks = item.getMasks();
        if (this.nestedJoin != null) {
            if (item.getNestedJoinPlan() != null) {
                this.nestedJoin.setPlanItem(item.getNestedJoinPlan());
            } else {
                this.nestedJoin.setScanIndexes();
            }
        }
        if (this.join != null) {
            if (item.getJoinPlan() != null) {
                this.join.setPlanItem(item.getJoinPlan());
            } else {
                this.join.setScanIndexes();
            }
        }
    }

    private void setScanIndexes() {
        if (this.index == null) {
            this.setIndex(this.table.getScanIndex(this.session), false);
        }
        if (this.join != null) {
            this.join.setScanIndexes();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.setScanIndexes();
        }
    }

    public void prepare() {
        boolean compoundIndexConditionFound = false;
        int i = 0;
        while (i < this.indexConditions.size()) {
            IndexCondition condition = this.indexConditions.get(i);
            if (!condition.isAlwaysFalse()) {
                if (compoundIndexConditionFound) {
                    this.indexConditions.remove(i);
                    --i;
                } else if (condition.isCompoundColumns()) {
                    if (this.index.getIndexType().isScan()) {
                        this.indexConditions.remove(i);
                        --i;
                    } else if (IndexCursor.canUseIndexForIn(this.index, condition.getColumns())) {
                        compoundIndexConditionFound = true;
                    } else {
                        IndexCondition fixedCondition = condition.cloneWithIndexColumns(this.index);
                        if (fixedCondition != null) {
                            this.indexConditions.set(i, fixedCondition);
                            compoundIndexConditionFound = true;
                        } else {
                            this.indexConditions.remove(i);
                            --i;
                        }
                    }
                } else {
                    int columnIndex;
                    Column col = condition.getColumn();
                    if (col.getColumnId() >= 0 && (columnIndex = this.index.getColumnIndex(col)) != 0 && (columnIndex < 0 || condition.getCompareType() == 10)) {
                        this.indexConditions.remove(i);
                        --i;
                    }
                }
            }
            ++i;
        }
        if (this.nestedJoin != null) {
            if (this.nestedJoin == this) {
                throw DbException.getInternalError("self join");
            }
            this.nestedJoin.prepare();
        }
        if (this.join != null) {
            if (this.join == this) {
                throw DbException.getInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimizeCondition(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimizeCondition(this.session);
        }
    }

    public void startQuery(SessionLocal s) {
        this.session = s;
        this.scanCount = 0;
        if (this.nestedJoin != null) {
            this.nestedJoin.startQuery(s);
        }
        if (this.join != null) {
            this.join.startQuery(s);
        }
    }

    public void reset() {
        if (this.nestedJoin != null) {
            this.nestedJoin.reset();
        }
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    public boolean next() {
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            this.cursor.find(this.session, this.indexConditions);
            if (!this.cursor.isAlwaysFalse()) {
                if (this.nestedJoin != null) {
                    this.nestedJoin.reset();
                }
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (this.cursor.isAlwaysFalse()) {
                this.state = 2;
            } else if (this.nestedJoin != null) {
                if (this.state == 0) {
                    this.state = 1;
                }
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.checkTimeout();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.nestedJoin != null && this.state == 1 && !this.nestedJoin.next()) {
                this.state = 2;
                if (!this.joinOuter || this.foundOne) continue;
            }
            if (this.state == 2) {
                if (!this.joinOuter || this.foundOne) break;
                this.setNullRow();
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean joinConditionOk = this.isOk(this.joinCondition);
            if (this.state == 1) {
                if (!joinConditionOk) continue;
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !joinConditionOk) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    public boolean isNullRow() {
        return this.state == 3;
    }

    protected void setNullRow() {
        this.state = 3;
        this.current = this.table.getNullRow();
        this.currentSearchRow = this.current;
        if (this.nestedJoin != null) {
            this.nestedJoin.visit(TableFilter::setNullRow);
        }
    }

    private void checkTimeout() {
        this.session.checkCanceled();
    }

    boolean isOk(Expression condition) {
        return condition == null || condition.getBooleanValue(this.session);
    }

    public Row get() {
        if (this.current == null && this.currentSearchRow != null) {
            this.current = this.cursor.get();
        }
        return this.current;
    }

    public void set(Row current) {
        this.current = current;
        this.currentSearchRow = current;
    }

    @Override
    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition condition) {
        this.indexConditions.add(condition);
    }

    public void addFilterCondition(Expression condition, boolean isJoin) {
        if (isJoin) {
            this.joinCondition = this.joinCondition == null ? condition : new ConditionAndOr(0, this.joinCondition, condition);
        } else {
            this.filterCondition = this.filterCondition == null ? condition : new ConditionAndOr(0, this.filterCondition, condition);
        }
    }

    public void addJoin(TableFilter filter, boolean outer, Expression on) {
        if (on != null) {
            on.mapColumns(this, 0, 0);
            MapColumnsVisitor visitor = new MapColumnsVisitor(on);
            this.visit(visitor);
            filter.visit(visitor);
        }
        if (this.join == null) {
            this.join = filter;
            filter.joinOuter = outer;
            if (outer) {
                filter.visit(JOI_VISITOR);
            }
            if (on != null) {
                filter.mapAndAddFilter(on);
            }
        } else {
            this.join.addJoin(filter, outer, on);
        }
    }

    public void setNestedJoin(TableFilter filter) {
        this.nestedJoin = filter;
    }

    public void mapAndAddFilter(Expression on) {
        on.mapColumns(this, 0, 0);
        this.addFilterCondition(on, true);
        if (this.nestedJoin != null) {
            on.mapColumns(this.nestedJoin, 0, 0);
        }
        if (this.join != null) {
            this.join.mapAndAddFilter(on);
        }
    }

    public void createIndexConditions() {
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimizeCondition(this.session);
            if (this.joinCondition != null) {
                this.joinCondition.createIndexConditions(this.session, this);
                if (this.nestedJoin != null) {
                    this.joinCondition.createIndexConditions(this.session, this.nestedJoin);
                }
            }
        }
        if (this.join != null) {
            this.join.createIndexConditions();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.createIndexConditions();
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.joinOuter;
    }

    public boolean isJoinOuterIndirect() {
        return this.joinOuterIndirect;
    }

    public StringBuilder getPlanSQL(StringBuilder builder, boolean isJoin, int sqlFlags) {
        if (isJoin) {
            if (this.joinOuter) {
                builder.append("LEFT OUTER JOIN ");
            } else {
                builder.append("INNER JOIN ");
            }
        }
        if (this.nestedJoin != null) {
            boolean enclose;
            StringBuilder buffNested = new StringBuilder();
            TableFilter n = this.nestedJoin;
            do {
                n.getPlanSQL(buffNested, n != this.nestedJoin, sqlFlags).append('\n');
            } while ((n = n.getJoin()) != null);
            String nested = buffNested.toString();
            boolean bl = enclose = !nested.startsWith("(");
            if (enclose) {
                builder.append("(\n");
            }
            StringUtils.indent(builder, nested, 4, false);
            if (enclose) {
                builder.append(')');
            }
            if (isJoin) {
                builder.append(" ON ");
                if (this.joinCondition == null) {
                    builder.append("1=1");
                } else {
                    this.joinCondition.getUnenclosedSQL(builder, sqlFlags);
                }
            }
            return builder;
        }
        this.table.getSQL(builder, sqlFlags);
        if (this.table instanceof TableView && ((TableView)this.table).isInvalid()) {
            throw DbException.get(90109, this.table.getName(), "not compiled");
        }
        if (this.alias != null) {
            builder.append(' ');
            ParserUtil.quoteIdentifier(builder, this.alias, sqlFlags);
            if (this.derivedColumnMap != null) {
                builder.append('(');
                boolean f = false;
                for (String name : this.derivedColumnMap.values()) {
                    if (f) {
                        builder.append(", ");
                    }
                    f = true;
                    ParserUtil.quoteIdentifier(builder, name, sqlFlags);
                }
                builder.append(')');
            }
        }
        if (this.indexHints != null) {
            builder.append(" USE INDEX (");
            boolean first = true;
            for (String index : this.indexHints.getAllowedIndexes()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                ParserUtil.quoteIdentifier(builder, index, sqlFlags);
            }
            builder.append(")");
        }
        if (this.index != null && (sqlFlags & 8) != 0) {
            builder.append('\n');
            StringBuilder planBuilder = new StringBuilder().append("/* ").append(this.index.getPlanSQL());
            if (!this.indexConditions.isEmpty()) {
                planBuilder.append(": ");
                int i = 0;
                int size = this.indexConditions.size();
                while (i < size) {
                    if (i > 0) {
                        planBuilder.append("\n    AND ");
                    }
                    planBuilder.append(this.indexConditions.get(i).getSQL(11));
                    ++i;
                }
            }
            if (planBuilder.indexOf("\n", 3) >= 0) {
                planBuilder.append('\n');
            }
            StringUtils.indent(builder, planBuilder.append(" */").toString(), 4, false);
        }
        if (isJoin) {
            builder.append("\n    ON ");
            if (this.joinCondition == null) {
                builder.append("1=1");
            } else {
                this.joinCondition.getUnenclosedSQL(builder, sqlFlags);
            }
        }
        if ((sqlFlags & 8) != 0) {
            if (this.filterCondition != null) {
                builder.append('\n');
                Object condition = this.filterCondition.getSQL(11, 2);
                condition = "/* WHERE " + (String)condition + "\n*/";
                StringUtils.indent(builder, (String)condition, 4, false);
            }
            if (this.scanCount > 0) {
                builder.append("\n    /* scanCount: ").append(this.scanCount).append(" */");
            }
        }
        return builder;
    }

    void removeUnusableIndexConditions() {
        int i = 0;
        while (i < this.indexConditions.size()) {
            IndexCondition cond = this.indexConditions.get(i);
            if (cond.getMask(this.indexConditions) == 0 || !cond.isEvaluatable()) {
                this.indexConditions.remove(i--);
            }
            ++i;
        }
    }

    public int[] getMasks() {
        return this.masks;
    }

    public ArrayList<IndexCondition> getIndexConditions() {
        return this.indexConditions;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index, boolean reverse) {
        this.index = index;
        this.cursor.setIndex(index, reverse);
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression condition) {
        this.fullCondition = condition;
        if (this.join != null) {
            this.join.setFullCondition(condition);
        }
    }

    void optimizeFullCondition() {
        if (!this.joinOuter && this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this);
            if (this.nestedJoin != null) {
                this.nestedJoin.optimizeFullCondition();
            }
            if (this.join != null) {
                this.join.optimizeFullCondition();
            }
        }
    }

    public void setEvaluatable(TableFilter filter, boolean b) {
        filter.setEvaluatable(b);
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(filter, b);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(filter, b);
        }
        if (this.nestedJoin != null && this == filter) {
            this.nestedJoin.setEvaluatable(this.nestedJoin, b);
        }
        if (this.join != null) {
            this.join.setEvaluatable(filter, b);
        }
    }

    public void setEvaluatable(boolean evaluatable) {
        this.evaluatable = evaluatable;
    }

    @Override
    public String getSchemaName() {
        if (this.alias == null && !(this.table instanceof VirtualTable)) {
            return this.table.getSchema().getName();
        }
        return null;
    }

    @Override
    public Column[] getColumns() {
        return this.table.getColumns();
    }

    @Override
    public Column findColumn(String name) {
        LinkedHashMap<Column, String> map = this.derivedColumnMap;
        if (map != null) {
            Database db = this.session.getDatabase();
            for (Map.Entry<Column, String> entry : this.derivedColumnMap.entrySet()) {
                if (!db.equalsIdentifiers(entry.getValue(), name)) continue;
                return entry.getKey();
            }
            return null;
        }
        return this.table.findColumn(name);
    }

    @Override
    public String getColumnName(Column column) {
        LinkedHashMap<Column, String> map = this.derivedColumnMap;
        return map != null ? (String)((HashMap)map).get(column) : column.getName();
    }

    @Override
    public boolean hasDerivedColumnList() {
        return this.derivedColumnMap != null;
    }

    public Column getColumn(String columnName, boolean ifExists) {
        LinkedHashMap<Column, String> map = this.derivedColumnMap;
        if (map != null) {
            Database database = this.session.getDatabase();
            for (Map.Entry entry : ((HashMap)map).entrySet()) {
                if (!database.equalsIdentifiers(columnName, (String)entry.getValue())) continue;
                return (Column)entry.getKey();
            }
            if (ifExists) {
                return null;
            }
            throw DbException.get(42122, columnName);
        }
        return this.table.getColumn(columnName, ifExists);
    }

    @Override
    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] sys = new Column[]{new Column("oid", TypeInfo.TYPE_INTEGER, this.table, 0), new Column("ctid", TypeInfo.TYPE_VARCHAR, this.table, 0)};
        return sys;
    }

    @Override
    public Column getRowIdColumn() {
        return this.table.getRowIdColumn();
    }

    @Override
    public Value getValue(Column column) {
        if (this.currentSearchRow == null) {
            return null;
        }
        int columnId = column.getColumnId();
        if (columnId == -1) {
            return ValueBigint.get(this.currentSearchRow.getKey());
        }
        if (this.current == null) {
            Value v = this.currentSearchRow.getValue(columnId);
            if (v != null) {
                return v;
            }
            if (columnId == column.getTable().getMainIndexColumn()) {
                return this.getDelegatedValue(column);
            }
            this.current = this.cursor.get();
            if (this.current == null) {
                return ValueNull.INSTANCE;
            }
        }
        return this.current.getValue(columnId);
    }

    private Value getDelegatedValue(Column column) {
        long key = this.currentSearchRow.getKey();
        switch (column.getType().getValueType()) {
            case 9: {
                return ValueTinyint.get((byte)key);
            }
            case 10: {
                return ValueSmallint.get((short)key);
            }
            case 11: {
                return ValueInteger.get((int)key);
            }
            case 12: {
                return ValueBigint.get(key);
            }
        }
        throw DbException.getInternalError();
    }

    @Override
    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDerivedColumns(ArrayList<String> derivedColumnNames) {
        Column[] columns = this.getColumns();
        int count = columns.length;
        if (count != derivedColumnNames.size()) {
            throw DbException.get(21002);
        }
        LinkedHashMap<Column, String> map = new LinkedHashMap<Column, String>();
        int i = 0;
        while (i < count) {
            String alias = derivedColumnNames.get(i);
            int j = 0;
            while (j < i) {
                if (alias.equals(derivedColumnNames.get(j))) {
                    throw DbException.get(42121, alias);
                }
                ++j;
            }
            map.put(columns[i], alias);
            ++i;
        }
        this.derivedColumnMap = map;
    }

    public String toString() {
        return this.alias != null ? this.alias : this.table.toString();
    }

    public void addCommonJoinColumns(Column leftColumn, Column replacementColumn, TableFilter replacementFilter) {
        if (this.commonJoinColumns == null) {
            this.commonJoinColumns = new LinkedHashMap();
            this.commonJoinColumnsFilter = replacementFilter;
        } else assert (this.commonJoinColumnsFilter == replacementFilter);
        this.commonJoinColumns.put(leftColumn, replacementColumn);
    }

    public void addCommonJoinColumnToExclude(Column columnToExclude) {
        if (this.commonJoinColumnsToExclude == null) {
            this.commonJoinColumnsToExclude = Utils.newSmallArrayList();
        }
        this.commonJoinColumnsToExclude.add(columnToExclude);
    }

    public LinkedHashMap<Column, Column> getCommonJoinColumns() {
        return this.commonJoinColumns;
    }

    public TableFilter getCommonJoinColumnsFilter() {
        return this.commonJoinColumnsFilter;
    }

    public boolean isCommonJoinColumnToExclude(Column c) {
        return this.commonJoinColumnsToExclude != null && this.commonJoinColumnsToExclude.contains(c);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean hasInComparisons() {
        for (IndexCondition cond : this.indexConditions) {
            int compareType = cond.getCompareType();
            switch (compareType) {
                case 10: 
                case 11: 
                case 12: {
                    return true;
                }
            }
        }
        return false;
    }

    public TableFilter getNestedJoin() {
        return this.nestedJoin;
    }

    public void visit(TableFilterVisitor visitor) {
        TableFilter f = this;
        do {
            visitor.accept(f);
            TableFilter n = f.nestedJoin;
            if (n == null) continue;
            n.visit(visitor);
        } while ((f = f.join) != null);
    }

    public boolean isEvaluatable() {
        return this.evaluatable;
    }

    public SessionLocal getSession() {
        return this.session;
    }

    public IndexHints getIndexHints() {
        return this.indexHints;
    }

    public boolean isNoFromClauseFilter() {
        return this.table instanceof DualTable && this.join == null && this.nestedJoin == null && this.joinCondition == null && this.filterCondition == null;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class MapColumnsVisitor
    implements TableFilterVisitor {
        private final Expression on;

        MapColumnsVisitor(Expression on) {
            this.on = on;
        }

        @Override
        public void accept(TableFilter f) {
            this.on.mapColumns(f, 0, 0);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface TableFilterVisitor {
        public void accept(TableFilter var1);
    }
}

