/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.query.TableValueConstructor;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.VirtualConstructedTable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TableValueConstructorTable
extends VirtualConstructedTable {
    private final ArrayList<ArrayList<Expression>> rows;

    public TableValueConstructorTable(Schema schema, SessionLocal session, Column[] columns, ArrayList<ArrayList<Expression>> rows) {
        super(schema, 0, "VALUES");
        this.setColumns(columns);
        this.rows = rows;
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return true;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.rows.size();
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.rows.size();
    }

    @Override
    public ResultInterface getResult(SessionLocal session) {
        SimpleResult simple = new SimpleResult();
        int columnCount = this.columns.length;
        int i = 0;
        while (i < columnCount) {
            Column column = this.columns[i];
            simple.addColumn(column.getName(), column.getType());
            ++i;
        }
        TableValueConstructor.getVisibleResult(session, simple, this.columns, this.rows);
        return simple;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append('(');
        TableValueConstructor.getValuesSQL(builder, sqlFlags, this.rows);
        return builder.append(')');
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

