/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.command.QueryScope;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Query;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.index.QueryExpressionIndex;
import org.h2.index.RegularQueryExpressionIndex;
import org.h2.message.DbException;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.QueryExpressionTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TableView
extends QueryExpressionTable {
    private String querySQL;
    private Column[] columnTemplates;
    private DbException createException;

    public TableView(Schema schema, int id, String name, String querySQL, Column[] columnTemplates, SessionLocal session) {
        super(schema, id, name);
        this.init(querySQL, columnTemplates, session);
    }

    @Override
    protected QueryExpressionIndex createIndex(SessionLocal session, int[] masks) {
        return new RegularQueryExpressionIndex(this, this.querySQL, null, session, masks);
    }

    public void replace(String querySQL, Column[] newColumnTemplates, SessionLocal session, boolean force) {
        String oldQuerySQL = this.querySQL;
        Column[] oldColumnTemplates = this.columnTemplates;
        this.init(querySQL, newColumnTemplates, session);
        DbException e = this.recompile(session, force, true);
        if (e != null) {
            this.init(oldQuerySQL, oldColumnTemplates, session);
            this.recompile(session, true, false);
            throw e;
        }
    }

    private synchronized void init(String querySQL, Column[] columnTemplates, SessionLocal session) {
        this.querySQL = querySQL;
        this.columnTemplates = columnTemplates;
        this.initColumnsAndTables(session);
    }

    private static Query compileViewQuery(SessionLocal session, String sql) {
        Prepared p;
        session.setParsingCreateView(true);
        try {
            p = session.prepare(sql, false, false, null);
        }
        finally {
            session.setParsingCreateView(false);
        }
        if (!(p instanceof Query)) {
            throw DbException.getSyntaxError(sql, 0);
        }
        return (Query)p;
    }

    public synchronized DbException recompile(SessionLocal session, boolean force, boolean clearIndexCache) {
        block4: {
            try {
                TableView.compileViewQuery(session, this.querySQL);
            }
            catch (DbException e) {
                if (force) break block4;
                return e;
            }
        }
        ArrayList<TableView> dependentViews = new ArrayList<TableView>(this.getDependentViews());
        this.initColumnsAndTables(session);
        for (TableView v : dependentViews) {
            DbException e = v.recompile(session, force, false);
            if (e == null || force) continue;
            return e;
        }
        if (clearIndexCache) {
            TableView.clearIndexCaches(this.database);
        }
        return force ? null : this.createException;
    }

    private void initColumnsAndTables(SessionLocal session) {
        Column[] cols;
        this.removeCurrentViewFromOtherTables();
        try {
            Query compiledQuery = TableView.compileViewQuery(session, this.querySQL);
            this.querySQL = compiledQuery.getPlanSQL(0);
            this.tables = new ArrayList<Table>(compiledQuery.getTables());
            cols = this.initColumns(session, this.columnTemplates, compiledQuery, false);
            this.createException = null;
            this.viewQuery = compiledQuery;
        }
        catch (DbException e) {
            if (e.getErrorCode() == 90156) {
                throw e;
            }
            e.addSQL(this.getCreateSQL());
            this.createException = e;
            this.tables = Utils.newSmallArrayList();
            cols = new Column[]{};
        }
        this.setColumns(cols);
        if (this.getId() != 0) {
            this.addDependentViewToTables();
        }
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public Query getTopQuery() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return this.getSQL(new StringBuilder("DROP VIEW IF EXISTS "), 0).append(" CASCADE").toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQL(false, true, quotedName);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean orReplace, boolean force) {
        return this.getCreateSQL(orReplace, force, this.getSQL(0));
    }

    private String getCreateSQL(boolean orReplace, boolean force, String quotedName) {
        StringBuilder builder = new StringBuilder("CREATE ");
        if (orReplace) {
            builder.append("OR REPLACE ");
        }
        if (force) {
            builder.append("FORCE ");
        }
        builder.append("VIEW ");
        builder.append(quotedName);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        if (this.columns != null && this.columns.length > 0) {
            builder.append('(');
            Column.writeColumns(builder, this.columns, 0);
            builder.append(')');
        } else if (this.columnTemplates != null) {
            builder.append('(');
            Column.writeColumns(builder, this.columnTemplates, 0);
            builder.append(')');
        }
        return builder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.VIEW;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.removeCurrentViewFromOtherTables();
        super.removeChildrenAndResources(session);
        this.querySQL = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        SessionLocal[] sessionLocalArray = database.getSessions(true);
        int n = sessionLocalArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionLocal s = sessionLocalArray[n2];
            s.clearViewIndexCache();
            ++n2;
        }
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    @Override
    public QueryScope getQueryScope() {
        return null;
    }

    @Override
    public Index getScanIndex(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        if (this.createException != null) {
            String msg = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getTraceSQL(), msg);
        }
        return super.getScanIndex(session, masks, filters, filter, sortOrder, allColumnsSet);
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null || this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        return super.getMaxDataModificationId();
    }

    private void removeCurrentViewFromOtherTables() {
        if (this.tables != null) {
            for (Table t : this.tables) {
                t.removeDependentView(this);
            }
            this.tables.clear();
        }
    }

    private void addDependentViewToTables() {
        for (Table t : this.tables) {
            t.addDependentView(this);
        }
    }

    @Override
    public boolean isDeterministic() {
        if (this.viewQuery == null) {
            return false;
        }
        return super.isDeterministic();
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

