/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test;

import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.rec.FilePathRec;
import org.h2.test.TestBase;
import org.h2.test.auth.TestAuthentication;
import org.h2.test.bench.TestPerformance;
import org.h2.test.db.TestAlter;
import org.h2.test.db.TestAlterSchemaRename;
import org.h2.test.db.TestAlterTableNotFound;
import org.h2.test.db.TestAnalyzeTableTx;
import org.h2.test.db.TestAutoRecompile;
import org.h2.test.db.TestBackup;
import org.h2.test.db.TestBigDb;
import org.h2.test.db.TestBigResult;
import org.h2.test.db.TestCases;
import org.h2.test.db.TestCheckpoint;
import org.h2.test.db.TestCluster;
import org.h2.test.db.TestCompatibility;
import org.h2.test.db.TestCompatibilityOracle;
import org.h2.test.db.TestCompatibilitySQLServer;
import org.h2.test.db.TestCompoundIndexParamSearch;
import org.h2.test.db.TestCompoundIndexSearch;
import org.h2.test.db.TestCsv;
import org.h2.test.db.TestDateStorage;
import org.h2.test.db.TestDeadlock;
import org.h2.test.db.TestDuplicateKeyUpdate;
import org.h2.test.db.TestEncryptedDb;
import org.h2.test.db.TestExclusive;
import org.h2.test.db.TestFullText;
import org.h2.test.db.TestFunctionOverload;
import org.h2.test.db.TestFunctions;
import org.h2.test.db.TestGeneralCommonTableQueries;
import org.h2.test.db.TestIgnoreCatalogs;
import org.h2.test.db.TestIndex;
import org.h2.test.db.TestIndexHints;
import org.h2.test.db.TestLargeBlob;
import org.h2.test.db.TestLinkedTable;
import org.h2.test.db.TestListener;
import org.h2.test.db.TestLob;
import org.h2.test.db.TestMaterializedView;
import org.h2.test.db.TestMemoryUsage;
import org.h2.test.db.TestMergeUsing;
import org.h2.test.db.TestMultiConn;
import org.h2.test.db.TestMultiDimension;
import org.h2.test.db.TestMultiThread;
import org.h2.test.db.TestMultiThreadedKernel;
import org.h2.test.db.TestOpenClose;
import org.h2.test.db.TestOptimizations;
import org.h2.test.db.TestOutOfMemory;
import org.h2.test.db.TestPersistentCommonTableExpressions;
import org.h2.test.db.TestPowerOff;
import org.h2.test.db.TestQueryCache;
import org.h2.test.db.TestReadOnly;
import org.h2.test.db.TestRecursiveQueries;
import org.h2.test.db.TestRights;
import org.h2.test.db.TestRunscript;
import org.h2.test.db.TestSQLInjection;
import org.h2.test.db.TestSelectTableNotFound;
import org.h2.test.db.TestSequence;
import org.h2.test.db.TestSessionsLocks;
import org.h2.test.db.TestSetCollation;
import org.h2.test.db.TestSpaceReuse;
import org.h2.test.db.TestSpatial;
import org.h2.test.db.TestSpeed;
import org.h2.test.db.TestSubqueryPerformanceOnLazyExecutionMode;
import org.h2.test.db.TestSynonymForTable;
import org.h2.test.db.TestTableEngines;
import org.h2.test.db.TestTempTables;
import org.h2.test.db.TestTransaction;
import org.h2.test.db.TestTriggersConstraints;
import org.h2.test.db.TestTwoPhaseCommit;
import org.h2.test.db.TestView;
import org.h2.test.db.TestViewAlterTable;
import org.h2.test.db.TestViewDropView;
import org.h2.test.jdbc.TestBatchUpdates;
import org.h2.test.jdbc.TestCallableStatement;
import org.h2.test.jdbc.TestCancel;
import org.h2.test.jdbc.TestConcurrentConnectionUsage;
import org.h2.test.jdbc.TestConnection;
import org.h2.test.jdbc.TestDatabaseEventListener;
import org.h2.test.jdbc.TestDriver;
import org.h2.test.jdbc.TestGetGeneratedKeys;
import org.h2.test.jdbc.TestJavaObjectSerializer;
import org.h2.test.jdbc.TestLobApi;
import org.h2.test.jdbc.TestManyJdbcObjects;
import org.h2.test.jdbc.TestMetaData;
import org.h2.test.jdbc.TestNativeSQL;
import org.h2.test.jdbc.TestPreparedStatement;
import org.h2.test.jdbc.TestResultSet;
import org.h2.test.jdbc.TestSQLXML;
import org.h2.test.jdbc.TestStatement;
import org.h2.test.jdbc.TestTransactionIsolation;
import org.h2.test.jdbc.TestUpdatableResultSet;
import org.h2.test.jdbc.TestUrlJavaObjectSerializer;
import org.h2.test.jdbc.TestZloty;
import org.h2.test.jdbcx.TestConnectionPool;
import org.h2.test.jdbcx.TestDataSource;
import org.h2.test.jdbcx.TestXA;
import org.h2.test.jdbcx.TestXASimple;
import org.h2.test.mvcc.TestMvcc1;
import org.h2.test.mvcc.TestMvcc2;
import org.h2.test.mvcc.TestMvcc3;
import org.h2.test.mvcc.TestMvcc4;
import org.h2.test.mvcc.TestMvccMultiThreaded;
import org.h2.test.mvcc.TestMvccMultiThreaded2;
import org.h2.test.poweroff.TestReorderWrites;
import org.h2.test.recover.RecoverLobTest;
import org.h2.test.rowlock.TestRowLocks;
import org.h2.test.scripts.TestScript;
import org.h2.test.server.TestAutoServer;
import org.h2.test.server.TestInit;
import org.h2.test.server.TestJakartaWeb;
import org.h2.test.server.TestNestedLoop;
import org.h2.test.server.TestWeb;
import org.h2.test.store.TestCacheConcurrentLIRS;
import org.h2.test.store.TestCacheLIRS;
import org.h2.test.store.TestCacheLongKeyLIRS;
import org.h2.test.store.TestDataUtils;
import org.h2.test.store.TestDefrag;
import org.h2.test.store.TestFreeSpace;
import org.h2.test.store.TestKillProcessWhileWriting;
import org.h2.test.store.TestMVRTree;
import org.h2.test.store.TestMVStore;
import org.h2.test.store.TestMVStoreBenchmark;
import org.h2.test.store.TestMVStoreConcurrent;
import org.h2.test.store.TestMVStoreStopCompact;
import org.h2.test.store.TestMVStoreTool;
import org.h2.test.store.TestMVTableEngine;
import org.h2.test.store.TestObjectDataType;
import org.h2.test.store.TestRandomMapOps;
import org.h2.test.store.TestSpinLock;
import org.h2.test.store.TestStreamStore;
import org.h2.test.store.TestTransactionStore;
import org.h2.test.synth.TestBtreeIndex;
import org.h2.test.synth.TestConcurrentUpdate;
import org.h2.test.synth.TestCrashAPI;
import org.h2.test.synth.TestDiskFull;
import org.h2.test.synth.TestFuzzOptimizations;
import org.h2.test.synth.TestHaltApp;
import org.h2.test.synth.TestJoin;
import org.h2.test.synth.TestKill;
import org.h2.test.synth.TestKillRestart;
import org.h2.test.synth.TestKillRestartMulti;
import org.h2.test.synth.TestLimit;
import org.h2.test.synth.TestMultiThreaded;
import org.h2.test.synth.TestNestedJoins;
import org.h2.test.synth.TestOuterJoins;
import org.h2.test.synth.TestRandomCompare;
import org.h2.test.synth.TestRandomSQL;
import org.h2.test.synth.TestTimer;
import org.h2.test.synth.sql.TestSynth;
import org.h2.test.synth.thread.TestMulti;
import org.h2.test.unit.TestAnsCompression;
import org.h2.test.unit.TestAutoReconnect;
import org.h2.test.unit.TestBinaryArithmeticStream;
import org.h2.test.unit.TestBinaryOperation;
import org.h2.test.unit.TestBitStream;
import org.h2.test.unit.TestBnf;
import org.h2.test.unit.TestCache;
import org.h2.test.unit.TestCharsetCollator;
import org.h2.test.unit.TestCollation;
import org.h2.test.unit.TestCompress;
import org.h2.test.unit.TestConcurrentJdbc;
import org.h2.test.unit.TestConnectionInfo;
import org.h2.test.unit.TestDate;
import org.h2.test.unit.TestDateIso8601;
import org.h2.test.unit.TestDateTimeTemplate;
import org.h2.test.unit.TestDateTimeUtils;
import org.h2.test.unit.TestDbException;
import org.h2.test.unit.TestExit;
import org.h2.test.unit.TestFile;
import org.h2.test.unit.TestFileLock;
import org.h2.test.unit.TestFileLockProcess;
import org.h2.test.unit.TestFileSystem;
import org.h2.test.unit.TestFtp;
import org.h2.test.unit.TestGeometryUtils;
import org.h2.test.unit.TestIntArray;
import org.h2.test.unit.TestIntPerfectHash;
import org.h2.test.unit.TestInterval;
import org.h2.test.unit.TestJmx;
import org.h2.test.unit.TestJsonUtils;
import org.h2.test.unit.TestKeywords;
import org.h2.test.unit.TestLocale;
import org.h2.test.unit.TestMVTempResult;
import org.h2.test.unit.TestMathUtils;
import org.h2.test.unit.TestMemoryUnmapper;
import org.h2.test.unit.TestMode;
import org.h2.test.unit.TestNetUtils;
import org.h2.test.unit.TestObjectDeserialization;
import org.h2.test.unit.TestOverflow;
import org.h2.test.unit.TestPageStoreCoverage;
import org.h2.test.unit.TestPattern;
import org.h2.test.unit.TestPerfectHash;
import org.h2.test.unit.TestPgServer;
import org.h2.test.unit.TestRecovery;
import org.h2.test.unit.TestReopen;
import org.h2.test.unit.TestSampleApps;
import org.h2.test.unit.TestScriptReader;
import org.h2.test.unit.TestSecurity;
import org.h2.test.unit.TestShell;
import org.h2.test.unit.TestSort;
import org.h2.test.unit.TestStreams;
import org.h2.test.unit.TestStringCache;
import org.h2.test.unit.TestStringUtils;
import org.h2.test.unit.TestTimeStampWithTimeZone;
import org.h2.test.unit.TestTools;
import org.h2.test.unit.TestTraceSystem;
import org.h2.test.unit.TestUpgrade;
import org.h2.test.unit.TestUtils;
import org.h2.test.unit.TestValue;
import org.h2.test.unit.TestValueMemory;
import org.h2.test.utils.OutputCatcher;
import org.h2.test.utils.SelfDestructor;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.AbbaLockingDetector;
import org.h2.util.Profiler;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.util.ThreadDeadlockDetector;
import org.h2.util.Utils;

public class TestAll {
    static boolean atLeastOneTestFailed;
    public boolean big;
    public boolean networked;
    public boolean memory;
    public boolean codeCoverage;
    public boolean lazy;
    public String cipher;
    public int traceLevelFile;
    public boolean traceTest;
    public boolean googleAppEngine;
    public boolean diskResult;
    public boolean reopen;
    public boolean splitFileSystem;
    public boolean ci;
    public boolean vmlens;
    public int lockTimeout = 50;
    boolean smallLog;
    boolean ssl;
    boolean diskUndo;
    boolean traceSystemOut;
    boolean endless;
    public int throttle;
    int throttleDefault = Integer.parseInt(System.getProperty("throttle", "0"));
    boolean stopOnError;
    String cacheType;
    public String collation;
    AbbaLockingDetector abbaLockingDetector;
    ArrayList<TestBase> tests = new ArrayList();
    private Server server;
    HashSet<String> excludedTests = new HashSet();
    HashMap<Class<? extends TestBase>, Boolean> executedTests = new HashMap();

    public static void main(String ... args) throws Exception {
        OutputCatcher catcher = OutputCatcher.start();
        TestAll.run(args);
        catcher.stop();
        catcher.writeTo("Test Output", "docs/html/testOutput.html");
        if (atLeastOneTestFailed) {
            System.exit(1);
        }
    }

    private static void run(String ... args) throws Exception {
        SelfDestructor.startCountdown(240);
        long time = System.nanoTime();
        TestAll.printSystemInfo();
        System.setProperty("h2.maxMemoryRows", "100");
        System.setProperty("h2.delayWrongPasswordMin", "0");
        System.setProperty("h2.delayWrongPasswordMax", "0");
        System.setProperty("h2.useThreadContextClassLoader", "true");
        TestAll test = new TestAll();
        if (args.length > 0) {
            if ("ci".equals(args[0])) {
                test.ci = true;
                test.testAll(args, 1);
            } else if ("vmlens".equals(args[0])) {
                test.vmlens = true;
                test.testAll(args, 1);
            } else if ("reopen".equals(args[0])) {
                System.setProperty("h2.delayWrongPasswordMin", "0");
                System.setProperty("h2.analyzeAuto", "100");
                System.setProperty("h2.pageSize", "64");
                System.setProperty("h2.reopenShift", "5");
                FilePathRec.register();
                test.reopen = true;
                TestReopen reopen = new TestReopen();
                reopen.init();
                FilePathRec.setRecorder(reopen);
                test.runTests();
            } else if ("crash".equals(args[0])) {
                test.endless = true;
                new TestCrashAPI().runTest(test);
            } else if ("synth".equals(args[0])) {
                new TestSynth().runTest(test);
            } else if ("kill".equals(args[0])) {
                new TestKill().runTest(test);
            } else if ("random".equals(args[0])) {
                test.endless = true;
                new TestRandomSQL().runTest(test);
            } else if ("join".equals(args[0])) {
                new TestJoin().runTest(test);
                test.endless = true;
            } else if ("btree".equals(args[0])) {
                new TestBtreeIndex().runTest(test);
            } else if ("all".equals(args[0])) {
                test.testEverything();
            } else if ("codeCoverage".equals(args[0])) {
                test.codeCoverage = true;
                test.runCoverage();
            } else if ("multiThread".equals(args[0])) {
                new TestMulti().runTest(test);
            } else if ("halt".equals(args[0])) {
                new TestHaltApp().runTest(test);
            } else if ("timer".equals(args[0])) {
                new TestTimer().runTest(test);
            }
        } else {
            test.testAll(args, 0);
        }
        System.out.println(TestBase.formatTime(new StringBuilder(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time)).append(" total").toString());
    }

    private void testAll(String[] args, int offset) throws Exception {
        int l = args.length;
        while (l > offset + 1) {
            if (!"-exclude".equals(args[offset])) break;
            this.excludedTests.add(args[offset + 1]);
            offset += 2;
        }
        this.runTests();
        if (!this.ci && !this.vmlens) {
            Profiler prof = new Profiler();
            prof.depth = 16;
            prof.interval = 1;
            prof.startCollecting();
            TestPerformance.main("-init", "-db", "1", "-size", "1000");
            prof.stopCollecting();
            System.out.println(prof.getTop(5));
            TestPerformance.main("-init", "-db", "1", "-size", "1000");
        }
    }

    private void testEverything() throws SQLException {
        int c = 0;
        while (c < 2) {
            this.cipher = c == 0 ? null : "AES";
            int a = 0;
            while (a < 64) {
                this.smallLog = (a & 1) != 0;
                this.big = (a & 2) != 0;
                this.networked = (a & 4) != 0;
                this.memory = (a & 8) != 0;
                this.ssl = (a & 0x10) != 0;
                this.diskResult = (a & 0x20) != 0;
                int trace = 0;
                while (trace < 3) {
                    this.traceLevelFile = trace++;
                    this.test();
                }
                ++a;
            }
            ++c;
        }
    }

    private void runTests() throws SQLException {
        if (Boolean.getBoolean("abba")) {
            this.abbaLockingDetector = new AbbaLockingDetector().startCollecting();
        }
        this.ssl = false;
        this.lazy = false;
        this.memory = false;
        this.networked = false;
        this.big = false;
        this.smallLog = false;
        this.diskUndo = false;
        this.traceSystemOut = false;
        this.diskResult = false;
        this.stopOnError = false;
        this.traceTest = false;
        this.throttle = 0;
        this.traceLevelFile = 0;
        this.cipher = null;
        this.memory = true;
        this.test();
        if (this.vmlens) {
            return;
        }
        this.testAdditional();
        this.big = !this.ci;
        this.testUtils();
        this.big = false;
        this.lazy = true;
        this.memory = true;
        this.test();
        this.lazy = false;
        this.memory = false;
        this.test();
        this.testAdditional();
        this.networked = true;
        this.memory = true;
        this.test();
        this.memory = false;
        this.lazy = true;
        this.test();
        this.lazy = false;
        this.networked = false;
        this.diskUndo = true;
        this.diskResult = true;
        this.traceLevelFile = 3;
        this.throttle = 1;
        this.cacheType = "SOFT_LRU";
        this.cipher = "AES";
        this.test();
        this.diskUndo = false;
        this.diskResult = false;
        this.traceLevelFile = 1;
        this.throttle = 0;
        this.cacheType = null;
        this.cipher = null;
        if (!this.ci) {
            this.traceLevelFile = 0;
            this.smallLog = true;
            this.networked = true;
            this.ssl = true;
            this.test();
            this.big = true;
            this.smallLog = false;
            this.networked = false;
            this.ssl = false;
            this.traceLevelFile = 0;
            this.test();
            this.testAdditional();
            this.big = false;
            this.cipher = "AES";
            this.test();
            this.cipher = null;
            this.test();
        }
        for (Map.Entry<Class<? extends TestBase>, Boolean> entry : this.executedTests.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            System.out.println("Warning: test " + entry.getKey().getName() + " was not executed.");
        }
    }

    private void runCoverage() throws SQLException {
        this.ssl = false;
        this.memory = false;
        this.networked = false;
        this.big = false;
        this.smallLog = false;
        this.diskUndo = false;
        this.traceSystemOut = false;
        this.diskResult = false;
        this.stopOnError = false;
        this.traceTest = false;
        this.throttle = 0;
        this.traceLevelFile = 0;
        this.cipher = null;
        this.memory = true;
        this.test();
        this.testAdditional();
        this.testUtils();
        this.test();
    }

    private void test() throws SQLException {
        System.out.println();
        System.out.println("Test " + this.toString() + " (" + Utils.getMemoryUsed() + " KB used)");
        this.beforeTest();
        try {
            this.addTest(new TestScript());
            this.addTest(new TestAlter());
            this.addTest(new TestAlterSchemaRename());
            this.addTest(new TestAutoRecompile());
            this.addTest(new TestBackup());
            this.addTest(new TestBigDb());
            this.addTest(new TestBigResult());
            this.addTest(new TestCases());
            this.addTest(new TestCheckpoint());
            this.addTest(new TestCompatibility());
            this.addTest(new TestCompatibilityOracle());
            this.addTest(new TestCompatibilitySQLServer());
            this.addTest(new TestCsv());
            this.addTest(new TestDeadlock());
            if (this.vmlens) {
                return;
            }
            this.addTest(new TestDuplicateKeyUpdate());
            this.addTest(new TestEncryptedDb());
            this.addTest(new TestExclusive());
            this.addTest(new TestFullText());
            this.addTest(new TestFunctionOverload());
            this.addTest(new TestFunctions());
            this.addTest(new TestInit());
            this.addTest(new TestIndex());
            this.addTest(new TestIndexHints());
            this.addTest(new TestCompoundIndexSearch());
            this.addTest(new TestCompoundIndexParamSearch());
            this.addTest(new TestLargeBlob());
            this.addTest(new TestLinkedTable());
            this.addTest(new TestListener());
            this.addTest(new TestLob());
            this.addTest(new TestMaterializedView());
            this.addTest(new TestMergeUsing());
            this.addTest(new TestMultiConn());
            this.addTest(new TestMultiDimension());
            this.addTest(new TestMultiThreadedKernel());
            this.addTest(new TestOpenClose());
            this.addTest(new TestReadOnly());
            this.addTest(new TestRecursiveQueries());
            this.addTest(new TestGeneralCommonTableQueries());
            this.addTest(new TestAlterTableNotFound());
            this.addTest(new TestSelectTableNotFound());
            if (!this.memory) {
                this.addTest(new TestPersistentCommonTableExpressions());
            }
            this.addTest(new TestRights());
            this.addTest(new TestRunscript());
            this.addTest(new TestSQLInjection());
            this.addTest(new TestSessionsLocks());
            this.addTest(new TestSequence());
            this.addTest(new TestSpaceReuse());
            this.addTest(new TestSpatial());
            this.addTest(new TestSpeed());
            this.addTest(new TestTableEngines());
            this.addTest(new TestTempTables());
            this.addTest(new TestTransaction());
            this.addTest(new TestTriggersConstraints());
            this.addTest(new TestTwoPhaseCommit());
            this.addTest(new TestView());
            this.addTest(new TestViewAlterTable());
            this.addTest(new TestViewDropView());
            this.addTest(new TestSynonymForTable());
            this.addTest(new TestBatchUpdates());
            this.addTest(new TestCallableStatement());
            this.addTest(new TestCancel());
            this.addTest(new TestConcurrentConnectionUsage());
            this.addTest(new TestConnection());
            this.addTest(new TestDatabaseEventListener());
            this.addTest(new TestLobApi());
            this.addTest(new TestSQLXML());
            this.addTest(new TestManyJdbcObjects());
            this.addTest(new TestMetaData());
            this.addTest(new TestNativeSQL());
            this.addTest(new TestPreparedStatement());
            this.addTest(new TestResultSet());
            this.addTest(new TestStatement());
            this.addTest(new TestGetGeneratedKeys());
            this.addTest(new TestTransactionIsolation());
            this.addTest(new TestUpdatableResultSet());
            this.addTest(new TestZloty());
            this.addTest(new TestSetCollation());
            this.addTest(new TestConnectionPool());
            this.addTest(new TestDataSource());
            this.addTest(new TestXA());
            this.addTest(new TestXASimple());
            this.addTest(new TestAutoServer());
            this.addTest(new TestNestedLoop());
            this.addTest(new TestMvcc1());
            this.addTest(new TestMvcc2());
            this.addTest(new TestMvcc3());
            this.addTest(new TestMvcc4());
            this.addTest(new TestMvccMultiThreaded());
            this.addTest(new TestMvccMultiThreaded2());
            this.addTest(new TestRowLocks());
            this.addTest(new TestAnalyzeTableTx());
            this.addTest(new TestBtreeIndex());
            this.addTest(new TestConcurrentUpdate());
            this.addTest(new TestDiskFull());
            this.addTest(new TestCrashAPI());
            this.addTest(new TestFuzzOptimizations());
            this.addTest(new TestLimit());
            this.addTest(new TestRandomCompare());
            this.addTest(new TestKillRestart());
            this.addTest(new TestKillRestartMulti());
            this.addTest(new TestMultiThreaded());
            this.addTest(new TestOuterJoins());
            this.addTest(new TestNestedJoins());
            this.runAddedTests();
            this.addTest(new TestDateStorage());
            this.addTest(new TestDriver());
            this.addTest(new TestJavaObjectSerializer());
            this.addTest(new TestLocale());
            this.addTest(new TestMemoryUsage());
            this.addTest(new TestMultiThread());
            this.addTest(new TestPowerOff());
            this.addTest(new TestReorderWrites());
            this.addTest(new TestRandomSQL());
            this.addTest(new TestQueryCache());
            this.addTest(new TestUrlJavaObjectSerializer());
            this.addTest(new TestWeb());
            this.addTest(new TestJakartaWeb());
            this.addTest(new TestOptimizations());
            this.addTest(new TestOutOfMemory());
            this.addTest(new TestIgnoreCatalogs());
            this.runAddedTests(1);
        }
        finally {
            this.afterTest();
        }
    }

    private void testAdditional() {
        if (this.networked) {
            throw new RuntimeException("testAdditional() is not allowed in networked mode");
        }
        this.addTest(new TestMVTableEngine());
        this.addTest(new TestAutoReconnect());
        this.addTest(new TestBnf());
        this.addTest(new TestCache());
        this.addTest(new TestCollation());
        this.addTest(new TestCompress());
        this.addTest(new TestConnectionInfo());
        this.addTest(new TestExit());
        this.addTest(new TestFileLock());
        this.addTest(new TestJmx());
        this.addTest(new TestMultiThreadedKernel());
        this.addTest(new TestPageStoreCoverage());
        this.addTest(new TestPgServer());
        this.addTest(new TestRecovery());
        this.addTest(new RecoverLobTest());
        this.addTest(TestAll.createTest("org.h2.test.unit.TestServlet"));
        this.addTest(TestAll.createTest("org.h2.test.unit.TestJakartaServlet"));
        this.addTest(new TestTimeStampWithTimeZone());
        this.addTest(new TestValue());
        this.runAddedTests();
        this.addTest(new TestCluster());
        this.addTest(new TestFileLockProcess());
        this.addTest(new TestDefrag());
        this.addTest(new TestTools());
        this.addTest(new TestSampleApps());
        this.addTest(new TestSubqueryPerformanceOnLazyExecutionMode());
        this.runAddedTests(1);
    }

    private void testUtils() {
        System.out.println();
        System.out.println("Test utilities (" + Utils.getMemoryUsed() + " KB used)");
        this.addTest(new TestCacheConcurrentLIRS());
        this.addTest(new TestCacheLIRS());
        this.addTest(new TestCacheLongKeyLIRS());
        this.addTest(new TestDataUtils());
        this.addTest(new TestFreeSpace());
        this.addTest(new TestKillProcessWhileWriting());
        this.addTest(new TestMVRTree());
        this.addTest(new TestMVStore());
        this.addTest(new TestMVStoreBenchmark());
        this.addTest(new TestMVStoreStopCompact());
        this.addTest(new TestMVStoreTool());
        this.addTest(new TestObjectDataType());
        this.addTest(new TestRandomMapOps());
        this.addTest(new TestSpinLock());
        this.addTest(new TestStreamStore());
        this.addTest(new TestTransactionStore());
        this.addTest(new TestMVTempResult());
        this.addTest(new TestConcurrentJdbc());
        this.addTest(new TestAnsCompression());
        this.addTest(new TestBinaryArithmeticStream());
        this.addTest(new TestBinaryOperation());
        this.addTest(new TestBitStream());
        this.addTest(new TestCharsetCollator());
        this.addTest(new TestDateIso8601());
        this.addTest(new TestDateTimeTemplate());
        this.addTest(new TestDbException());
        this.addTest(new TestFile());
        this.addTest(new TestFileSystem());
        this.addTest(new TestFtp());
        this.addTest(new TestGeometryUtils());
        this.addTest(new TestInterval());
        this.addTest(new TestIntArray());
        this.addTest(new TestIntPerfectHash());
        this.addTest(new TestJsonUtils());
        this.addTest(new TestKeywords());
        this.addTest(new TestMathUtils());
        this.addTest(new TestMemoryUnmapper());
        this.addTest(new TestMode());
        this.addTest(new TestObjectDeserialization());
        this.addTest(new TestOverflow());
        this.addTest(new TestPerfectHash());
        this.addTest(new TestScriptReader());
        this.addTest(new TestSecurity());
        this.addTest(new TestShell());
        this.addTest(new TestSort());
        this.addTest(new TestStreams());
        this.addTest(new TestStringUtils());
        this.addTest(new TestTraceSystem());
        this.addTest(new TestUtils());
        this.addTest(new TestUpgrade());
        this.runAddedTests();
        this.addTest(new TestDate());
        this.addTest(new TestDateTimeUtils());
        this.addTest(new TestMVStoreConcurrent());
        this.addTest(new TestNetUtils());
        this.addTest(new TestPattern());
        this.addTest(new TestStringCache());
        this.addTest(new TestValueMemory());
        this.addTest(new TestAuthentication());
        this.runAddedTests(1);
    }

    private void addTest(TestBase test) {
        if (this.excludedTests.contains(test.getClass().getName())) {
            return;
        }
        Timer watchdog = new Timer();
        watchdog.schedule(new TimerTask(){

            @Override
            public void run() {
                ThreadDeadlockDetector.dumpAllThreadsAndLocks("test watchdog timed out");
            }
        }, 300000L);
        try {
            test.runTest(this);
        }
        finally {
            watchdog.cancel();
        }
    }

    private void runAddedTests() {
        int threadCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        this.runAddedTests(threadCount);
    }

    private void runAddedTests(int threadCount) {
        Task[] tasks = new Task[threadCount];
        int i = 0;
        while (i < threadCount) {
            Task t = new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call() throws Exception {
                    while (true) {
                        TestBase test;
                        ArrayList<TestBase> arrayList = TestAll.this.tests;
                        synchronized (arrayList) {
                            if (TestAll.this.tests.isEmpty()) {
                                break;
                            }
                            test = TestAll.this.tests.remove(0);
                        }
                        if (TestAll.this.excludedTests.contains(test.getClass().getName())) continue;
                        test.runTest(TestAll.this);
                    }
                }
            };
            t.execute();
            tasks[i] = t;
            ++i;
        }
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task t = taskArray[n2];
            t.get();
            ++n2;
        }
    }

    private static TestBase createTest(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (TestBase)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception | NoClassDefFoundError e) {
            TestBase.printlnWithTime(0L, className + " class not found");
            return new TestBase(){

                @Override
                public void test() throws Exception {
                }
            };
        }
    }

    public void beforeTest() throws SQLException {
        Driver.load();
        FileUtils.deleteRecursive("./data", true);
        DeleteDbFiles.execute("./data", null, true);
        FileUtils.deleteRecursive("trace.db", false);
        if (this.networked) {
            String[] stringArray;
            if (this.ssl) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "-ifNotExists";
                stringArray = stringArray2;
                stringArray2[1] = "-tcpSSL";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "-ifNotExists";
            }
            String[] args = stringArray;
            this.server = Server.createTcpServer(args);
            try {
                this.server.start();
            }
            catch (SQLException e) {
                System.out.println("FAIL: can not start server (may already be running)");
                this.server = null;
            }
        }
    }

    public void afterTest() {
        if (this.networked && this.server != null) {
            this.server.stop();
        }
        FileUtils.deleteRecursive("trace.db", true);
        FileUtils.deleteRecursive("./data", true);
    }

    public int getPort() {
        return this.server == null ? 9192 : this.server.getPort();
    }

    public static void printSystemInfo() {
        Properties prop = System.getProperties();
        System.out.println("H2 " + Constants.FULL_VERSION + " @ " + new Timestamp(System.currentTimeMillis()).toString());
        System.out.println("Java " + prop.getProperty("java.runtime.version") + ", " + prop.getProperty("java.vm.name") + ", " + prop.getProperty("java.vendor") + ", " + prop.getProperty("sun.arch.data.model"));
        System.out.println(prop.getProperty("os.name") + ", " + prop.getProperty("os.arch") + ", " + prop.getProperty("os.version") + ", " + prop.getProperty("sun.os.patch.level") + ", " + prop.getProperty("file.separator") + " " + prop.getProperty("path.separator") + " " + StringUtils.javaEncode(prop.getProperty("line.separator")) + " " + prop.getProperty("user.country") + " " + prop.getProperty("user.language") + " " + prop.getProperty("user.timezone") + " " + prop.getProperty("user.variant") + " " + prop.getProperty("file.encoding"));
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        TestAll.appendIf(buff, this.lazy, "lazy");
        TestAll.appendIf(buff, this.big, "big");
        TestAll.appendIf(buff, this.networked, "net");
        TestAll.appendIf(buff, this.memory, "memory");
        TestAll.appendIf(buff, this.codeCoverage, "codeCoverage");
        TestAll.appendIf(buff, this.cipher != null, this.cipher);
        TestAll.appendIf(buff, this.cacheType != null, this.cacheType);
        TestAll.appendIf(buff, this.smallLog, "smallLog");
        TestAll.appendIf(buff, this.ssl, "ssl");
        TestAll.appendIf(buff, this.diskUndo, "diskUndo");
        TestAll.appendIf(buff, this.diskResult, "diskResult");
        TestAll.appendIf(buff, this.traceSystemOut, "traceSystemOut");
        TestAll.appendIf(buff, this.endless, "endless");
        TestAll.appendIf(buff, this.traceLevelFile > 0, "traceLevelFile");
        TestAll.appendIf(buff, this.throttle > 0, "throttle:" + this.throttle);
        TestAll.appendIf(buff, this.traceTest, "traceTest");
        TestAll.appendIf(buff, this.stopOnError, "stopOnError");
        TestAll.appendIf(buff, this.splitFileSystem, "split");
        TestAll.appendIf(buff, this.collation != null, this.collation);
        return buff.toString();
    }

    private static void appendIf(StringBuilder buff, boolean flag, String text) {
        if (flag) {
            buff.append(text);
            buff.append(' ');
        }
    }
}

