/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.h2.Driver;
import org.h2.test.TestBase;
import org.h2.test.utils.SelfDestructor;
import org.h2.tools.DeleteDbFiles;

public abstract class TestDb
extends TestBase {
    public Connection getConnection(String name) throws SQLException {
        return TestDb.getConnectionInternal(this.getURL(name, true), this.getUser(), this.getPassword());
    }

    public Connection getConnection(String name, String user, String password) throws SQLException {
        return TestDb.getConnectionInternal(this.getURL(name, false), user, password);
    }

    protected String getURL(String name, boolean admin) {
        if (((String)name).startsWith("jdbc:")) {
            name = TestDb.addOption((String)name, "MV_STORE", "true");
            return name;
        }
        int idx = ((String)name).indexOf(58);
        if (idx == -1 && this.config.memory) {
            name = "mem:" + (String)name;
        } else if (idx < 0 || idx > 10) {
            name = this.getBaseDir() + "/" + (String)name;
        }
        Object url = this.config.networked ? (this.config.ssl ? "ssl://localhost:" + this.config.getPort() + "/" + (String)name : "tcp://localhost:" + this.config.getPort() + "/" + (String)name) : (this.config.googleAppEngine ? "gae://" + (String)name + ";FILE_LOCK=NO;AUTO_SERVER=FALSE;DB_CLOSE_ON_EXIT=FALSE" : name);
        url = TestDb.addOption((String)url, "MV_STORE", "true");
        url = TestDb.addOption((String)url, "MAX_COMPACT_TIME", "0");
        if (!this.config.memory && this.config.smallLog && admin) {
            url = TestDb.addOption((String)url, "MAX_LOG_SIZE", "1");
        }
        if (this.config.traceSystemOut) {
            url = TestDb.addOption((String)url, "TRACE_LEVEL_SYSTEM_OUT", "2");
        }
        if (this.config.traceLevelFile > 0 && admin) {
            url = TestDb.addOption((String)url, "TRACE_LEVEL_FILE", "" + this.config.traceLevelFile);
            url = TestDb.addOption((String)url, "TRACE_MAX_FILE_SIZE", "8");
        }
        if (this.config.throttleDefault > 0) {
            url = TestDb.addOption((String)url, "THROTTLE", "" + this.config.throttleDefault);
        } else if (this.config.throttle > 0) {
            url = TestDb.addOption((String)url, "THROTTLE", "" + this.config.throttle);
        }
        url = TestDb.addOption((String)url, "LOCK_TIMEOUT", "" + this.config.lockTimeout);
        if (this.config.diskUndo && admin) {
            url = TestDb.addOption((String)url, "MAX_MEMORY_UNDO", "3");
        }
        if (this.config.big && admin) {
            url = TestDb.addOption((String)url, "MAX_OPERATION_MEMORY", "1");
        }
        if (this.config.lazy) {
            url = TestDb.addOption((String)url, "LAZY_QUERY_EXECUTION", "1");
        }
        if (this.config.cacheType != null && admin) {
            url = TestDb.addOption((String)url, "CACHE_TYPE", this.config.cacheType);
        }
        if (this.config.diskResult && admin) {
            url = TestDb.addOption((String)url, "MAX_MEMORY_ROWS", "100");
            url = TestDb.addOption((String)url, "CACHE_SIZE", "0");
        }
        if (this.config.cipher != null) {
            url = TestDb.addOption((String)url, "CIPHER", this.config.cipher);
        }
        if (this.config.collation != null) {
            url = TestDb.addOption((String)url, "COLLATION", this.config.collation);
        }
        return "jdbc:h2:" + (String)url;
    }

    private static String addOption(String url, String option, String value) {
        if (((String)url).indexOf(";" + option + "=") < 0) {
            url = (String)url + ";" + option + "=" + value;
        }
        return url;
    }

    private static Connection getConnectionInternal(String url, String user, String password) throws SQLException {
        Driver.load();
        return DriverManager.getConnection(url, user, password);
    }

    protected void deleteDb(String name) {
        this.deleteDb(this.getBaseDir(), name);
    }

    protected void deleteDb(String dir, String name) {
        DeleteDbFiles.execute(dir, name, true);
    }

    public ProcessBuilder buildChild(String name, Class<? extends TestDb> childClass, String ... jvmArgs) {
        ArrayList<String> args = new ArrayList<String>(16);
        args.add(TestDb.getJVM());
        Collections.addAll(args, jvmArgs);
        Collections.addAll(args, "-cp", this.getClassPath(), SelfDestructor.getPropertyString(1), childClass.getName(), "-url", this.getURL(name, true), "-user", this.getUser(), "-password", this.getPassword());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.INHERIT).command(args);
        return processBuilder;
    }

    public static abstract class Child
    extends TestDb {
        private String url;
        private String user;
        private String password;

        public Child(String ... args) {
            int i = 0;
            while (i < args.length) {
                if ("-url".equals(args[i])) {
                    this.url = args[++i];
                } else if ("-user".equals(args[i])) {
                    this.user = args[++i];
                } else if ("-password".equals(args[i])) {
                    this.password = args[++i];
                }
                SelfDestructor.startCountdown(60);
                ++i;
            }
        }

        public Connection getConnection() throws SQLException {
            return this.getConnection(this.url, this.user, this.password);
        }
    }
}

