/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.auth;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Database;
import org.h2.engine.Engine;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.security.auth.DefaultAuthenticator;
import org.h2.security.auth.H2AuthConfig;
import org.h2.security.auth.H2AuthConfigXml;
import org.h2.security.auth.impl.AssignRealmNameRole;
import org.h2.security.auth.impl.JaasCredentialsValidator;
import org.h2.security.auth.impl.StaticRolesMapper;
import org.h2.security.auth.impl.StaticUserCredentialsValidator;
import org.h2.test.TestBase;
import org.h2.test.auth.MyLoginModule;

public class TestAuthentication
extends TestBase {
    private static final String TESTXML = "<h2Auth allowUserRegistration=\"true\" createMissingRoles=\"false\"><realm name=\"ciao\" validatorClass=\"myclass\"/><realm name=\"miao\" validatorClass=\"myclass1\"><property name=\"prop1\" value=\"value1\"/><userToRolesMapper className=\"class1\"><property name=\"prop2\" value=\"value2\"/></userToRolesMapper></realm></h2Auth>";
    private static final String JAAS_CONFIG_NAME = "testJaasH2";
    private String externalUserPassword;
    private DefaultAuthenticator defaultAuthenticator;
    private SessionLocal session;
    private Database database;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    String getExternalUserPassword() {
        if (this.externalUserPassword == null) {
            this.externalUserPassword = UUID.randomUUID().toString();
        }
        return this.externalUserPassword;
    }

    private static String getRealmName() {
        return "testRealm";
    }

    private static String getStaticRoleName() {
        return "staticRole";
    }

    private void configureAuthentication(Database database) {
        this.defaultAuthenticator = new DefaultAuthenticator(true);
        this.defaultAuthenticator.setAllowUserRegistration(true);
        this.defaultAuthenticator.setCreateMissingRoles(true);
        this.defaultAuthenticator.addRealm(TestAuthentication.getRealmName(), new JaasCredentialsValidator(JAAS_CONFIG_NAME));
        this.defaultAuthenticator.addRealm(TestAuthentication.getRealmName() + "_STATIC", new StaticUserCredentialsValidator("staticuser[0-9]", "staticpassword"));
        this.defaultAuthenticator.setUserToRolesMappers(new AssignRealmNameRole("@%s"), new StaticRolesMapper(TestAuthentication.getStaticRoleName()));
        database.setAuthenticator(this.defaultAuthenticator);
    }

    private void configureJaas() {
        final Configuration innerConfiguration = Configuration.getConfiguration();
        Configuration.setConfiguration(new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (name.equals(TestAuthentication.JAAS_CONFIG_NAME)) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("password", TestAuthentication.this.getExternalUserPassword());
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(MyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
                }
                return innerConfiguration.getAppConfigurationEntry(name);
            }
        });
    }

    private String getDatabaseURL() {
        return "jdbc:h2:mem:" + this.getClass().getSimpleName();
    }

    private static String getExternalUser() {
        return "user";
    }

    @Override
    public void test() throws Exception {
        Configuration oldConfiguration = Configuration.getConfiguration();
        try {
            this.configureJaas();
            ConnectionInfo connectionInfo = new ConnectionInfo(this.getDatabaseURL(), null, "dba", null);
            this.session = Engine.createSession(connectionInfo);
            this.database = this.session.getDatabase();
            this.configureAuthentication(this.database);
            try {
                this.allTests();
            }
            finally {
                this.session.close();
            }
        }
        finally {
            Configuration.setConfiguration(oldConfiguration);
        }
    }

    private void allTests() throws Exception {
        this.testInvalidPassword();
        this.testExternalUserWithoutRealm();
        this.testExternalUser();
        this.testAssignRealNameRole();
        this.testStaticRole();
        this.testStaticUserCredentials();
        this.testUserRegistration();
        this.testSet();
        this.testDatasource();
        this.testXmlConfig();
    }

    private void testInvalidPassword() throws Exception {
        try {
            Connection wrongLoginConnection = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), TestAuthentication.getExternalUser(), "");
            wrongLoginConnection.close();
            throw new Exception("user should not be able to login with an invalid password");
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private void testExternalUserWithoutRealm() throws Exception {
        try {
            Connection wrongLoginConnection = DriverManager.getConnection(this.getDatabaseURL(), TestAuthentication.getExternalUser(), this.getExternalUserPassword());
            wrongLoginConnection.close();
            throw new Exception("user should not be able to login without a realm");
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private void testExternalUser() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection ignored = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), TestAuthentication.getExternalUser(), this.getExternalUserPassword());){
            User user = this.session.getDatabase().findUser((TestAuthentication.getExternalUser() + "@" + TestAuthentication.getRealmName()).toUpperCase());
            this.assertNotNull(user);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testDatasource() throws Exception {
        JdbcConnectionPool dataSource = JdbcConnectionPool.create(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), TestAuthentication.getExternalUser(), this.getExternalUserPassword());
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection ignored = dataSource.getConnection();){
            User user = this.session.getDatabase().findUser((TestAuthentication.getExternalUser() + "@" + TestAuthentication.getRealmName()).toUpperCase());
            this.assertNotNull(user);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testAssignRealNameRole() throws Exception {
        String realmNameRoleName = "@" + TestAuthentication.getRealmName().toUpperCase();
        Role realmNameRole = this.database.findRole(realmNameRoleName);
        if (realmNameRole == null) {
            realmNameRole = new Role(this.database, this.database.allocateObjectId(), realmNameRoleName, false);
            this.session.getDatabase().addDatabaseObject(this.session, realmNameRole);
            this.session.commit(false);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection ignored = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), TestAuthentication.getExternalUser(), this.getExternalUserPassword());){
            User user = this.session.getDatabase().findUser((TestAuthentication.getExternalUser() + "@" + TestAuthentication.getRealmName()).toUpperCase());
            this.assertNotNull(user);
            this.assertTrue(user.isRoleGranted(realmNameRole));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testStaticRole() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection ignored = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), TestAuthentication.getExternalUser(), this.getExternalUserPassword());){
            User user = this.session.getDatabase().findUser((TestAuthentication.getExternalUser() + "@" + TestAuthentication.getRealmName()).toUpperCase());
            this.assertNotNull(user);
            Role staticRole = this.session.getDatabase().findRole(TestAuthentication.getStaticRoleName());
            if (staticRole != null) {
                this.assertTrue(user.isRoleGranted(staticRole));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testUserRegistration() throws Exception {
        boolean initialValueAllow = this.defaultAuthenticator.isAllowUserRegistration();
        this.defaultAuthenticator.setAllowUserRegistration(false);
        try {
            try {
                Connection wrongLoginConnection = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), "___" + TestAuthentication.getExternalUser(), "");
                wrongLoginConnection.close();
                throw new Exception("unregistered external users should not be able to login when allowUserRegistration=false");
            }
            catch (SQLException wrongLoginConnection) {
                String validUserName = "new_" + TestAuthentication.getExternalUser();
                User validUser = new User(this.database, this.database.allocateObjectId(), (validUserName.toUpperCase() + "@" + TestAuthentication.getRealmName()).toUpperCase(), false);
                validUser.setUserPasswordHash(new byte[0]);
                this.database.addDatabaseObject(this.session, validUser);
                this.session.commit(false);
                Connection connectionWithRegisterUser = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase(), validUserName, this.getExternalUserPassword());
                connectionWithRegisterUser.close();
            }
        }
        finally {
            this.defaultAuthenticator.setAllowUserRegistration(initialValueAllow);
        }
    }

    private void testStaticUserCredentials() throws Exception {
        String userName = "STATICUSER3";
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection ignored = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHREALM=" + TestAuthentication.getRealmName().toUpperCase() + "_STATIC", userName, "staticpassword");){
            User user = this.session.getDatabase().findUser(userName + "@" + TestAuthentication.getRealmName().toUpperCase() + "_STATIC");
            this.assertNotNull(user);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testSet() throws Exception {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                Connection ignored = DriverManager.getConnection(this.getDatabaseURL() + ";AUTHENTICATOR=FALSE", "DBA", "");
                try {
                    try {
                        this.testExternalUser();
                        throw new Exception("External user shouldn't be allowed");
                    }
                    catch (Exception exception) {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (ignored != null) {
                        ignored.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            this.configureAuthentication(this.database);
        }
        this.testExternalUser();
    }

    private void testXmlConfig() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(TESTXML.getBytes());
        H2AuthConfig config = H2AuthConfigXml.parseFrom(inputStream);
        this.assertTrue(config.isAllowUserRegistration());
        this.assertFalse(config.isCreateMissingRoles());
        this.assertEquals("ciao", config.getRealms().get(0).getName());
        this.assertEquals("myclass", config.getRealms().get(0).getValidatorClass());
        this.assertEquals("prop1", config.getRealms().get(1).getProperties().get(0).getName());
        this.assertEquals("value1", config.getRealms().get(1).getProperties().get(0).getValue());
        this.assertEquals("class1", config.getUserToRolesMappers().get(0).getClassName());
        this.assertEquals("prop2", config.getUserToRolesMappers().get(0).getProperties().get(0).getName());
        this.assertEquals("value2", config.getUserToRolesMappers().get(0).getProperties().get(0).getValue());
    }
}

