/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Random;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;

public class BenchA
implements Bench {
    private static final String FILLER = "abcdefghijklmnopqrstuvwxyz";
    private static final int DELTA = 10000;
    private Database database;
    private int branches;
    private int tellers;
    private int accounts;
    private int transactions;

    @Override
    public void init(Database db, int size) throws SQLException {
        String[] create;
        this.database = db;
        this.transactions = size * 6;
        int scale = 2;
        this.accounts = size * 30;
        this.tellers = Math.max(this.accounts / 10, 1);
        this.branches = Math.max(this.tellers / 10, 1);
        db.start(this, "Init");
        db.openConnection();
        db.dropTable("BRANCHES");
        db.dropTable("TELLERS");
        db.dropTable("ACCOUNTS");
        db.dropTable("HISTORY");
        String[] stringArray = create = new String[]{"CREATE TABLE BRANCHES(BID INT NOT NULL PRIMARY KEY, BBALANCE DECIMAL(15,2), FILLER VARCHAR(88))", "CREATE TABLE TELLERS(TID INT NOT NULL PRIMARY KEY, BID INT, TBALANCE DECIMAL(15,2), FILLER VARCHAR(84))", "CREATE TABLE ACCOUNTS(AID INT NOT NULL PRIMARY KEY, BID INT, ABALANCE DECIMAL(15,2), FILLER VARCHAR(84))", "CREATE TABLE HISTORY(TID INT, BID INT, AID INT, DELTA DECIMAL(15,2), HTIME DATETIME, FILLER VARCHAR(40))"};
        int n = create.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            db.update(sql);
            ++n2;
        }
        db.setAutoCommit(false);
        int commitEvery = 1000;
        PreparedStatement prep = db.prepare("INSERT INTO BRANCHES(BID, BBALANCE, FILLER) VALUES(?, 10000.00, 'abcdefghijklmnopqrstuvwxyz')");
        int i = 0;
        while (i < this.branches * scale) {
            prep.setInt(1, i);
            db.update(prep, "insertBranches");
            if ((i + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i;
        }
        db.commit();
        prep = db.prepare("INSERT INTO TELLERS(TID, BID, TBALANCE, FILLER) VALUES(?, ?, 10000.00, 'abcdefghijklmnopqrstuvwxyz')");
        i = 0;
        while (i < this.tellers * scale) {
            prep.setInt(1, i);
            prep.setInt(2, i / this.tellers);
            db.update(prep, "insertTellers");
            if ((i + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i;
        }
        db.commit();
        int len = this.accounts * scale;
        prep = db.prepare("INSERT INTO ACCOUNTS(AID, BID, ABALANCE, FILLER) VALUES(?, ?, 10000.00, 'abcdefghijklmnopqrstuvwxyz')");
        int i2 = 0;
        while (i2 < len) {
            prep.setInt(1, i2);
            prep.setInt(2, i2 / this.accounts);
            db.update(prep, "insertAccounts");
            if ((i2 + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i2;
        }
        db.commit();
        db.closeConnection();
        db.end();
    }

    @Override
    public void runTest() throws SQLException {
        this.database.openConnection();
        this.database.start(this, "Transactions");
        this.processTransactions();
        this.database.end();
        this.database.logMemory(this, "Memory Usage");
        this.database.closeConnection();
    }

    private void processTransactions() throws SQLException {
        Random random = this.database.getRandom();
        int branch = random.nextInt(this.branches);
        int teller = random.nextInt(this.tellers);
        PreparedStatement updateAccount = this.database.prepare("UPDATE ACCOUNTS SET ABALANCE=ABALANCE+? WHERE AID=?");
        PreparedStatement selectBalance = this.database.prepare("SELECT ABALANCE FROM ACCOUNTS WHERE AID=?");
        PreparedStatement updateTeller = this.database.prepare("UPDATE TELLERS SET TBALANCE=TBALANCE+? WHERE TID=?");
        PreparedStatement updateBranch = this.database.prepare("UPDATE BRANCHES SET BBALANCE=BBALANCE+? WHERE BID=?");
        PreparedStatement insertHistory = this.database.prepare("INSERT INTO HISTORY(AID, TID, BID, DELTA, HTIME, FILLER) VALUES(?, ?, ?, ?, ?, ?)");
        int accountsPerBranch = this.accounts / this.branches;
        this.database.setAutoCommit(false);
        int i = 0;
        while (i < this.transactions) {
            int account = random.nextInt(100) < 85 ? random.nextInt(accountsPerBranch) + branch * accountsPerBranch : random.nextInt(this.accounts);
            int max = 10000;
            BigDecimal delta = BigDecimal.valueOf(random.nextInt(max * 2) - max);
            long current = System.currentTimeMillis();
            updateAccount.setBigDecimal(1, delta);
            updateAccount.setInt(2, account);
            this.database.update(updateAccount, "updateAccount");
            updateTeller.setBigDecimal(1, delta);
            updateTeller.setInt(2, teller);
            this.database.update(updateTeller, "updateTeller");
            updateBranch.setBigDecimal(1, delta);
            updateBranch.setInt(2, branch);
            this.database.update(updateBranch, "updateBranch");
            selectBalance.setInt(1, account);
            this.database.queryReadResult(selectBalance);
            insertHistory.setInt(1, account);
            insertHistory.setInt(2, teller);
            insertHistory.setInt(3, branch);
            insertHistory.setBigDecimal(4, delta);
            insertHistory.setTimestamp(5, new Timestamp(current));
            insertHistory.setString(6, FILLER);
            this.database.update(insertHistory, "insertHistory");
            this.database.commit();
            ++i;
        }
        updateAccount.close();
        selectBalance.close();
        updateTeller.close();
        updateBranch.close();
        insertHistory.close();
    }

    @Override
    public String getName() {
        return "BenchA";
    }
}

