/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Random;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;

public class BenchSimple
implements Bench {
    Database database;
    int records;

    @Override
    public void init(Database db, int size) throws SQLException {
        this.database = db;
        this.records = size * 75;
        db.start(this, "Init");
        db.openConnection();
        db.dropTable("TEST");
        db.setAutoCommit(false);
        int commitEvery = 1000;
        db.update("CREATE TABLE TEST(ID INT NOT NULL PRIMARY KEY, NAME VARCHAR(255))");
        db.commit();
        PreparedStatement prep = db.prepare("INSERT INTO TEST VALUES(?, ?)");
        int i = 0;
        while (i < this.records) {
            prep.setInt(1, i);
            prep.setString(2, "Hello World " + i);
            db.update(prep, "insertTest");
            if ((i + 1) % commitEvery == 0) {
                db.commit();
            }
            ++i;
        }
        db.commit();
        db.closeConnection();
        db.end();
    }

    @Override
    public void runTest() throws SQLException {
        Database db = this.database;
        Random random = db.getRandom();
        db.openConnection();
        db.start(this, "Query (random)");
        PreparedStatement prep = db.prepare("SELECT * FROM TEST WHERE ID=?");
        int i = 0;
        while (i < this.records / 10) {
            prep.setInt(1, random.nextInt(this.records));
            db.queryReadResult(prep);
            ++i;
        }
        db.end();
        db.start(this, "Query (sequential)");
        prep = db.prepare("SELECT * FROM TEST WHERE ID=?");
        i = 0;
        while (i < this.records) {
            prep.setInt(1, i);
            db.queryReadResult(prep);
            ++i;
        }
        db.end();
        db.start(this, "Update (sequential)");
        prep = db.prepare("UPDATE TEST SET NAME=? WHERE ID=?");
        i = 0;
        while (i < this.records) {
            prep.setString(1, "Hallo Welt " + i);
            prep.setInt(2, i);
            db.update(prep, "updateTest");
            i += 3;
        }
        db.end();
        db.start(this, "Delete (sequential)");
        prep = db.prepare("DELETE FROM TEST WHERE ID=?");
        i = 0;
        while (i < this.records) {
            prep.setInt(1, i);
            db.update(prep, "deleteTest");
            i += 2;
        }
        db.end();
        db.logMemory(this, "Memory Usage");
        db.closeConnection();
    }

    @Override
    public String getName() {
        return "Simple";
    }
}

