/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.test.TestBase;
import org.h2.test.bench.Bench;
import org.h2.tools.Server;
import org.h2.util.StringUtils;

class Database {
    private static final boolean TRACE = true;
    private DatabaseTest test;
    private int id;
    private String name;
    private String url;
    private String user;
    private String password;
    private final ArrayList<String[]> replace = new ArrayList();
    private String currentAction;
    private long startTimeNs;
    private long initialGCTime;
    private Connection conn;
    private Statement stat;
    private long lastTrace;
    private final Random random = new Random(1L);
    private ArrayList<Measurement> results = new ArrayList();
    private int totalTime;
    private int totalGCTime;
    private final AtomicInteger executedStatements = new AtomicInteger();
    private Server serverH2;
    private Object serverDerby;
    private boolean serverHSQLDB;

    Database() {
    }

    String getName() {
        return this.name;
    }

    int getTotalTime() {
        return this.totalTime;
    }

    int getTotalGCTime() {
        return this.totalGCTime;
    }

    ArrayList<Measurement> getResults() {
        return this.results;
    }

    ArrayList<Measurement> reset() {
        this.executedStatements.set(0);
        this.totalTime = 0;
        this.totalGCTime = 0;
        this.lastTrace = 0L;
        ArrayList<Measurement> measurements = this.results;
        this.results = new ArrayList();
        return measurements;
    }

    Random getRandom() {
        return this.random;
    }

    void startServer() throws Exception {
        if (this.url.startsWith("jdbc:h2:tcp:")) {
            try {
                this.serverH2 = Server.createTcpServer("-ifNotExists").start();
            }
            catch (SQLException e) {
                this.serverH2 = Server.createTcpServer(new String[0]).start();
            }
            Thread.sleep(100L);
        } else if (this.url.startsWith("jdbc:derby://")) {
            this.serverDerby = Class.forName("org.apache.derby.drda.NetworkServerControl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method m = this.serverDerby.getClass().getMethod("start", PrintWriter.class);
            m.invoke(this.serverDerby, new Object[1]);
            Thread.sleep(100L);
        } else if (this.url.startsWith("jdbc:hsqldb:hsql:") && !this.serverHSQLDB) {
            Class<?> c;
            try {
                c = Class.forName("org.hsqldb.server.Server");
            }
            catch (Exception e) {
                c = Class.forName("org.hsqldb.Server");
            }
            Method m = c.getMethod("main", String[].class);
            m.invoke(null, new Object[]{new String[]{"-database.0", "data/mydb;hsqldb.default_table_type=cached;hsqldb.write_delay_millis=1000", "-dbname.0", "xdb"}});
            this.serverHSQLDB = true;
            Thread.sleep(100L);
        }
    }

    void stopServer() throws Exception {
        if (this.serverH2 != null) {
            this.serverH2.stop();
            this.serverH2 = null;
        }
        if (this.serverDerby != null) {
            Method m = this.serverDerby.getClass().getMethod("shutdown", new Class[0]);
            m.invoke(this.serverDerby, null);
            this.serverDerby = null;
        }
    }

    static Database parse(DatabaseTest test, int id, String dbString, Properties properties) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(dbString, ",");
            Database db = new Database();
            db.id = id;
            db.test = test;
            db.name = tokenizer.nextToken().trim();
            String driver = tokenizer.nextToken().trim();
            Class.forName(driver);
            db.url = tokenizer.nextToken().trim();
            db.user = tokenizer.nextToken().trim();
            db.password = null;
            if (tokenizer.hasMoreTokens()) {
                db.password = tokenizer.nextToken().trim();
            }
            db.setTranslations(properties);
            return db;
        }
        catch (Exception e) {
            System.out.println("Cannot load database " + dbString + ": " + String.valueOf(e));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Connection openNewConnection() throws SQLException {
        Connection newConn = DriverManager.getConnection(this.url, this.user, this.password);
        if (this.url.startsWith("jdbc:derby:")) {
            Throwable throwable = null;
            Object var3_7 = null;
            try {
                Statement s = newConn.createStatement();
                if (s == null) return newConn;
                s.close();
                return newConn;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (this.url.startsWith("jdbc:hsqldb:")) {
            Throwable throwable = null;
            Object var3_9 = null;
            try (Statement s = newConn.createStatement();){
                s.execute("SET WRITE_DELAY 1");
                return newConn;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (!this.url.startsWith("jdbc:sqlite:")) return newConn;
        Throwable throwable = null;
        Object var3_11 = null;
        try (Statement s = newConn.createStatement();){
            s.execute("PRAGMA journal_mode=WAL;");
            s.execute("PRAGMA synchronous=NORMAL;");
            return newConn;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    void openConnection() throws SQLException {
        this.conn = this.openNewConnection();
        this.stat = this.conn.createStatement();
    }

    void closeConnection() throws SQLException {
        this.conn.close();
        this.stat = null;
        this.conn = null;
    }

    void setTranslations(Properties prop) {
        String databaseType = this.url.substring("jdbc:".length());
        databaseType = databaseType.substring(0, databaseType.indexOf(58));
        for (Object k : prop.keySet()) {
            String key = (String)k;
            if (!key.startsWith(databaseType + ".")) continue;
            String pattern = key.substring(databaseType.length() + 1);
            pattern = pattern.replace('_', ' ');
            pattern = StringUtils.toUpperEnglish(pattern);
            String replacement = prop.getProperty(key);
            this.replace.add(new String[]{pattern, replacement});
        }
    }

    PreparedStatement prepare(String sql) throws SQLException {
        sql = this.getSQL(sql);
        return this.conn.prepareStatement(sql);
    }

    private String getSQL(String sql) {
        for (String[] pair : this.replace) {
            String pattern = pair[0];
            String replacement = pair[1];
            sql = StringUtils.replaceAll(sql, pattern, replacement);
        }
        return sql;
    }

    void start(Bench bench, String action) {
        this.currentAction = bench.getName() + ": " + action;
        this.startTimeNs = System.nanoTime();
        this.initialGCTime = Database.getGarbageCollectionTime();
    }

    void end() {
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTimeNs);
        long gcCollectionTime = Database.getGarbageCollectionTime() - this.initialGCTime;
        this.log(this.currentAction, "ms", (int)time);
        if (this.test.isCollect()) {
            this.totalTime = (int)((long)this.totalTime + time);
            this.totalGCTime = (int)((long)this.totalGCTime + gcCollectionTime);
        }
    }

    public static long getGarbageCollectionTime() {
        long totalGCTime = 0L;
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionTime = gcMXBean.getCollectionTime();
            if (collectionTime <= 0L) continue;
            totalGCTime += collectionTime;
        }
        return totalGCTime;
    }

    void dropTable(String table) {
        try {
            this.update("DROP TABLE " + table);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void update(PreparedStatement prep, String traceMessage) throws SQLException {
        this.test.trace(traceMessage);
        prep.executeUpdate();
        if (this.test.isCollect()) {
            this.executedStatements.incrementAndGet();
        }
    }

    void update(String sql) throws SQLException {
        if ((sql = this.getSQL(sql)).trim().length() > 0) {
            if (this.test.isCollect()) {
                this.executedStatements.incrementAndGet();
            }
            this.stat.execute(sql);
        } else {
            System.out.println("?");
        }
    }

    void setAutoCommit(boolean b) throws SQLException {
        this.conn.setAutoCommit(b);
    }

    void commit() throws SQLException {
        this.conn.commit();
    }

    void rollback() throws SQLException {
        this.conn.rollback();
    }

    void trace(String action, int i, int max) {
        long time = System.nanoTime();
        if (i == 0 || this.lastTrace == 0L) {
            this.lastTrace = time;
        } else if (time > this.lastTrace + TimeUnit.SECONDS.toNanos(1L)) {
            System.out.println(action + ": " + 100 * i / max + "%");
            this.lastTrace = time;
        }
    }

    void logMemory(Bench bench, String action) {
        this.log(bench.getName() + ": " + action, "MB", TestBase.getMemoryUsed());
    }

    void log(String action, String unit, int value) {
        if (this.test.isCollect()) {
            this.results.add(new Measurement(action, unit, value));
        }
    }

    ResultSet query(PreparedStatement prep) throws SQLException {
        ResultSet rs = prep.executeQuery();
        if (this.test.isCollect()) {
            this.executedStatements.incrementAndGet();
        }
        return rs;
    }

    void queryReadResult(PreparedStatement prep) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSet rs = this.query(prep);){
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            while (rs.next()) {
                int i = 0;
                while (i < columnCount) {
                    rs.getString(i + 1);
                    ++i;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    int getExecutedStatements() {
        return this.executedStatements.get();
    }

    int getId() {
        return this.id;
    }

    public static interface DatabaseTest {
        public boolean isCollect();

        public void trace(String var1);

        default public Properties loadProperties() throws IOException {
            Properties prop = new Properties();
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream in = this.getClass().getResourceAsStream("test.properties");){
                prop.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return prop;
        }
    }

    public static final class Measurement {
        final String name;
        final String unit;
        final int value;

        public Measurement(String name, String unit, int value) {
            this.name = name;
            this.unit = unit;
            this.value = value;
        }
    }
}

