/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.coverage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.h2.test.coverage.Tokenizer;

public class Coverage {
    private static final String IMPORT = "import " + Coverage.class.getPackage().getName() + ".Profile";
    private final ArrayList<String> files = new ArrayList();
    private final ArrayList<String> exclude = new ArrayList();
    private Tokenizer tokenizer;
    private Writer writer;
    private Writer data;
    private String token = "";
    private String add = "";
    private String file;
    private int index;
    private int indent;
    private int line;
    private String last;
    private String word;
    private String function;
    private boolean perClass;
    private boolean perFunction = true;

    private void printUsage() {
        System.out.println("Usage:\n- copy all your source files to another directory\n  (be careful, they will be modified - don't take originals!)\n- java " + this.getClass().getName() + " <directory>\n  this will modified the source code and create 'profile.txt'\n- compile the modified source files\n- run your main application\n- after the application exits, a file 'notCovered.txt' is created,\n  which contains the class names, function names and line numbers\n  of code that has not been covered\n\nOptions:\n-r     recurse all subdirectories\n-e     exclude files\n-c     coverage on a per-class basis\n-f     coverage on a per-function basis\n<dir>  directory name (. for current directory)");
    }

    public static void main(String ... args) {
        new Coverage().run(args);
    }

    private void run(String ... args) {
        if (args.length == 0 || args[0].equals("-?")) {
            this.printUsage();
            return;
        }
        Coverage c = new Coverage();
        int recurse = 1;
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            if (s.equals("-r")) {
                recurse = 100;
            } else if (s.equals("-c")) {
                c.perClass = true;
            } else if (s.equals("-f")) {
                c.perFunction = true;
            } else if (s.equals("-e")) {
                c.addExclude(args[++i]);
            } else {
                c.addDir(s, recurse);
            }
            ++i;
        }
        try {
            c.data = new BufferedWriter(new FileWriter("profile.txt"));
            c.processAll();
            c.data.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addExclude(String fileName) {
        this.exclude.add(fileName);
    }

    private boolean isExcluded(String s) {
        for (String e : this.exclude) {
            if (!s.startsWith(e)) continue;
            return true;
        }
        return false;
    }

    private void addDir(String path, int recurse) {
        File f = new File(path);
        if (f.isFile() && path.endsWith(".java")) {
            if (!this.isExcluded(path)) {
                this.files.add(path);
            }
        } else if (f.isDirectory() && recurse > 0) {
            String[] stringArray = f.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.addDir(path + "/" + name, recurse - 1);
                ++n2;
            }
        }
    }

    private void processAll() {
        int len = this.files.size();
        long time = System.nanoTime();
        int i = 0;
        while (i < len) {
            long t2 = System.nanoTime();
            if (t2 - time > TimeUnit.SECONDS.toNanos(1L) || i >= len - 1) {
                System.out.println(i + 1 + " of " + len + " " + 100 * i / len + "%");
                time = t2;
            }
            String fileName = this.files.get(i);
            this.processFile(fileName);
            ++i;
        }
    }

    private void processFile(String name) {
        this.file = name;
        int i = this.file.lastIndexOf(46);
        if (i != -1) {
            this.file = this.file.substring(0, i);
        }
        while (true) {
            if ((i = this.file.indexOf(47)) < 0) {
                i = this.file.indexOf(92);
            }
            if (i < 0) break;
            this.file = this.file.substring(0, i) + "." + this.file.substring(i + 1);
        }
        if (name.endsWith("Coverage.java") || name.endsWith("Tokenizer.java") || name.endsWith("Profile.java")) {
            return;
        }
        File f = new File(name);
        File fileNew = new File(name + ".new");
        try {
            this.writer = new BufferedWriter(new FileWriter(fileNew));
            BufferedReader r = new BufferedReader(new FileReader(f));
            this.tokenizer = new Tokenizer(r);
            this.indent = 0;
            try {
                this.process();
            }
            catch (Exception e) {
                ((Reader)r).close();
                this.writer.close();
                e.printStackTrace();
                this.printError(e.getMessage());
                throw e;
            }
            ((Reader)r).close();
            this.writer.close();
            File backup = new File(name + ".bak");
            backup.delete();
            f.renameTo(backup);
            File copy = new File(name);
            fileNew.renameTo(copy);
            if (this.perClass) {
                this.nextDebug();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printError(e.getMessage());
        }
    }

    private void read() throws IOException {
        this.last = this.token;
        Object write = this.token;
        this.token = null;
        this.tokenizer.initToken();
        int i = this.tokenizer.nextToken();
        if (i != -1) {
            this.token = this.tokenizer.getString();
            if (this.token == null) {
                this.token = "" + (char)i;
            } else if (i == 39) {
                this.token = this.tokenizer.getToken();
            } else if (i == 34) {
                this.token = this.tokenizer.getToken();
            } else {
                write = write == null ? "" : (String)write + " ";
            }
        }
        if (!(write != null && (((String)write).equals("else ") || ((String)write).equals("else") || ((String)write).equals("super ") || ((String)write).equals("super") || ((String)write).equals("this ") || ((String)write).equals("this") || ((String)write).equals("} ") || ((String)write).equals("}")) || this.add == null || this.add.equals(""))) {
            this.writeLine();
            this.write(this.add);
            if (!this.perClass) {
                this.nextDebug();
            }
        }
        this.add = "";
        if (write != null) {
            this.write((String)write);
        }
    }

    private void readThis(String s) throws IOException {
        if (!this.token.equals(s)) {
            throw new IOException("Expected: " + s + " got:" + this.token);
        }
        this.read();
    }

    private void process() throws IOException {
        boolean imp = false;
        this.read();
        while (true) {
            if (this.token != null && !this.token.equals("{")) {
                if (this.token.equals(";") && !imp) {
                    this.write(";" + IMPORT);
                    imp = true;
                }
                this.read();
                continue;
            }
            this.processClass();
            if (this.token == null) break;
        }
    }

    private void processInit() throws IOException {
        while (true) {
            if (this.token.equals("{")) {
                this.read();
                this.processInit();
                continue;
            }
            if (this.token.equals("}")) {
                this.read();
                return;
            }
            this.read();
        }
    }

    private void processClass() throws IOException {
        int type = 0;
        while (this.token != null) {
            if (this.token.equals("class")) {
                this.read();
                type = 1;
                continue;
            }
            if (this.token.equals("=")) {
                this.read();
                type = 2;
                continue;
            }
            if (this.token.equals("static")) {
                this.word = "static";
                this.read();
                type = 3;
                continue;
            }
            if (this.token.equals("(")) {
                this.word = this.last + "(";
                this.read();
                if (!this.token.equals(")")) {
                    this.word = String.valueOf(this.word) + this.token;
                }
                type = 3;
                continue;
            }
            if (this.token.equals(",")) {
                this.read();
                this.word = this.word + "," + this.token;
                continue;
            }
            if (this.token.equals(")")) {
                this.word = String.valueOf(this.word) + ")";
                this.read();
                continue;
            }
            if (this.token.equals(";")) {
                this.read();
                type = 0;
                continue;
            }
            if (this.token.equals("{")) {
                this.read();
                if (type == 1) {
                    this.processClass();
                    continue;
                }
                if (type == 2) {
                    this.processInit();
                    continue;
                }
                if (type != 3) continue;
                this.writeLine();
                this.setLine();
                this.processFunction();
                this.writeLine();
                continue;
            }
            if (this.token.equals("}")) {
                this.read();
                break;
            }
            this.read();
        }
    }

    private void processBracket() throws IOException {
        while (true) {
            if (this.token.equals("(")) {
                this.read();
                this.processBracket();
                continue;
            }
            if (this.token.equals(")")) {
                this.read();
                return;
            }
            this.read();
        }
    }

    private void processFunction() throws IOException {
        this.function = this.word;
        this.writeLine();
        do {
            this.processStatement();
        } while (!this.token.equals("}"));
        this.read();
        this.writeLine();
    }

    private void processBlockOrStatement() throws IOException {
        if (!this.token.equals("{")) {
            this.write("{ //++");
            this.writeLine();
            this.setLine();
            this.processStatement();
            this.write("} //++");
            this.writeLine();
        } else {
            this.read();
            this.setLine();
            this.processFunction();
        }
    }

    private void processStatement() throws IOException {
        while (true) {
            if (this.token.equals("while") || this.token.equals("for") || this.token.equals("synchronized")) {
                this.read();
                this.readThis("(");
                this.processBracket();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                return;
            }
            if (this.token.equals("if")) {
                this.read();
                this.readThis("(");
                this.processBracket();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                if (this.token.equals("else")) {
                    this.read();
                    ++this.indent;
                    this.processBlockOrStatement();
                    --this.indent;
                }
                return;
            }
            if (this.token.equals("try")) {
                this.read();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                while (true) {
                    if (this.token.equals("catch")) {
                        this.read();
                        this.readThis("(");
                        this.processBracket();
                        ++this.indent;
                        this.processBlockOrStatement();
                        --this.indent;
                        continue;
                    }
                    if (!this.token.equals("finally")) break;
                    this.read();
                    ++this.indent;
                    this.processBlockOrStatement();
                    --this.indent;
                }
                return;
            }
            if (this.token.equals("{")) {
                if (this.last.equals(")")) {
                    this.read();
                    this.processClass();
                    return;
                }
                if (this.last.equals("]")) {
                    while (!this.token.equals("}")) {
                        this.read();
                    }
                    this.read();
                    return;
                }
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                return;
            }
            if (this.token.equals("do")) {
                this.read();
                ++this.indent;
                this.processBlockOrStatement();
                this.readThis("while");
                this.readThis("(");
                this.processBracket();
                this.readThis(";");
                this.setLine();
                --this.indent;
                return;
            }
            if (this.token.equals("case")) {
                this.add = "";
                this.read();
                while (!this.token.equals(":")) {
                    this.read();
                }
                this.read();
                this.setLine();
                continue;
            }
            if (this.token.equals("default")) {
                this.add = "";
                this.read();
                this.readThis(":");
                this.setLine();
                continue;
            }
            if (this.token.equals("switch")) {
                this.read();
                this.readThis("(");
                this.processBracket();
                ++this.indent;
                this.processBlockOrStatement();
                --this.indent;
                return;
            }
            if (this.token.equals("class")) {
                this.read();
                this.processClass();
                return;
            }
            if (this.token.equals("(")) {
                this.read();
                this.processBracket();
                continue;
            }
            if (this.token.equals("=")) {
                this.read();
                if (!this.token.equals("{")) continue;
                this.read();
                this.processInit();
                continue;
            }
            if (this.token.equals(";")) {
                this.read();
                this.setLine();
                return;
            }
            if (this.token.equals("}")) {
                return;
            }
            this.read();
        }
    }

    private void setLine() {
        this.add = String.valueOf(this.add) + "Profile.visit(" + this.index + ");";
        this.line = this.tokenizer.getLine();
    }

    private void nextDebug() throws IOException {
        if (this.perFunction) {
            int i = this.function.indexOf(40);
            String func = i < 0 ? this.function : this.function.substring(0, i);
            String fileLine = this.file + "." + func + "(";
            i = this.file.lastIndexOf(46);
            String className = i < 0 ? this.file : this.file.substring(i + 1);
            fileLine = fileLine + className + ".java:" + this.line + ")";
            this.data.write(fileLine + " " + this.last + "\r\n");
        } else {
            this.data.write(this.file + " " + this.line + "\r\n");
        }
        ++this.index;
    }

    private void writeLine() throws IOException {
        this.write("\r\n");
        int i = 0;
        while (i < this.indent) {
            this.writer.write(32);
            ++i;
        }
    }

    private void write(String s) throws IOException {
        this.writer.write(s);
    }

    private void printError(String error) {
        System.out.println("");
        System.out.println("File:" + this.file);
        System.out.println("ERROR: " + error);
    }
}

