/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.h2.test.TestDb;

public abstract class AbstractBaseForCommonTableExpressions
extends TestDb {
    void testRepeatedQueryWithSetup(int maxRetries, String[] expectedRowData, String[] expectedColumnNames, int expectedNumberOfRows, String setupSQL, String withQuery, int closeAndReopenDatabaseConnectionOnIteration, String[] expectedColumnTypes, boolean anyOrder) throws SQLException {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        if (anyOrder) {
            Arrays.sort(expectedRowData);
        }
        ArrayList<String> rowData = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        int queryRunTries = 1;
        while (queryRunTries <= maxRetries) {
            Statement stat = conn.createStatement();
            stat.execute(setupSQL);
            stat.close();
            if (queryRunTries == closeAndReopenDatabaseConnectionOnIteration) {
                conn.close();
                conn = this.getConnection("commonTableExpressionQueries");
            }
            PreparedStatement prep = conn.prepareStatement(withQuery);
            ResultSet rs = prep.executeQuery();
            int columnIndex = 1;
            while (columnIndex <= rs.getMetaData().getColumnCount()) {
                this.assertNotNull(rs.getMetaData().getColumnLabel(columnIndex));
                this.assertEquals(expectedColumnNames[columnIndex - 1], rs.getMetaData().getColumnLabel(columnIndex));
                this.assertEquals("wrong type of column " + rs.getMetaData().getColumnLabel(columnIndex) + " on iteration #" + queryRunTries, expectedColumnTypes[columnIndex - 1], rs.getMetaData().getColumnTypeName(columnIndex));
                ++columnIndex;
            }
            rowData.clear();
            while (rs.next()) {
                buf.setLength(0);
                columnIndex = 1;
                while (columnIndex <= rs.getMetaData().getColumnCount()) {
                    buf.append('|').append(rs.getString(columnIndex));
                    ++columnIndex;
                }
                rowData.add(buf.toString());
            }
            if (anyOrder) {
                Collections.sort(rowData);
            }
            this.assertEquals(expectedRowData, rowData.toArray(new String[0]));
            rs.close();
            prep.close();
            ++queryRunTries;
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }
}

