/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.schema.Sequence;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestAlter
extends TestDb {
    private Connection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.conn = this.getConnection(this.getTestName());
        this.stat = this.conn.createStatement();
        this.testAlterTableRenameConstraint();
        this.testAlterTableDropColumnWithReferences();
        this.testAlterTableDropMultipleColumns();
        this.testAlterTableAddColumnIdentity();
        this.testAlterTableDropIdentityColumn();
        this.testAlterTableAddColumnIfNotExists();
        this.testAlterTableAddMultipleColumns();
        this.testAlterTableAddColumnBefore();
        this.testAlterTableAddColumnAfter();
        this.testAlterTableAddMultipleColumnsBefore();
        this.testAlterTableAddMultipleColumnsAfter();
        this.conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testAlterTableDropColumnWithReferences() throws SQLException {
        this.stat.execute("create table parent(id int primary key, b int)");
        this.stat.execute("create table child(p int primary key)");
        this.stat.execute("alter table child add foreign key(p) references parent(id)");
        this.stat.execute("alter table parent drop column id");
        this.stat.execute("drop table parent");
        this.stat.execute("drop table child");
        this.stat.execute("create table test(id int, name varchar(255))");
        this.stat.execute("alter table test add constraint x check (id > name)");
        this.assertThrows(90083, this.stat).execute("alter table test drop column id");
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, name varchar(255))");
        this.stat.execute("alter table test add constraint x unique(id, name)");
        this.assertThrows(90083, this.stat).execute("alter table test drop column id");
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, name varchar(255))");
        this.stat.execute("alter table test add constraint x check (id > 1)");
        this.stat.execute("alter table test drop column id");
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, name varchar(255))");
        this.stat.execute("alter table test add constraint x check (name > 'TEST.ID')");
        this.stat.execute("alter table test drop column id");
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, name varchar(255))");
        this.stat.execute("alter table test add constraint x unique(id)");
        this.stat.execute("alter table test drop column id");
        this.stat.execute("drop table test");
    }

    private void testAlterTableDropMultipleColumns() throws SQLException {
        this.stat.execute("create table test(id int, b varchar, c int, d int)");
        this.stat.execute("alter table test drop column b, c");
        this.stat.execute("alter table test drop d");
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, b varchar, c int, d int)");
        this.stat.execute("alter table test drop column (b, c)");
        this.assertThrows(42122, this.stat).execute("alter table test drop column b");
        this.stat.execute("alter table test drop (d)");
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int, name varchar, name2 varchar)");
        this.assertThrows(90084, this.stat).execute("alter table test drop column id, name, name2");
        this.stat.execute("drop table test");
    }

    private void testAlterTableRenameConstraint() throws SQLException {
        this.stat.execute("create table test(id int, name varchar(255))");
        this.stat.execute("alter table test add constraint x check (id > name)");
        this.stat.execute("alter table test rename constraint x to x2");
        this.stat.execute("drop table test");
    }

    private void testAlterTableDropIdentityColumn() throws SQLException {
        Session iface = ((JdbcConnection)this.stat.getConnection()).getSession();
        if (!(iface instanceof SessionLocal)) {
            return;
        }
        Collection<Sequence> allSequences = ((SessionLocal)iface).getDatabase().getMainSchema().getAllSequences();
        this.stat.execute("create table test(id int auto_increment, name varchar)");
        this.stat.execute("alter table test drop column id");
        this.assertEquals(0, allSequences.size());
        this.stat.execute("drop table test");
        this.stat.execute("create table test(id int auto_increment, name varchar)");
        this.stat.execute("alter table test drop column name");
        this.assertEquals(1, allSequences.size());
        this.stat.execute("drop table test");
    }

    private void testAlterTableAddColumnIdentity() throws SQLException {
        this.stat.execute("create table t(x varchar)");
        this.stat.execute("alter table t add id bigint generated by default as identity(start with 5 increment by 5) default on null");
        this.stat.execute("insert into t values (null, null)");
        this.stat.execute("insert into t values (null, null)");
        ResultSet rs = this.stat.executeQuery("select id from t order by id");
        this.assertTrue(rs.next());
        this.assertEquals(5, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(10, rs.getInt(1));
        this.assertFalse(rs.next());
        this.stat.execute("drop table t");
    }

    private void testAlterTableAddColumnIfNotExists() throws SQLException {
        this.stat.execute("create table t(x varchar) as select 'x'");
        this.stat.execute("alter table t add if not exists x int");
        this.stat.execute("drop table t");
        this.stat.execute("create table t(x varchar) as select 'x'");
        this.stat.execute("alter table t add if not exists y int");
        this.stat.execute("select x, y from t");
        this.stat.execute("drop table t");
    }

    private void testAlterTableAddMultipleColumns() throws SQLException {
        this.stat.execute("create table t(x varchar) as select 'x'");
        this.stat.execute("alter table t add (y int, z varchar)");
        this.stat.execute("drop table t");
        this.stat.execute("create table t(x varchar) as select 'x'");
        this.stat.execute("alter table t add (y int)");
        this.stat.execute("drop table t");
    }

    private void testAlterTableAddMultipleColumnsBefore() throws SQLException {
        this.stat.execute("create table T(X varchar)");
        this.stat.execute("alter table T add (Y int, Z int) before X");
        DatabaseMetaData dbMeta = this.conn.getMetaData();
        ResultSet rs = dbMeta.getColumns(null, null, "T", null);
        this.assertTrue(rs.next());
        this.assertEquals("Y", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("Z", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("X", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        this.stat.execute("drop table T");
    }

    private void testAlterTableAddMultipleColumnsAfter() throws SQLException {
        this.stat.execute("create table T(X varchar)");
        this.stat.execute("alter table T add (Y int, Z int) after X");
        DatabaseMetaData dbMeta = this.conn.getMetaData();
        ResultSet rs = dbMeta.getColumns(null, null, "T", null);
        this.assertTrue(rs.next());
        this.assertEquals("X", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("Y", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("Z", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        this.stat.execute("drop table T");
    }

    private void testAlterTableAddColumnBefore() throws SQLException {
        this.stat.execute("create table T(X varchar)");
        this.stat.execute("alter table T add Y int before X");
        DatabaseMetaData dbMeta = this.conn.getMetaData();
        ResultSet rs = dbMeta.getColumns(null, null, "T", null);
        this.assertTrue(rs.next());
        this.assertEquals("Y", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("X", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        this.stat.execute("drop table T");
    }

    private void testAlterTableAddColumnAfter() throws SQLException {
        this.stat.execute("create table T(X varchar)");
        this.stat.execute("alter table T add Y int after X");
        DatabaseMetaData dbMeta = this.conn.getMetaData();
        ResultSet rs = dbMeta.getColumns(null, null, "T", null);
        this.assertTrue(rs.next());
        this.assertEquals("X", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("Y", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        this.stat.execute("drop table T");
    }
}

