/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.api.DatabaseEventListener;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Backup;
import org.h2.tools.Restore;
import org.h2.util.Task;

public class TestBackup
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws SQLException {
        this.testConcurrentBackup();
        this.testBackupRestoreLobStatement();
        this.testBackupRestoreLob();
        this.testBackup();
        this.deleteDb("backup");
        FileUtils.delete(this.getBaseDir() + "/backup.zip");
    }

    private void testConcurrentBackup() throws SQLException {
        if (this.config.networked || !this.config.big) {
            return;
        }
        this.deleteDb("backup");
        String url = this.getURL("backup", true);
        Connection conn = this.getConnection(url);
        final Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test select x, 'Hello' from system_range(1, 2)");
        conn.setAutoCommit(false);
        Connection conn1 = this.getConnection(url);
        final AtomicLong updateEnd = new AtomicLong();
        final Statement stat1 = conn.createStatement();
        Task task = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    if (System.nanoTime() < updateEnd.get()) {
                        stat.execute("update test set name = 'Hallo'");
                        stat1.execute("checkpoint");
                        stat.execute("update test set name = 'Hello'");
                        stat.execute("commit");
                        stat.execute("checkpoint");
                        continue;
                    }
                    Thread.sleep(10L);
                }
            }
        };
        Connection conn2 = this.getConnection(url + ";database_event_listener='" + BackupListener.class.getName() + "'");
        Statement stat2 = conn2.createStatement();
        task.execute();
        int i = 0;
        while (i < 10) {
            updateEnd.set(System.nanoTime() + TimeUnit.SECONDS.toNanos(2L));
            stat2.execute("backup to '" + this.getBaseDir() + "/backup.zip'");
            stat2.execute("checkpoint");
            Restore.execute(this.getBaseDir() + "/backup.zip", this.getBaseDir() + "/t" + i, "backup");
            Connection conn3 = this.getConnection("t" + i + "/backup");
            Statement stat3 = conn3.createStatement();
            stat3.execute("script");
            ResultSet rs = stat3.executeQuery("select * from test where name='Hallo'");
            while (rs.next()) {
                this.fail();
            }
            conn3.close();
            ++i;
        }
        task.get();
        conn2.close();
        conn.close();
        conn1.close();
    }

    private void testBackupRestoreLob() throws SQLException {
        this.deleteDb("backup");
        Connection conn = this.getConnection("backup");
        conn.createStatement().execute("create table test(x clob) as select space(10000)");
        conn.close();
        Backup.execute(this.getBaseDir() + "/backup.zip", this.getBaseDir(), "backup", true);
        this.deleteDb("backup");
        Restore.execute(this.getBaseDir() + "/backup.zip", this.getBaseDir(), "backup");
    }

    private void testBackupRestoreLobStatement() throws SQLException {
        this.deleteDb("backup");
        Connection conn = this.getConnection("backup");
        conn.createStatement().execute("create table test(x clob) as select space(10000)");
        conn.createStatement().execute("backup to '" + this.getBaseDir() + "/backup.zip'");
        conn.close();
        this.deleteDb("backup");
        Restore.execute(this.getBaseDir() + "/backup.zip", this.getBaseDir(), "backup");
    }

    private void testBackup() throws SQLException {
        this.deleteDb("backup");
        this.deleteDb("restored");
        Connection conn1 = this.getConnection("backup");
        Statement stat1 = conn1.createStatement();
        stat1.execute("create table test(id int primary key, name varchar(255))");
        stat1.execute("insert into test values(1, 'first'), (2, 'second')");
        stat1.execute("create table testlob(id int primary key, b blob, c clob)");
        stat1.execute("insert into testlob values(1, repeat(char(0), 10000), space(10000))");
        Connection conn2 = this.getConnection("backup");
        Statement stat2 = conn2.createStatement();
        stat2.execute("insert into test values(3, 'third')");
        conn2.setAutoCommit(false);
        stat2.execute("insert into test values(4, 'fourth (uncommitted)')");
        stat2.execute("insert into testlob values(2, ' ', '00')");
        stat1.execute("backup to '" + this.getBaseDir() + "/backup.zip'");
        conn2.rollback();
        this.assertEqualDatabases(stat1, stat2);
        Restore.execute(this.getBaseDir() + "/backup.zip", this.getBaseDir(), "restored");
        Connection conn3 = this.getConnection("restored");
        Statement stat3 = conn3.createStatement();
        this.assertEqualDatabases(stat1, stat3);
        conn1.close();
        conn2.close();
        conn3.close();
        this.deleteDb("restored");
    }

    public static class BackupListener
    implements DatabaseEventListener {
        @Override
        public void setProgress(int state, String name, long x, long max) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long cfr_ignored_0 = x % 400L;
        }
    }
}

