/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Utils;

public class TestBigDb
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        if (this.config.memory) {
            return false;
        }
        return !this.config.networked || !this.config.big;
    }

    @Override
    public void test() throws SQLException {
        this.testLargeTable();
        this.testInsert();
        this.testLeftSummary();
        this.deleteDb("bigDb");
    }

    private void testLargeTable() throws SQLException {
        this.deleteDb("bigDb");
        Connection conn = this.getConnection("bigDb");
        Statement stat = conn.createStatement();
        stat.execute("CREATE CACHED TABLE TEST(M_CODE CHAR(1) DEFAULT CAST(RAND()*9 AS INT),PRD_CODE CHAR(20) DEFAULT SECURE_RAND(10),ORG_CODE_SUPPLIER CHAR(13) DEFAULT SECURE_RAND(6),PRD_CODE_1 CHAR(14) DEFAULT SECURE_RAND(7),PRD_CODE_2 CHAR(20)  DEFAULT SECURE_RAND(10),ORG_CODE CHAR(13)  DEFAULT SECURE_RAND(6),SUBSTITUTED_BY CHAR(20) DEFAULT SECURE_RAND(10),SUBSTITUTED_BY_2 CHAR(14) DEFAULT SECURE_RAND(7),SUBSTITUTION_FOR CHAR(20) DEFAULT SECURE_RAND(10),SUBSTITUTION_FOR_2 CHAR(14) DEFAULT SECURE_RAND(7),TEST CHAR(2) DEFAULT SECURE_RAND(1),TEST_2 CHAR(2) DEFAULT SECURE_RAND(1),TEST_3 DECIMAL(7,2) DEFAULT RAND(),PRIMARY_UNIT_CODE CHAR(3) DEFAULT SECURE_RAND(1),RATE_PRICE_ORDER_UNIT DECIMAL(9,3) DEFAULT RAND(),ORDER_UNIT_CODE CHAR(3) DEFAULT SECURE_RAND(1),ORDER_QTY_MIN DECIMAL(6,1) DEFAULT RAND(),ORDER_QTY_LOT_SIZE DECIMAL(6,1) DEFAULT RAND(),ORDER_UNIT_CODE_2 CHAR(3) DEFAULT SECURE_RAND(1),PRICE_GROUP CHAR(20) DEFAULT SECURE_RAND(10),LEAD_TIME INTEGER DEFAULT RAND(),LEAD_TIME_UNIT_CODE CHAR(3) DEFAULT SECURE_RAND(1),PRD_GROUP CHAR(10) DEFAULT SECURE_RAND(5),WEIGHT_GROSS DECIMAL(7,3) DEFAULT RAND(),WEIGHT_UNIT_CODE CHAR(3) DEFAULT SECURE_RAND(1),PACK_UNIT_CODE CHAR(3) DEFAULT SECURE_RAND(1),PACK_LENGTH DECIMAL(7,3) DEFAULT RAND(),PACK_WIDTH DECIMAL(7,3) DEFAULT RAND(),PACK_HEIGHT DECIMAL(7,3) DEFAULT RAND(),SIZE_UNIT_CODE CHAR(3) DEFAULT SECURE_RAND(1),STATUS_CODE CHAR(3) DEFAULT SECURE_RAND(1),INTRA_STAT_CODE CHAR(12) DEFAULT SECURE_RAND(6),PRD_TITLE CHAR(50) DEFAULT SECURE_RAND(25),VALID_FROM DATE DEFAULT CURRENT_DATE,MOD_DATUM DATE DEFAULT CURRENT_DATE)");
        int len = this.getSize(10, 50000);
        try {
            PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(PRD_CODE) VALUES('abc' || ?)");
            long time = System.nanoTime();
            int i = 0;
            while (i < len) {
                long t;
                if (i % 1000 == 0 && (t = System.nanoTime()) - time > TimeUnit.SECONDS.toNanos(1L)) {
                    time = t;
                    long free = Utils.getMemoryFree();
                    this.println("i: " + i + " free: " + free + " used: " + Utils.getMemoryUsed());
                }
                prep.setInt(1, i);
                prep.execute();
                ++i;
            }
            stat.execute("CREATE INDEX IDX_TEST_PRD_CODE ON TEST(PRD_CODE)");
            ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                int i2 = 0;
                while (i2 < columns) {
                    rs.getString(i2 + 1);
                    ++i2;
                }
            }
        }
        catch (OutOfMemoryError e) {
            TestBase.logError("memory", e);
            conn.close();
            throw e;
        }
        conn.close();
    }

    private void testLeftSummary() throws SQLException {
        this.deleteDb("bigDb");
        Connection conn = this.getConnection("bigDb");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, NEG INT AS -ID, NAME VARCHAR, PRIMARY KEY(ID, NAME))");
        stat.execute("CREATE INDEX IDX_NEG ON TEST(NEG, NAME)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(ID, NAME) VALUES(?, '1234567890')");
        int len = this.getSize(10, 1000);
        int block = this.getSize(3, 10);
        int x = 0;
        int i = 0;
        while (i < len) {
            int left = x + block / 2;
            int j = 0;
            while (j < block) {
                prep.setInt(1, x++);
                prep.execute();
                ++j;
            }
            stat.execute("DELETE FROM TEST WHERE ID>" + left);
            ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
            rs.next();
            int count = rs.getInt(1);
            this.trace("count: " + count);
            ++i;
        }
        conn.close();
    }

    private void testInsert() throws SQLException {
        this.deleteDb("bigDb");
        Connection conn = this.getConnection("bigDb");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(NAME) VALUES('Hello World')");
        int len = this.getSize(1000, 10000);
        int i = 0;
        while (i < len) {
            if (i % 1000 == 0) {
                this.println("rows: " + i);
                Thread.yield();
            }
            prep.execute();
            ++i;
        }
        conn.close();
    }
}

