/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Locale;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.SimpleResultSet;

public class TestCompatibilityOracle
extends TestDb {
    public static void main(String ... s) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testNotNullSyntax();
        this.testTreatEmptyStringsAsNull();
        this.testDecimalScale();
        this.testPoundSymbolInColumnName();
        this.testToDate();
        this.testSpecialTypes();
        this.testDate();
        this.testSequenceNextval();
        this.testVarchar();
        this.deleteDb("oracle");
    }

    private void testNotNullSyntax() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("create table T (C int not null enable)");
        stat.execute("insert into T values(1)");
        stat.execute("drop table T");
        stat.execute("create table T (C int not null enable validate)");
        stat.execute("insert into T values(1)");
        stat.execute("drop table T");
        stat.execute("create table T (C int not null disable)");
        stat.execute("insert into T values(null)");
        stat.execute("drop table T");
        stat.execute("create table T (C int not null enable novalidate)");
        stat.execute("insert into T values(null)");
        stat.execute("drop table T");
        stat.execute("create table T (C int not null)");
        stat.execute("insert into T values(1)");
        stat.execute("alter table T modify C not null");
        stat.execute("insert into T values(1)");
        stat.execute("alter table T modify C not null enable");
        stat.execute("insert into T values(1)");
        stat.execute("alter table T modify C not null enable validate");
        stat.execute("insert into T values(1)");
        stat.execute("drop table T");
        stat.execute("create table T (C int null)");
        stat.execute("insert into T values(null)");
        stat.execute("alter table T modify C null enable");
        stat.execute("alter table T modify C null enable validate");
        stat.execute("insert into T values(null)");
        stat.execute("alter table T modify C not null disable");
        stat.execute("insert into T values(null)");
        stat.execute("alter table T modify C not null enable novalidate");
        stat.execute("insert into T values(null)");
        stat.execute("drop table T");
        conn.close();
    }

    private void testSpecialTypes() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("create table T (ID NUMBER)");
        stat.execute("alter table T add A_1 VARCHAR(1)");
        stat.execute("alter table T add A_2 VARCHAR2(1)");
        stat.execute("alter table T add B_1 VARCHAR(1 byte)");
        stat.execute("alter table T add B_2 VARCHAR2(1 byte)");
        stat.execute("alter table T add C_1 VARCHAR(1 char)");
        stat.execute("alter table T add C_2 VARCHAR2(1 char)");
        stat.execute("alter table T add B_255 VARCHAR(255 byte)");
        stat.execute("alter table T add C_255 VARCHAR(255 char)");
        stat.execute("drop table T");
        conn.close();
    }

    private void testTreatEmptyStringsAsNull() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE A (ID NUMBER, X VARCHAR2(1))");
        stat.execute("INSERT INTO A VALUES (1, 'a')");
        stat.execute("INSERT INTO A VALUES (2, '')");
        stat.execute("INSERT INTO A VALUES (3, ' ')");
        this.assertResult("3", stat, "SELECT COUNT(*) FROM A");
        this.assertResult("1", stat, "SELECT COUNT(*) FROM A WHERE X IS NULL");
        this.assertResult("2", stat, "SELECT COUNT(*) FROM A WHERE TRIM(X) IS NULL");
        this.assertResult("0", stat, "SELECT COUNT(*) FROM A WHERE X = ''");
        Object[][] objectArray = new Object[3][];
        objectArray[0] = new Object[]{1, "a"};
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = 2;
        objectArray[1] = objectArray2;
        objectArray[2] = new Object[]{3, " "};
        this.assertResult(objectArray, stat, "SELECT * FROM A");
        Object[][] objectArray3 = new Object[3][];
        objectArray3[0] = new Object[]{1, "a"};
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = 2;
        objectArray3[1] = objectArray4;
        Object[] objectArray5 = new Object[2];
        objectArray5[0] = 3;
        objectArray3[2] = objectArray5;
        this.assertResult(objectArray3, stat, "SELECT ID, TRIM(X) FROM A");
        stat.execute("CREATE TABLE B (ID NUMBER, X NUMBER)");
        stat.execute("INSERT INTO B VALUES (1, '5')");
        stat.execute("INSERT INTO B VALUES (2, '')");
        this.assertResult("2", stat, "SELECT COUNT(*) FROM B");
        this.assertResult("1", stat, "SELECT COUNT(*) FROM B WHERE X IS NULL");
        this.assertResult("0", stat, "SELECT COUNT(*) FROM B WHERE X = ''");
        Object[][] objectArray6 = new Object[2][];
        objectArray6[0] = new Object[]{1, 5};
        Object[] objectArray7 = new Object[2];
        objectArray7[0] = 2;
        objectArray6[1] = objectArray7;
        this.assertResult(objectArray6, stat, "SELECT * FROM B");
        stat.execute("CREATE TABLE C (ID NUMBER, X TIMESTAMP)");
        stat.execute("INSERT INTO C VALUES (1, '1979-11-12')");
        stat.execute("INSERT INTO C VALUES (2, '')");
        this.assertResult("2", stat, "SELECT COUNT(*) FROM C");
        this.assertResult("1", stat, "SELECT COUNT(*) FROM C WHERE X IS NULL");
        this.assertResult("0", stat, "SELECT COUNT(*) FROM C WHERE X = ''");
        Object[][] objectArray8 = new Object[2][];
        objectArray8[0] = new Object[]{1, "1979-11-12 00:00:00.0"};
        Object[] objectArray9 = new Object[2];
        objectArray9[0] = 2;
        objectArray8[1] = objectArray9;
        this.assertResult(objectArray8, stat, "SELECT * FROM C");
        stat.execute("CREATE TABLE D (ID NUMBER, X VARCHAR2(1))");
        stat.execute("INSERT INTO D VALUES (1, 'a')");
        stat.execute("SET @FOO = ''");
        stat.execute("INSERT INTO D VALUES (2, @FOO)");
        this.assertResult("2", stat, "SELECT COUNT(*) FROM D");
        this.assertResult("1", stat, "SELECT COUNT(*) FROM D WHERE X IS NULL");
        this.assertResult("0", stat, "SELECT COUNT(*) FROM D WHERE X = ''");
        Object[][] objectArray10 = new Object[2][];
        objectArray10[0] = new Object[]{1, "a"};
        Object[] objectArray11 = new Object[2];
        objectArray11[0] = 2;
        objectArray10[1] = objectArray11;
        this.assertResult(objectArray10, stat, "SELECT * FROM D");
        stat.execute("CREATE TABLE E (ID NUMBER, X RAW(1))");
        stat.execute("INSERT INTO E VALUES (1, HEXTORAW('0A'))");
        stat.execute("INSERT INTO E VALUES (2, '')");
        this.assertResult("2", stat, "SELECT COUNT(*) FROM E");
        this.assertResult("1", stat, "SELECT COUNT(*) FROM E WHERE X IS NULL");
        this.assertResult("0", stat, "SELECT COUNT(*) FROM E WHERE X = ''");
        Object[][] objectArray12 = new Object[2][];
        objectArray12[0] = new Object[]{1, new byte[]{10}};
        Object[] objectArray13 = new Object[2];
        objectArray13[0] = 2;
        objectArray12[1] = objectArray13;
        this.assertResult(objectArray12, stat, "SELECT * FROM E");
        stat.execute("CREATE TABLE F (ID NUMBER, X VARCHAR2(1))");
        stat.execute("INSERT INTO F VALUES (1, 'a')");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO F VALUES (2, ?)");
        prep.setString(1, "");
        prep.execute();
        this.assertResult("2", stat, "SELECT COUNT(*) FROM F");
        this.assertResult("1", stat, "SELECT COUNT(*) FROM F WHERE X IS NULL");
        this.assertResult("0", stat, "SELECT COUNT(*) FROM F WHERE X = ''");
        Object[][] objectArray14 = new Object[2][];
        objectArray14[0] = new Object[]{1, "a"};
        Object[] objectArray15 = new Object[2];
        objectArray15[0] = 2;
        objectArray14[1] = objectArray15;
        this.assertResult(objectArray14, stat, "SELECT * FROM F");
        conn.close();
    }

    private void testDecimalScale() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE A (ID NUMBER, X DECIMAL(9,5))");
        stat.execute("INSERT INTO A VALUES (1, 2)");
        stat.execute("INSERT INTO A VALUES (2, 4.3)");
        stat.execute("INSERT INTO A VALUES (3, '6.78')");
        this.assertResult("3", stat, "SELECT COUNT(*) FROM A");
        this.assertResult(new Object[][]{{1, 2}, {2, 4.3}, {3, 6.78}}, stat, "SELECT * FROM A");
        conn.close();
    }

    private void testPoundSymbolInColumnName() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, U##NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'HelloWorld'), (3, 'HelloWorldWorld')");
        this.assertResult("1", stat, "SELECT ID FROM TEST where U##NAME ='Hello'");
        conn.close();
    }

    private void testToDate() throws SQLException {
        if (this.config.ci || Locale.getDefault() != Locale.ENGLISH) {
            return;
        }
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE DATE_TABLE (ID NUMBER PRIMARY KEY, TEST_VAL TIMESTAMP)");
        stat.execute("INSERT INTO DATE_TABLE VALUES (1, to_date('31-DEC-9999 23:59:59','DD-MON-RRRR HH24:MI:SS'))");
        stat.execute("INSERT INTO DATE_TABLE VALUES (2, to_date('01-JAN-0001 00:00:00','DD-MON-RRRR HH24:MI:SS'))");
        this.assertResultDate("9999-12-31T23:59:59", stat, "SELECT TEST_VAL FROM DATE_TABLE WHERE ID=1");
        this.assertResultDate("0001-01-01T00:00:00", stat, "SELECT TEST_VAL FROM DATE_TABLE WHERE ID=2");
        conn.close();
    }

    private void testDate() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        Timestamp t1 = Timestamp.valueOf("2011-02-03 12:11:10");
        Timestamp t2 = Timestamp.valueOf("1999-10-15 13:14:15");
        Timestamp t3 = Timestamp.valueOf("2030-11-22 11:22:33");
        Timestamp t4 = Timestamp.valueOf("2018-01-10 22:10:01");
        stat.execute("CREATE TABLE TEST (ID INT PRIMARY KEY, D DATE)");
        stat.executeUpdate("INSERT INTO TEST VALUES(1, TIMESTAMP '2011-02-03 12:11:10.1')");
        stat.executeUpdate("INSERT INTO TEST VALUES(2, CAST ('1999-10-15 13:14:15.1' AS DATE))");
        stat.executeUpdate("INSERT INTO TEST VALUES(3, '2030-11-22 11:22:33.1')");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST VALUES (?, ?)");
        ps.setInt(1, 4);
        ps.setTimestamp(2, Timestamp.valueOf("2018-01-10 22:10:01.1"));
        ps.executeUpdate();
        ResultSet rs = stat.executeQuery("SELECT D FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(t1, rs.getTimestamp(1));
        rs.next();
        this.assertEquals(t2, rs.getTimestamp(1));
        rs.next();
        this.assertEquals(t3, rs.getTimestamp(1));
        rs.next();
        this.assertEquals(t4, rs.getTimestamp(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testSequenceNextval() throws SQLException {
        this.checkSequenceTypeWithMode("REGULAR", -5, false);
        this.checkSequenceTypeWithMode("Oracle", 2, true);
    }

    private void checkSequenceTypeWithMode(String mode, int expectedType, boolean usePseudoColumn) throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=" + mode);
        Statement stat = conn.createStatement();
        stat.execute("CREATE SEQUENCE seq");
        ResultSet rs = stat.executeQuery(usePseudoColumn ? "SELECT seq.NEXTVAL FROM DUAL" : "VALUES NEXT VALUE FOR seq");
        this.assertEquals(rs.getMetaData().getColumnType(1), expectedType);
        conn.close();
    }

    private void testVarchar() throws SQLException {
        this.deleteDb("oracle");
        Connection conn = this.getConnection("oracle;MODE=Oracle");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V VARCHAR) AS VALUES (1, 'a')");
        PreparedStatement prep = conn.prepareStatement("UPDATE TEST SET V = ? WHERE ID = ?");
        prep.setInt(2, 1);
        prep.setString(1, "");
        prep.executeUpdate();
        ResultSet rs = stat.executeQuery("SELECT V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(1));
        this.assertFalse(rs.next());
        prep.setNString(1, "");
        prep.executeUpdate();
        Statement stat2 = conn.createStatement(1003, 1008);
        rs = stat2.executeQuery("SELECT ID, V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(2));
        rs.updateString(2, "");
        rs.updateRow();
        this.assertFalse(rs.next());
        rs = stat2.executeQuery("SELECT ID, V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(2));
        rs.updateString("V", "");
        rs.updateRow();
        this.assertFalse(rs.next());
        rs = stat2.executeQuery("SELECT ID, V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(2));
        rs.updateNString(2, "");
        rs.updateRow();
        this.assertFalse(rs.next());
        rs = stat2.executeQuery("SELECT ID, V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(2));
        rs.updateNString("V", "");
        rs.updateRow();
        this.assertFalse(rs.next());
        rs = stat2.executeQuery("SELECT ID, V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(2));
        rs.updateObject(2, (Object)"");
        rs.updateRow();
        this.assertFalse(rs.next());
        rs = stat2.executeQuery("SELECT ID, V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(2));
        rs.updateObject("V", (Object)"");
        rs.updateRow();
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT V FROM TEST");
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void assertResultDate(String expected, Statement stat, String sql) throws SQLException {
        ResultSet rs = stat.executeQuery(sql);
        if (rs.next()) {
            this.assertEquals(LocalDateTime.parse(expected), rs.getObject(1, LocalDateTime.class));
        } else {
            this.assertEquals(expected, null);
        }
    }

    private void assertResult(Object[][] expectedRowsOfValues, Statement stat, String sql) throws SQLException {
        this.assertResult(TestCompatibilityOracle.newSimpleResultSet(expectedRowsOfValues), stat, sql);
    }

    private void assertResult(ResultSet expected, Statement stat, String sql) throws SQLException {
        ResultSet actual = stat.executeQuery(sql);
        int expectedColumnCount = expected.getMetaData().getColumnCount();
        this.assertEquals(expectedColumnCount, actual.getMetaData().getColumnCount());
        block0: while (true) {
            boolean expectedNext = expected.next();
            boolean actualNext = actual.next();
            if (!expectedNext && !actualNext) {
                return;
            }
            if (expectedNext != actualNext) {
                this.fail("number of rows in actual and expected results sets does not match");
            }
            int i = 0;
            while (true) {
                if (i >= expectedColumnCount) continue block0;
                String expectedString = TestCompatibilityOracle.columnResultToString(expected.getObject(i + 1));
                String actualString = TestCompatibilityOracle.columnResultToString(actual.getObject(i + 1));
                this.assertEquals(expectedString, actualString);
                ++i;
            }
            break;
        }
    }

    private static String columnResultToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            return Arrays.deepToString((Object[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        return object.toString();
    }

    private static SimpleResultSet newSimpleResultSet(Object[][] rowsOfValues) {
        SimpleResultSet result = new SimpleResultSet();
        int i = 0;
        while (i < rowsOfValues[0].length) {
            result.addColumn("" + i, 2000, 0, 0);
            ++i;
        }
        i = 0;
        while (i < rowsOfValues.length) {
            result.addRow(rowsOfValues[i]);
            ++i;
        }
        return result;
    }
}

