/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Csv;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class TestCsv
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testWriteColumnHeader();
        this.testCaseSensitiveColumnNames();
        this.testWriteResultSetDataType();
        this.testPreserveWhitespace();
        this.testChangeData();
        this.testOptions();
        this.testPseudoBom();
        this.testWriteRead();
        this.testColumnNames();
        this.testSpaceSeparated();
        this.testNull();
        this.testRandomData();
        this.testEmptyFieldDelimiter();
        this.testFieldDelimiter();
        this.testAsTable();
        this.testRead();
        this.testPipe();
        this.testReadEmptyNumbers1();
        this.testReadEmptyNumbers2();
        this.testCsvQuotedString1();
        this.testCsvQuotedString2();
        this.testCsvQuotedString3();
        this.testCsvQuotedString4();
        this.testCsvQuotedString5();
        this.testCsvQuotedString6();
        this.deleteDb("csv");
    }

    private void testWriteColumnHeader() throws Exception {
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("call csvwrite('" + this.getBaseDir() + "/test.tsv', 'select x from system_range(1, 1)', 'writeColumnHeader=false')");
        String x = IOUtils.readStringAndClose(IOUtils.getReader(FileUtils.newInputStream(this.getBaseDir() + "/test.tsv")), -1);
        this.assertEquals("\"1\"", x.trim());
        stat.execute("call csvwrite('" + this.getBaseDir() + "/test.tsv', 'select x from system_range(1, 1)', 'writeColumnHeader=true')");
        x = IOUtils.readStringAndClose(IOUtils.getReader(FileUtils.newInputStream(this.getBaseDir() + "/test.tsv")), -1);
        x = x.trim();
        this.assertTrue(x.startsWith("\"X\""));
        this.assertTrue(x.endsWith("\"1\""));
        conn.close();
    }

    private void testWriteResultSetDataType() throws Exception {
        StringWriter writer = new StringWriter();
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select timestamp '-100-01-01 12:00:00.0' ts, null n");
        Csv csv = new Csv();
        csv.setFieldDelimiter('\u0000');
        csv.setLineSeparator(";");
        csv.write(writer, rs);
        conn.close();
        this.assertEquals("TS,N;-0100-01-01 12:00:00,;", writer.toString());
    }

    private void testCaseSensitiveColumnNames() throws Exception {
        OutputStream out = FileUtils.newOutputStream(this.getBaseDir() + "/test.tsv", false);
        out.write("lower,Mixed,UPPER\n 1 , 2, 3 \n".getBytes());
        out.close();
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv')");
        rs.next();
        this.assertEquals("LOWER", rs.getMetaData().getColumnName(1));
        this.assertEquals("MIXED", rs.getMetaData().getColumnName(2));
        this.assertEquals("UPPER", rs.getMetaData().getColumnName(3));
        rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv', null, 'caseSensitiveColumnNames=true')");
        rs.next();
        this.assertEquals("lower", rs.getMetaData().getColumnName(1));
        this.assertEquals("Mixed", rs.getMetaData().getColumnName(2));
        this.assertEquals("UPPER", rs.getMetaData().getColumnName(3));
        conn.close();
    }

    private void testPreserveWhitespace() throws Exception {
        OutputStream out = FileUtils.newOutputStream(this.getBaseDir() + "/test.tsv", false);
        out.write("a,b\n 1 , 2 \n".getBytes());
        out.close();
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv')");
        rs.next();
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("2", rs.getString(2));
        rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv', null, 'preserveWhitespace=true')");
        rs.next();
        this.assertEquals(" 1 ", rs.getString(1));
        this.assertEquals(" 2 ", rs.getString(2));
        conn.close();
    }

    private void testChangeData() throws Exception {
        OutputStream out = FileUtils.newOutputStream(this.getBaseDir() + "/test.tsv", false);
        out.write("a,b,c,d,e,f,g\n1".getBytes());
        out.close();
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv')");
        this.assertEquals(7, rs.getMetaData().getColumnCount());
        this.assertEquals("A", rs.getMetaData().getColumnLabel(1));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        out = FileUtils.newOutputStream(this.getBaseDir() + "/test.tsv", false);
        out.write("x".getBytes());
        out.close();
        rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv')");
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("X", rs.getMetaData().getColumnLabel(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testOptions() {
        Csv csv = new Csv();
        this.assertEquals(",", csv.getFieldSeparatorWrite());
        this.assertEquals(System.lineSeparator(), csv.getLineSeparator());
        this.assertEquals("", csv.getNullString());
        this.assertEquals(34, csv.getEscapeCharacter());
        this.assertEquals(34, csv.getFieldDelimiter());
        this.assertEquals(44, csv.getFieldSeparatorRead());
        this.assertEquals(",", csv.getFieldSeparatorWrite());
        this.assertEquals(0, csv.getLineCommentCharacter());
        this.assertEquals(false, csv.getPreserveWhitespace());
        String charset = csv.setOptions("escape=\\  fieldDelimiter=\\\\ fieldSeparator=\n lineComment=\" lineSeparator=\\ \\\\\\ ");
        this.assertEquals(32, csv.getEscapeCharacter());
        this.assertEquals(92, csv.getFieldDelimiter());
        this.assertEquals(10, csv.getFieldSeparatorRead());
        this.assertEquals("\n", csv.getFieldSeparatorWrite());
        this.assertEquals(34, csv.getLineCommentCharacter());
        this.assertEquals(" \\ ", csv.getLineSeparator());
        this.assertFalse(csv.getPreserveWhitespace());
        this.assertFalse(csv.getCaseSensitiveColumnNames());
        charset = csv.setOptions("escape=1x fieldDelimiter=2x fieldSeparator=3x lineComment=4x lineSeparator=5x null=6x charset=7x preserveWhitespace=true caseSensitiveColumnNames=true");
        this.assertEquals(49, csv.getEscapeCharacter());
        this.assertEquals(50, csv.getFieldDelimiter());
        this.assertEquals(51, csv.getFieldSeparatorRead());
        this.assertEquals("3x", csv.getFieldSeparatorWrite());
        this.assertEquals(52, csv.getLineCommentCharacter());
        this.assertEquals("5x", csv.getLineSeparator());
        this.assertEquals("6x", csv.getNullString());
        this.assertEquals("7x", charset);
        this.assertTrue(csv.getPreserveWhitespace());
        this.assertTrue(csv.getCaseSensitiveColumnNames());
        charset = csv.setOptions("escape= fieldDelimiter= fieldSeparator= lineComment= lineSeparator=\r\n null=\u0000 charset=");
        this.assertEquals(0, csv.getEscapeCharacter());
        this.assertEquals(0, csv.getFieldDelimiter());
        this.assertEquals(0, csv.getFieldSeparatorRead());
        this.assertEquals("", csv.getFieldSeparatorWrite());
        this.assertEquals(0, csv.getLineCommentCharacter());
        this.assertEquals("\r\n", csv.getLineSeparator());
        this.assertEquals("\u0000", csv.getNullString());
        this.assertEquals("", charset);
        this.assertThrows(50100, () -> csv.setOptions("escape=a error=b"));
        this.assertEquals(97, csv.getEscapeCharacter());
    }

    private void testPseudoBom() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(StringUtils.convertHexToBytes("efbbbf"));
        out.write("\"ID\", \"NAME\"\n1, Hello".getBytes(StandardCharsets.UTF_8));
        byte[] buff = out.toByteArray();
        InputStreamReader r = new InputStreamReader((InputStream)new ByteArrayInputStream(buff), StandardCharsets.UTF_8);
        ResultSet rs = new Csv().read(r, null);
        this.assertEquals("ID", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("NAME", rs.getMetaData().getColumnLabel(2));
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
    }

    private void testColumnNames() throws Exception {
        ResultSet rs = new Csv().read(new StringReader("Id,First Name,2x,_x2\n1,2,3"), null);
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("First Name", rs.getMetaData().getColumnName(2));
        this.assertEquals("2x", rs.getMetaData().getColumnName(3));
        this.assertEquals("_X2", rs.getMetaData().getColumnName(4));
        rs = new Csv().read(new StringReader("a,a\n1,2"), null);
        this.assertEquals("A", rs.getMetaData().getColumnName(1));
        this.assertEquals("A1", rs.getMetaData().getColumnName(2));
        String[] stringArray = new String[2];
        stringArray[0] = "";
        rs = new Csv().read(new StringReader("1,2"), stringArray);
        this.assertEquals("C1", rs.getMetaData().getColumnName(1));
        this.assertEquals("C2", rs.getMetaData().getColumnName(2));
    }

    private void testSpaceSeparated() throws SQLException {
        this.deleteDb("csv");
        File f = new File(this.getBaseDir() + "/testSpace.csv");
        FileUtils.delete(f.getAbsolutePath());
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("create temporary table test (a int, b int, c int)");
        stat.execute("insert into test values(1,2,3)");
        stat.execute("insert into test values(4,null,5)");
        stat.execute("call csvwrite('" + this.getBaseDir() + "/test.tsv','select * from test',null,' ')");
        ResultSet rs1 = stat.executeQuery("select * from test");
        String[][] stringArray = new String[2][];
        stringArray[0] = new String[]{"1", "2", "3"};
        String[] stringArray2 = new String[3];
        stringArray2[0] = "4";
        stringArray2[2] = "5";
        stringArray[1] = stringArray2;
        this.assertResultSetOrdered(rs1, stringArray);
        ResultSet rs2 = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.tsv',null,null,' ')");
        String[][] stringArray3 = new String[2][];
        stringArray3[0] = new String[]{"1", "2", "3"};
        String[] stringArray4 = new String[3];
        stringArray4[0] = "4";
        stringArray4[2] = "5";
        stringArray3[1] = stringArray4;
        this.assertResultSetOrdered(rs2, stringArray3);
        conn.close();
        FileUtils.delete(f.getAbsolutePath());
        FileUtils.delete(this.getBaseDir() + "/test.tsv");
    }

    private void testNull() throws Exception {
        this.deleteDb("csv");
        String fileName = this.getBaseDir() + "/testNull.csv";
        FileUtils.delete(fileName);
        OutputStream out = FileUtils.newOutputStream(fileName, false);
        String csvContent = "\"A\",\"B\",\"C\",\"D\"\n\\N,\"\",\"\\N\",";
        byte[] b = csvContent.getBytes(StandardCharsets.UTF_8);
        out.write(b, 0, b.length);
        out.close();
        Csv csv = new Csv();
        csv.setNullString("\\N");
        ResultSet rs = csv.read(fileName, null, "UTF8");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(4, meta.getColumnCount());
        this.assertEquals("A", meta.getColumnLabel(1));
        this.assertEquals("B", meta.getColumnLabel(2));
        this.assertEquals("C", meta.getColumnLabel(3));
        this.assertEquals("D", meta.getColumnLabel(4));
        this.assertTrue(rs.next());
        this.assertEquals(null, rs.getString(1));
        this.assertEquals("", rs.getString(2));
        this.assertEquals("\\N", rs.getString(3));
        this.assertEquals(null, rs.getString(4));
        this.assertFalse(rs.next());
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("call csvwrite('" + fileName + "', 'select NULL as a, '''' as b, ''\\N'' as c, NULL as d', 'UTF8', ',', '\"', NULL, '\\N', '\n')");
        InputStreamReader reader = new InputStreamReader(FileUtils.newInputStream(fileName));
        String data = IOUtils.readStringAndClose(reader, -1);
        this.assertEquals(csvContent + "\\N", data.trim());
        conn.close();
        FileUtils.delete(fileName);
    }

    private void testRandomData() throws SQLException {
        this.deleteDb("csv");
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists test");
        stat.execute("create table test(id identity, a varchar, b varchar)");
        int len = this.getSize(1000, 10000);
        PreparedStatement prep = conn.prepareStatement("insert into test(a, b) values(?, ?)");
        ArrayList<String[]> list = new ArrayList<String[]>(len);
        Random random = new Random(1L);
        int i = 0;
        while (i < len) {
            String a = TestCsv.randomData(random);
            String b = TestCsv.randomData(random);
            prep.setString(1, a);
            prep.setString(2, b);
            list.add(new String[]{a, b});
            prep.execute();
            ++i;
        }
        stat.execute("call csvwrite('" + this.getBaseDir() + "/test.csv', 'select a, b from test order by id', 'UTF-8', '|', '#')");
        Csv csv = new Csv();
        csv.setFieldSeparatorRead('|');
        csv.setFieldDelimiter('#');
        ResultSet rs = csv.read(this.getBaseDir() + "/test.csv", null, "UTF-8");
        int i2 = 0;
        while (i2 < len) {
            this.assertTrue(rs.next());
            String[] pair = (String[])list.get(i2);
            this.assertEquals(pair[0], rs.getString(1));
            this.assertEquals(pair[1], rs.getString(2));
            ++i2;
        }
        this.assertFalse(rs.next());
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/test.csv");
    }

    private static String randomData(Random random) {
        if (random.nextInt(10) == 1) {
            return null;
        }
        int len = random.nextInt(5);
        StringBuilder buff = new StringBuilder();
        String chars = "\\'\",\r\n\t ;.-123456|#";
        int i = 0;
        while (i < len) {
            buff.append(chars.charAt(random.nextInt(chars.length())));
            ++i;
        }
        return buff.toString();
    }

    private void testEmptyFieldDelimiter() throws Exception {
        String fileName = this.getBaseDir() + "/test.csv";
        FileUtils.delete(fileName);
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("call csvwrite('" + fileName + "', 'select 1 id, ''Hello'' name', null, '|', '', null, null, chr(10))");
        InputStreamReader reader = new InputStreamReader(FileUtils.newInputStream(fileName));
        String text = IOUtils.readStringAndClose(reader, -1).trim();
        text = text.replace('\n', ' ');
        this.assertEquals("ID|NAME 1|Hello", text);
        ResultSet rs = stat.executeQuery("select * from csvread('" + fileName + "', null, null, '|', '')");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(2, meta.getColumnCount());
        this.assertEquals("ID", meta.getColumnLabel(1));
        this.assertEquals("NAME", meta.getColumnLabel(2));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        conn.close();
        FileUtils.delete(fileName);
    }

    private void testFieldDelimiter() throws Exception {
        String fileName = this.getBaseDir() + "/test.csv";
        String fileName2 = this.getBaseDir() + "/test2.csv";
        FileUtils.delete(fileName);
        OutputStream out = FileUtils.newOutputStream(fileName, false);
        byte[] b = "'A'; 'B'\n'It\\'s nice'; '\nHello\\*\n'".getBytes();
        out.write(b, 0, b.length);
        out.close();
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from csvread('" + fileName + "', null, null, ';', '''', '\\')");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(2, meta.getColumnCount());
        this.assertEquals("A", meta.getColumnLabel(1));
        this.assertEquals("B", meta.getColumnLabel(2));
        this.assertTrue(rs.next());
        this.assertEquals("It's nice", rs.getString(1));
        this.assertEquals("\nHello*\n", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("call csvwrite('" + fileName2 + "', 'select * from csvread(''" + fileName + "'', null, null, '';'', '''''''', ''\\'')', null, '+', '*', '#')");
        rs = stat.executeQuery("select * from csvread('" + fileName2 + "', null, null, '+', '*', '#')");
        meta = rs.getMetaData();
        this.assertEquals(2, meta.getColumnCount());
        this.assertEquals("A", meta.getColumnLabel(1));
        this.assertEquals("B", meta.getColumnLabel(2));
        this.assertTrue(rs.next());
        this.assertEquals("It's nice", rs.getString(1));
        this.assertEquals("\nHello*\n", rs.getString(2));
        this.assertFalse(rs.next());
        conn.close();
        FileUtils.delete(fileName);
        FileUtils.delete(fileName2);
    }

    private void testPipe() throws SQLException {
        this.deleteDb("csv");
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("call csvwrite('" + this.getBaseDir() + "/test.csv', 'select 1 id, ''Hello'' name', 'utf-8', '|')");
        ResultSet rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.csv', null, 'utf-8', '|')");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        new File(this.getBaseDir() + "/test.csv").delete();
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/test.csv");
    }

    private void testAsTable() throws SQLException {
        this.deleteDb("csv");
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("call csvwrite('" + this.getBaseDir() + "/test.csv', 'select 1 id, ''Hello'' name')");
        ResultSet rs = stat.executeQuery("select name from csvread('" + this.getBaseDir() + "/test.csv')");
        this.assertTrue(rs.next());
        this.assertEquals("Hello", rs.getString(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select * from csvread('" + this.getBaseDir() + "/test.csv')");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        new File(this.getBaseDir() + "/test.csv").delete();
        conn.close();
    }

    private void testRead() throws Exception {
        String fileName = this.getBaseDir() + "/test.csv";
        FileUtils.delete(fileName);
        OutputStream out = FileUtils.newOutputStream(fileName, false);
        byte[] b = "a,b,c,d\n201,-2,0,18\n, \"abc\"\"\" ,,\"\"\n 1 ,2 , 3, 4 \n5, 6, 7, 8".getBytes();
        out.write(b, 0, b.length);
        out.close();
        ResultSet rs = new Csv().read(fileName, null, "UTF8");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(4, meta.getColumnCount());
        this.assertEquals("A", meta.getColumnLabel(1));
        this.assertEquals("B", meta.getColumnLabel(2));
        this.assertEquals("C", meta.getColumnLabel(3));
        this.assertEquals("D", meta.getColumnLabel(4));
        this.assertTrue(rs.next());
        this.assertEquals("201", rs.getString(1));
        this.assertEquals("-2", rs.getString(2));
        this.assertEquals("0", rs.getString(3));
        this.assertEquals("18", rs.getString(4));
        this.assertTrue(rs.next());
        this.assertEquals(null, rs.getString(1));
        this.assertEquals("abc\"", rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertEquals("", rs.getString(4));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("2", rs.getString(2));
        this.assertEquals("3", rs.getString(3));
        this.assertEquals("4", rs.getString(4));
        this.assertTrue(rs.next());
        this.assertEquals("5", rs.getString(1));
        this.assertEquals("6", rs.getString(2));
        this.assertEquals("7", rs.getString(3));
        this.assertEquals("8", rs.getString(4));
        this.assertFalse(rs.next());
        FileUtils.delete(fileName);
    }

    private void testWriteRead() throws SQLException {
        ResultSet rs;
        this.deleteDb("csv");
        Connection conn = this.getConnection("csv");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
        int len = 100;
        int i = 0;
        while (i < len) {
            stat.execute("INSERT INTO TEST(NAME) VALUES('Ruebezahl')");
            ++i;
        }
        long time = System.nanoTime();
        new Csv().write(conn, this.getBaseDir() + "/testRW.csv", "SELECT X ID, 'Ruebezahl' NAME FROM SYSTEM_RANGE(1, " + len + ")", "UTF8");
        this.trace("write: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        time = System.nanoTime();
        int i2 = 0;
        while (i2 < 30) {
            rs = new Csv().read(this.getBaseDir() + "/testRW.csv", null, "UTF8");
            while (rs.next()) {
            }
            ++i2;
        }
        this.trace("read: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        rs = new Csv().read(this.getBaseDir() + "/testRW.csv", null, "UTF8");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(2, meta.getColumnCount());
        int i3 = 0;
        while (i3 < len) {
            rs.next();
            this.assertEquals("" + (i3 + 1), rs.getString("ID"));
            this.assertEquals("Ruebezahl", rs.getString("NAME"));
            ++i3;
        }
        this.assertFalse(rs.next());
        rs.close();
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/testRW.csv");
    }

    private void testReadEmptyNumbers1() throws Exception {
        String fileName = this.getBaseDir() + "/test.csv";
        FileUtils.delete(fileName);
        OutputStream out = FileUtils.newOutputStream(fileName, false);
        byte[] b = "\"TEST\"\n\"100.22\"\n\"\"\n".getBytes();
        out.write(b, 0, b.length);
        out.close();
        Csv csv = new Csv();
        csv.setQuotedNulls(true);
        ResultSet rs = csv.read(fileName, null, "UTF8");
        this.assertTrue(rs.next());
        this.assertNotNull(rs.getString(1));
        this.assertTrue(rs.next());
        this.assertNull(rs.getString(1));
        this.assertFalse(rs.next());
        FileUtils.delete(fileName);
    }

    private void testReadEmptyNumbers2() throws Exception {
        String fileName = this.getBaseDir() + "/test.csv";
        FileUtils.delete(fileName);
        OutputStream out = FileUtils.newOutputStream(fileName, false);
        byte[] b = "\"TEST\"\n\"100.22\"\n\"\"".getBytes();
        out.write(b, 0, b.length);
        out.close();
        this.deleteDb("csv");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:test");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(TEST DECIMAL(12,2) NULL)");
        stat.execute("INSERT INTO TEST SELECT * FROM CsvRead('" + fileName + "', NULL, 'quotedNulls=true')");
        FileUtils.delete(fileName);
    }

    private void testCsvQuotedString1() throws Exception {
        this.testCsvQuotedNullStrings(false, "NULL");
    }

    private void testCsvQuotedString2() throws Exception {
        this.testCsvQuotedNullStrings(true, "NULL");
    }

    private void testCsvQuotedString3() throws Exception {
        this.testCsvQuotedNullStrings(false, "");
    }

    private void testCsvQuotedString4() throws Exception {
        this.testCsvQuotedNullStrings(true, "");
    }

    private void testCsvQuotedString5() throws Exception {
        this.testCsvQuotedNullStrings(false, "$empty");
    }

    private void testCsvQuotedString6() throws Exception {
        this.testCsvQuotedNullStrings(true, "$empty");
    }

    private void testCsvQuotedNullStrings(boolean quotedStrings, String nullString) throws Exception {
        String fileName = this.getBaseDir() + "/test.csv";
        FileUtils.delete(fileName);
        this.deleteDb("csv");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:test");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID char(2) NOT NULL, NAME varchar(255), HEIGHT integer, BIRTHDATE date, PRIMARY KEY (ID))");
        stat.execute("INSERT INTO TEST VALUES('01', 'Penrosed Roberto', 511, '1958-03-29')");
        stat.execute("INSERT INTO TEST VALUES('02', NULL, 512, '1975-07-12')");
        stat.execute("INSERT INTO TEST VALUES('03', 'Smith John', NULL, '1971-11-03')");
        stat.execute("INSERT INTO TEST VALUES('04', 'Hatchet Eve', 500, NULL)");
        stat.execute("INSERT INTO TEST VALUES('05', NULL, NULL, NULL)");
        stat.execute("CALL CSVWRITE('" + fileName + "', 'SELECT * FROM TEST ORDER BY ID','quotedNulls=" + quotedStrings + " nullString=" + nullString + "')");
        InputStream fis = FileUtils.newInputStream(fileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = fis.read(buffer);
        while (read >= 0) {
            baos.write(buffer, 0, read);
            read = fis.read(buffer);
        }
        baos.close();
        fis.close();
        String csvWrittenContent = new String(baos.toByteArray());
        if (quotedStrings) {
            this.assertTrue(csvWrittenContent.contains("\"" + nullString + "\""));
        } else {
            this.assertTrue(csvWrittenContent.contains(nullString));
            this.assertFalse(csvWrittenContent.contains("\"" + nullString + "\""));
        }
        stat.execute("DELETE FROM TEST");
        stat.execute("INSERT INTO TEST SELECT * FROM CSVREAD('" + fileName + "', NULL, 'quotedNulls=" + quotedStrings + " nullString=" + nullString + "')");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int i = 1;
        while (i <= 5) {
            this.assertTrue("Missing record " + i, rs.next());
            if (i == 1) {
                this.assertEquals("Penrosed Roberto", rs.getString("NAME"));
                this.assertEquals(511, rs.getInt("HEIGHT"));
                this.assertEquals(LocalDate.of(1958, 3, 29), rs.getObject("BIRTHDATE", LocalDate.class));
            } else if (i == 2) {
                this.assertNull(rs.getString("NAME"));
            } else if (i == 3) {
                this.assertNull(rs.getObject("HEIGHT"));
            } else if (i == 4) {
                this.assertNull(rs.getDate("BIRTHDATE"));
            } else {
                this.assertNull(rs.getString("NAME"));
                this.assertNull(rs.getObject("HEIGHT"));
                this.assertNull(rs.getDate("BIRTHDATE"));
            }
            ++i;
        }
        rs.close();
        FileUtils.delete(fileName);
    }
}

