/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.h2.fulltext.FullText;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.IOUtils;
import org.h2.util.Task;

public class TestFullText
extends TestDb {
    static final String[] KNOWN_WORDS = new String[]{"skiing", "balance", "storage", "water", "train"};
    private static final String LUCENE_FULLTEXT_CLASS_NAME = "org.h2.fulltext.FullTextLucene";

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testUuidPrimaryKey(false);
        this.testAutoAnalyze();
        this.testNativeFeatures();
        this.testTransaction(false);
        this.testCreateDropNative();
        this.testStreamLob();
        this.test(false, "VARCHAR");
        this.test(false, "CLOB");
        this.testPerformance(false);
        this.testReopen(false);
        this.testDropIndex(false);
        if (!this.config.reopen) {
            try {
                Class.forName(LUCENE_FULLTEXT_CLASS_NAME);
                this.testCreateDropLucene();
                this.testUuidPrimaryKey(true);
                this.testMultiThreaded(true);
                this.testMultiThreaded(false);
                this.testTransaction(true);
                this.test(true, "VARCHAR");
                this.test(true, "CLOB");
                this.testPerformance(true);
                this.testReopen(true);
                this.testDropIndex(true);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.println("Class not found, not tested: org.h2.fulltext.FullTextLucene");
            }
            FullText.closeAll();
        }
        this.deleteDb("fullText");
        this.deleteDb("fullTextReopen");
    }

    private static void close(Collection<Connection> list) {
        for (Connection conn : list) {
            IOUtils.closeSilently(conn);
        }
    }

    private Connection getConnection(String name, Collection<Connection> list) throws SQLException {
        Connection conn = this.getConnection(name + ";MODE=STRICT");
        list.add(conn);
        return conn;
    }

    private void testAutoAnalyze() throws SQLException {
        this.deleteDb("fullTextNative");
        ArrayList<Connection> connList = new ArrayList<Connection>();
        Connection conn = this.getConnection("fullTextNative", connList);
        Statement stat = conn.createStatement();
        stat.execute("create alias if not exists ft_init for 'org.h2.fulltext.FullText.init'");
        stat.execute("call ft_init()");
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("call ft_create_index('PUBLIC', 'TEST', 'NAME')");
        if (!this.config.memory) {
            conn.close();
        }
        conn = this.getConnection("fullTextNative", connList);
        stat = conn.createStatement();
        stat.execute("insert into test select x, 'x' from system_range(1, 3000)");
        TestFullText.close(connList);
    }

    private void testNativeFeatures() throws SQLException {
        this.deleteDb("fullTextNative");
        ArrayList<Connection> connList = new ArrayList<Connection>();
        Connection conn = this.getConnection("fullTextNative", connList);
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_INIT FOR 'org.h2.fulltext.FullText.init'");
        stat.execute("CALL FT_INIT()");
        FullText.setIgnoreList(conn, "to,this");
        FullText.setWhitespaceChars(conn, " ,.-");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Welcome to this world, One_Word')");
        stat.execute("CALL FT_CREATE_INDEX('PUBLIC', 'TEST', NULL)");
        ResultSet rs = stat.executeQuery("SELECT * FROM FT_SEARCH('Welcome', 0, 0)");
        this.assertTrue(rs.next());
        this.assertEquals("QUERY", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("SCORE", rs.getMetaData().getColumnLabel(2));
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=1", rs.getString(1));
        this.assertEquals("1.0", rs.getString(2));
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH_DATA('One', 0, 0)");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH_DATA('One_Word', 0, 0)");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH_DATA('Welcome', 0, 0)");
        this.assertTrue(rs.next());
        this.assertEquals("SCHEMA", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("TABLE", rs.getMetaData().getColumnLabel(2));
        this.assertEquals("COLUMNS", rs.getMetaData().getColumnLabel(3));
        this.assertEquals("KEYS", rs.getMetaData().getColumnLabel(4));
        this.assertEquals("PUBLIC", rs.getString(1));
        this.assertEquals("TEST", rs.getString(2));
        this.assertEquals("[ID]", rs.getString(3));
        this.assertEquals("[1]", rs.getString(4));
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH('this', 0, 0)");
        this.assertFalse(rs.next());
        if (!this.config.memory) {
            conn.close();
        }
        conn = this.getConnection("fullTextNative", connList);
        stat = conn.createStatement();
        conn.setAutoCommit(false);
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH_DATA('Welcome', 0, 0)");
        this.assertTrue(rs.next());
        stat.execute("delete from test");
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH_DATA('Welcome', 0, 0)");
        this.assertFalse(rs.next());
        conn.rollback();
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH_DATA('Welcome', 0, 0)");
        this.assertTrue(rs.next());
        conn.setAutoCommit(true);
        TestFullText.close(connList);
    }

    private void testUuidPrimaryKey(boolean lucene) throws SQLException {
        this.deleteDb("fullText");
        Connection conn = this.getConnection("fullText");
        Statement stat = conn.createStatement();
        String prefix = lucene ? "FTL" : "FT";
        TestFullText.initFullText(stat, lucene);
        stat.execute("CREATE TABLE TEST(ID UUID PRIMARY KEY, NAME VARCHAR)");
        String id = UUID.randomUUID().toString();
        stat.execute("INSERT INTO TEST VALUES('" + id + "', 'Hello World')");
        stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', 'TEST', 'NAME')");
        ResultSet rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('Hello', 0, 0)");
        this.assertTrue(rs.next());
        stat.execute("UPDATE TEST SET NAME=NULL WHERE ID='" + id + "'");
        rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('Hello', 0, 0)");
        this.assertFalse(rs.next());
        stat.execute("UPDATE TEST SET NAME='Good Bye' WHERE ID='" + id + "'");
        rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('bye', 0, 0)");
        this.assertTrue(rs.next());
        FullText.dropAll(conn);
        conn.close();
        this.deleteDb("fullText");
    }

    private void testTransaction(boolean lucene) throws SQLException {
        String prefix = lucene ? "FTL" : "FT";
        this.deleteDb("fullTextTransaction");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullTextTransaction", false);
        ArrayList<Connection> connList = new ArrayList<Connection>();
        Connection conn = this.getConnection("fullTextTransaction", connList);
        Statement stat = conn.createStatement();
        TestFullText.initFullText(stat, lucene);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello World')");
        stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', 'TEST', NULL)");
        ResultSet rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('Hello', 0, 0)");
        this.assertTrue(rs.next());
        stat.execute("UPDATE TEST SET NAME=NULL WHERE ID=1");
        stat.execute("UPDATE TEST SET NAME='Hello World' WHERE ID=1");
        conn.setAutoCommit(false);
        stat.execute("insert into test values(2, 'Hello Moon!')");
        conn.rollback();
        if (!this.config.memory) {
            conn.close();
        }
        conn = this.getConnection("fullTextTransaction", connList);
        stat = conn.createStatement();
        rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('Hello', 0, 0)");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('Moon', 0, 0)");
        this.assertFalse(rs.next());
        FullText.dropAll(conn);
        TestFullText.close(connList);
        this.deleteDb("fullTextTransaction");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullTextTransaction", false);
    }

    private void testMultiThreaded(boolean lucene) throws Exception {
        final String prefix = lucene ? "FTL" : "FT";
        this.trace("Testing multithreaded " + prefix);
        this.deleteDb("fullText");
        ArrayList<Connection> connList = new ArrayList<Connection>();
        try {
            int len = 2;
            Task[] task = new Task[len];
            int i = 0;
            while (i < len) {
                final Connection conn = this.getConnection("fullText;LOCK_TIMEOUT=60000", connList);
                Statement stat = conn.createStatement();
                TestFullText.initFullText(stat, lucene);
                TestFullText.initFullText(stat, lucene);
                final String tableName = "TEST" + i;
                stat.execute("CREATE TABLE " + tableName + "(ID INT PRIMARY KEY, DATA VARCHAR)");
                stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', '" + tableName + "', NULL)");
                task[i] = new Task(){

                    @Override
                    public void call() throws SQLException {
                        TestFullText.this.trace("starting thread " + String.valueOf(Thread.currentThread()));
                        PreparedStatement prep = conn.prepareStatement("INSERT INTO " + tableName + " VALUES(?, ?)");
                        Statement stat = conn.createStatement();
                        Random random = new Random();
                        int x = 0;
                        while (!this.stop) {
                            TestFullText.this.trace("stop = " + this.stop + " for " + String.valueOf(Thread.currentThread()));
                            StringBuilder buff = new StringBuilder();
                            int j = 0;
                            while (j < 1000) {
                                buff.append(" ").append(random.nextInt(10000));
                                buff.append(" x").append(j);
                                buff.append(" ").append(KNOWN_WORDS[j % KNOWN_WORDS.length]);
                                ++j;
                            }
                            prep.setInt(1, x);
                            prep.setString(2, buff.toString());
                            prep.execute();
                            ++x;
                            String[] stringArray = KNOWN_WORDS;
                            int n = KNOWN_WORDS.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String knownWord = stringArray[n2];
                                TestFullText.this.trace("searching for " + knownWord + " with " + String.valueOf(Thread.currentThread()));
                                ResultSet rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('" + knownWord + "', 0, 0)");
                                TestFullText.this.assertTrue(rs.next());
                                ++n2;
                            }
                        }
                        TestFullText.this.trace("closing connection");
                        if (!TestFullText.this.config.memory) {
                            conn.close();
                        }
                        TestFullText.this.trace("completed thread " + String.valueOf(Thread.currentThread()));
                    }
                };
                ++i;
            }
            Task[] taskArray = task;
            int n = task.length;
            int n2 = 0;
            while (n2 < n) {
                Task t = taskArray[n2];
                t.execute();
                ++n2;
            }
            this.trace("sleeping");
            Thread.sleep(1000L);
            this.trace("setting stop to true");
            taskArray = task;
            n = task.length;
            n2 = 0;
            while (n2 < n) {
                Task t = taskArray[n2];
                this.trace("joining " + String.valueOf(t));
                t.get();
                this.trace("done joining " + String.valueOf(t));
                ++n2;
            }
        }
        finally {
            TestFullText.close(connList);
        }
    }

    private void testStreamLob() throws SQLException {
        this.deleteDb("fullText");
        Connection conn = this.getConnection("fullText");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_INIT FOR 'org.h2.fulltext.FullText.init'");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA CLOB)");
        FullText.createIndex(conn, "PUBLIC", "TEST", null);
        conn.setAutoCommit(false);
        stat.execute("insert into test values(1, 'Hello Moon!')");
        conn.rollback();
        conn.setAutoCommit(true);
        stat.execute("insert into test values(0, 'Hello World!')");
        PreparedStatement prep = conn.prepareStatement("insert into test values(1, ?)");
        int length = 0x100000;
        prep.setCharacterStream(1, new Reader(){
            int remaining = 0x100000;

            @Override
            public void close() {
            }

            @Override
            public int read(char[] buff, int off, int len) {
                if (this.remaining >= len) {
                    this.remaining -= len;
                    return len;
                }
                this.remaining = -1;
                return -1;
            }
        }, 0x100000);
        prep.execute();
        ResultSet rs = stat.executeQuery("SELECT * FROM FT_SEARCH('World', 0, 0)");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("SELECT * FROM FT_SEARCH('Moon', 0, 0)");
        this.assertFalse(rs.next());
        FullText.dropAll(conn);
        conn.close();
        this.deleteDb("fullText");
    }

    private void testCreateDropNative() throws SQLException {
        this.deleteDb("fullText");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullText", false);
        Connection conn = this.getConnection("fullText");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_INIT FOR 'org.h2.fulltext.FullText.init'");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        int i = 0;
        while (i < 10) {
            FullText.createIndex(conn, "PUBLIC", "TEST", null);
            FullText.dropIndex(conn, "PUBLIC", "TEST");
            ++i;
        }
        conn.close();
        this.deleteDb("fullText");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullText", false);
    }

    private void testCreateDropLucene() throws SQLException, SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.deleteDb("fullText");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullText", false);
        Connection conn = this.getConnection("fullText");
        Statement stat = conn.createStatement();
        TestFullText.initFullText(stat, true);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        Method createIndexMethod = Class.forName(LUCENE_FULLTEXT_CLASS_NAME).getMethod("createIndex", Connection.class, String.class, String.class, String.class);
        Method dropIndexMethod = Class.forName(LUCENE_FULLTEXT_CLASS_NAME).getMethod("dropIndex", Connection.class, String.class, String.class);
        int i = 0;
        while (i < 10) {
            createIndexMethod.invoke(null, conn, "PUBLIC", "TEST", null);
            dropIndexMethod.invoke(null, conn, "PUBLIC", "TEST");
            ++i;
        }
        conn.close();
        this.deleteDb("fullText");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullText", false);
    }

    private void testReopen(boolean lucene) throws SQLException {
        if (this.config.memory) {
            return;
        }
        String prefix = lucene ? "FTL" : "FT";
        this.deleteDb("fullTextReopen");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullTextReopen", false);
        Connection conn = this.getConnection("fullTextReopen");
        Statement stat = conn.createStatement();
        TestFullText.initFullText(stat, lucene);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello World')");
        stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', 'TEST', NULL)");
        stat.execute("UPDATE TEST SET NAME=NULL WHERE ID=1");
        stat.execute("UPDATE TEST SET NAME='Hello World' WHERE ID=1");
        conn.close();
        conn = this.getConnection("fullTextReopen");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH('Hello', 0, 0)");
        this.assertTrue(rs.next());
        stat.executeQuery("SELECT * FROM " + prefix + "_SEARCH(NULL, 0, 0)");
        stat.execute("INSERT INTO TEST VALUES(2, NULL)");
        conn.close();
        FullText.closeAll();
        conn = this.getConnection("fullTextReopen");
        stat = conn.createStatement();
        stat.execute("INSERT INTO TEST VALUES(3, 'Hello')");
        conn.close();
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullTextReopen", false);
    }

    private void testPerformance(boolean lucene) throws SQLException {
        this.deleteDb("fullText");
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullText", false);
        Connection conn = this.getConnection("fullText");
        String prefix = lucene ? "FTL" : "FT";
        Statement stat = conn.createStatement();
        TestFullText.initFullText(stat, lucene);
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, SECTION VARCHAR, TOPIC VARCHAR, SYNTAX VARCHAR, TEXT VARCHAR)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO TEST(SECTION, TOPIC, SYNTAX, TEXT) VALUES (?, ?, ?, ?)");
        Throwable throwable = null;
        Object var7_9 = null;
        try (ResultSet rs = stat.executeQuery("HELP \"\"");){
            while (rs.next()) {
                int i = 1;
                while (i <= 4) {
                    ps.setString(i, rs.getString(i));
                    ++i;
                }
                ps.addBatch();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ps.executeUpdate();
        long time = System.nanoTime();
        stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', 'TEST', NULL)");
        this.println("create " + prefix + ": " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM " + prefix + "_SEARCH(?, 0, 0)");
        time = System.nanoTime();
        ResultSet rs = stat.executeQuery("SELECT TEXT FROM TEST");
        int count = 0;
        while (rs.next()) {
            String text = rs.getString(1);
            StringTokenizer tokenizer = new StringTokenizer(text, " ()[].,;:-+*/!?=<>{}#@'\"~$_%&|");
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                if (word.length() < 10) continue;
                prep.setString(1, word);
                ResultSet rs2 = prep.executeQuery();
                while (rs2.next()) {
                    rs2.getString(1);
                    ++count;
                }
            }
        }
        this.println("search " + prefix + ": " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time) + " count: " + count);
        stat.execute("CALL " + prefix + "_DROP_ALL()");
        conn.close();
    }

    private void test(boolean lucene, String dataType) throws SQLException {
        if (lucene && this.getBaseDir().indexOf(58) > 0) {
            return;
        }
        this.deleteDb("fullText");
        Connection conn = this.getConnection("fullText");
        String prefix = lucene ? "FTL_" : "FT_";
        Statement stat = conn.createStatement();
        String className = lucene ? "FullTextLucene" : "FullText";
        stat.execute("CREATE ALIAS IF NOT EXISTS " + prefix + "INIT FOR 'org.h2.fulltext." + className + ".init'");
        stat.execute("CALL " + prefix + "INIT()");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME " + dataType + ")");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello World')");
        stat.execute("CALL " + prefix + "CREATE_INDEX('PUBLIC', 'TEST', NULL)");
        ResultSet rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('Hello', 0, 0)");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=1", rs.getString(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('Hallo', 0, 0)");
        this.assertFalse(rs.next());
        stat.execute("INSERT INTO TEST VALUES(2, 'Hallo Welt')");
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('Hello', 0, 0)");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=1", rs.getString(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('Hallo', 0, 0)");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=2", rs.getString(1));
        this.assertFalse(rs.next());
        stat.execute("CALL " + prefix + "REINDEX()");
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('Hello', 0, 0)");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=1", rs.getString(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('Hallo', 0, 0)");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=2", rs.getString(1));
        this.assertFalse(rs.next());
        stat.execute("INSERT INTO TEST VALUES(3, 'Hello World')");
        stat.execute("INSERT INTO TEST VALUES(4, 'Hello World')");
        stat.execute("INSERT INTO TEST VALUES(5, 'Hello World')");
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('World', 0, 0) ORDER BY QUERY");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=1", rs.getString(1));
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=3", rs.getString(1));
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=4", rs.getString(1));
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=5", rs.getString(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('World', 1, 0)");
        rs.next();
        this.assertTrue(rs.getString(1).startsWith("\"PUBLIC\".\"TEST\" WHERE \"ID\"="));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('World', 0, 2) ORDER BY QUERY");
        rs.next();
        this.assertTrue(rs.getString(1).startsWith("\"PUBLIC\".\"TEST\" WHERE \"ID\"="));
        rs.next();
        this.assertTrue(rs.getString(1).startsWith("\"PUBLIC\".\"TEST\" WHERE \"ID\"="));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('World', 2, 1) ORDER BY QUERY");
        rs.next();
        this.assertTrue(rs.getString(1).startsWith("\"PUBLIC\".\"TEST\" WHERE \"ID\"="));
        rs.next();
        this.assertTrue(rs.getString(1).startsWith("\"PUBLIC\".\"TEST\" WHERE \"ID\"="));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('1', 0, 0)");
        rs.next();
        this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=1", rs.getString(1));
        this.assertFalse(rs.next());
        if (lucene) {
            rs = stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('NAME:Hallo', 0, 0)");
            rs.next();
            this.assertEquals("\"PUBLIC\".\"TEST\" WHERE \"ID\"=2", rs.getString(1));
            this.assertFalse(rs.next());
        }
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("fullText");
        }
        stat = conn.createStatement();
        stat.executeQuery("SELECT * FROM " + prefix + "SEARCH('World', 0, 0)");
        stat.execute("CALL " + prefix + "DROP_ALL()");
        conn.close();
    }

    private void testDropIndex(boolean lucene) throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("fullTextDropIndex");
        String prefix = lucene ? "FTL" : "FT";
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullTextDropIndex", false);
        Connection conn = this.getConnection("fullTextDropIndex");
        Statement stat = conn.createStatement();
        TestFullText.initFullText(stat, lucene);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME1 VARCHAR, NAME2 VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello World', 'Hello Again')");
        stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', 'TEST', 'NAME1')");
        stat.execute("UPDATE TEST SET NAME1=NULL WHERE ID=1");
        stat.execute("UPDATE TEST SET NAME1='Hello World' WHERE ID=1");
        stat.execute("CALL " + prefix + "_DROP_INDEX('PUBLIC', 'TEST')");
        stat.execute("CALL " + prefix + "_CREATE_INDEX('PUBLIC', 'TEST', 'NAME1, NAME2')");
        stat.execute("UPDATE TEST SET NAME2=NULL WHERE ID=1");
        stat.execute("UPDATE TEST SET NAME2='Hello World' WHERE ID=1");
        conn.close();
        FileUtils.deleteRecursive(this.getBaseDir() + "/fullTextDropIndex", false);
    }

    private static void initFullText(Statement stat, boolean lucene) throws SQLException {
        String prefix = lucene ? "FTL" : "FT";
        String className = lucene ? "FullTextLucene" : "FullText";
        stat.execute("CREATE ALIAS IF NOT EXISTS " + prefix + "_INIT FOR 'org.h2.fulltext." + className + ".init'");
        stat.execute("CALL " + prefix + "_INIT()");
    }
}

