/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestFunctionOverload
extends TestDb {
    private static final String ME = TestFunctionOverload.class.getName();
    private Connection conn;
    private DatabaseMetaData meta;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("functionOverload");
        this.conn = this.getConnection("functionOverload");
        this.meta = this.conn.getMetaData();
        this.testControl();
        this.testOverload();
        this.testOverloadNamedArgs();
        this.testOverloadWithConnection();
        this.testOverloadError();
        this.conn.close();
        this.deleteDb("functionOverload");
    }

    private void testOverloadError() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.assertThrows(90073, stat).execute("create alias overloadError for '" + ME + ".overloadError'");
    }

    private void testControl() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("create alias overload0 for '" + ME + ".overload0'");
        ResultSet rs = stat.executeQuery("select overload0() from dual");
        this.assertTrue(rs.next());
        this.assertEquals("0 args", 0, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = this.meta.getProcedures(null, null, "OVERLOAD0");
        rs.next();
        this.assertFalse(rs.next());
    }

    private void testOverload() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("create alias overload1or2 for '" + ME + ".overload1or2'");
        ResultSet rs = stat.executeQuery("select overload1or2(1) from dual");
        rs.next();
        this.assertEquals("1 arg", 1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select overload1or2(1, 2) from dual");
        rs.next();
        this.assertEquals("2 args", 3, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = this.meta.getProcedures(null, null, "OVERLOAD1OR2");
        rs.next();
        this.assertEquals("OVERLOAD1OR2_1", rs.getString("SPECIFIC_NAME"));
        rs.next();
        this.assertEquals("OVERLOAD1OR2_2", rs.getString("SPECIFIC_NAME"));
        this.assertFalse(rs.next());
    }

    private void testOverloadNamedArgs() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("create alias overload1or2Named for '" + ME + ".overload1or2(int)'");
        ResultSet rs = stat.executeQuery("select overload1or2Named(1) from dual");
        this.assertTrue("First Row", rs.next());
        this.assertEquals("1 arg", 1, rs.getInt(1));
        this.assertFalse("Second Row", rs.next());
        rs.close();
        this.assertThrows(90087, stat).executeQuery("select overload1or2Named(1, 2) from dual");
        stat.close();
    }

    private void testOverloadWithConnection() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("create alias overload1or2WithConn for '" + ME + ".overload1or2WithConn'");
        ResultSet rs = stat.executeQuery("select overload1or2WithConn(1) from dual");
        rs.next();
        this.assertEquals("1 arg", 1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs.close();
        rs = stat.executeQuery("select overload1or2WithConn(1, 2) from dual");
        rs.next();
        this.assertEquals("2 args", 3, rs.getInt(1));
        this.assertFalse(rs.next());
        rs.close();
        stat.close();
    }

    public static int overload0() {
        return 0;
    }

    public static int overload1or2(int one) {
        return one;
    }

    public static int overload1or2(int one, int two) {
        return one + two;
    }

    public static int overload1or2WithConn(Connection conn, int one) throws SQLException {
        conn.createStatement().executeQuery("select 1 from dual");
        return one;
    }

    public static int overload1or2WithConn(int one, int two) {
        return one + two;
    }

    public static int overloadError(int one, int two) {
        return one + two;
    }

    public static int overloadError(double one, double two) {
        return (int)(one + two);
    }
}

