/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalQueries;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.h2.api.Aggregate;
import org.h2.api.AggregateFunction;
import org.h2.engine.Constants;
import org.h2.engine.SessionLocal;
import org.h2.expression.function.ToCharFunction;
import org.h2.jdbc.JdbcConnection;
import org.h2.mode.ToDateParser;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.ap.TestAnnotationProcessor;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class TestFunctions
extends TestDb
implements AggregateFunction {
    static int count;
    private static HashSet<SimpleResultSet> RESULT_SETS;

    static {
        RESULT_SETS = new HashSet();
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("functions");
        this.testOverrideAlias();
        this.deleteDb("functions");
        if (!this.config.networked) {
            JdbcConnection conn = (JdbcConnection)this.getConnection("functions");
            SessionLocal session = (SessionLocal)conn.getSession();
            this.testToDate(session);
            this.testToDateException(session);
            conn.close();
        }
        this.testVersion();
        this.testFunctionTable();
        this.testFunctionTableVarArgs();
        this.testArray();
        this.testArrayParameters();
        this.testDefaultConnection();
        this.testFunctionInSchema();
        this.testGreatest();
        this.testSource();
        this.testDynamicArgumentAndReturn();
        this.testUUID();
        this.testWhiteSpacesInParameters();
        this.testSchemaSearchPath();
        this.testDeterministic();
        this.testTransactionId();
        this.testPrecision();
        this.testVarArgs();
        this.testAggregate();
        this.testAggregateType();
        this.testFunctions();
        this.testDateTimeFunctions();
        this.testFileRead();
        this.testValue();
        this.testNvl2();
        this.testToCharFromDateTime();
        this.testToCharFromNumber();
        this.testToCharFromText();
        this.testFileWrite();
        this.testThatCurrentTimestampIsSane();
        this.testThatCurrentTimestampStaysTheSameWithinATransaction();
        this.testThatCurrentTimestampUpdatesOutsideATransaction();
        this.testCompatibilityDateTime();
        this.testAnnotationProcessorsOutput();
        this.testSignal();
        this.deleteDb("functions");
    }

    private void testVersion() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        String query = "select h2version()";
        ResultSet rs = stat.executeQuery(query);
        this.assertTrue(rs.next());
        String version = rs.getString(1);
        this.assertEquals(Constants.VERSION, version);
        this.assertFalse(rs.next());
        rs.close();
        stat.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFunctionTable() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        HashSet<SimpleResultSet> hashSet = RESULT_SETS;
        synchronized (hashSet) {
            try {
                stat.execute("create alias simple_function_table for '" + TestFunctions.class.getName() + ".simpleFunctionTable'");
                stat.execute("select * from simple_function_table() where a>0 and b in ('x', 'y')");
                for (SimpleResultSet simpleResultSet : RESULT_SETS) {
                    this.assertTrue(simpleResultSet.isClosed());
                }
            }
            finally {
                RESULT_SETS.clear();
            }
        }
        stat.execute("create alias function_table_with_parameter for '" + TestFunctions.class.getName() + ".functionTableWithParameter'");
        PreparedStatement prep = conn.prepareStatement("call function_table_with_parameter(?)");
        prep.setInt(1, 10);
        ResultSet resultSet = prep.executeQuery();
        this.assertTrue(resultSet.next());
        this.assertEquals(10, resultSet.getInt(1));
        this.assertEquals("X", resultSet.getString(2));
        conn.close();
    }

    private void testFunctionTableVarArgs() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias varargs_function_table for '" + TestFunctions.class.getName() + ".varArgsFunctionTable'");
        ResultSet rs = stat.executeQuery("select * from varargs_function_table(1,2,3,5,8,13)");
        int[] nArray = new int[]{1, 2, 3, 5, 8, 13};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.assertTrue(rs.next());
            this.assertEquals(i, rs.getInt(1));
            ++n2;
        }
        this.assertFalse(rs.next());
        conn.close();
    }

    public static ResultSet simpleFunctionTable(Connection conn) {
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("A", 4, 0, 0);
        result.addColumn("B", 1, 0, 0);
        result.addRow(42, Character.valueOf('X'));
        result.setAutoClose(false);
        RESULT_SETS.add(result);
        return result;
    }

    public static ResultSet functionTableWithParameter(Connection conn, int p) {
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("A", 4, 0, 0);
        result.addColumn("B", 1, 0, 0);
        result.addRow(p, Character.valueOf('X'));
        return result;
    }

    public static ResultSet varArgsFunctionTable(int ... values) throws SQLException {
        if (values.length != 6) {
            throw new SQLException("Unexpected argument count");
        }
        SimpleResultSet result = new SimpleResultSet();
        result.addColumn("A", 4, 0, 0);
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            result.addRow(value);
            ++n2;
        }
        return result;
    }

    private void testNvl2() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        String createSQL = "CREATE TABLE testNvl2(id BIGINT, txt1 varchar, txt2 varchar, num number(9, 0));";
        stat.execute(createSQL);
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(1, 'test1', 'test2', null)");
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(2, null, 'test4', null)");
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(3, 'test5', null, null)");
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(4, null, null, null)");
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(5, '2', null, 1)");
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(6, '2', null, null)");
        stat.execute("insert into testNvl2(id, txt1, txt2, num) values(7, 'test2', null, null)");
        String query = "SELECT NVL2(txt1, txt1, txt2), txt1 FROM testNvl2 order by id asc";
        ResultSet rs = stat.executeQuery(query);
        rs.next();
        String actual = rs.getString(1);
        this.assertEquals("test1", actual);
        rs.next();
        actual = rs.getString(1);
        this.assertEquals("test4", actual);
        rs.next();
        actual = rs.getString(1);
        this.assertEquals("test5", actual);
        rs.next();
        actual = rs.getString(1);
        this.assertEquals(null, actual);
        this.assertEquals(rs.getMetaData().getColumnType(2), rs.getMetaData().getColumnType(1));
        rs.close();
        rs = stat.executeQuery("SELECT NVL2(num, num, txt1), num FROM testNvl2 where id in(5, 6) order by id asc");
        rs.next();
        this.assertEquals(rs.getMetaData().getColumnType(2), rs.getMetaData().getColumnType(1));
        this.assertThrows(22018, stat).executeQuery("SELECT NVL2(num, num, txt1), num FROM testNvl2 where id = 7 order by id asc");
        rs = stat.executeQuery("SELECT NVL2(1, 'test', 123), 'test' FROM dual");
        rs.next();
        actual = rs.getString(1);
        this.assertEquals("test", actual);
        this.assertEquals(rs.getMetaData().getColumnType(2), rs.getMetaData().getColumnType(1));
        conn.close();
    }

    private void testValue() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias TO_CHAR_2 for '" + this.getClass().getName() + ".toChar'");
        ResultSet rs = stat.executeQuery("call TO_CHAR_2(TIMESTAMP '2001-02-03 04:05:06', 'format')");
        rs.next();
        this.assertEquals("2001-02-03 04:05:06", rs.getString(1));
        stat.execute("drop alias TO_CHAR_2");
        conn.close();
    }

    public static Value toChar(Value ... args) {
        if (args.length == 0) {
            return null;
        }
        return args[0].convertTo(TypeInfo.TYPE_VARCHAR);
    }

    private void testDefaultConnection() throws SQLException {
        Connection conn = this.getConnection("functions;DEFAULT_CONNECTION=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("create alias test for '" + TestFunctions.class.getName() + ".testDefaultConn'");
        stat.execute("call test()");
        stat.execute("drop alias test");
        conn.close();
    }

    public static void testDefaultConn() throws SQLException {
        DriverManager.getConnection("jdbc:default:connection");
    }

    private void testFunctionInSchema() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create schema schema2");
        stat.execute("create alias schema2.func as 'int x() { return 1; }'");
        stat.execute("create view test as select schema2.func()");
        ResultSet rs = stat.executeQuery("select * from information_schema.views where table_schema = 'PUBLIC'");
        rs.next();
        this.assertContains(rs.getString("VIEW_DEFINITION"), "\"SCHEMA2\".\"FUNC\"");
        stat.execute("drop view test");
        stat.execute("drop schema schema2 cascade");
        conn.close();
    }

    private void testGreatest() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        String createSQL = "CREATE TABLE testGreatest (id BIGINT);";
        stat.execute(createSQL);
        stat.execute("insert into testGreatest values (1)");
        String query = "SELECT GREATEST(id, 2147483647) FROM testGreatest";
        ResultSet rs = stat.executeQuery(query);
        rs.next();
        Object o = rs.getObject(1);
        this.assertEquals(Long.class.getName(), o.getClass().getName());
        String query2 = "SELECT GREATEST(id, 2147483648) FROM testGreatest";
        ResultSet rs2 = stat.executeQuery(query2);
        rs2.next();
        Object o2 = rs2.getObject(1);
        this.assertEquals(Long.class.getName(), o2.getClass().getName());
        conn.close();
    }

    private void testSource() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create force alias sayHi as 'String test(String name) {\nreturn \"Hello \" + name;\n}'");
        ResultSet rs = stat.executeQuery("SELECT ROUTINE_NAME FROM INFORMATION_SCHEMA.ROUTINES");
        rs.next();
        this.assertEquals("SAYHI", rs.getString(1));
        rs = stat.executeQuery("call sayHi('Joe')");
        rs.next();
        this.assertEquals("Hello Joe", rs.getString(1));
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("functions");
            stat = conn.createStatement();
            rs = stat.executeQuery("call sayHi('Joe')");
            rs.next();
            this.assertEquals("Hello Joe", rs.getString(1));
        }
        stat.execute("drop alias sayHi");
        conn.close();
    }

    private void testDynamicArgumentAndReturn() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias dynamic deterministic for '" + this.getClass().getName() + ".dynamic'");
        TestFunctions.setCount(0);
        ResultSet rs = stat.executeQuery("call dynamic(ARRAY['a', '1'])[1]");
        rs.next();
        String a = rs.getString(1);
        this.assertEquals("a1", a);
        stat.execute("drop alias dynamic");
        conn.close();
    }

    private void testUUID() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias xorUUID for '" + this.getClass().getName() + ".xorUUID'");
        TestFunctions.setCount(0);
        ResultSet rs = stat.executeQuery("call xorUUID(random_uuid(), random_uuid())");
        rs.next();
        Object o = rs.getObject(1);
        this.assertEquals(UUID.class.toString(), o.getClass().toString());
        stat.execute("drop alias xorUUID");
        conn.close();
    }

    private void testDeterministic() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias getCount for '" + this.getClass().getName() + ".getCount'");
        TestFunctions.setCount(0);
        ResultSet rs = stat.executeQuery("select getCount() from system_range(1, 2)");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        stat.execute("drop alias getCount");
        stat.execute("create alias getCount deterministic for '" + this.getClass().getName() + ".getCount'");
        TestFunctions.setCount(0);
        rs = stat.executeQuery("select getCount() from system_range(1, 2)");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        stat.execute("drop alias getCount");
        rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE UPPER(ROUTINE_NAME) = 'GET' || 'COUNT'");
        this.assertFalse(rs.next());
        stat.execute("create alias reverse deterministic for '" + this.getClass().getName() + ".reverse'");
        rs = stat.executeQuery("select reverse(x) from system_range(700, 700)");
        rs.next();
        this.assertEquals("007", rs.getString(1));
        stat.execute("drop alias reverse");
        conn.close();
    }

    private void testTransactionId() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        ResultSet rs = stat.executeQuery("call transaction_id()");
        rs.next();
        this.assertTrue(rs.getString(1) == null && rs.wasNull());
        stat.execute("insert into test values(1)");
        rs = stat.executeQuery("call transaction_id()");
        rs.next();
        this.assertTrue(rs.getString(1) == null && rs.wasNull());
        conn.setAutoCommit(false);
        stat.execute("delete from test");
        rs = stat.executeQuery("call transaction_id()");
        rs.next();
        this.assertNotNull(rs.getString(1));
        stat.execute("drop table test");
        conn.close();
    }

    private void testPrecision() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias no_op for '" + this.getClass().getName() + ".noOp'");
        PreparedStatement prep = conn.prepareStatement("select * from dual where no_op(1.6)=?");
        prep.setBigDecimal(1, new BigDecimal("1.6"));
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        stat.execute("create aggregate agg_sum for '" + this.getClass().getName() + "'");
        rs = stat.executeQuery("select agg_sum(1), sum(1.6) from dual");
        rs.next();
        this.assertEquals(1, rs.getMetaData().getScale(2));
        this.assertEquals(50000, rs.getMetaData().getScale(1));
        stat.executeQuery("select * from information_schema.routines");
        conn.close();
    }

    private void testVarArgs() throws SQLException {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS mean FOR '" + this.getClass().getName() + ".mean'");
        ResultSet rs = stat.executeQuery("select mean(), mean(10), mean(10, 20), mean(10, 20, 30)");
        rs.next();
        this.assertEquals(1.0, rs.getDouble(1));
        this.assertEquals(10.0, rs.getDouble(2));
        this.assertEquals(15.0, rs.getDouble(3));
        this.assertEquals(20.0, rs.getDouble(4));
        stat.execute("CREATE ALIAS mean2 FOR '" + this.getClass().getName() + ".mean2'");
        rs = stat.executeQuery("select mean2(), mean2(10), mean2(10, 20)");
        rs.next();
        this.assertEquals(Double.NaN, rs.getDouble(1));
        this.assertEquals(10.0, rs.getDouble(2));
        this.assertEquals(15.0, rs.getDouble(3));
        DatabaseMetaData meta = conn.getMetaData();
        rs = meta.getProcedureColumns(null, null, "MEAN2", null);
        this.assertTrue(rs.next());
        this.assertEquals("RESULT", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("FUNCTIONS", rs.getString("PROCEDURE_CAT"));
        this.assertEquals("PUBLIC", rs.getString("PROCEDURE_SCHEM"));
        this.assertEquals("MEAN2", rs.getString("PROCEDURE_NAME"));
        this.assertEquals("P1", rs.getString("COLUMN_NAME"));
        this.assertEquals(1, rs.getInt("COLUMN_TYPE"));
        this.assertEquals("DOUBLE PRECISION ARRAY", rs.getString("TYPE_NAME"));
        this.assertEquals(65536, rs.getInt("PRECISION"));
        this.assertEquals(65536, rs.getInt("LENGTH"));
        this.assertEquals(0, rs.getInt("SCALE"));
        this.assertEquals(2, rs.getInt("NULLABLE"));
        this.assertNull(rs.getString("REMARKS"));
        this.assertEquals(null, rs.getString("COLUMN_DEF"));
        this.assertEquals(0, rs.getInt("SQL_DATA_TYPE"));
        this.assertEquals(0, rs.getInt("SQL_DATETIME_SUB"));
        this.assertEquals(0, rs.getInt("CHAR_OCTET_LENGTH"));
        this.assertEquals(1, rs.getInt("ORDINAL_POSITION"));
        this.assertEquals("", rs.getString("IS_NULLABLE"));
        this.assertEquals("MEAN2_1", rs.getString("SPECIFIC_NAME"));
        this.assertFalse(rs.next());
        stat.execute("CREATE ALIAS printMean FOR '" + this.getClass().getName() + ".printMean'");
        rs = stat.executeQuery("select printMean('A'), printMean('A', 10), printMean('BB', 10, 20), printMean ('CCC', 10, 20, 30)");
        rs.next();
        this.assertEquals("A: 0", rs.getString(1));
        this.assertEquals("A: 10", rs.getString(2));
        this.assertEquals("BB: 15", rs.getString(3));
        this.assertEquals("CCC: 20", rs.getString(4));
        conn.close();
    }

    private void testFileRead() throws Exception {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        Object fileName = this.getBaseDir() + "/test.txt";
        Properties prop = System.getProperties();
        OutputStream out = FileUtils.newOutputStream((String)fileName, false);
        prop.store(out, "");
        out.close();
        ResultSet rs = stat.executeQuery("SELECT LENGTH(FILE_READ('" + (String)fileName + "')) LEN");
        rs.next();
        this.assertEquals(FileUtils.size((String)fileName), (long)rs.getInt(1));
        rs = stat.executeQuery("SELECT FILE_READ('" + (String)fileName + "') PROP");
        rs.next();
        Properties p2 = new Properties();
        p2.load(rs.getBinaryStream(1));
        this.assertEquals(prop.size(), p2.size());
        rs = stat.executeQuery("SELECT FILE_READ('" + (String)fileName + "', NULL) PROP");
        rs.next();
        String ps = rs.getString(1);
        InputStreamReader r = new InputStreamReader(FileUtils.newInputStream((String)fileName));
        String ps2 = IOUtils.readStringAndClose(r, -1);
        this.assertEquals(ps, ps2);
        FileUtils.delete((String)fileName);
        fileName = "/" + this.getClass().getName().replaceAll("\\.", "/") + ".class";
        rs = stat.executeQuery("SELECT LENGTH(FILE_READ('classpath:" + (String)fileName + "')) LEN");
        rs.next();
        int fileSize = rs.getInt(1);
        this.assertTrue(fileSize > 0);
        String[] classPathItems = this.getClassPath().split(System.getProperty("path.separator"));
        JarFile jarFile = new JarFile(Arrays.stream(classPathItems).filter(x -> x.endsWith(".jar")).findFirst().get());
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
            fileName = jarEntry.getName();
            break;
        }
        rs = stat.executeQuery("SELECT LENGTH(FILE_READ('classpath:" + (String)fileName + "')) LEN");
        rs.next();
        fileSize = rs.getInt(1);
        this.assertTrue(fileSize > 0);
        conn.close();
    }

    private void testFileWrite() throws Exception {
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE TEST IF EXISTS");
        PreparedStatement pst = conn.prepareStatement("CREATE TABLE TEST(data clob) AS SELECT ? data");
        Properties prop = System.getProperties();
        ByteArrayOutputStream os = new ByteArrayOutputStream(prop.size());
        prop.store(os, "");
        pst.setBinaryStream(1, new ByteArrayInputStream(os.toByteArray()));
        pst.execute();
        os.close();
        String fileName = new File(this.getBaseDir(), "test.txt").getPath();
        FileUtils.delete(fileName);
        ResultSet rs = stat.executeQuery("SELECT FILE_WRITE(data, " + StringUtils.quoteStringSQL(fileName) + ") len from test");
        this.assertTrue(rs.next());
        this.assertEquals(os.size(), rs.getInt(1));
        InputStreamReader r = new InputStreamReader(FileUtils.newInputStream(fileName));
        String ps2 = IOUtils.readStringAndClose(r, -1);
        this.assertEquals(os.toString(), ps2);
        conn.close();
        FileUtils.delete(fileName);
    }

    private void testAggregateType() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("CREATE AGGREGATE SIMPLE_MEDIAN FOR '" + MedianStringType.class.getName() + "'");
        stat.execute("CREATE AGGREGATE IF NOT EXISTS SIMPLE_MEDIAN FOR '" + MedianStringType.class.getName() + "'");
        ResultSet rs = stat.executeQuery("SELECT SIMPLE_MEDIAN(X) FROM SYSTEM_RANGE(1, 9)");
        rs.next();
        this.assertEquals("5", rs.getString(1));
        rs = stat.executeQuery("SELECT SIMPLE_MEDIAN(X) FILTER (WHERE X > 2) FROM SYSTEM_RANGE(1, 9)");
        rs.next();
        this.assertEquals("6", rs.getString(1));
        rs = stat.executeQuery("SELECT SIMPLE_MEDIAN(X) OVER () FROM SYSTEM_RANGE(1, 9)");
        int i = 1;
        while (i < 9) {
            this.assertTrue(rs.next());
            this.assertEquals("5", rs.getString(1));
            ++i;
        }
        rs = stat.executeQuery("SELECT SIMPLE_MEDIAN(X) OVER (PARTITION BY X) FROM SYSTEM_RANGE(1, 9)");
        i = 1;
        while (i < 9) {
            this.assertTrue(rs.next());
            this.assertEquals(Integer.toString(i), rs.getString(1));
            ++i;
        }
        conn.close();
        if (this.config.memory) {
            return;
        }
        conn = this.getConnection("functions");
        stat = conn.createStatement();
        stat.executeQuery("SELECT SIMPLE_MEDIAN(X) FROM SYSTEM_RANGE(1, 9)");
        DatabaseMetaData meta = conn.getMetaData();
        rs = meta.getProcedures(null, null, "SIMPLE_MEDIAN");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SCRIPT");
        boolean found = false;
        while (rs.next()) {
            String sql = rs.getString(1);
            if (!sql.contains("SIMPLE_MEDIAN")) continue;
            found = true;
        }
        this.assertTrue(found);
        stat.execute("DROP AGGREGATE SIMPLE_MEDIAN");
        stat.execute("DROP AGGREGATE IF EXISTS SIMPLE_MEDIAN");
        conn.close();
    }

    private void testAggregate() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("CREATE AGGREGATE SIMPLE_MEDIAN FOR '" + MedianString.class.getName() + "'");
        stat.execute("CREATE AGGREGATE IF NOT EXISTS SIMPLE_MEDIAN FOR '" + MedianString.class.getName() + "'");
        stat.execute("CREATE SCHEMA S1");
        stat.execute("CREATE AGGREGATE S1.MEDIAN2 FOR '" + MedianString.class.getName() + "'");
        ResultSet rs = stat.executeQuery("SELECT SIMPLE_MEDIAN(X) FROM SYSTEM_RANGE(1, 9)");
        rs.next();
        this.assertEquals("5", rs.getString(1));
        this.assertThrows(90022, stat).executeQuery("SELECT MEDIAN2(X) FROM SYSTEM_RANGE(1, 9)");
        rs = stat.executeQuery("SELECT S1.MEDIAN2(X) FROM SYSTEM_RANGE(1, 9)");
        rs.next();
        this.assertEquals("5", rs.getString(1));
        stat.execute("CREATE TABLE DATA(V INT)");
        stat.execute("INSERT INTO DATA VALUES (1), (3), (2), (1), (1), (2), (1), (1), (1), (1), (1)");
        rs = stat.executeQuery("SELECT SIMPLE_MEDIAN(V), SIMPLE_MEDIAN(DISTINCT V) FROM DATA");
        rs.next();
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("2", rs.getString(2));
        conn.close();
        if (this.config.memory) {
            return;
        }
        conn = this.getConnection("functions");
        stat = conn.createStatement();
        stat.executeQuery("SELECT SIMPLE_MEDIAN(X) FROM SYSTEM_RANGE(1, 9)");
        DatabaseMetaData meta = conn.getMetaData();
        rs = meta.getProcedures(null, null, "SIMPLE_MEDIAN");
        this.assertTrue(rs.next());
        this.assertEquals("PUBLIC", rs.getString("PROCEDURE_SCHEM"));
        this.assertFalse(rs.next());
        rs = meta.getProcedures(null, null, "MEDIAN2");
        this.assertTrue(rs.next());
        this.assertEquals("S1", rs.getString("PROCEDURE_SCHEM"));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SCRIPT");
        boolean found1 = false;
        boolean found2 = false;
        while (rs.next()) {
            String sql = rs.getString(1);
            if (sql.contains("\"PUBLIC\".\"SIMPLE_MEDIAN\"")) {
                found1 = true;
                continue;
            }
            if (!sql.contains("\"S1\".\"MEDIAN2\"")) continue;
            found2 = true;
        }
        this.assertTrue(found1);
        this.assertTrue(found2);
        stat.execute("DROP AGGREGATE SIMPLE_MEDIAN");
        stat.execute("DROP AGGREGATE IF EXISTS SIMPLE_MEDIAN");
        stat.execute("DROP AGGREGATE S1.MEDIAN2");
        stat.execute("DROP SCHEMA S1");
        conn.close();
    }

    private void testFunctions() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        this.assertCallResult(null, stat, "abs(null)");
        this.assertCallResult("1", stat, "abs(1)");
        this.assertCallResult("1", stat, "abs(1)");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE ALIAS ADD_ROW FOR '" + this.getClass().getName() + ".addRow'");
        ResultSet rs = stat.executeQuery("CALL ADD_ROW(1, 'Hello')");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        DatabaseMetaData meta = conn.getMetaData();
        rs = meta.getProcedureColumns(null, null, "ADD_ROW", null);
        this.assertTrue(rs.next());
        this.assertEquals("RESULT", rs.getString("COLUMN_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("FUNCTIONS", rs.getString("PROCEDURE_CAT"));
        this.assertEquals("PUBLIC", rs.getString("PROCEDURE_SCHEM"));
        this.assertEquals("ADD_ROW", rs.getString("PROCEDURE_NAME"));
        this.assertEquals("P1", rs.getString("COLUMN_NAME"));
        this.assertEquals(1, rs.getInt("COLUMN_TYPE"));
        this.assertEquals("INTEGER", rs.getString("TYPE_NAME"));
        this.assertEquals(32, rs.getInt("PRECISION"));
        this.assertEquals(32, rs.getInt("LENGTH"));
        this.assertEquals(0, rs.getInt("SCALE"));
        this.assertEquals(0, rs.getInt("NULLABLE"));
        this.assertNull(rs.getString("REMARKS"));
        this.assertEquals(null, rs.getString("COLUMN_DEF"));
        this.assertEquals(0, rs.getInt("SQL_DATA_TYPE"));
        this.assertEquals(0, rs.getInt("SQL_DATETIME_SUB"));
        this.assertEquals(0, rs.getInt("CHAR_OCTET_LENGTH"));
        this.assertEquals(1, rs.getInt("ORDINAL_POSITION"));
        this.assertEquals("", rs.getString("IS_NULLABLE"));
        this.assertEquals("ADD_ROW_1", rs.getString("SPECIFIC_NAME"));
        this.assertTrue(rs.next());
        this.assertEquals("P2", rs.getString("COLUMN_NAME"));
        this.assertEquals("CHARACTER VARYING", rs.getString("TYPE_NAME"));
        this.assertFalse(rs.next());
        stat.executeQuery("CALL ADD_ROW(2, 'World')");
        stat.execute("CREATE ALIAS SELECT_F FOR '" + this.getClass().getName() + ".select'");
        rs = stat.executeQuery("SELECT * FROM SELECT_F('SELECT * FROM TEST ORDER BY ID')");
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT NAME FROM SELECT_F('SELECT * FROM TEST ORDER BY NAME') ORDER BY NAME DESC");
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        rs.next();
        this.assertEquals("World", rs.getString(1));
        rs.next();
        this.assertEquals("Hello", rs.getString(1));
        this.assertFalse(rs.next());
        this.assertThrows(42001, stat).executeQuery("SELECT * FROM SELECT_F('ERROR')");
        stat.execute("CREATE ALIAS SIMPLE FOR '" + this.getClass().getName() + ".simpleResultSet'");
        rs = stat.executeQuery("SELECT * FROM SIMPLE(2, 1, 1, 1, 1, 1, 1, 1)");
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM SIMPLE(1, 1, 1, 1, 1, 1, 1, 1)");
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("CREATE ALIAS GET_ARRAY FOR '" + this.getClass().getName() + ".getArray'");
        rs = stat.executeQuery("CALL GET_ARRAY()");
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        rs.next();
        Array a = rs.getArray(1);
        Object[] array = (Object[])a.getArray();
        this.assertEquals(2, array.length);
        this.assertEquals("0", (String)array[0]);
        this.assertEquals("Hello", (String)array[1]);
        this.assertThrows(90008, a).getArray(1L, -1);
        this.assertEquals(2, ((Object[])a.getArray(1L, 3)).length);
        this.assertEquals(0, ((Object[])a.getArray(1L, 0)).length);
        this.assertEquals(0, ((Object[])a.getArray(2L, 0)).length);
        this.assertThrows(90008, a).getArray(0L, 0);
        this.assertThrows(90008, a).getArray(3L, 0);
        HashMap map = new HashMap();
        this.assertEquals(0, ((Object[])a.getArray(1L, 0, map)).length);
        this.assertEquals(2, ((Object[])a.getArray(map)).length);
        this.assertEquals(2, ((Object[])a.getArray(null)).length);
        map.put("x", Object.class);
        this.assertThrows(50100, a).getArray(1L, 0, map);
        this.assertThrows(50100, a).getArray(map);
        ResultSet rs2 = a.getResultSet();
        rs2.next();
        this.assertEquals(1, rs2.getInt(1));
        this.assertEquals(0, rs2.getInt(2));
        rs2.next();
        this.assertEquals(2, rs2.getInt(1));
        this.assertEquals("Hello", rs2.getString(2));
        this.assertFalse(rs.next());
        map.clear();
        rs2 = a.getResultSet(map);
        rs2.next();
        this.assertEquals(1, rs2.getInt(1));
        this.assertEquals(0, rs2.getInt(2));
        rs2.next();
        this.assertEquals(2, rs2.getInt(1));
        this.assertEquals("Hello", rs2.getString(2));
        this.assertFalse(rs.next());
        rs2 = a.getResultSet(2L, 1);
        rs2.next();
        this.assertEquals(2, rs2.getInt(1));
        this.assertEquals("Hello", rs2.getString(2));
        this.assertFalse(rs.next());
        rs2 = a.getResultSet(1L, 1, map);
        rs2.next();
        this.assertEquals(1, rs2.getInt(1));
        this.assertEquals(0, rs2.getInt(2));
        this.assertFalse(rs.next());
        map.put("x", Object.class);
        this.assertThrows(50100, a).getResultSet(map);
        this.assertThrows(50100, a).getResultSet(0L, 1, map);
        a.free();
        this.assertThrows(90007, a).getArray();
        this.assertThrows(90007, a).getResultSet();
        stat.execute("CREATE ALIAS ROOT FOR '" + this.getClass().getName() + ".root'");
        rs = stat.executeQuery("CALL ROOT(9)");
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertFalse(rs.next());
        stat.execute("CREATE ALIAS MAX_ID FOR '" + this.getClass().getName() + ".selectMaxId'");
        rs = stat.executeQuery("SELECT * FROM MAX_ID()");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("CALL CASE WHEN -9 < 0 THEN 0 ELSE ROOT(-9) END");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.assertFalse(rs.next());
        stat.execute("CREATE ALIAS blob FOR '" + this.getClass().getName() + ".blob'");
        rs = stat.executeQuery("SELECT blob(CAST('0102' AS BLOB)) FROM DUAL");
        while (rs.next()) {
        }
        rs.close();
        stat.execute("CREATE ALIAS clob FOR '" + this.getClass().getName() + ".clob'");
        rs = stat.executeQuery("SELECT clob(CAST('Hello' AS CLOB)) FROM DUAL");
        while (rs.next()) {
        }
        rs.close();
        stat.execute("create alias sql as 'ResultSet sql(Connection conn, String sql) throws SQLException { return conn.createStatement().executeQuery(sql); }'");
        rs = stat.executeQuery("select * from sql('select cast(''Hello'' as clob)')");
        this.assertTrue(rs.next());
        this.assertEquals("Hello", rs.getString(1));
        rs = stat.executeQuery("select * from sql('select cast(X''4869'' as blob)')");
        this.assertTrue(rs.next());
        this.assertEquals("Hi", new String(rs.getBytes(1)));
        rs = stat.executeQuery("select * from sql('select 1 a, ''Hello'' b')");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        ResultSetMetaData meta2 = rs.getMetaData();
        this.assertEquals(4, meta2.getColumnType(1));
        this.assertEquals("INTEGER", meta2.getColumnTypeName(1));
        this.assertEquals("java.lang.Integer", meta2.getColumnClassName(1));
        this.assertEquals(12, meta2.getColumnType(2));
        this.assertEquals("CHARACTER VARYING", meta2.getColumnTypeName(2));
        this.assertEquals("java.lang.String", meta2.getColumnClassName(2));
        stat.execute("CREATE ALIAS blob2stream FOR '" + this.getClass().getName() + ".blob2stream'");
        stat.execute("CREATE ALIAS stream2stream FOR '" + this.getClass().getName() + ".stream2stream'");
        stat.execute("CREATE TABLE TEST_BLOB(ID INT PRIMARY KEY, \"VALUE\" BLOB)");
        stat.execute("INSERT INTO TEST_BLOB VALUES(0, null)");
        stat.execute("INSERT INTO TEST_BLOB VALUES(1, 'edd1f011edd1f011edd1f011')");
        rs = stat.executeQuery("SELECT blob2stream(\"VALUE\") FROM TEST_BLOB");
        while (rs.next()) {
        }
        rs.close();
        rs = stat.executeQuery("SELECT stream2stream(\"VALUE\") FROM TEST_BLOB");
        while (rs.next()) {
        }
        conn.close();
    }

    private void testDateTimeFunctions() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        WeekFields wf = WeekFields.of(Locale.getDefault());
        int y = 2001;
        while (y <= 2010) {
            int d = 1;
            while (d <= 7) {
                String date1 = y + "-01-0" + d;
                String date2 = y + "-01-0" + (d + 1);
                LocalDate local1 = LocalDate.parse(date1);
                LocalDate local2 = LocalDate.parse(date2);
                ResultSet rs = stat.executeQuery("SELECT EXTRACT(DAY_OF_WEEK FROM C1), EXTRACT(WEEK FROM C1), EXTRACT(WEEK_YEAR FROM C1), DATEDIFF(WEEK, C1, C2), DATE_TRUNC(WEEK, C1), DATE_TRUNC(WEEK_YEAR, C1) FROM VALUES (DATE '" + date1 + "', DATE '" + date2 + "')");
                rs.next();
                this.assertEquals(local1.get(wf.dayOfWeek()), rs.getInt(1));
                int w1 = local1.get(wf.weekOfWeekBasedYear());
                this.assertEquals(w1, rs.getInt(2));
                int weekYear = local1.get(wf.weekBasedYear());
                this.assertEquals(weekYear, rs.getInt(3));
                this.assertEquals(w1 == local2.get(wf.weekOfWeekBasedYear()) ? 0 : 1, rs.getInt(4));
                this.assertEquals(local1.minus(local1.get(wf.dayOfWeek()) - 1, ChronoUnit.DAYS), rs.getObject(5, LocalDate.class));
                this.assertEquals(DateTimeFormatter.ofPattern("Y-w-e").parse(weekYear + "-1-1").query(TemporalQueries.localDate()), rs.getObject(6, LocalDate.class));
                ++d;
            }
            ++y;
        }
        conn.close();
    }

    private void testWhiteSpacesInParameters() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS PARSE_INT2 FOR \"java.lang.Integer.parseInt(java.lang.String, int)\"");
        ResultSet rs = stat.executeQuery("CALL PARSE_INT2('473', 10)");
        rs.next();
        this.assertEquals(473, rs.getInt(1));
        stat.execute("DROP ALIAS PARSE_INT2");
        stat.execute("CREATE ALIAS PARSE_INT2 FOR \"java.lang.Integer.parseInt(java.lang.String,int)\"");
        stat.execute("DROP ALIAS PARSE_INT2");
        conn.close();
    }

    private void testSchemaSearchPath() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA TEST");
        stat.execute("SET SCHEMA TEST");
        stat.execute("CREATE ALIAS PARSE_INT2 FOR \"java.lang.Integer.parseInt(java.lang.String, int)\";");
        ResultSet rs = stat.executeQuery("SELECT ROUTINE_NAME FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA ='TEST'");
        rs.next();
        this.assertEquals("PARSE_INT2", rs.getString(1));
        stat.execute("DROP ALIAS PARSE_INT2");
        stat.execute("SET SCHEMA PUBLIC");
        stat.execute("CREATE ALIAS TEST.PARSE_INT2 FOR \"java.lang.Integer.parseInt(java.lang.String, int)\";");
        stat.execute("SET SCHEMA_SEARCH_PATH PUBLIC, TEST");
        rs = stat.executeQuery("CALL PARSE_INT2('-FF', 16)");
        rs.next();
        this.assertEquals(-255, rs.getInt(1));
        rs = stat.executeQuery("SELECT ROUTINE_NAME FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA ='TEST'");
        rs.next();
        this.assertEquals("PARSE_INT2", rs.getString(1));
        rs = stat.executeQuery("CALL TEST.PARSE_INT2('-2147483648', 10)");
        rs.next();
        this.assertEquals(Integer.MIN_VALUE, rs.getInt(1));
        rs = stat.executeQuery("CALL FUNCTIONS.TEST.PARSE_INT2('-2147483648', 10)");
        rs.next();
        this.assertEquals(Integer.MIN_VALUE, rs.getInt(1));
        conn.close();
    }

    private void testArray() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        PreparedStatement prep = conn.prepareStatement("SELECT ARRAY_MAX_CARDINALITY(?)");
        prep.setObject(1, new Integer[]{1, 2, 3});
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet rs = prep.executeQuery();){
            rs.next();
            this.assertEquals(3, rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        conn.close();
    }

    private void testArrayParameters() throws SQLException {
        ResultSet rs;
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        stat.execute("create alias array_test AS $$ Integer[] array_test(Integer[] in_array) { return in_array; } $$;");
        PreparedStatement prep = conn.prepareStatement("select array_test(?) from dual");
        prep.setObject(1, new Integer[]{1, 2});
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (ResultSet rs2 = prep.executeQuery();){
            rs2.next();
            this.assertTrue(rs2.getObject(1) instanceof Array);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        CallableStatement call = conn.prepareCall("{ ? = call array_test(?) }");
        call.setObject(2, (Object)new Integer[]{2, 1});
        call.registerOutParameter(1, 2003);
        call.execute();
        this.assertEquals(Object[].class.getName(), call.getArray(1).getArray().getClass().getName());
        this.assertEquals(new Object[]{2, 1}, (Object[])((Array)call.getObject(1)).getArray());
        stat.execute("drop alias array_test");
        stat.execute("CREATE ALIAS F DETERMINISTIC FOR '" + TestFunctions.class.getName() + ".arrayParameters1'");
        prep = conn.prepareStatement("SELECT F(ARRAY[ARRAY['1', '2'], ARRAY['3']])");
        throwable2 = null;
        Object var6_10 = null;
        try {
            rs = prep.executeQuery();
            try {
                rs.next();
                this.assertEquals((Object[])new Integer[][]{{1, 2}, {3}}, (Object[])rs.getObject(1, Integer[][].class));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        prep = conn.prepareStatement("SELECT F(ARRAY[ARRAY[1::BIGINT, 2::BIGINT], ARRAY[3::BIGINT]])");
        throwable2 = null;
        var6_10 = null;
        try {
            rs = prep.executeQuery();
            try {
                rs.next();
                this.assertEquals((Object[])new Short[][]{{(short)1, (short)2}, {(short)3}}, (Object[])rs.getObject(1, Short[][].class));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable2 == null) {
                throwable2 = throwable5;
            } else if (throwable2 != throwable5) {
                throwable2.addSuppressed(throwable5);
            }
            throw throwable2;
        }
        stat.execute("DROP ALIAS F");
        conn.close();
    }

    public static Integer[][] arrayParameters1(String[][] x) {
        int l = x.length;
        Integer[][] result = new Integer[l][];
        int i = 0;
        while (i < l) {
            String[] x1 = x[i];
            int l1 = x1.length;
            Integer[] r1 = new Integer[l1];
            int j = 0;
            while (j < l1) {
                r1[j] = Integer.parseInt(x1[j]);
                ++j;
            }
            result[i] = r1;
            ++i;
        }
        return result;
    }

    private void testToDateException(SessionLocal session) {
        this.assertThrows(90056, () -> ToDateParser.toDate(session, "1979-ThisWillFail-12", "YYYY-MM-DD"));
        this.assertThrows(90056, () -> ToDateParser.toDate(session, "1-DEC-0000", "DD-MON-RRRR"));
    }

    private void testToDate(SessionLocal session) {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String defDate = year + "-" + month + "-1 ";
        ValueTimestamp date = null;
        date = ValueTimestamp.parse("1979-11-12", null);
        this.assertEquals(date, ToDateParser.toDate(session, "1979-11-12T00:00:00Z", "YYYY-MM-DD\"T\"HH24:MI:SS\"Z\""));
        this.assertEquals(date, ToDateParser.toDate(session, "1979*foo*1112", "YYYY\"*foo*\"MM\"\"DD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979-11-12", "YYYY-MM-DD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979/11/12", "YYYY/MM/DD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979,11,12", "YYYY,MM,DD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979.11.12", "YYYY.MM.DD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979;11;12", "YYYY;MM;DD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979:11:12", "YYYY:MM:DD"));
        date = ValueTimestamp.parse("1979-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "1979", "YYYY"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979 AD", "YYYY AD"));
        this.assertEquals(date, ToDateParser.toDate(session, "1979 A.D.", "YYYY A.D."));
        this.assertEquals(date, ToDateParser.toDate(session, "1979 A.D.", "YYYY BC"));
        this.assertEquals(date, ToDateParser.toDate(session, "+1979", "SYYYY"));
        this.assertEquals(date, ToDateParser.toDate(session, "79", "RRRR"));
        date = ValueTimestamp.parse(defDate + "00:12:00", null);
        this.assertEquals(date, ToDateParser.toDate(session, "12", "MI"));
        date = ValueTimestamp.parse("1970-11-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "11", "MM"));
        this.assertEquals(date, ToDateParser.toDate(session, "11", "Mm"));
        this.assertEquals(date, ToDateParser.toDate(session, "11", "mM"));
        this.assertEquals(date, ToDateParser.toDate(session, "11", "mm"));
        this.assertEquals(date, ToDateParser.toDate(session, "XI", "RM"));
        int y = year / 10 * 10 + 9;
        date = ValueTimestamp.parse(y + "-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "9", "Y"));
        y = year / 100 * 100 + 79;
        date = ValueTimestamp.parse(y + "-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "79", "YY"));
        y = year / 1000 * 1000 + 979;
        date = ValueTimestamp.parse(y + "-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "979", "YYY"));
        date = ValueTimestamp.parse("-99-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "0100 BC", "YYYY BC"));
        this.assertEquals(date, ToDateParser.toDate(session, "0100 B.C.", "YYYY B.C."));
        this.assertEquals(date, ToDateParser.toDate(session, "-0100", "SYYYY"));
        this.assertEquals(date, ToDateParser.toDate(session, "-0100", "YYYY"));
        y = -(year / 1000 * 1000 + 99);
        date = ValueTimestamp.parse(y + "-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "100 BC", "YYY BC"));
        y = -(year / 100 * 100);
        date = ValueTimestamp.parse(y + "-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "01 BC", "YY BC"));
        y = -(year / 10 * 10);
        date = ValueTimestamp.parse(y + "-" + month + "-01", null);
        this.assertEquals(date, ToDateParser.toDate(session, "1 BC", "Y BC"));
        date = ValueTimestamp.parse(defDate + "08:12:00", null);
        this.assertEquals(date, ToDateParser.toDate(session, "08:12 AM", "HH:MI AM"));
        this.assertEquals(date, ToDateParser.toDate(session, "08:12 A.M.", "HH:MI A.M."));
        this.assertEquals(date, ToDateParser.toDate(session, "08:12", "HH24:MI"));
        date = ValueTimestamp.parse(defDate + "08:12:00", null);
        this.assertEquals(date, ToDateParser.toDate(session, "08:12", "HH:MI"));
        this.assertEquals(date, ToDateParser.toDate(session, "08:12", "HH12:MI"));
        date = ValueTimestamp.parse(defDate + "08:12:34", null);
        this.assertEquals(date, ToDateParser.toDate(session, "08:12:34", "HH:MI:SS"));
        date = ValueTimestamp.parse(defDate + "12:00:00", null);
        this.assertEquals(date, ToDateParser.toDate(session, "12:00:00 PM", "HH12:MI:SS AM"));
        date = ValueTimestamp.parse(defDate + "00:00:00", null);
        this.assertEquals(date, ToDateParser.toDate(session, "12:00:00 AM", "HH12:MI:SS AM"));
        date = ValueTimestamp.parse(defDate + "00:00:34", null);
        this.assertEquals(date, ToDateParser.toDate(session, "34", "SS"));
        date = ValueTimestamp.parse(defDate + "08:12:34", null);
        this.assertEquals(date, ToDateParser.toDate(session, "29554", "SSSSS"));
        date = ValueTimestamp.parse(defDate + "08:12:34.550", null);
        this.assertEquals(date, ToDateParser.toDate(session, "08:12:34 550", "HH:MI:SS FF"));
        this.assertEquals(date, ToDateParser.toDate(session, "08:12:34 55", "HH:MI:SS FF2"));
        date = ValueTimestamp.parse(defDate + "14:04:00", null);
        this.assertEquals(date, ToDateParser.toDate(session, "02:04 P.M.", "HH:MI p.M."));
        this.assertEquals(date, ToDateParser.toDate(session, "02:04 PM", "HH:MI PM"));
        date = ValueTimestamp.parse("1970-" + month + "-12", null);
        this.assertEquals(date, ToDateParser.toDate(session, "12", "DD"));
        date = ValueTimestamp.parse(year + (calendar.isLeapYear(year) ? "-11-11" : "-11-12"), null);
        this.assertEquals(date, ToDateParser.toDate(session, "316", "DDD"));
        this.assertEquals(date, ToDateParser.toDate(session, "316", "DdD"));
        this.assertEquals(date, ToDateParser.toDate(session, "316", "dDD"));
        this.assertEquals(date, ToDateParser.toDate(session, "316", "ddd"));
        date = ValueTimestamp.parse("2013-01-29", null);
        this.assertEquals(date, ToDateParser.toDate(session, "2456322", "J"));
        if (Locale.getDefault().getLanguage().equals("en")) {
            date = ValueTimestamp.parse("9999-12-31 23:59:59", null);
            this.assertEquals(date, ToDateParser.toDate(session, "31-DEC-9999 23:59:59", "DD-MON-YYYY HH24:MI:SS"));
            this.assertEquals(date, ToDateParser.toDate(session, "31-DEC-9999 23:59:59", "DD-MON-RRRR HH24:MI:SS"));
            this.assertEquals(ValueTimestamp.parse("0001-03-01", null), ToDateParser.toDate(session, "1-MAR-0001", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("9999-03-01", null), ToDateParser.toDate(session, "1-MAR-9999", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("2000-03-01", null), ToDateParser.toDate(session, "1-MAR-000", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("1999-03-01", null), ToDateParser.toDate(session, "1-MAR-099", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("0100-03-01", null), ToDateParser.toDate(session, "1-MAR-100", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("2000-03-01", null), ToDateParser.toDate(session, "1-MAR-00", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("2049-03-01", null), ToDateParser.toDate(session, "1-MAR-49", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("1950-03-01", null), ToDateParser.toDate(session, "1-MAR-50", "DD-MON-RRRR"));
            this.assertEquals(ValueTimestamp.parse("1999-03-01", null), ToDateParser.toDate(session, "1-MAR-99", "DD-MON-RRRR"));
        }
        this.assertEquals(ValueTimestampTimeZone.parse("2000-05-10 10:11:12-08:15", null), ToDateParser.toTimestampTz(session, "2000-05-10 10:11:12 -8:15", "YYYY-MM-DD HH24:MI:SS TZH:TZM"));
        this.assertEquals(ValueTimestampTimeZone.parse("2000-05-10 10:11:12-08:15", null), ToDateParser.toTimestampTz(session, "2000-05-10 10:11:12 GMT-08:15", "YYYY-MM-DD HH24:MI:SS TZR"));
        this.assertEquals(ValueTimestampTimeZone.parse("2000-02-10 10:11:12-08", null), ToDateParser.toTimestampTz(session, "2000-02-10 10:11:12 US/Pacific", "YYYY-MM-DD HH24:MI:SS TZR"));
        this.assertEquals(ValueTimestampTimeZone.parse("2000-02-10 10:11:12-08", null), ToDateParser.toTimestampTz(session, "2000-02-10 10:11:12 PST", "YYYY-MM-DD HH24:MI:SS TZD"));
    }

    private void testToCharFromDateTime() throws SQLException {
        ToCharFunction.clearNames();
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        TimeZone tz = TimeZone.getDefault();
        Timestamp timestamp1979 = Timestamp.valueOf("1979-11-12 08:12:34.560");
        boolean daylight = tz.inDaylightTime(timestamp1979);
        String tzShortName = tz.getDisplayName(daylight, 0);
        String tzLongName = tz.getID();
        if (tzLongName.equals("Etc/UTC")) {
            tzLongName = "UTC";
        }
        stat.executeUpdate("CREATE TABLE T (X TIMESTAMP(6))");
        stat.executeUpdate("INSERT INTO T VALUES (TIMESTAMP '" + timestamp1979.toString() + "')");
        stat.executeUpdate("CREATE TABLE U (X TIMESTAMP(6))");
        stat.executeUpdate("INSERT INTO U VALUES (TIMESTAMP '-100-01-15 14:04:02.120')");
        this.assertResult("1979-11-12 08:12:34.56", stat, "SELECT X FROM T");
        this.assertResult("-0100-01-15 14:04:02.12", stat, "SELECT X FROM U");
        Object expected = String.format("%tb", timestamp1979).toUpperCase();
        expected = TestFunctions.stripTrailingPeriod((String)expected);
        this.assertResult("12-" + (String)expected + "-79 08.12.34.560000000 AM", stat, "SELECT TO_CHAR(X) FROM T");
        this.assertResult("- / , . ; : text - /", stat, "SELECT TO_CHAR(X, '- / , . ; : \"text\" - /') FROM T");
        this.assertResult("1979-11-12", stat, "SELECT TO_CHAR(X, 'YYYY-MM-DD') FROM T");
        this.assertResult("1979/11/12", stat, "SELECT TO_CHAR(X, 'YYYY/MM/DD') FROM T");
        this.assertResult("1979,11,12", stat, "SELECT TO_CHAR(X, 'YYYY,MM,DD') FROM T");
        this.assertResult("1979.11.12", stat, "SELECT TO_CHAR(X, 'YYYY.MM.DD') FROM T");
        this.assertResult("1979;11;12", stat, "SELECT TO_CHAR(X, 'YYYY;MM;DD') FROM T");
        this.assertResult("1979:11:12", stat, "SELECT TO_CHAR(X, 'YYYY:MM:DD') FROM T");
        this.assertResult("year 1979!", stat, "SELECT TO_CHAR(X, '\"year \"YYYY\"!\"') FROM T");
        this.assertResult("1979 AD", stat, "SELECT TO_CHAR(X, 'YYYY AD') FROM T");
        this.assertResult("1979 A.D.", stat, "SELECT TO_CHAR(X, 'YYYY A.D.') FROM T");
        this.assertResult("0100 B.C.", stat, "SELECT TO_CHAR(X, 'YYYY A.D.') FROM U");
        this.assertResult("1979 AD", stat, "SELECT TO_CHAR(X, 'YYYY BC') FROM T");
        this.assertResult("100 BC", stat, "SELECT TO_CHAR(X, 'YYY BC') FROM U");
        this.assertResult("00 BC", stat, "SELECT TO_CHAR(X, 'YY BC') FROM U");
        this.assertResult("0 BC", stat, "SELECT TO_CHAR(X, 'Y BC') FROM U");
        this.assertResult("1979 A.D.", stat, "SELECT TO_CHAR(X, 'YYYY B.C.') FROM T");
        this.assertResult("2013", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'YYYY') FROM DUAL");
        this.assertResult("013", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'YYY') FROM DUAL");
        this.assertResult("13", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'YY') FROM DUAL");
        this.assertResult("3", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'Y') FROM DUAL");
        this.assertResult("2014", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'IYYY') FROM DUAL");
        this.assertResult("014", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'IYY') FROM DUAL");
        this.assertResult("14", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'IY') FROM DUAL");
        this.assertResult("4", stat, "SELECT TO_CHAR(DATE '2013-12-30', 'I') FROM DUAL");
        this.assertResult("0002", stat, "SELECT TO_CHAR(DATE '-0001-01-01', 'IYYY') FROM DUAL");
        this.assertResult("0001", stat, "SELECT TO_CHAR(DATE '-0001-01-04', 'IYYY') FROM DUAL");
        this.assertResult("0004", stat, "SELECT TO_CHAR(DATE '-0004-01-01', 'IYYY') FROM DUAL");
        this.assertResult("08:12 AM", stat, "SELECT TO_CHAR(X, 'HH:MI AM') FROM T");
        this.assertResult("08:12 A.M.", stat, "SELECT TO_CHAR(X, 'HH:MI A.M.') FROM T");
        this.assertResult("02:04 P.M.", stat, "SELECT TO_CHAR(X, 'HH:MI A.M.') FROM U");
        this.assertResult("08:12 AM", stat, "SELECT TO_CHAR(X, 'HH:MI PM') FROM T");
        this.assertResult("02:04 PM", stat, "SELECT TO_CHAR(X, 'HH:MI PM') FROM U");
        this.assertResult("08:12 A.M.", stat, "SELECT TO_CHAR(X, 'HH:MI P.M.') FROM T");
        this.assertResult("12 PM", stat, "SELECT TO_CHAR(TIME '12:00:00', 'HH AM')");
        this.assertResult("12 AM", stat, "SELECT TO_CHAR(TIME '00:00:00', 'HH AM')");
        this.assertResult("A.M.", stat, "SELECT TO_CHAR(X, 'P.M.') FROM T");
        this.assertResult("a.m.", stat, "SELECT TO_CHAR(X, 'p.M.') FROM T");
        this.assertResult("a.m.", stat, "SELECT TO_CHAR(X, 'p.m.') FROM T");
        this.assertResult("AM", stat, "SELECT TO_CHAR(X, 'PM') FROM T");
        this.assertResult("Am", stat, "SELECT TO_CHAR(X, 'Pm') FROM T");
        this.assertResult("am", stat, "SELECT TO_CHAR(X, 'pM') FROM T");
        this.assertResult("am", stat, "SELECT TO_CHAR(X, 'pm') FROM T");
        this.assertResult("2", stat, "SELECT TO_CHAR(X, 'D') FROM T");
        this.assertResult("2", stat, "SELECT TO_CHAR(X, 'd') FROM T");
        expected = String.format("%tA", timestamp1979);
        expected = ((String)expected).substring(0, 1).toUpperCase() + ((String)expected).substring(1);
        String spaces = "         ";
        String first9 = ((String)expected + spaces).substring(0, 9);
        this.assertResult(StringUtils.toUpperEnglish(first9), stat, "SELECT TO_CHAR(X, 'DAY') FROM T");
        this.assertResult(first9, stat, "SELECT TO_CHAR(X, 'Day') FROM T");
        this.assertResult(first9.toLowerCase(), stat, "SELECT TO_CHAR(X, 'day') FROM T");
        this.assertResult(first9.toLowerCase(), stat, "SELECT TO_CHAR(X, 'dAY') FROM T");
        this.assertResult((String)expected, stat, "SELECT TO_CHAR(X, 'fmDay') FROM T");
        this.assertResult("12", stat, "SELECT TO_CHAR(X, 'DD') FROM T");
        this.assertResult("316", stat, "SELECT TO_CHAR(X, 'DDD') FROM T");
        this.assertResult("316", stat, "SELECT TO_CHAR(X, 'DdD') FROM T");
        this.assertResult("316", stat, "SELECT TO_CHAR(X, 'dDD') FROM T");
        this.assertResult("316", stat, "SELECT TO_CHAR(X, 'ddd') FROM T");
        expected = String.format("%1$tA, %1$tB %1$te, %1$tY", timestamp1979);
        this.assertResult((String)expected, stat, "SELECT TO_CHAR(X, 'DL') FROM T");
        this.assertResult("11/12/1979", stat, "SELECT TO_CHAR(X, 'DS') FROM T");
        this.assertResult("11/12/1979", stat, "SELECT TO_CHAR(X, 'Ds') FROM T");
        this.assertResult("11/12/1979", stat, "SELECT TO_CHAR(X, 'dS') FROM T");
        this.assertResult("11/12/1979", stat, "SELECT TO_CHAR(X, 'ds') FROM T");
        expected = String.format("%1$ta", timestamp1979);
        this.assertResult(((String)expected).toUpperCase(), stat, "SELECT TO_CHAR(X, 'DY') FROM T");
        this.assertResult(ToCharFunction.Capitalization.CAPITALIZE.apply((String)expected), stat, "SELECT TO_CHAR(X, 'Dy') FROM T");
        this.assertResult(((String)expected).toLowerCase(), stat, "SELECT TO_CHAR(X, 'dy') FROM T");
        this.assertResult(((String)expected).toLowerCase(), stat, "SELECT TO_CHAR(X, 'dY') FROM T");
        this.assertResult("08:12:34.560000000", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF') FROM T");
        this.assertResult("08:12:34.5", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF1') FROM T");
        this.assertResult("08:12:34.56", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF2') FROM T");
        this.assertResult("08:12:34.560", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF3') FROM T");
        this.assertResult("08:12:34.5600", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF4') FROM T");
        this.assertResult("08:12:34.56000", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF5') FROM T");
        this.assertResult("08:12:34.560000", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF6') FROM T");
        this.assertResult("08:12:34.5600000", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF7') FROM T");
        this.assertResult("08:12:34.56000000", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF8') FROM T");
        this.assertResult("08:12:34.560000000", stat, "SELECT TO_CHAR(X, 'HH:MI:SS.FF9') FROM T");
        this.assertResult("012345678", stat, "SELECT TO_CHAR(TIME '0:00:00.012345678', 'FF') FROM T");
        this.assertResult("00", stat, "SELECT TO_CHAR(TIME '0:00:00.000', 'FF2') FROM T");
        this.assertResult("08:12", stat, "SELECT TO_CHAR(X, 'HH:MI') FROM T");
        this.assertResult("08:12", stat, "SELECT TO_CHAR(X, 'HH12:MI') FROM T");
        this.assertResult("08:12", stat, "SELECT TO_CHAR(X, 'HH24:MI') FROM T");
        this.assertResult("46", stat, "SELECT TO_CHAR(X, 'IW') FROM T");
        this.assertResult("46", stat, "SELECT TO_CHAR(X, 'WW') FROM T");
        this.assertResult("2", stat, "SELECT TO_CHAR(X, 'W') FROM T");
        this.assertResult("9", stat, "SELECT TO_CHAR(X, 'I') FROM T");
        this.assertResult("79", stat, "SELECT TO_CHAR(X, 'IY') FROM T");
        this.assertResult("979", stat, "SELECT TO_CHAR(X, 'IYY') FROM T");
        this.assertResult("1979", stat, "SELECT TO_CHAR(X, 'IYYY') FROM T");
        this.assertResult("2444190", stat, "SELECT TO_CHAR(X, 'J') FROM T");
        this.assertResult("12", stat, "SELECT TO_CHAR(X, 'MI') FROM T");
        this.assertResult("11", stat, "SELECT TO_CHAR(X, 'MM') FROM T");
        this.assertResult("11", stat, "SELECT TO_CHAR(X, 'Mm') FROM T");
        this.assertResult("11", stat, "SELECT TO_CHAR(X, 'mM') FROM T");
        this.assertResult("11", stat, "SELECT TO_CHAR(X, 'mm') FROM T");
        expected = String.format("%1$tb", timestamp1979);
        expected = TestFunctions.stripTrailingPeriod((String)expected);
        expected = ((String)expected).substring(0, 1).toUpperCase() + ((String)expected).substring(1);
        this.assertResult(((String)expected).toUpperCase(), stat, "SELECT TO_CHAR(X, 'MON') FROM T");
        this.assertResult((String)expected, stat, "SELECT TO_CHAR(X, 'Mon') FROM T");
        this.assertResult(((String)expected).toLowerCase(), stat, "SELECT TO_CHAR(X, 'mon') FROM T");
        expected = String.format("%1$tB", timestamp1979);
        expected = ((String)expected + "        ").substring(0, 9);
        this.assertResult(((String)expected).toUpperCase(), stat, "SELECT TO_CHAR(X, 'MONTH') FROM T");
        this.assertResult(ToCharFunction.Capitalization.CAPITALIZE.apply((String)expected), stat, "SELECT TO_CHAR(X, 'Month') FROM T");
        this.assertResult(((String)expected).toLowerCase(), stat, "SELECT TO_CHAR(X, 'month') FROM T");
        this.assertResult(ToCharFunction.Capitalization.CAPITALIZE.apply(((String)expected).trim()), stat, "SELECT TO_CHAR(X, 'fmMonth') FROM T");
        this.assertResult("4", stat, "SELECT TO_CHAR(X, 'Q') FROM T");
        this.assertResult("XI", stat, "SELECT TO_CHAR(X, 'RM') FROM T");
        this.assertResult("xi", stat, "SELECT TO_CHAR(X, 'rm') FROM T");
        this.assertResult("Xi", stat, "SELECT TO_CHAR(X, 'Rm') FROM T");
        this.assertResult("79", stat, "SELECT TO_CHAR(X, 'RR') FROM T");
        this.assertResult("1979", stat, "SELECT TO_CHAR(X, 'RRRR') FROM T");
        this.assertResult("34", stat, "SELECT TO_CHAR(X, 'SS') FROM T");
        this.assertResult("29554", stat, "SELECT TO_CHAR(X, 'SSSSS') FROM T");
        expected = new SimpleDateFormat("h:mm:ss aa").format(timestamp1979);
        if (Locale.getDefault().equals(Locale.US)) {
            this.assertEquals("8:12:34 AM", (String)expected);
        }
        this.assertResult((String)expected, stat, "SELECT TO_CHAR(X, 'TS') FROM T");
        this.assertResult(tzLongName, stat, "SELECT TO_CHAR(X, 'TZR') FROM T");
        this.assertResult(tzShortName, stat, "SELECT TO_CHAR(X, 'TZD') FROM T");
        this.assertResult("GMT+10:30", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+10:30', 'TZR')");
        this.assertResult("GMT+10:30", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+10:30', 'TZD')");
        this.assertResult("-10", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00-10:00', 'TZH')");
        this.assertResult("+10", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+10:00', 'TZH')");
        this.assertResult("+00", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+00:00', 'TZH')");
        this.assertResult("50", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+00:50', 'TZM')");
        this.assertResult("00", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+00:00', 'TZM')");
        this.assertResult("-10:50", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00-10:50', 'TZH:TZM')");
        this.assertResult("+10:50", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+10:50', 'TZH:TZM')");
        this.assertResult("+00:00", stat, "SELECT TO_CHAR(TIMESTAMP WITH TIME ZONE '2010-01-01 0:00:00+00:00', 'TZH:TZM')");
        expected = String.format("%f", 1.1).substring(1, 2);
        this.assertResult((String)expected, stat, "SELECT TO_CHAR(X, 'X') FROM T");
        expected = String.format("%,d", 1979);
        this.assertResult((String)expected, stat, "SELECT TO_CHAR(X, 'Y,YYY') FROM T");
        this.assertResult("1979", stat, "SELECT TO_CHAR(X, 'YYYY') FROM T");
        this.assertResult("1979", stat, "SELECT TO_CHAR(X, 'SYYYY') FROM T");
        this.assertResult("-0100", stat, "SELECT TO_CHAR(X, 'SYYYY') FROM U");
        this.assertResult("979", stat, "SELECT TO_CHAR(X, 'YYY') FROM T");
        this.assertResult("79", stat, "SELECT TO_CHAR(X, 'YY') FROM T");
        this.assertResult("9", stat, "SELECT TO_CHAR(X, 'Y') FROM T");
        this.assertResult("7979", stat, "SELECT TO_CHAR(X, 'yyfxyy') FROM T");
        this.assertThrows(90010, stat, "SELECT TO_CHAR(X, 'A') FROM T");
        this.assertResult("01-1 2000-01 1999-52", stat, "SELECT TO_CHAR(DATE '2000-01-01', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-1 2000-01 1999-52", stat, "SELECT TO_CHAR(DATE '2000-01-02', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-1 2000-01 2000-01", stat, "SELECT TO_CHAR(DATE '2000-01-03', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-1 2000-01 2000-01", stat, "SELECT TO_CHAR(DATE '2000-01-04', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-1 2000-01 2000-01", stat, "SELECT TO_CHAR(DATE '2000-01-05', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-1 2000-01 2000-01", stat, "SELECT TO_CHAR(DATE '2000-01-06', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-1 2000-01 2000-01", stat, "SELECT TO_CHAR(DATE '2000-01-07', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("01-2 2000-02 2000-01", stat, "SELECT TO_CHAR(DATE '2000-01-08', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("02-1 2000-05 2000-05", stat, "SELECT TO_CHAR(DATE '2000-02-01', 'MM-W YYYY-WW IYYY-IW')");
        this.assertResult("12-5 2000-53 2000-52", stat, "SELECT TO_CHAR(DATE '2000-12-31', 'MM-W YYYY-WW IYYY-IW')");
        stat.executeUpdate("TRUNCATE TABLE T");
        stat.executeUpdate("INSERT INTO T VALUES (TIMESTAMP '1985-01-01 08:12:34.560')");
        this.assertResult("19850101", stat, "SELECT TO_CHAR(X, 'YYYYMMDD') FROM T");
        conn.close();
    }

    private static String stripTrailingPeriod(String expected) {
        int l = expected.length() - 1;
        if (expected.charAt(l) == '.') {
            expected = expected.substring(0, l);
        }
        return expected;
    }

    private void testToCharFromNumber() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        Locale.setDefault(new Locale("en"));
        Locale locale = Locale.getDefault();
        Currency currency = Currency.getInstance(locale.getCountry().length() == 2 ? locale : Locale.US);
        String cc = currency.getCurrencyCode();
        String cs = currency.getSymbol();
        this.assertResult(".45", stat, "SELECT TO_CHAR(0.45) FROM DUAL");
        this.assertResult("12923", stat, "SELECT TO_CHAR(12923) FROM DUAL");
        this.assertResult(" 12923.00", stat, "SELECT TO_CHAR(12923, '99999.99', 'NLS_CURRENCY = BTC') FROM DUAL");
        this.assertResult("12923.", stat, "SELECT TO_CHAR(12923, 'FM99999.99', 'NLS_CURRENCY = BTC') FROM DUAL");
        this.assertResult("######", stat, "SELECT TO_CHAR(12345, '9,999') FROM DUAL");
        this.assertResult("######", stat, "SELECT TO_CHAR(1234567, '9,999') FROM DUAL");
        this.assertResult(" 12,345", stat, "SELECT TO_CHAR(12345, '99,999') FROM DUAL");
        this.assertResult(" 123,45", stat, "SELECT TO_CHAR(12345, '999,99') FROM DUAL");
        this.assertResult("######", stat, "SELECT TO_CHAR(12345, '9.999') FROM DUAL");
        this.assertResult("#######", stat, "SELECT TO_CHAR(12345, '99.999') FROM DUAL");
        this.assertResult("########", stat, "SELECT TO_CHAR(12345, '999.999') FROM DUAL");
        this.assertResult("#########", stat, "SELECT TO_CHAR(12345, '9999.999') FROM DUAL");
        this.assertResult(" 12345.000", stat, "SELECT TO_CHAR(12345, '99999.999') FROM DUAL");
        this.assertResult("###", stat, "SELECT TO_CHAR(12345, '$9') FROM DUAL");
        this.assertResult("#####", stat, "SELECT TO_CHAR(12345, '$999') FROM DUAL");
        this.assertResult("######", stat, "SELECT TO_CHAR(12345, '$9999') FROM DUAL");
        String expected = String.format("%,d", 12345);
        if (locale == Locale.ENGLISH) {
            this.assertResult(String.format("%5s12345", cs), stat, "SELECT TO_CHAR(12345, '$99999999') FROM DUAL");
            this.assertResult(String.format("%6s12,345.35", cs), stat, "SELECT TO_CHAR(12345.345, '$99,999,999.99') FROM DUAL");
            this.assertResult(String.format("%5s%s", cs, expected), stat, "SELECT TO_CHAR(12345.345, '$99g999g999') FROM DUAL");
            this.assertResult("          " + cs + "123.45", stat, "SELECT TO_CHAR(123.45, 'L999.99') FROM DUAL");
            this.assertResult("         -" + cs + "123.45", stat, "SELECT TO_CHAR(-123.45, 'L999.99') FROM DUAL");
            this.assertResult(cs + "123.45", stat, "SELECT TO_CHAR(123.45, 'FML999.99') FROM DUAL");
            this.assertResult("          " + cs + "123.45", stat, "SELECT TO_CHAR(123.45, 'U999.99') FROM DUAL");
            this.assertResult("          " + cs + "123.45", stat, "SELECT TO_CHAR(123.45, 'u999.99') FROM DUAL");
        }
        this.assertResult("     12,345.35", stat, "SELECT TO_CHAR(12345.345, '99,999,999.99') FROM DUAL");
        this.assertResult("12,345.35", stat, "SELECT TO_CHAR(12345.345, 'FM99,999,999.99') FROM DUAL");
        this.assertResult(" 00,012,345.35", stat, "SELECT TO_CHAR(12345.345, '00,000,000.00') FROM DUAL");
        this.assertResult("00,012,345.35", stat, "SELECT TO_CHAR(12345.345, 'FM00,000,000.00') FROM DUAL");
        this.assertResult("###", stat, "SELECT TO_CHAR(12345, '09') FROM DUAL");
        this.assertResult("#####", stat, "SELECT TO_CHAR(12345, '0999') FROM DUAL");
        this.assertResult(" 00012345", stat, "SELECT TO_CHAR(12345, '09999999') FROM DUAL");
        this.assertResult(" 0000012345", stat, "SELECT TO_CHAR(12345, '0009999999') FROM DUAL");
        this.assertResult("###", stat, "SELECT TO_CHAR(12345, '90') FROM DUAL");
        this.assertResult("#####", stat, "SELECT TO_CHAR(12345, '9990') FROM DUAL");
        this.assertResult("    12345", stat, "SELECT TO_CHAR(12345, '99999990') FROM DUAL");
        this.assertResult("      12345", stat, "SELECT TO_CHAR(12345, '9999999000') FROM DUAL");
        this.assertResult("      12345", stat, "SELECT TO_CHAR(12345, '9999999990') FROM DUAL");
        this.assertResult("12345", stat, "SELECT TO_CHAR(12345, 'FM9999999990') FROM DUAL");
        this.assertResult("   12345.2300", stat, "SELECT TO_CHAR(12345.23, '9999999.9000') FROM DUAL");
        this.assertResult("   12345", stat, "SELECT TO_CHAR(12345, '9999999') FROM DUAL");
        this.assertResult("  12345", stat, "SELECT TO_CHAR(12345, '999999') FROM DUAL");
        this.assertResult(" 12345", stat, "SELECT TO_CHAR(12345, '99999') FROM DUAL");
        this.assertResult(" 12345", stat, "SELECT TO_CHAR(12345, '00000') FROM DUAL");
        this.assertResult("#####", stat, "SELECT TO_CHAR(12345, '9999') FROM DUAL");
        this.assertResult("#####", stat, "SELECT TO_CHAR(12345, '0000') FROM DUAL");
        this.assertResult("   -12345", stat, "SELECT TO_CHAR(-12345, '99999999') FROM DUAL");
        this.assertResult("  -12345", stat, "SELECT TO_CHAR(-12345, '9999999') FROM DUAL");
        this.assertResult(" -12345", stat, "SELECT TO_CHAR(-12345, '999999') FROM DUAL");
        this.assertResult("-12345", stat, "SELECT TO_CHAR(-12345, '99999') FROM DUAL");
        this.assertResult("#####", stat, "SELECT TO_CHAR(-12345, '9999') FROM DUAL");
        this.assertResult("####", stat, "SELECT TO_CHAR(-12345, '999') FROM DUAL");
        this.assertResult("       0", stat, "SELECT TO_CHAR(0, '9999999') FROM DUAL");
        this.assertResult(" 00.30", stat, "SELECT TO_CHAR(0.3, '00.99') FROM DUAL");
        this.assertResult("00.3", stat, "SELECT TO_CHAR(0.3, 'FM00.99') FROM DUAL");
        this.assertResult(" 00.30", stat, "SELECT TO_CHAR(0.3, '00.00') FROM DUAL");
        this.assertResult("   .30000", stat, "SELECT TO_CHAR(0.3, '99.00000') FROM DUAL");
        this.assertResult(".30000", stat, "SELECT TO_CHAR(0.3, 'FM99.00000') FROM DUAL");
        this.assertResult(" 00.30", stat, "SELECT TO_CHAR(0.3, 'B00.99') FROM DUAL");
        this.assertResult("   .30", stat, "SELECT TO_CHAR(0.3, 'B99.99') FROM DUAL");
        this.assertResult("   .30", stat, "SELECT TO_CHAR(0.3, '99.99') FROM DUAL");
        this.assertResult(".3", stat, "SELECT TO_CHAR(0.3, 'FMB99.99') FROM DUAL");
        this.assertResult(" 00.30", stat, "SELECT TO_CHAR(0.3, 'B09.99') FROM DUAL");
        this.assertResult(" 00.30", stat, "SELECT TO_CHAR(0.3, 'B00.00') FROM DUAL");
        this.assertResult("     " + cc + "123.45", stat, "SELECT TO_CHAR(123.45, 'C999.99') FROM DUAL");
        this.assertResult("    -" + cc + "123.45", stat, "SELECT TO_CHAR(-123.45, 'C999.99') FROM DUAL");
        this.assertResult("         " + cc + "123.45", stat, "SELECT TO_CHAR(123.45, 'C999,999.99') FROM DUAL");
        this.assertResult("         " + cc + "123", stat, "SELECT TO_CHAR(123.45, 'C999g999') FROM DUAL");
        this.assertResult(cc + "123.45", stat, "SELECT TO_CHAR(123.45, 'FMC999,999.99') FROM DUAL");
        expected = String.format("%.2f", Float.valueOf(0.33f)).substring(1);
        this.assertResult("   " + expected, stat, "SELECT TO_CHAR(0.326, '99D99') FROM DUAL");
        this.assertResult("  1.2E+02", stat, "SELECT TO_CHAR(123.456, '9.9EEEE') FROM DUAL");
        this.assertResult("  1.2E+14", stat, "SELECT TO_CHAR(123456789012345, '9.9EEEE') FROM DUAL");
        this.assertResult("  1E+02", stat, "SELECT TO_CHAR(123.456, '9EEEE') FROM DUAL");
        this.assertResult("  1E+02", stat, "SELECT TO_CHAR(123.456, '999EEEE') FROM DUAL");
        this.assertResult("  1E-03", stat, "SELECT TO_CHAR(.00123456, '999EEEE') FROM DUAL");
        this.assertResult("  1E+00", stat, "SELECT TO_CHAR(1, '999EEEE') FROM DUAL");
        this.assertResult(" -1E+00", stat, "SELECT TO_CHAR(-1, '999EEEE') FROM DUAL");
        this.assertResult("  1.23456000E+02", stat, "SELECT TO_CHAR(123.456, '00.00000000EEEE') FROM DUAL");
        this.assertResult("1.23456000E+02", stat, "SELECT TO_CHAR(123.456, 'fm00.00000000EEEE') FROM DUAL");
        expected = String.format("%,d", 1234567);
        this.assertResult(" " + expected, stat, "SELECT TO_CHAR(1234567, '9G999G999') FROM DUAL");
        this.assertResult("-" + expected, stat, "SELECT TO_CHAR(-1234567, '9G999G999') FROM DUAL");
        this.assertResult("123.45-", stat, "SELECT TO_CHAR(-123.45, '999.99MI') FROM DUAL");
        this.assertResult("123.45-", stat, "SELECT TO_CHAR(-123.45, '999.99mi') FROM DUAL");
        this.assertResult("123.45-", stat, "SELECT TO_CHAR(-123.45, '999.99mI') FROM DUAL");
        this.assertResult("230.00-", stat, "SELECT TO_CHAR(-230, '999.99MI') FROM DUAL");
        this.assertResult("230-", stat, "SELECT TO_CHAR(-230, '999MI') FROM DUAL");
        this.assertResult("123.45 ", stat, "SELECT TO_CHAR(123.45, '999.99MI') FROM DUAL");
        this.assertResult("230.00 ", stat, "SELECT TO_CHAR(230, '999.99MI') FROM DUAL");
        this.assertResult("230 ", stat, "SELECT TO_CHAR(230, '999MI') FROM DUAL");
        this.assertResult("230", stat, "SELECT TO_CHAR(230, 'FM999MI') FROM DUAL");
        this.assertResult("<230>", stat, "SELECT TO_CHAR(-230, '999PR') FROM DUAL");
        this.assertResult("<230>", stat, "SELECT TO_CHAR(-230, '999pr') FROM DUAL");
        this.assertResult("<230>", stat, "SELECT TO_CHAR(-230, 'fm999pr') FROM DUAL");
        this.assertResult(" 230 ", stat, "SELECT TO_CHAR(230, '999PR') FROM DUAL");
        this.assertResult("230", stat, "SELECT TO_CHAR(230, 'FM999PR') FROM DUAL");
        this.assertResult("0", stat, "SELECT TO_CHAR(0, 'fm999pr') FROM DUAL");
        this.assertResult("             XI", stat, "SELECT TO_CHAR(11, 'RN') FROM DUAL");
        this.assertResult("XI", stat, "SELECT TO_CHAR(11, 'FMRN') FROM DUAL");
        this.assertResult("xi", stat, "SELECT TO_CHAR(11, 'FMrN') FROM DUAL");
        this.assertResult("             XI", stat, "SELECT TO_CHAR(11, 'RN') FROM DUAL;");
        this.assertResult("             xi", stat, "SELECT TO_CHAR(11, 'rN') FROM DUAL");
        this.assertResult("             xi", stat, "SELECT TO_CHAR(11, 'rn') FROM DUAL");
        this.assertResult(" +42", stat, "SELECT TO_CHAR(42, 'S999') FROM DUAL");
        this.assertResult(" +42", stat, "SELECT TO_CHAR(42, 's999') FROM DUAL");
        this.assertResult(" 42+", stat, "SELECT TO_CHAR(42, '999S') FROM DUAL");
        this.assertResult(" -42", stat, "SELECT TO_CHAR(-42, 'S999') FROM DUAL");
        this.assertResult(" 42-", stat, "SELECT TO_CHAR(-42, '999S') FROM DUAL");
        this.assertResult("42", stat, "SELECT TO_CHAR(42, 'TM') FROM DUAL");
        this.assertResult("-42", stat, "SELECT TO_CHAR(-42, 'TM') FROM DUAL");
        this.assertResult("4212341241234.23412342", stat, "SELECT TO_CHAR(4212341241234.23412342, 'tm') FROM DUAL");
        this.assertResult(".23412342", stat, "SELECT TO_CHAR(0.23412342, 'tm') FROM DUAL");
        this.assertResult(" 12300", stat, "SELECT TO_CHAR(123, '999V99') FROM DUAL");
        this.assertResult("######", stat, "SELECT TO_CHAR(1234, '999V99') FROM DUAL");
        this.assertResult("123400", stat, "SELECT TO_CHAR(1234, 'FM9999v99') FROM DUAL");
        this.assertResult("1234", stat, "SELECT TO_CHAR(123.4, 'FM9999V9') FROM DUAL");
        this.assertResult("123", stat, "SELECT TO_CHAR(123.4, 'FM9999V') FROM DUAL");
        this.assertResult("123400000", stat, "SELECT TO_CHAR(123.4, 'FM9999V090909') FROM DUAL");
        this.assertResult("##", stat, "SELECT TO_CHAR(123, 'X') FROM DUAL");
        this.assertResult(" 7B", stat, "SELECT TO_CHAR(123, 'XX') FROM DUAL");
        this.assertResult(" 7b", stat, "SELECT TO_CHAR(123, 'Xx') FROM DUAL");
        this.assertResult(" 7b", stat, "SELECT TO_CHAR(123, 'xX') FROM DUAL");
        this.assertResult("   7B", stat, "SELECT TO_CHAR(123, 'XXXX') FROM DUAL");
        this.assertResult(" 007B", stat, "SELECT TO_CHAR(123, '000X') FROM DUAL");
        this.assertResult(" 007B", stat, "SELECT TO_CHAR(123, '0XXX') FROM DUAL");
        this.assertResult("####", stat, "SELECT TO_CHAR(123456789, 'FMXXX') FROM DUAL");
        this.assertResult("7B", stat, "SELECT TO_CHAR(123, 'FMXX') FROM DUAL");
        this.assertResult("C6", stat, "SELECT TO_CHAR(197.6, 'FMXX') FROM DUAL");
        this.assertResult("  7", stat, "SELECT TO_CHAR(7, 'XX') FROM DUAL");
        this.assertResult("123", stat, "SELECT TO_CHAR(123, 'TM') FROM DUAL");
        this.assertResult("123", stat, "SELECT TO_CHAR(123, 'tm') FROM DUAL");
        this.assertResult("123", stat, "SELECT TO_CHAR(123, 'tM9') FROM DUAL");
        this.assertResult("1.23E+02", stat, "SELECT TO_CHAR(123, 'TME') FROM DUAL");
        this.assertResult("1.23456789012345E+14", stat, "SELECT TO_CHAR(123456789012345, 'TME') FROM DUAL");
        this.assertResult("4.5E-01", stat, "SELECT TO_CHAR(0.45, 'TME') FROM DUAL");
        this.assertResult("4.5E-01", stat, "SELECT TO_CHAR(0.45, 'tMe') FROM DUAL");
        this.assertThrows(90010, stat, "SELECT TO_CHAR(123.45, '999.99q') FROM DUAL");
        this.assertThrows(90010, stat, "SELECT TO_CHAR(123.45, 'fm999.99q') FROM DUAL");
        this.assertThrows(90010, stat, "SELECT TO_CHAR(123.45, 'q999.99') FROM DUAL");
        this.assertResult("0.123", stat, "select to_char(0.123, 'FM0.099') from dual;");
        this.assertResult("1.123", stat, "select to_char(1.1234, 'FM0.099') from dual;");
        this.assertResult("1.1234", stat, "select to_char(1.1234, 'FM0.0999') from dual;");
        this.assertResult("1.023", stat, "select to_char(1.023, 'FM0.099') from dual;");
        this.assertResult("0.012", stat, "select to_char(0.012, 'FM0.099') from dual;");
        this.assertResult("0.123", stat, "select to_char(0.123, 'FM0.099') from dual;");
        this.assertResult("0.001", stat, "select to_char(0.001, 'FM0.099') from dual;");
        this.assertResult("0.001", stat, "select to_char(0.0012, 'FM0.099') from dual;");
        this.assertResult("0.002", stat, "select to_char(0.0019, 'FM0.099') from dual;");
        char decimalSeparator = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        String oneDecimal = "0" + decimalSeparator + "0";
        String twoDecimals = "0" + decimalSeparator + "00";
        this.assertResult(oneDecimal, stat, "select to_char(0, 'FM0D099') from dual;");
        this.assertResult(twoDecimals, stat, "select to_char(0., 'FM0D009') from dual;");
        this.assertResult("0" + decimalSeparator + "000000000", stat, "select to_char(0.000000000, 'FM0D999999999') from dual;");
        this.assertResult("0" + decimalSeparator, stat, "select to_char(0, 'FM0D9') from dual;");
        this.assertResult(oneDecimal, stat, "select to_char(0.0, 'FM0D099') from dual;");
        this.assertResult(twoDecimals, stat, "select to_char(0.00, 'FM0D009') from dual;");
        this.assertResult(twoDecimals, stat, "select to_char(0, 'FM0D009') from dual;");
        this.assertResult(oneDecimal, stat, "select to_char(0, 'FM0D09') from dual;");
        this.assertResult(oneDecimal, stat, "select to_char(0, 'FM0D0') from dual;");
        this.assertResult("10,000,000.", stat, "SELECT TO_CHAR(CAST(10000000 AS DOUBLE PRECISION), 'FM999,999,999.99') FROM DUAL");
        conn.close();
    }

    private void testToCharFromText() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        this.assertResult("abc", stat, "SELECT TO_CHAR('abc') FROM DUAL");
        conn.close();
    }

    private void testAnnotationProcessorsOutput() {
        try {
            try {
                System.setProperty(TestAnnotationProcessor.MESSAGES_KEY, "WARNING,foo1|ERROR,foo2");
                this.callCompiledFunction("test_annotation_processor_warn_and_error");
                this.fail();
            }
            catch (SQLException e) {
                this.assertEquals(42000, e.getErrorCode());
                this.assertContains(e.getMessage(), "foo1");
                this.assertContains(e.getMessage(), "foo2");
                System.clearProperty(TestAnnotationProcessor.MESSAGES_KEY);
            }
        }
        finally {
            System.clearProperty(TestAnnotationProcessor.MESSAGES_KEY);
        }
    }

    private void testSignal() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        Statement stat = conn.createStatement();
        this.assertThrows(90008, stat).execute("call signal('00145', 'success class is invalid')");
        this.assertThrows(90008, stat).execute("call signal('foo', 'SQLSTATE has 5 chars')");
        this.assertThrows(90008, stat).execute("call signal('Ab123', 'SQLSTATE has only digits or upper-case letters')");
        try {
            stat.execute("call signal('AB123', 'some custom error')");
            this.fail("Should have thrown");
        }
        catch (SQLException e) {
            this.assertEquals("AB123", e.getSQLState());
            this.assertContains(e.getMessage(), "some custom error");
        }
        conn.close();
    }

    private void testThatCurrentTimestampIsSane() throws SQLException, ParseException {
        this.deleteDb("functions");
        Date before = new Date();
        Connection conn = this.getConnection("functions");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select to_char(current_timestamp(9), 'YYYY MM DD HH24 MI SS FF3') from dual");
        rs.next();
        String formatted = rs.getString(1);
        rs.close();
        Date after = new Date();
        Date parsed = new SimpleDateFormat("y M d H m s S").parse(formatted);
        this.assertFalse(parsed.before(before));
        this.assertFalse(parsed.after(after));
        conn.close();
    }

    private void testThatCurrentTimestampStaysTheSameWithinATransaction() throws SQLException, InterruptedException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select CURRENT_TIMESTAMP from DUAL");
        rs.next();
        Timestamp first = rs.getTimestamp(1);
        rs.close();
        Thread.sleep(1L);
        rs = stat.executeQuery("select CURRENT_TIMESTAMP from DUAL");
        rs.next();
        Timestamp second = rs.getTimestamp(1);
        rs.close();
        this.assertEquals(first, second);
        conn.close();
    }

    private void testThatCurrentTimestampUpdatesOutsideATransaction() throws SQLException, InterruptedException {
        if (this.config.lazy && this.config.networked) {
            return;
        }
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        conn.setAutoCommit(true);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select CURRENT_TIMESTAMP from DUAL");
        rs.next();
        Timestamp first = rs.getTimestamp(1);
        rs.close();
        Thread.sleep(1L);
        rs = stat.executeQuery("select CURRENT_TIMESTAMP from DUAL");
        rs.next();
        Timestamp second = rs.getTimestamp(1);
        rs.close();
        this.assertTrue(second.after(first));
        conn.close();
    }

    private void testCompatibilityDateTime() throws SQLException {
        this.deleteDb("functions");
        TimeZone tz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT+1"));
            String[] stringArray = new String[]{"LEGACY", "ORACLE"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mode = stringArray[n2];
                Connection conn = this.getConnection("functions;MODE=" + mode);
                conn.setAutoCommit(false);
                Statement stat = conn.createStatement();
                stat.execute("SET TIME ZONE '2:00'");
                ResultSet rs = stat.executeQuery("SELECT SYSDATE, SYSTIMESTAMP, SYSTIMESTAMP(0), SYSTIMESTAMP(9) FROM DUAL");
                rs.next();
                LocalDateTime ldt = rs.getObject(1, LocalDateTime.class);
                OffsetDateTime odt = rs.getObject(2, OffsetDateTime.class);
                OffsetDateTime odt0 = rs.getObject(3, OffsetDateTime.class);
                OffsetDateTime odt9 = rs.getObject(4, OffsetDateTime.class);
                this.assertEquals(3600, odt.getOffset().getTotalSeconds());
                this.assertEquals(3600, odt9.getOffset().getTotalSeconds());
                this.assertEquals(ldt, odt9.toLocalDateTime().withNano(0));
                if (mode.equals("LEGACY")) {
                    stat.execute("SET TIME ZONE '3:00'");
                    rs = stat.executeQuery("SELECT SYSDATE, SYSTIMESTAMP, SYSTIMESTAMP(0), SYSTIMESTAMP(9) FROM DUAL");
                    rs.next();
                    this.assertEquals(ldt, rs.getObject(1, LocalDateTime.class));
                    this.assertEquals(odt, rs.getObject(2, OffsetDateTime.class));
                    this.assertEquals(odt0, rs.getObject(3, OffsetDateTime.class));
                    this.assertEquals(odt9, rs.getObject(4, OffsetDateTime.class));
                }
                conn.close();
                ++n2;
            }
        }
        finally {
            TimeZone.setDefault(tz);
        }
    }

    private void testOverrideAlias() throws SQLException {
        this.deleteDb("functions");
        Connection conn = this.getConnection("functions");
        conn.setAutoCommit(true);
        Statement stat = conn.createStatement();
        this.assertThrows(90076, stat).execute("create alias CURRENT_TIMESTAMP for '" + this.getClass().getName() + ".currentTimestamp'");
        stat.execute("set BUILTIN_ALIAS_OVERRIDE true");
        stat.execute("create alias CURRENT_TIMESTAMP for '" + this.getClass().getName() + ".currentTimestampOverride'");
        this.assertCallResult("3141", stat, "CURRENT_TIMESTAMP");
        conn.close();
    }

    private void callCompiledFunction(String functionName) throws SQLException {
        this.deleteDb("functions");
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = this.getConnection("functions");){
            Statement stat = conn.createStatement();
            stat.execute("create alias " + functionName + " AS $$ boolean " + functionName + "() { return true; } $$;");
            PreparedStatement stmt = conn.prepareStatement("select " + functionName + "() from dual");
            ResultSet rs = stmt.executeQuery();
            rs.next();
            this.assertEquals(Boolean.class.getName(), rs.getObject(1).getClass().getName());
            stat.execute("drop alias " + functionName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void assertCallResult(String expected, Statement stat, String sql) throws SQLException {
        ResultSet rs = stat.executeQuery("CALL " + sql);
        rs.next();
        String s = rs.getString(1);
        this.assertEquals(expected, s);
    }

    public static BufferedInputStream blob2stream(Blob value) throws SQLException {
        if (value == null) {
            return null;
        }
        BufferedInputStream bufferedInStream = new BufferedInputStream(value.getBinaryStream());
        return bufferedInStream;
    }

    public static Blob blob(Blob value) {
        return value;
    }

    public static Clob clob(Clob value) {
        return value;
    }

    public static BufferedInputStream stream2stream(InputStream value) {
        if (value == null) {
            return null;
        }
        BufferedInputStream bufferedInStream = new BufferedInputStream(value);
        return bufferedInStream;
    }

    public static int addRow(Connection conn, int id, String name) throws SQLException {
        conn.createStatement().execute("INSERT INTO TEST VALUES(" + id + ", '" + name + "')");
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM TEST");
        rs.next();
        int result = rs.getInt(1);
        rs.close();
        return result;
    }

    public static ResultSet select(Connection conn, String sql) throws SQLException {
        Statement stat = conn.createStatement(1004, 1007);
        return stat.executeQuery(sql);
    }

    public static ResultSet selectMaxId(Connection conn) throws SQLException {
        return conn.createStatement().executeQuery("SELECT MAX(ID) FROM TEST");
    }

    public static String[] getArray() {
        return new String[]{"0", "Hello"};
    }

    public static ResultSet resultSetWithNull(Connection conn) throws SQLException {
        PreparedStatement statement = conn.prepareStatement("select null from system_range(1,1)");
        return statement.executeQuery();
    }

    public static ResultSet simpleResultSet(Integer rowCount, int ip, boolean bp, float fp, double dp, long lp, byte byParam, short sp) {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("ID", 4, 10, 0);
        rs.addColumn("NAME", 12, 255, 0);
        if (rowCount == null && (ip != 0 || bp || (double)fp != 0.0 || dp != 0.0 || sp != 0 || lp != 0L || byParam != 0)) {
            throw new AssertionError((Object)"params not 0/false");
        }
        if (rowCount != null) {
            if (ip != 1 || !bp || (double)fp != 1.0 || dp != 1.0 || sp != 1 || lp != 1L || byParam != 1) {
                throw new AssertionError((Object)"params not 1/true");
            }
            if (rowCount >= 1) {
                rs.addRow(0, "Hello");
            }
            if (rowCount >= 2) {
                rs.addRow(1, "World");
            }
        }
        return rs;
    }

    public static int root(int value) {
        if (value < 0) {
            TestBase.logError("function called but should not", null);
        }
        return (int)Math.sqrt(value);
    }

    public static double mean() {
        return 1.0;
    }

    public static BigDecimal noOp(BigDecimal dec) {
        return dec;
    }

    public static int getCount() {
        return count++;
    }

    private static void setCount(int newCount) {
        count = newCount;
    }

    public static String reverse(String s) {
        return new StringBuilder(s).reverse().toString();
    }

    public static double mean(double ... values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum += x;
            ++n2;
        }
        return sum / (double)values.length;
    }

    public static double mean2(Connection conn, double ... values) {
        conn.getClass();
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum += x;
            ++n2;
        }
        return sum / (double)values.length;
    }

    public static String printMean(String prefix, double ... values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum += x;
            ++n2;
        }
        return prefix + ": " + (int)(sum / (double)values.length);
    }

    public static UUID xorUUID(UUID a, UUID b) {
        return new UUID(a.getMostSignificantBits() ^ b.getMostSignificantBits(), a.getLeastSignificantBits() ^ b.getLeastSignificantBits());
    }

    public static String[] dynamic(String[] args) {
        StringBuilder buff = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            buff.append((Object)a);
            ++n2;
        }
        return new String[]{buff.toString()};
    }

    public static long currentTimestampOverride() {
        return 3141L;
    }

    @Override
    public void add(Object value) {
    }

    @Override
    public Object getResult() {
        return new BigDecimal("1.6");
    }

    @Override
    public int getType(int[] inputTypes) {
        if (inputTypes.length != 1 || inputTypes[0] != 4) {
            throw new RuntimeException("unexpected data type");
        }
        return 3;
    }

    public static class MedianString
    implements AggregateFunction {
        private final ArrayList<String> list = new ArrayList();

        @Override
        public void add(Object value) {
            this.list.add(value.toString());
        }

        @Override
        public Object getResult() {
            Collections.sort(this.list);
            return this.list.get(this.list.size() / 2);
        }

        @Override
        public int getType(int[] inputType) {
            return 12;
        }
    }

    public static class MedianStringType
    implements Aggregate {
        private final ArrayList<String> list = new ArrayList();

        @Override
        public void add(Object value) {
            this.list.add(value.toString());
        }

        @Override
        public Object getResult() {
            return this.list.get(this.list.size() / 2);
        }

        @Override
        public int getInternalType(int[] inputTypes) throws SQLException {
            return 2;
        }
    }
}

