/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.db.AbstractBaseForCommonTableExpressions;

public class TestGeneralCommonTableQueries
extends AbstractBaseForCommonTableExpressions {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testSimpleSelect();
        this.testImpliedColumnNames();
        this.testChainedQuery();
        this.testParameterizedQuery();
        this.testNumberedParameterizedQuery();
        this.testColumnNames();
        this.testInsert();
        this.testUpdate();
        this.testDelete();
        this.testMerge();
        this.testCreateTable();
        this.testNestedSQL();
        this.testSimple4RowRecursiveQuery();
        this.testSimple2By4RowRecursiveQuery();
        this.testSimple3RowRecursiveQueryWithLazyEval();
        this.testSimple3RowRecursiveQueryDropAllObjects();
    }

    private void testSimpleSelect() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        Statement stat = conn.createStatement();
        String simpleTwoColumnQuery = "with t1(n) as (select 1 as first) ,t2(n) as (select 2 as first) select * from t1 union all select * from t2";
        ResultSet rs = stat.executeQuery("with t1(n) as (select 1 as first) ,t2(n) as (select 2 as first) select * from t1 union all select * from t2");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        PreparedStatement prep = conn.prepareStatement("with t1(n) as (select 1 as first) ,t2(n) as (select 2 as first) select * from t1 union all select * from t2");
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("with t1(n) as (select 2 as first) ,t2(n) as (select 3 as first) select * from t1 union all select * from t2 where n<>?");
        prep.setInt(1, 0);
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("with t1(n) as (select 2 as first) ,t2(n) as (select 3 as first) ,t3(n) as (select 4 as first) select * from t1 union all select * from t2 union all select * from t3 where n<>?");
        prep.setInt(1, 4);
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testImpliedColumnNames() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        PreparedStatement prep = conn.prepareStatement("with t1 as (select 2 as first_col) ,t2 as (select first_col+1 from t1) ,t3 as (select 4 as first_col) select * from t1 union all select * from t2 union all select * from t3 where first_col<>?");
        prep.setInt(1, 4);
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt("FIRST_COL"));
        this.assertFalse(rs.next());
        this.assertEquals(rs.getMetaData().getColumnCount(), 1);
        this.assertEquals("FIRST_COL", rs.getMetaData().getColumnLabel(1));
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testChainedQuery() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        PreparedStatement prep = conn.prepareStatement("    WITH t1 AS (        SELECT 1 AS FIRST_COLUMN),     t2 AS (        SELECT FIRST_COLUMN+1 AS FIRST_COLUMN FROM t1 ) SELECT sum(FIRST_COLUMN) FROM t2");
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testParameterizedQuery() throws Exception {
        int n;
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        PreparedStatement prep = conn.prepareStatement("WITH t1 AS (     SELECT X, 'T1' FROM SYSTEM_RANGE(?,?)),t2 AS (     SELECT X, 'T2' FROM SYSTEM_RANGE(?,?)) SELECT * FROM t1 UNION ALL SELECT * FROM t2 UNION ALL SELECT X, 'Q' FROM SYSTEM_RANGE(?,?)");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        prep.setInt(3, 3);
        prep.setInt(4, 4);
        prep.setInt(5, 5);
        prep.setInt(6, 6);
        ResultSet rs = prep.executeQuery();
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6};
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            this.assertTrue(rs.next());
            this.assertEquals(n, rs.getInt(1));
            ++n3;
        }
        this.assertFalse(rs.next());
        rs = prep.executeQuery();
        nArray = new int[]{1, 2, 3, 4, 5, 6};
        n2 = nArray.length;
        n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            this.assertTrue(rs.next());
            this.assertEquals(n, rs.getInt(1));
            ++n3;
        }
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testNumberedParameterizedQuery() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        conn.setAutoCommit(false);
        PreparedStatement prep = conn.prepareStatement("WITH t1 AS (     SELECT R.X, 'T1' FROM SYSTEM_RANGE(?1,?2) R),t2 AS (     SELECT R.X, 'T2' FROM SYSTEM_RANGE(?3,?4) R) SELECT * FROM t1 UNION ALL SELECT * FROM t2 UNION ALL SELECT X, 'Q' FROM SYSTEM_RANGE(?5,?6)");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        prep.setInt(3, 3);
        prep.setInt(4, 4);
        prep.setInt(5, 5);
        prep.setInt(6, 6);
        ResultSet rs = prep.executeQuery();
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.assertTrue(rs.next());
            this.assertEquals(n3, rs.getInt(1));
            ++n2;
        }
        this.assertEquals("X", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("'T1'", rs.getMetaData().getColumnLabel(2));
        this.assertFalse(rs.next());
        try {
            prep = conn.prepareStatement("SELECT * FROM t1 UNION ALL SELECT * FROM t2 UNION ALL SELECT X, 'Q' FROM SYSTEM_RANGE(5,6)");
            rs = prep.executeQuery();
            this.fail("Temp view T1 was accessible after previous WITH statement finished - but should not have been.");
        }
        catch (SQLException e) {
            this.assertContains(e.getMessage(), "Table \"T1\" not found (this database is empty);");
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testInsert() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY,  X INT NULL, Y VARCHAR(100) NULL )");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T1 (X,Y) WITH v1 AS (     SELECT R.X, 'X1' AS Y FROM SYSTEM_RANGE(?1,?2) R)SELECT v1.X, v1.Y FROM v1");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        int rowCount = prep.executeUpdate();
        this.assertEquals(2, rowCount);
        ResultSet rs = stat.executeQuery("SELECT ID, X,Y FROM T1");
        int[] nArray = new int[]{1, 2};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.assertTrue(rs.next());
            this.assertTrue(rs.getInt(1) != 0);
            this.assertEquals(n3, rs.getInt(2));
            this.assertEquals("X1", rs.getString(3));
            ++n2;
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testUpdate() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS T1 AS SELECT R.X AS ID, R.X, 'X1' AS Y FROM SYSTEM_RANGE(1,2) R");
        PreparedStatement prep = conn.prepareStatement("UPDATE T1 SET Y = 'Y1' WHERE X IN (WITH v1 AS (     SELECT R.X, 'X1' AS Y FROM SYSTEM_RANGE(?1,?2) R)SELECT v1.X FROM v1)");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        int rowCount = prep.executeUpdate();
        this.assertEquals(2, rowCount);
        ResultSet rs = stat.executeQuery("SELECT ID, X,Y FROM T1");
        int[] nArray = new int[]{1, 2};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.assertTrue(rs.next());
            this.assertTrue(rs.getInt(1) != 0);
            this.assertEquals(n3, rs.getInt(2));
            this.assertEquals("Y1", rs.getString(3));
            ++n2;
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testDelete() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS T1 AS SELECT R.X AS ID, R.X, 'X1' AS Y FROM SYSTEM_RANGE(1,2) R");
        PreparedStatement prep = conn.prepareStatement("DELETE FROM T1 WHERE X IN (WITH v1 AS (     SELECT R.X, 'X1' AS Y FROM SYSTEM_RANGE(1,2) R)SELECT v1.X FROM v1 )");
        int rowCount = prep.executeUpdate();
        this.assertEquals(2, rowCount);
        ResultSet rs = stat.executeQuery("SELECT ID, X,Y FROM T1");
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testMerge() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS T1 AS SELECT R.X AS ID, R.X, 'X1' AS Y FROM SYSTEM_RANGE(1,2) R");
        PreparedStatement prep = conn.prepareStatement("MERGE INTO T1 KEY(ID) WITH v1 AS (     SELECT R.X, 'X1' AS Y FROM SYSTEM_RANGE(1,3) R)SELECT v1.X AS ID, v1.X, v1.Y FROM v1");
        int rowCount = prep.executeUpdate();
        this.assertEquals(3, rowCount);
        ResultSet rs = stat.executeQuery("SELECT ID, X,Y FROM T1");
        int[] nArray = new int[]{1, 2, 3};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.assertTrue(rs.next());
            this.assertTrue(rs.getInt(1) != 0);
            this.assertEquals(n3, rs.getInt(2));
            this.assertEquals("X1", rs.getString(3));
            ++n2;
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testCreateTable() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        Statement stat = conn.createStatement();
        PreparedStatement prep = conn.prepareStatement("CREATE TABLE IF NOT EXISTS T1 AS WITH v1 AS (     SELECT R.X, 'X1' AS Y FROM SYSTEM_RANGE(1,3) R)SELECT v1.X AS ID, v1.X, v1.Y FROM v1");
        boolean success = prep.execute();
        this.assertEquals(false, success);
        ResultSet rs = stat.executeQuery("SELECT ID, X,Y FROM T1");
        int[] nArray = new int[]{1, 2, 3};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.assertTrue(rs.next());
            this.assertTrue(rs.getInt(1) != 0);
            this.assertEquals(n3, rs.getInt(2));
            this.assertEquals("X1", rs.getString(3));
            ++n2;
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testNestedSQL() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        PreparedStatement prep = conn.prepareStatement("WITH T1 AS (                                SELECT *                            FROM TABLE (                            K VARCHAR = ('a', 'b'),             V INTEGER = (1, 2)          )                               ),                                                                                                          T2 AS (                                     SELECT *                            FROM TABLE (                            K VARCHAR = ('a', 'b'),             V INTEGER = (3, 4)          )                               ),                                                                                                          JOIN_CTE AS (                           SELECT T1.*                                                             FROM                                    T1                                  JOIN T2 ON (                            T1.K = T2.K                     )                           )                                                                       SELECT * FROM JOIN_CTE");
        ResultSet rs = prep.executeQuery();
        String[] stringArray = new String[]{"a", "b"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyLetter = stringArray[n2];
            this.assertTrue(rs.next());
            this.assertContains("ab", rs.getString(1));
            this.assertEquals(rs.getString(1), keyLetter);
            this.assertTrue(rs.getInt(2) != 0);
            ++n2;
        }
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testColumnNames() throws Exception {
        this.deleteDb("commonTableExpressionQueries");
        Connection conn = this.getConnection("commonTableExpressionQueries");
        conn.setAutoCommit(false);
        PreparedStatement prep = conn.prepareStatement("WITH t1 AS (     SELECT 1 AS ONE, R.X AS TWO, 'T1' AS THREE, X FROM SYSTEM_RANGE(1,1) R)SELECT * FROM t1");
        ResultSet rs = prep.executeQuery();
        int[] nArray = new int[]{1};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            this.assertTrue(rs.next());
            this.assertEquals(n3, rs.getInt(1));
            this.assertEquals(n3, rs.getInt(4));
            ++n2;
        }
        this.assertEquals("ONE", rs.getMetaData().getColumnLabel(1));
        this.assertEquals("TWO", rs.getMetaData().getColumnLabel(2));
        this.assertEquals("THREE", rs.getMetaData().getColumnLabel(3));
        this.assertEquals("X", rs.getMetaData().getColumnLabel(4));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("commonTableExpressionQueries");
    }

    private void testSimple4RowRecursiveQuery() throws Exception {
        String[] expectedRowData = new String[]{"|1", "|2", "|3"};
        String[] expectedColumnTypes = new String[]{"INTEGER"};
        String[] expectedColumnNames = new String[]{"N"};
        String setupSQL = "-- do nothing";
        String withQuery = "with recursive r(n) as (\n(select 1) union all (select n+1 from r where n < 3)\n)\nselect n from r";
        int maxRetries = 3;
        int expectedNumberOfRows = expectedRowData.length;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }

    private void testSimple2By4RowRecursiveQuery() throws Exception {
        String[] expectedRowData = new String[]{"|0|1|10", "|1|2|11", "|2|3|12", "|3|4|13"};
        String[] expectedColumnTypes = new String[]{"INTEGER", "INTEGER", "INTEGER"};
        String[] expectedColumnNames = new String[]{"K", "N", "N2"};
        String setupSQL = "-- do nothing";
        String withQuery = "with recursive\nr1(n,k) as ((select 1, 0) union all (select n+1,k+1 from r1 where n <= 3)),r2(n,k) as ((select 10,0) union all (select n+1,k+1 from r2 where n <= 13))select r1.k, r1.n, r2.n AS n2 from r1 inner join r2 ON r1.k= r2.k          ";
        int maxRetries = 3;
        int expectedNumberOfRows = expectedRowData.length;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }

    private void testSimple3RowRecursiveQueryWithLazyEval() throws Exception {
        if (this.config.lazy && this.config.networked) {
            return;
        }
        String[] expectedRowData = new String[]{"|6"};
        String[] expectedColumnTypes = new String[]{"BIGINT"};
        String[] expectedColumnNames = new String[]{"SUM(N)"};
        TestAll backupConfig = this.config;
        this.config = new TestAll();
        try {
            this.config.lazy = true;
            this.config.memory = true;
            String setupSQL = "--no config set";
            String withQuery = "select sum(n) from (\n    with recursive r(n) as (\n        (select 1) union all (select n+1 from r where n < 3) \n    )\n    select n from r \n)\n";
            int maxRetries = 10;
            int expectedNumberOfRows = expectedRowData.length;
            this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
        }
        finally {
            this.config = backupConfig;
        }
    }

    private void testSimple3RowRecursiveQueryDropAllObjects() throws Exception {
        String[] expectedRowData = new String[]{"|6"};
        String[] expectedColumnTypes = new String[]{"BIGINT"};
        String[] expectedColumnNames = new String[]{"SUM(N)"};
        String setupSQL = "DROP ALL OBJECTS;";
        String withQuery = "select sum(n) from (    with recursive r(n) as (        (select 1) union all (select n+1 from r where n < 3)    ),   dummyUnusedCte(n) as (   select 1    )    select n from r)";
        int maxRetries = 10;
        int expectedNumberOfRows = expectedRowData.length;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }
}

