/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.command.query.Select;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.SimpleResultSet;

public class TestIndex
extends TestDb {
    private static int testFunctionIndexCounter;
    private Connection conn;
    private Statement stat;
    private final Random random = new Random();

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("index");
        this.testOrderIndex();
        this.testIndexTypes();
        this.testHashIndexOnMemoryTable();
        this.testErrorMessage();
        this.testDuplicateKeyException();
        int to = this.config.lockTimeout;
        this.config.lockTimeout = 50000;
        try {
            this.testConcurrentUpdate();
        }
        finally {
            this.config.lockTimeout = to;
        }
        this.testNonUniqueHashIndex();
        this.testRenamePrimaryKey();
        this.testRandomized();
        this.testDescIndex();
        this.testHashIndex();
        if (this.config.networked && this.config.big) {
            return;
        }
        this.random.setSeed(100L);
        this.deleteDb("index");
        this.testWideIndex(147);
        this.testWideIndex(313);
        this.testWideIndex(979);
        this.testWideIndex(1200);
        this.testWideIndex(2400);
        if (this.config.big) {
            Random r = new Random();
            int j = 0;
            while (j < 10) {
                int i = r.nextInt(3000);
                if (i % 100 == 0) {
                    this.println("width: " + i);
                }
                this.testWideIndex(i);
                ++j;
            }
        }
        this.testLike();
        this.reconnect();
        this.testConstraint();
        this.testLargeIndex();
        this.testMultiColumnIndex();
        this.testHashIndex(true, false);
        this.testHashIndex(false, false);
        this.testHashIndex(true, true);
        this.testHashIndex(false, true);
        this.testMultiColumnHashIndex();
        this.testFunctionIndex();
        this.conn.close();
        this.deleteDb("index");
        this.testEnumIndex();
    }

    private void testOrderIndex() throws SQLException {
        Connection conn = this.getConnection("index");
        this.stat = conn.createStatement();
        this.stat.execute("create table test(id int, name varchar)");
        this.stat.execute("insert into test values (2, 'a'), (1, 'a')");
        this.stat.execute("create index on test(name)");
        ResultSet rs = this.stat.executeQuery("select id from test where name = 'a' order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("index");
    }

    private void testIndexTypes() throws SQLException {
        Connection conn = this.getConnection("index");
        this.stat = conn.createStatement();
        String[] stringArray = new String[]{"unique", "hash", "unique hash"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.stat.execute("create table test(id int)");
            this.stat.execute("create " + type + " index idx_name on test(id)");
            this.stat.execute("insert into test select x from system_range(1, 1000)");
            ResultSet rs = this.stat.executeQuery("select * from test where id=100");
            this.assertTrue(rs.next());
            this.assertFalse(rs.next());
            this.stat.execute("delete from test where id=100");
            rs = this.stat.executeQuery("select * from test where id=100");
            this.assertFalse(rs.next());
            rs = this.stat.executeQuery("select min(id), max(id) from test");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            this.assertEquals(1000, rs.getInt(2));
            this.stat.execute("drop table test");
            ++n2;
        }
        conn.close();
        this.deleteDb("index");
    }

    private void testErrorMessage() throws SQLException {
        this.reconnect();
        this.stat.execute("create table test(id int primary key, name varchar)");
        this.testErrorMessage("PRIMARY", "KEY", " ON PUBLIC.TEST(ID)");
        this.stat.execute("create table test(id int, name varchar primary key)");
        this.testErrorMessage("PRIMARY_KEY_2 ON PUBLIC.TEST(NAME)");
        this.stat.execute("create table test(id int, name varchar, primary key(id, name))");
        this.testErrorMessage("PRIMARY_KEY_2 ON PUBLIC.TEST(ID, NAME)");
        this.stat.execute("create table test(id int, name varchar, primary key(name, id))");
        this.testErrorMessage("PRIMARY_KEY_2 ON PUBLIC.TEST(NAME, ID)");
        this.stat.execute("create table test(id int, name int primary key)");
        this.testErrorMessage("PRIMARY", "KEY", " ON PUBLIC.TEST(NAME)");
        this.stat.execute("create table test(id int, name int, unique(name))");
        this.testErrorMessage("CONSTRAINT_INDEX_2 ON PUBLIC.TEST(NAME NULLS FIRST)");
        this.stat.execute("create table test(id int, name int, constraint abc unique(name, id))");
        this.testErrorMessage("ABC_INDEX_2 ON PUBLIC.TEST(NAME NULLS FIRST, ID NULLS FIRST)");
    }

    /*
     * Unable to fully structure code
     */
    private void testErrorMessage(String ... expected) throws SQLException {
        block3: {
            try {
                this.stat.execute("INSERT INTO TEST VALUES(1, 1)");
                this.stat.execute("INSERT INTO TEST VALUES(1, 1)");
                this.fail();
                break block3;
            }
            catch (SQLException e) {
                m = e.getMessage();
                start = m.indexOf(34);
                end = m.lastIndexOf(34);
                s = m.substring(start + 1, end);
                var10_7 = expected;
                var9_8 = expected.length;
                var8_9 = 0;
                ** while (var8_9 < var9_8)
            }
lbl-1000:
            // 1 sources

            {
                t = var10_7[var8_9];
                this.assertContains(s, t);
                ++var8_9;
                continue;
            }
        }
        this.stat.execute("drop table test");
    }

    private void testDuplicateKeyException() throws SQLException {
        this.reconnect();
        this.stat.execute("create table test(id int primary key, name varchar(255))");
        this.stat.execute("create unique index idx_test_name on test(name)");
        this.stat.execute("insert into TEST values(1, 'Hello')");
        try {
            this.stat.execute("insert into TEST values(2, 'Hello')");
            this.fail();
        }
        catch (SQLException ex) {
            this.assertEquals(23505, ex.getErrorCode());
            String m = ex.getMessage();
            this.assertContains(m, "IDX_TEST_NAME ON PUBLIC.TEST(NAME NULLS FIRST)");
            this.assertContains(m, "'Hello'");
        }
        this.stat.execute("drop table test");
    }

    private void testConcurrentUpdate() throws SQLException {
        Connection c = this.getConnection("index");
        Statement stat = c.createStatement();
        stat.execute("create table test(id int primary key, v int)");
        stat.execute("create unique index idx_value_name on test(v)");
        PreparedStatement check = c.prepareStatement("select v from test");
        ConcurrentUpdateThread[] threads = new ConcurrentUpdateThread[4];
        AtomicInteger concurrentUpdateId = new AtomicInteger();
        AtomicInteger concurrentUpdateValue = new AtomicInteger();
        int i = 0;
        while (i < threads.length) {
            threads[i] = new ConcurrentUpdateThread(c, concurrentUpdateId, concurrentUpdateValue);
            ++i;
        }
        this.testConcurrentUpdateRun(threads, check);
        Connection[] connections = new Connection[threads.length];
        int i2 = 0;
        while (i2 < threads.length) {
            Connection c2;
            connections[i2] = c2 = this.getConnection("index");
            threads[i2] = new ConcurrentUpdateThread(c2, concurrentUpdateId, concurrentUpdateValue);
            ++i2;
        }
        this.testConcurrentUpdateRun(threads, check);
        Connection[] connectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            Connection c2 = connectionArray[n2];
            c2.close();
            ++n2;
        }
        stat.execute("drop table test");
        c.close();
    }

    private void testConcurrentUpdateRun(ConcurrentUpdateThread[] threads, PreparedStatement check) throws SQLException {
        ConcurrentUpdateThread[] concurrentUpdateThreadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ConcurrentUpdateThread t = concurrentUpdateThreadArray[n2];
            t.start();
            ++n2;
        }
        boolean haveDuplicateKeyException = false;
        ConcurrentUpdateThread[] concurrentUpdateThreadArray2 = threads;
        int n3 = threads.length;
        n = 0;
        while (n < n3) {
            ConcurrentUpdateThread t = concurrentUpdateThreadArray2[n];
            try {
                t.join();
                haveDuplicateKeyException |= t.haveDuplicateKeyException;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        this.assertTrue("haveDuplicateKeys", haveDuplicateKeyException);
        HashSet<Integer> set = new HashSet<Integer>();
        Throwable throwable = null;
        Object var6_5 = null;
        try (ResultSet rs = check.executeQuery();){
            while (rs.next()) {
                if (set.add(rs.getInt(1))) continue;
                this.fail("unique index violation");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testNonUniqueHashIndex() throws SQLException {
        this.reconnect();
        this.stat.execute("create memory table test(id bigint, data bigint)");
        this.stat.execute("create hash index on test(id)");
        Random rand = new Random(1L);
        PreparedStatement prepInsert = this.conn.prepareStatement("insert into test values(?, ?)");
        PreparedStatement prepDelete = this.conn.prepareStatement("delete from test where id=?");
        PreparedStatement prepSelect = this.conn.prepareStatement("select count(*) from test where id=?");
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        int i = 0;
        while (i < 1000) {
            int result;
            long key = (long)rand.nextInt(10) * 1000000000L;
            Integer r = (Integer)map.get(key);
            int n = result = r == null ? 0 : r;
            if (rand.nextBoolean()) {
                prepSelect.setLong(1, key);
                ResultSet rs = prepSelect.executeQuery();
                rs.next();
                this.assertEquals(result, rs.getInt(1));
            } else if (rand.nextBoolean()) {
                prepInsert.setLong(1, key);
                prepInsert.setInt(2, rand.nextInt());
                prepInsert.execute();
                map.put(key, result + 1);
            } else {
                prepDelete.setLong(1, key);
                prepDelete.execute();
                map.put(key, 0);
            }
            ++i;
        }
        this.stat.execute("drop table test");
        this.conn.close();
    }

    private void testRenamePrimaryKey() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.reconnect();
        this.stat.execute("create table test(id int not null)");
        this.stat.execute("alter table test add constraint x primary key(id)");
        ResultSet rs = this.conn.getMetaData().getIndexInfo(null, null, "TEST", true, false);
        rs.next();
        String old = rs.getString("INDEX_NAME");
        this.stat.execute("alter index " + old + " rename to y");
        rs = this.conn.getMetaData().getIndexInfo(null, null, "TEST", true, false);
        rs.next();
        this.assertEquals("Y", rs.getString("INDEX_NAME"));
        this.reconnect();
        rs = this.conn.getMetaData().getIndexInfo(null, null, "TEST", true, false);
        rs.next();
        this.assertEquals("Y", rs.getString("INDEX_NAME"));
        this.stat.execute("drop table test");
    }

    private void testRandomized() throws SQLException {
        boolean reopen = !this.config.memory;
        Random rand = new Random(1L);
        this.reconnect();
        this.stat.execute("drop all objects");
        this.stat.execute("CREATE TABLE TEST(ID identity default on null)");
        int len = this.getSize(100, 1000);
        int i = 0;
        while (i < len) {
            switch (rand.nextInt(4)) {
                case 0: {
                    if (rand.nextInt(10) != 0 || !reopen) break;
                    this.trace("reconnect");
                    this.reconnect();
                    break;
                }
                case 1: {
                    this.trace("insert");
                    this.stat.execute("insert into test(id) values(null)");
                    break;
                }
                case 2: {
                    this.trace("delete");
                    this.stat.execute("delete from test");
                    break;
                }
                case 3: {
                    this.trace("insert 1-100");
                    this.stat.execute("insert into test select null from system_range(1, 100)");
                }
            }
            ++i;
        }
        this.stat.execute("drop table test");
    }

    private void testHashIndex() throws SQLException {
        this.reconnect();
        this.stat.execute("create table testA(id int primary key, name varchar)");
        this.stat.execute("create table testB(id int primary key hash, name varchar)");
        int len = this.getSize(300, 3000);
        this.stat.execute("insert into testA select x, 'Hello' from system_range(1, " + len + ")");
        this.stat.execute("insert into testB select x, 'Hello' from system_range(1, " + len + ")");
        Random rand = new Random(1L);
        int i = 0;
        while (i < len) {
            int x = rand.nextInt(len);
            Object sql = "";
            switch (rand.nextInt(3)) {
                case 0: {
                    sql = "delete from testA where id = " + x;
                    break;
                }
                case 1: {
                    sql = "update testA set name = " + rand.nextInt(100) + " where id = " + x;
                    break;
                }
                case 2: {
                    sql = "select name from testA where id = " + x;
                }
            }
            boolean result = this.stat.execute((String)sql);
            if (result) {
                ResultSet rs = this.stat.getResultSet();
                String s1 = rs.next() ? rs.getString(1) : null;
                rs = this.stat.executeQuery(((String)sql).replace('A', 'B'));
                String s2 = rs.next() ? rs.getString(1) : null;
                this.assertEquals(s1, s2);
            } else {
                int count1 = this.stat.getUpdateCount();
                int count2 = this.stat.executeUpdate(((String)sql).replace('A', 'B'));
                this.assertEquals(count1, count2);
            }
            ++i;
        }
        this.stat.execute("drop table testA, testB");
        this.conn.close();
    }

    private void reconnect() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
        this.conn = this.getConnection("index");
        this.stat = this.conn.createStatement();
    }

    private void testDescIndex() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.reconnect();
        this.stat.execute("CREATE TABLE TEST(ID INT)");
        this.stat.execute("CREATE INDEX IDX_ND ON TEST(ID DESC)");
        ResultSet rs = this.conn.getMetaData().getIndexInfo(null, null, "TEST", false, false);
        rs.next();
        this.assertEquals("D", rs.getString("ASC_OR_DESC"));
        this.stat.execute("INSERT INTO TEST SELECT X FROM SYSTEM_RANGE(1, 30)");
        rs = this.stat.executeQuery("SELECT COUNT(*) FROM TEST WHERE ID BETWEEN 10 AND 20");
        rs.next();
        this.assertEquals(11, rs.getInt(1));
        this.reconnect();
        rs = this.conn.getMetaData().getIndexInfo(null, null, "TEST", false, false);
        rs.next();
        this.assertEquals("D", rs.getString("ASC_OR_DESC"));
        rs = this.stat.executeQuery("SELECT COUNT(*) FROM TEST WHERE ID BETWEEN 10 AND 20");
        rs.next();
        this.assertEquals(11, rs.getInt(1));
        this.stat.execute("DROP TABLE TEST");
        this.stat.execute("create table test(x int, y int)");
        this.stat.execute("insert into test values(1, 1), (1, 2)");
        this.stat.execute("create index test_x_y on test (x desc, y desc)");
        rs = this.stat.executeQuery("select * from test where x=1 and y<2");
        this.assertTrue(rs.next());
        this.conn.close();
    }

    private String getRandomString(int len) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < len) {
            buff.append((char)(97 + this.random.nextInt(26)));
            ++i;
        }
        return buff.toString();
    }

    private void testWideIndex(int length) throws SQLException {
        String name;
        int id;
        this.reconnect();
        this.stat.execute("drop all objects");
        this.stat.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR)");
        this.stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        int i = 0;
        while (i < 100) {
            this.stat.execute("INSERT INTO TEST VALUES(" + i + ", SPACE(" + length + ") || " + i + " )");
            ++i;
        }
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY NAME");
        while (rs.next()) {
            id = rs.getInt("ID");
            name = rs.getString("NAME");
            this.assertEquals("" + id, name.trim());
        }
        if (!this.config.memory) {
            this.reconnect();
            rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY NAME");
            while (rs.next()) {
                id = rs.getInt("ID");
                name = rs.getString("NAME");
                this.assertEquals("" + id, name.trim());
            }
        }
        this.stat.execute("drop all objects");
    }

    private void testLike() throws SQLException {
        this.reconnect();
        this.stat.execute("CREATE TABLE ABC(ID INT, NAME VARCHAR)");
        this.stat.execute("INSERT INTO ABC VALUES(1, 'Hello')");
        PreparedStatement prep = this.conn.prepareStatement("SELECT * FROM ABC WHERE NAME LIKE CAST(? AS VARCHAR)");
        prep.setString(1, "Hi%");
        prep.execute();
        this.stat.execute("DROP TABLE ABC");
    }

    private void testConstraint() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.stat.execute("CREATE TABLE PARENT(ID INT PRIMARY KEY)");
        this.stat.execute("CREATE TABLE CHILD(ID INT PRIMARY KEY, PID INT, FOREIGN KEY(PID) REFERENCES PARENT(ID))");
        this.reconnect();
        this.stat.execute("DROP TABLE PARENT, CHILD");
    }

    private void testLargeIndex() throws SQLException {
        this.random.setSeed(10L);
        int i = 1;
        while (i < 100) {
            this.stat.execute("DROP TABLE IF EXISTS TEST");
            this.stat.execute("CREATE TABLE TEST(NAME VARCHAR(" + i + "))");
            this.stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
            PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?)");
            int j = 0;
            while (j < this.getSize(2, 5)) {
                prep.setString(1, this.getRandomString(i));
                prep.execute();
                ++j;
            }
            if (!this.config.memory) {
                this.conn.close();
                this.conn = this.getConnection("index");
                this.stat = this.conn.createStatement();
            }
            ResultSet rs = this.stat.executeQuery("SELECT COUNT(*) FROM TEST WHERE NAME > 'mdd'");
            rs.next();
            int count = rs.getInt(1);
            this.trace(i + " count=" + count);
            i += this.getSize(1000, 7);
        }
        this.stat.execute("DROP TABLE IF EXISTS TEST");
    }

    private void testHashIndex(boolean primaryKey, boolean hash) throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.reconnect();
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        if (primaryKey) {
            this.stat.execute("CREATE TABLE TEST(A INT PRIMARY KEY " + (hash ? "HASH" : "") + ", B INT)");
        } else {
            this.stat.execute("CREATE TABLE TEST(A INT, B INT)");
            this.stat.execute("CREATE UNIQUE " + (hash ? "HASH" : "") + " INDEX ON TEST(A)");
        }
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int len = this.getSize(5, 1000);
        int a = 0;
        while (a < len) {
            prep.setInt(1, a);
            prep.setInt(2, a);
            prep.execute();
            this.assertEquals(1, this.getValue("SELECT COUNT(*) FROM TEST WHERE A=" + a));
            this.assertEquals(0, this.getValue("SELECT COUNT(*) FROM TEST WHERE A=-1-" + a));
            ++a;
        }
        this.reconnect();
        prep = this.conn.prepareStatement("DELETE FROM TEST WHERE A=?");
        a = 0;
        while (a < len) {
            if (this.getValue("SELECT COUNT(*) FROM TEST WHERE A=" + a) != 1) {
                this.assertEquals(1, this.getValue("SELECT COUNT(*) FROM TEST WHERE A=" + a));
            }
            prep.setInt(1, a);
            this.assertEquals(1, prep.executeUpdate());
            ++a;
        }
        this.assertEquals(0, this.getValue("SELECT COUNT(*) FROM TEST"));
    }

    private void testMultiColumnIndex() throws SQLException {
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        this.stat.execute("CREATE TABLE TEST(A INT, B INT)");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int len = this.getSize(3, 260);
        int a = 0;
        while (a < len) {
            prep.setInt(1, a);
            prep.setInt(2, a);
            prep.execute();
            ++a;
        }
        this.stat.execute("INSERT INTO TEST SELECT A, B FROM TEST");
        this.stat.execute("CREATE INDEX ON TEST(A, B)");
        prep = this.conn.prepareStatement("DELETE FROM TEST WHERE A=?");
        a = 0;
        while (a < len) {
            this.log("SELECT * FROM TEST");
            this.assertEquals(2, this.getValue("SELECT COUNT(*) FROM TEST WHERE A=" + (len - a - 1)));
            this.assertEquals((len - a) * 2, this.getValue("SELECT COUNT(*) FROM TEST"));
            prep.setInt(1, len - a - 1);
            prep.execute();
            ++a;
        }
        this.assertEquals(0, this.getValue("SELECT COUNT(*) FROM TEST"));
    }

    private void testMultiColumnHashIndex() throws SQLException {
        int b;
        if (this.config.memory) {
            return;
        }
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        this.stat.execute("CREATE TABLE TEST(A INT, B INT, DATA VARCHAR(255))");
        this.stat.execute("CREATE UNIQUE HASH INDEX IDX_AB ON TEST(A, B)");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        int len = this.getSize(2, 14);
        int a = 0;
        while (a < len) {
            b = 0;
            while (b < len) {
                prep.setInt(1, a);
                prep.setInt(2, b);
                prep.setString(3, "i(" + a + "," + b + ")");
                prep.execute();
                b += 2;
            }
            ++a;
        }
        this.reconnect();
        prep = this.conn.prepareStatement("UPDATE TEST SET DATA=DATA||? WHERE A=? AND B=?");
        a = 0;
        while (a < len) {
            b = 0;
            while (b < len) {
                prep.setString(1, "u(" + a + "," + b + ")");
                prep.setInt(2, a);
                prep.setInt(3, b);
                prep.execute();
                b += 2;
            }
            ++a;
        }
        this.reconnect();
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST WHERE DATA <> 'i('||a||','||b||')u('||a||','||b||')'");
        this.assertFalse(rs.next());
        this.assertEquals(len * (len / 2), this.getValue("SELECT COUNT(*) FROM TEST"));
        this.stat.execute("DROP TABLE TEST");
    }

    private void testHashIndexOnMemoryTable() throws SQLException {
        this.reconnect();
        this.stat.execute("drop table if exists hash_index_test");
        this.stat.execute("create memory table hash_index_test as select x as id, x % 10 as data from (select *  from system_range(1, 100))");
        this.stat.execute("create hash index idx2 on hash_index_test(data)");
        this.assertEquals(10, this.getValue("select count(*) from hash_index_test where data = 1"));
        this.stat.execute("drop index idx2");
        this.stat.execute("create unique hash index idx2 on hash_index_test(id)");
        this.assertEquals(1, this.getValue("select count(*) from hash_index_test where id = 1"));
    }

    private int getValue(String sql) throws SQLException {
        ResultSet rs = this.stat.executeQuery(sql);
        rs.next();
        return rs.getInt(1);
    }

    private void log(String sql) throws SQLException {
        this.trace(sql);
        ResultSet rs = this.stat.executeQuery(sql);
        int cols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            StringBuilder buff = new StringBuilder();
            int i = 0;
            while (i < cols) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append("[" + i + "]=" + rs.getString(i + 1));
                ++i;
            }
            this.trace(buff.toString());
        }
        this.trace("---done---");
    }

    public static ResultSet testFunctionIndexFunction() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (element.getClassName().startsWith(Select.class.getName())) {
                ++testFunctionIndexCounter;
                break;
            }
            ++n2;
        }
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("ID", 4, 32, 0);
        rs.addColumn("VALUE", 4, 32, 0);
        rs.addRow(1, 10);
        rs.addRow(2, 20);
        rs.addRow(3, 30);
        return rs;
    }

    private void testFunctionIndex() throws SQLException {
        testFunctionIndexCounter = 0;
        this.stat.execute("CREATE ALIAS TEST_INDEX FOR '" + TestIndex.class.getName() + ".testFunctionIndexFunction'");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST_INDEX() WHERE ID = 1 OR ID = 3");){
                this.assertTrue(rs.next());
                this.assertEquals(1, rs.getInt(1));
                this.assertEquals(10, rs.getInt(2));
                this.assertTrue(rs.next());
                this.assertEquals(3, rs.getInt(1));
                this.assertEquals(30, rs.getInt(2));
                this.assertFalse(rs.next());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.stat.execute("DROP ALIAS TEST_INDEX");
        }
        this.assertEquals(1, testFunctionIndexCounter);
    }

    private void testEnumIndex() throws SQLException {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.deleteDb("index");
        String url = "jdbc:h2:" + this.getBaseDir() + "/index;DB_CLOSE_DELAY=0";
        Connection conn = DriverManager.getConnection(url);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, V ENUM('A', 'B'), CONSTRAINT PK PRIMARY KEY(ID, V))");
        stat.execute("INSERT INTO TEST VALUES (1, 'A'), (2, 'B')");
        conn.close();
        conn = DriverManager.getConnection(url);
        stat = conn.createStatement();
        stat.execute("DELETE FROM TEST WHERE V = 'A'");
        stat.execute("DROP TABLE TEST");
        conn.close();
        this.deleteDb("index");
    }

    private static class ConcurrentUpdateThread
    extends Thread {
        private final AtomicInteger concurrentUpdateId;
        private final AtomicInteger concurrentUpdateValue;
        private final PreparedStatement psInsert;
        private final PreparedStatement psDelete;
        boolean haveDuplicateKeyException;

        ConcurrentUpdateThread(Connection c, AtomicInteger concurrentUpdateId, AtomicInteger concurrentUpdateValue) throws SQLException {
            this.concurrentUpdateId = concurrentUpdateId;
            this.concurrentUpdateValue = concurrentUpdateValue;
            this.psInsert = c.prepareStatement("insert into test(id, v) values (?, ?)");
            this.psDelete = c.prepareStatement("delete from test where v = ?");
        }

        @Override
        public void run() {
            int i = 0;
            while (i < 10000) {
                try {
                    if (Math.random() > 0.05) {
                        this.psInsert.setInt(1, this.concurrentUpdateId.incrementAndGet());
                        this.psInsert.setInt(2, this.concurrentUpdateValue.get());
                        this.psInsert.executeUpdate();
                    } else {
                        this.psDelete.setInt(1, this.concurrentUpdateValue.get());
                        this.psDelete.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    switch (ex.getErrorCode()) {
                        case 23505: {
                            this.haveDuplicateKeyException = true;
                            break;
                        }
                        case 90131: {
                            break;
                        }
                        default: {
                            ex.printStackTrace();
                        }
                    }
                }
                if (Math.random() > 0.95) {
                    this.concurrentUpdateValue.incrementAndGet();
                }
                ++i;
            }
        }
    }
}

